use 5.006;
use strict;
use warnings;
use Module::Build 0.36;

my $builder = Module::Build->new(
    module_name         => 'Padre::Plugin::CSS',
    license             => 'perl',
    dist_author         => 'Fayland Lam <fayland@gmail.com>',
    dist_version_from   => 'lib/Padre/Plugin/CSS.pm',
    requires => {
        'Padre' => '0.43',
        'WebService::Validator::CSS::W3C' => 0,
        'CSS::Minifier::XS' => 0,
        'YAML::Tiny' => 0,
    },
    build_requires => {
        'Test::More' => 0,
    },
    configure_requires => {
        'Module::Build' => 0.36,
    },
    add_to_cleanup      => [ 'Padre-Plugin-CSS-*' ],
    #create_makefile_pl => 'traditional',
    meta_merge     => {
        resources => {
            homepage   => 'http://padre.perlide.org/',
            repository => 'http://svn.perlide.org/padre/trunk/Padre-Plugin-CSS/',
        }
    },
    share_dir => 'share',
);

$builder->create_build_script();
