#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use lib 'lib';

use_ok('Hypersonic::Future');
use_ok('Hypersonic::Future::Pool');

# Compile Future (includes Pool)
Hypersonic::Future->compile();

# Test initialization
{
    ok(!Hypersonic::Future::Pool->is_initialized, 'Pool not initialized initially');

    my $result = Hypersonic::Future::Pool->init;
    ok($result, 'Pool init returns true');
    ok(Hypersonic::Future::Pool->is_initialized, 'Pool is initialized');

    # Init again should be no-op
    my $result2 = Hypersonic::Future::Pool->init;
    ok($result2, 'Second init also returns true');
}

# Test notify fd
{
    my $fd = Hypersonic::Future::Pool->get_notify_fd;
    ok($fd >= 0, "notify_fd is valid ($fd)");
}

# Test pending count
{
    my $count = Hypersonic::Future::Pool->pending_count;
    is($count, 0, 'No pending operations initially');
}

# Cleanup
Hypersonic::Future::Pool->shutdown;

done_testing;
