# Generated by default/object.tt
package Paws::SageMaker::MetadataProperties;
  use Moose;
  has CommitId => (is => 'ro', isa => 'Str');
  has GeneratedBy => (is => 'ro', isa => 'Str');
  has ProjectId => (is => 'ro', isa => 'Str');
  has Repository => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::MetadataProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::MetadataProperties object:

  $service_obj->Method(Att1 => { CommitId => $value, ..., Repository => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::MetadataProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->CommitId

=head1 DESCRIPTION

Metadata properties of the tracking entity, trial, or trial component.

=head1 ATTRIBUTES


=head2 CommitId => Str

The commit ID.


=head2 GeneratedBy => Str

The entity this entity was generated by.


=head2 ProjectId => Str

The project ID.


=head2 Repository => Str

The repository.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

