# Generated by default/object.tt
package Paws::FMS::AwsEc2InstanceViolation;
  use Moose;
  has AwsEc2NetworkInterfaceViolations => (is => 'ro', isa => 'ArrayRef[Paws::FMS::AwsEc2NetworkInterfaceViolation]');
  has ViolationTarget => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::AwsEc2InstanceViolation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::AwsEc2InstanceViolation object:

  $service_obj->Method(Att1 => { AwsEc2NetworkInterfaceViolations => $value, ..., ViolationTarget => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::AwsEc2InstanceViolation object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsEc2NetworkInterfaceViolations

=head1 DESCRIPTION

Violations for an EC2 instance resource.

=head1 ATTRIBUTES


=head2 AwsEc2NetworkInterfaceViolations => ArrayRef[L<Paws::FMS::AwsEc2NetworkInterfaceViolation>]

Violations for network interfaces associated with the EC2 instance.


=head2 ViolationTarget => Str

The resource ID of the EC2 instance.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

