/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import java.io.File;
import java.io.FileFilter;

public class NumberRangeFileFilter
implements FileFilter {
    private int minimum;
    private int maximum;
    private boolean recursively;

    public NumberRangeFileFilter(int min, int max, boolean recurse) {
        this.minimum = min;
        this.maximum = max;
        this.recursively = recurse;
    }

    public boolean accept(File file) {
        String theNumber;
        int number;
        if (file.isDirectory()) {
            return this.recursively;
        }
        String filename = file.getName();
        int k = filename.length() - 1;
        char c = filename.charAt(k);
        while (k >= 0 && (c < '0' || c > '9')) {
            if (--k < 0) continue;
            c = filename.charAt(k);
        }
        if (k < 0) {
            return false;
        }
        int j = k;
        c = filename.charAt(j);
        while (j >= 0 && c >= '0' && c <= '9') {
            if (--j < 0) continue;
            c = filename.charAt(j);
        }
        return (number = Integer.parseInt(theNumber = filename.substring(++j, ++k))) >= this.minimum && number <= this.maximum;
    }
}

