/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Date;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

public class CitationConstant
extends SimpleCitation {
    private static final long serialVersionUID = 7812463864874105717L;
    private volatile transient Citation delegate;

    public CitationConstant(String string) {
        super(string);
    }

    public final void refresh() {
        this.delegate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Citation delegate() {
        Citation citation = this.delegate;
        if (citation == null) {
            CitationConstant citationConstant = this;
            synchronized (citationConstant) {
                citation = this.delegate;
                if (citation == null) {
                    citation = MetadataServices.getInstance().createCitation(this.title);
                    if (citation == null) {
                        citation = new SimpleCitation(this.title);
                    }
                    this.delegate = citation;
                }
            }
        }
        return citation;
    }

    @Override
    public InternationalString getTitle() {
        return this.delegate().getTitle();
    }

    @Override
    public Collection<? extends InternationalString> getAlternateTitles() {
        return this.delegate().getAlternateTitles();
    }

    @Override
    public Collection<? extends CitationDate> getDates() {
        return this.delegate().getDates();
    }

    @Override
    public InternationalString getEdition() {
        return this.delegate().getEdition();
    }

    @Override
    public Date getEditionDate() {
        return this.delegate().getEditionDate();
    }

    @Override
    public Collection<? extends Identifier> getIdentifiers() {
        return this.delegate().getIdentifiers();
    }

    @Override
    public Collection<? extends ResponsibleParty> getCitedResponsibleParties() {
        return this.delegate().getCitedResponsibleParties();
    }

    @Override
    public Collection<PresentationForm> getPresentationForms() {
        return this.delegate().getPresentationForms();
    }

    @Override
    public Series getSeries() {
        return this.delegate().getSeries();
    }

    @Override
    public InternationalString getOtherCitationDetails() {
        return this.delegate().getOtherCitationDetails();
    }

    @Override
    public String getISBN() {
        return this.delegate().getISBN();
    }

    @Override
    public String getISSN() {
        return this.delegate().getISSN();
    }

    protected Object readResolve() throws ObjectStreamException {
        CitationConstant citationConstant = MetadataServices.getInstance().getCitationConstant(this.title);
        if (citationConstant == null) {
            citationConstant = this;
        }
        return citationConstant;
    }

    public static class Authority<T>
    extends CitationConstant
    implements IdentifierSpace<T> {
        private static final long serialVersionUID = 2067932813561130294L;

        public Authority(String string) {
            super(string);
        }

        @Override
        public String getName() {
            return this.title;
        }

        @Override
        public final String toString() {
            return "IdentifierSpace[" + this.title + ']';
        }
    }
}

