/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.itadaki.bzip2.BZip2BitInputStream;
import org.itadaki.bzip2.BZip2BlockDecompressor;
import org.itadaki.bzip2.BZip2Exception;

public class BZip2InputStream
extends InputStream {
    private InputStream inputStream;
    private BZip2BitInputStream bitInputStream;
    private final boolean headerless;
    private boolean streamComplete = false;
    private int streamBlockSize;
    private int streamCRC = 0;
    private BZip2BlockDecompressor blockDecompressor = null;

    @Override
    public int read() throws IOException {
        int nextByte = -1;
        if (this.blockDecompressor == null) {
            this.initialiseStream();
        } else {
            nextByte = this.blockDecompressor.read();
        }
        if (nextByte == -1 && this.initialiseNextBlock()) {
            nextByte = this.blockDecompressor.read();
        }
        return nextByte;
    }

    @Override
    public int read(byte[] destination, int offset, int length) throws IOException {
        int bytesRead = -1;
        if (this.blockDecompressor == null) {
            this.initialiseStream();
        } else {
            bytesRead = this.blockDecompressor.read(destination, offset, length);
        }
        if (bytesRead == -1 && this.initialiseNextBlock()) {
            bytesRead = this.blockDecompressor.read(destination, offset, length);
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.bitInputStream != null) {
            this.streamComplete = true;
            this.blockDecompressor = null;
            this.bitInputStream = null;
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
            }
        }
    }

    private void initialiseStream() throws IOException {
        if (this.bitInputStream == null) {
            throw new BZip2Exception("Stream closed");
        }
        if (this.streamComplete) {
            return;
        }
        try {
            int marker1 = this.headerless ? 0 : this.bitInputStream.readBits(16);
            int marker2 = this.bitInputStream.readBits(8);
            int blockSize = this.bitInputStream.readBits(8) - 48;
            if (!this.headerless && marker1 != 16986 || marker2 != 104 || blockSize < 1 || blockSize > 9) {
                throw new BZip2Exception("Invalid BZip2 header");
            }
            this.streamBlockSize = blockSize * 100000;
        }
        catch (IOException e) {
            this.streamComplete = true;
            throw e;
        }
    }

    private boolean initialiseNextBlock() throws IOException {
        if (this.streamComplete) {
            return false;
        }
        if (this.blockDecompressor != null) {
            int blockCRC = this.blockDecompressor.checkCRC();
            this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ blockCRC;
        }
        int marker1 = this.bitInputStream.readBits(24);
        int marker2 = this.bitInputStream.readBits(24);
        if (marker1 == 3227993 && marker2 == 2511705) {
            try {
                this.blockDecompressor = new BZip2BlockDecompressor(this.bitInputStream, this.streamBlockSize);
            }
            catch (IOException e) {
                this.streamComplete = true;
                throw e;
            }
            return true;
        }
        if (marker1 == 1536581 && marker2 == 3690640) {
            this.streamComplete = true;
            int storedCombinedCRC = this.bitInputStream.readInteger();
            if (storedCombinedCRC != this.streamCRC) {
                throw new BZip2Exception("BZip2 stream CRC error");
            }
            return false;
        }
        this.streamComplete = true;
        throw new BZip2Exception("BZip2 stream format error");
    }

    public BZip2InputStream(InputStream inputStream, boolean headerless) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Null input stream");
        }
        this.inputStream = inputStream;
        this.bitInputStream = new BZip2BitInputStream(inputStream);
        this.headerless = headerless;
    }
}

