######################################################################
#
# 1125_keis78_by_utf8.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x04",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\x05",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x06",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x07",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\x08",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x09",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x0A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x0B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x14",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x15",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x16",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\x17",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x18",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x1A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x1B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x1C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x20",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\x21",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\x22",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x23",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x24",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\x25",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x26",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\x27",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\x28",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\x29",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x2A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x2B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\x2C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x2D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x2E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\x2F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x30",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\x31",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\x32",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\x33",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\x34",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\x35",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\x36",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\x37",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\x38",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\x39",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\x3A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\x3B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x3C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\x3D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x3E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x3F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x40",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\x41",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x42",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x43",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x44",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x45",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x46",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x47",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x48",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x49",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x4A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\x4B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\x4C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\x4D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\x4E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\x4F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\x50",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\x51",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\x52",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\x53",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\x54",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\x55",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\x56",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\x57",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\x58",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\x59",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\x5A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\x5B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\x5C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x5E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x5F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x60",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\x61",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\x62",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x63",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x64",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x65",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x66",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x67",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x68",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x69",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x6A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x6B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x6C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x6D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x6E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x6F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x70",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x71",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\x72",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\x73",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x74",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x75",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x76",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x9C"],
        ["\x77",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x78",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x79",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x7A",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xB1"],
        ["\x7B",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x7C",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x7D",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\x7E",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\xA1"],
        ["\x7F",'keis78','utf8',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\xEF\xBD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\xEF\xBD\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\xEF\xBD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\xEF\xBD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\xEF\xBD\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\xEF\xBD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\xEF\xBD\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\xEF\xBD\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\xEF\xBD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\xEF\xBD\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\xEF\xBD\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\xEF\xBD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\xEF\xBD\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\xEF\xBD\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\xEF\xBD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\xEF\xBD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\xEF\xBD\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x81"],
        ["\xEF\xBD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x82"],
        ["\xEF\xBD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x83"],
        ["\xEF\xBD\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x84"],
        ["\xEF\xBD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x85"],
        ["\xEF\xBD\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x86"],
        ["\xEF\xBD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x87"],
        ["\xEF\xBD\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x88"],
        ["\xEF\xBD\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x89"],
        ["\xEF\xBD\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A"],
        ["\xEF\xBD\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C"],
        ["\xEF\xBD\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D"],
        ["\xEF\xBD\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E"],
        ["\xEF\xBD\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F"],
        ["\xEF\xBD\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x90"],
        ["\xEF\xBE\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x91"],
        ["\xEF\xBE\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x92"],
        ["\xEF\xBE\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x93"],
        ["\xEF\xBE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x94"],
        ["\xEF\xBE\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x95"],
        ["\xEF\xBE\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x96"],
        ["\xEF\xBE\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x97"],
        ["\xEF\xBE\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x98"],
        ["\xEF\xBE\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x99"],
        ["\xEF\xBE\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A"],
        ["\xEF\xBE\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D"],
        ["\xEF\xBE\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E"],
        ["\xEF\xBE\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F"],
        ["\xEF\xBE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xEF\xBE\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xEF\xBE\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xEF\xBE\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xEF\xBE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xEF\xBE\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xEF\xBE\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xEF\xBE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xEF\xBE\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xEF\xBE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xEF\xBE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xEF\xBE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xEF\xBE\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xEF\xBE\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xEF\xBE\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xEF\xBE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xEF\xBE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xEF\xBE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xEF\xBE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xE3\x80\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],
        ["\xE3\x80\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],
        ["\xE3\x80\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],
        ["\xEF\xBC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],
        ["\xEF\xBC\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],
        ["\xE3\x83\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],
        ["\xEF\xBC\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],
        ["\xEF\xBC\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],
        ["\xEF\xBC\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],
        ["\xEF\xBC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],
        ["\xE3\x82\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],
        ["\xE3\x82\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],
        ["\xC2\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],
        ["\xEF\xBD\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],
        ["\xC2\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],
        ["\xEF\xBC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],
        ["\xEF\xBF\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],
        ["\xEF\xBC\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],
        ["\xE3\x83\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],
        ["\xE3\x83\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],
        ["\xE3\x82\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],
        ["\xE3\x82\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],
        ["\xE3\x80\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],
        ["\xE4\xBB\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],
        ["\xE3\x80\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],
        ["\xE3\x80\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],
        ["\xE3\x80\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],
        ["\xE3\x83\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],
        ["\xE2\x80\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],
        ["\xE2\x80\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],
        ["\xEF\xBC\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],
        ["\xEF\xBC\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],
        ["\xE3\x80\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],
        ["\xE2\x88\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],
        ["\xEF\xBD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],
        ["\xE2\x80\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],
        ["\xE2\x80\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],
        ["\xE2\x80\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],
        ["\xE2\x80\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],
        ["\xE2\x80\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],
        ["\xE2\x80\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],
        ["\xEF\xBC\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],
        ["\xEF\xBC\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],
        ["\xE3\x80\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],
        ["\xE3\x80\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],
        ["\xEF\xBC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],
        ["\xEF\xBC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],
        ["\xEF\xBD\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],
        ["\xEF\xBD\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],
        ["\xE3\x80\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],
        ["\xE3\x80\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],
        ["\xE3\x80\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],
        ["\xE3\x80\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],
        ["\xE3\x80\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],
        ["\xE3\x80\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],
        ["\xE3\x80\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],
        ["\xE3\x80\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],
        ["\xE3\x80\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],
        ["\xE3\x80\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],
        ["\xEF\xBC\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],
        ["\xEF\xBC\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],
        ["\xC2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],
        ["\xC3\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],
        ["\xC3\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],
        ["\xEF\xBC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],
        ["\xE2\x89\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],
        ["\xEF\xBC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],
        ["\xEF\xBC\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],
        ["\xE2\x89\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],
        ["\xE2\x89\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],
        ["\xE2\x88\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],
        ["\xE2\x88\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\xE2\x99\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\xE2\x99\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\xC2\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\xE2\x80\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\xE2\x80\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\xE2\x84\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\xEF\xBF\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\xEF\xBC\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\xEF\xBF\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],
        ["\xEF\xBF\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],
        ["\xEF\xBC\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\xEF\xBC\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\xEF\xBC\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\xEF\xBC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\xEF\xBC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\xC2\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\xE2\x98\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\xE2\x98\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\xE2\x97\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],
        ["\xE2\x97\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],
        ["\xE2\x97\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\xE2\x97\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\xE2\x97\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\xE2\x96\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\xE2\x96\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\xE2\x96\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\xE2\x96\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\xE2\x96\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\xE2\x96\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\xE2\x80\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\xE3\x80\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\xE2\x86\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\xE2\x86\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],
        ["\xE2\x86\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\xE2\x86\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],
        ["\xE3\x80\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x88\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],
        ["\xE2\x88\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],
        ["\xE2\x8A\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],
        ["\xE2\x8A\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\xE2\x8A\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],
        ["\xE2\x8A\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\xE2\x88\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],
        ["\xE2\x88\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],
        ["\xE2\x88\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],
        ["\xE2\x88\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],
        ["\xEF\xBF\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xCC"],
        ["\xE2\x87\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],
        ["\xE2\x87\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],
        ["\xE2\x88\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],
        ["\xE2\x88\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],
        ["\xE2\x88\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],
        ["\xE2\x8A\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],
        ["\xE2\x8C\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],
        ["\xE2\x88\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],
        ["\xE2\x88\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],
        ["\xE2\x89\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],
        ["\xE2\x89\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],
        ["\xE2\x89\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],
        ["\xE2\x89\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],
        ["\xE2\x88\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],
        ["\xE2\x88\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],
        ["\xE2\x88\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],
        ["\xE2\x88\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],
        ["\xE2\x88\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],
        ["\xE2\x88\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],
        ["\xE2\x84\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],
        ["\xE2\x80\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],
        ["\xE2\x99\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],
        ["\xE2\x99\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],
        ["\xE2\x99\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],
        ["\xE2\x80\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],
        ["\xE2\x80\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],
        ["\xC2\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],
        ["\xE2\x97\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],
        ["\xEF\xBC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],
        ["\xEF\xBC\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],
        ["\xEF\xBC\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],
        ["\xEF\xBC\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],
        ["\xEF\xBC\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\xEF\xBC\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\xEF\xBC\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\xEF\xBC\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],
        ["\xEF\xBC\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],
        ["\xEF\xBC\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],
        ["\xEF\xBC\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],
        ["\xEF\xBC\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],
        ["\xEF\xBC\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],
        ["\xEF\xBC\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],
        ["\xEF\xBC\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],
        ["\xEF\xBC\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],
        ["\xEF\xBC\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],
        ["\xEF\xBC\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],
        ["\xEF\xBC\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],
        ["\xEF\xBC\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],
        ["\xEF\xBC\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],
        ["\xEF\xBC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\xEF\xBC\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\xEF\xBC\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\xEF\xBC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\xEF\xBC\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],
        ["\xEF\xBC\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],
        ["\xEF\xBC\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],
        ["\xEF\xBC\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],
        ["\xEF\xBC\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],
        ["\xEF\xBC\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],
        ["\xEF\xBC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],
        ["\xEF\xBC\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],
        ["\xEF\xBC\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],
        ["\xEF\xBC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],
        ["\xEF\xBC\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],
        ["\xEF\xBD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\xEF\xBD\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\xEF\xBD\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\xEF\xBD\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\xEF\xBD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],
        ["\xEF\xBD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],
        ["\xEF\xBD\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],
        ["\xEF\xBD\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],
        ["\xEF\xBD\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],
        ["\xEF\xBD\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],
        ["\xEF\xBD\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\xEF\xBD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\xEF\xBD\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\xEF\xBD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\xEF\xBD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\xEF\xBD\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\xEF\xBD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\xEF\xBD\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\xEF\xBD\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\xEF\xBD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\xEF\xBD\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\xEF\xBD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\xEF\xBD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\xEF\xBD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\xEF\xBD\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\xEF\xBD\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xE3\x81\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],
        ["\xE3\x81\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],
        ["\xE3\x81\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],
        ["\xE3\x81\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],
        ["\xE3\x81\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\xE3\x81\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\xE3\x81\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\xE3\x81\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],
        ["\xE3\x81\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],
        ["\xE3\x81\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],
        ["\xE3\x81\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],
        ["\xE3\x81\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\xE3\x81\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],
        ["\xE3\x81\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],
        ["\xE3\x81\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],
        ["\xE3\x81\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],
        ["\xE3\x81\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],
        ["\xE3\x81\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],
        ["\xE3\x81\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],
        ["\xE3\x81\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],
        ["\xE3\x81\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\xE3\x81\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],
        ["\xE3\x81\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],
        ["\xE3\x81\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\xE3\x81\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],
        ["\xE3\x81\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],
        ["\xE3\x81\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xE3\x81\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\xE3\x81\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\xE3\x81\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xE3\x81\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\xE3\x81\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\xE3\x81\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\xE3\x81\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\xE3\x81\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\xE3\x81\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\xE3\x81\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\xE3\x81\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\xE3\x81\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\xE3\x81\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\xE3\x81\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\xE3\x81\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\xE3\x81\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],
        ["\xE3\x81\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],
        ["\xE3\x81\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],
        ["\xE3\x81\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\xE3\x81\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],
        ["\xE3\x81\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],
        ["\xE3\x81\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],
        ["\xE3\x81\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],
        ["\xE3\x81\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],
        ["\xE3\x81\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],
        ["\xE3\x81\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],
        ["\xE3\x81\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],
        ["\xE3\x81\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],
        ["\xE3\x81\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],
        ["\xE3\x81\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],
        ["\xE3\x81\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],
        ["\xE3\x81\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],
        ["\xE3\x81\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],
        ["\xE3\x81\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\xE3\x81\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],
        ["\xE3\x81\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xE3\x82\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],
        ["\xE3\x82\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],
        ["\xE3\x82\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],
        ["\xE3\x82\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],
        ["\xE3\x82\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],
        ["\xE3\x82\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],
        ["\xE3\x82\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],
        ["\xE3\x82\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],
        ["\xE3\x82\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],
        ["\xE3\x82\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],
        ["\xE3\x82\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],
        ["\xE3\x82\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],
        ["\xE3\x82\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],
        ["\xE3\x82\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],
        ["\xE3\x82\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],
        ["\xE3\x82\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],
        ["\xE3\x82\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],
        ["\xE3\x82\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],
        ["\xE3\x82\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],
        ["\xE3\x82\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],
        ["\xE3\x82\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\xE3\x82\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\xE3\x82\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],
        ["\xE3\x82\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\xE3\x82\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\xE3\x82\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\xE3\x82\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\xE3\x82\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\xE3\x82\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\xE3\x82\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\xE3\x82\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\xE3\x82\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\xE3\x82\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\xE3\x82\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\xE3\x82\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\xE3\x82\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\xE3\x82\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\xE3\x82\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\xE3\x82\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\xE3\x82\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\xE3\x82\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\xE3\x82\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\xE3\x82\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\xE3\x82\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\xE3\x82\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\xE3\x82\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\xE3\x82\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\xE3\x82\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\xE3\x82\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\xE3\x82\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\xE3\x82\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\xE3\x83\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\xE3\x83\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\xE3\x83\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\xE3\x83\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],
        ["\xE3\x83\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\xE3\x83\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\xE3\x83\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\xE3\x83\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\xE3\x83\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\xE3\x83\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],
        ["\xE3\x83\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xE3\x83\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\xE3\x83\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\xE3\x83\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],
        ["\xE3\x83\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\xE3\x83\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\xE3\x83\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\xE3\x83\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\xE3\x83\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\xE3\x83\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\xE3\x83\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\xE3\x83\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\xE3\x83\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\xE3\x83\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\xE3\x83\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],
        ["\xE3\x83\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],
        ["\xE3\x83\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],
        ["\xE3\x83\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\xE3\x83\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xE3\x83\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\xE3\x83\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\xE3\x83\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\xE3\x83\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\xE3\x83\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\xE3\x83\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\xE3\x83\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\xE3\x83\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\xE3\x83\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],
        ["\xE3\x83\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],
        ["\xE3\x83\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\xE3\x83\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\xE3\x83\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\xE3\x83\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\xE3\x83\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\xE3\x83\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],
        ["\xE3\x83\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],
        ["\xE3\x83\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xE3\x83\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xE3\x83\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\xE3\x83\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],
        ["\xE3\x83\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\xE3\x83\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\xE3\x83\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\xE3\x83\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\xE3\x83\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],
        ["\xCE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],
        ["\xCE\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],
        ["\xCE\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],
        ["\xCE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],
        ["\xCE\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],
        ["\xCE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\xCE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\xCE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\xCE\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\xCE\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\xCE\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],
        ["\xCE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\xCE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],
        ["\xCE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],
        ["\xCE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\xCE\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],
        ["\xCE\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],
        ["\xCE\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],
        ["\xCE\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],
        ["\xCE\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\xCE\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],
        ["\xCE\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\xCE\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],
        ["\xCE\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\xCE\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],
        ["\xCE\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],
        ["\xCE\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],
        ["\xCE\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],
        ["\xCE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],
        ["\xCE\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],
        ["\xCE\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],
        ["\xCE\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],
        ["\xCE\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],
        ["\xCE\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],
        ["\xCE\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],
        ["\xCE\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],
        ["\xCE\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\xCE\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],
        ["\xCE\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\xCF\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],
        ["\xCF\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],
        ["\xCF\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],
        ["\xCF\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],
        ["\xCF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],
        ["\xCF\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],
        ["\xCF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],
        ["\xCF\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],
        ["\xCF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],
        ["\xD0\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],
        ["\xD0\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],
        ["\xD0\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],
        ["\xD0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],
        ["\xD0\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],
        ["\xD0\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\xD0\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],
        ["\xD0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\xD0\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],
        ["\xD0\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],
        ["\xD0\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],
        ["\xD0\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],
        ["\xD0\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],
        ["\xD0\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\xD0\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],
        ["\xD0\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],
        ["\xD0\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],
        ["\xD0\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],
        ["\xD0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],
        ["\xD0\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],
        ["\xD0\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],
        ["\xD0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],
        ["\xD0\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],
        ["\xD0\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],
        ["\xD0\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\xD0\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\xD0\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],
        ["\xD0\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],
        ["\xD0\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],
        ["\xD0\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],
        ["\xD0\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\xD0\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],
        ["\xD0\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],
        ["\xD0\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],
        ["\xD0\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],
        ["\xD0\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],
        ["\xD0\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],
        ["\xD0\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],
        ["\xD0\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],
        ["\xD1\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],
        ["\xD0\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],
        ["\xD0\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],
        ["\xD0\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\xD0\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],
        ["\xD0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],
        ["\xD0\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],
        ["\xD0\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\xD0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\xD0\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],
        ["\xD0\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],
        ["\xD1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],
        ["\xD1\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],
        ["\xD1\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],
        ["\xD1\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],
        ["\xD1\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],
        ["\xD1\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],
        ["\xD1\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],
        ["\xD1\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],
        ["\xD1\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\xD1\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],
        ["\xD1\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],
        ["\xD1\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\xD1\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\xD1\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],
        ["\xD1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],
        ["\xD1\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],
        ["\xE2\x94\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xBC"],
        ["\xE2\x94\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xBF"],
        ["\xE2\x94\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xA1"],
        ["\xE2\x94\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xA4"],
        ["\xE2\x94\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xAA"],
        ["\xE2\x94\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xA7"],
        ["\xE2\x94\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xAD"],
        ["\xE2\x94\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xB3"],
        ["\xE2\x94\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xB0"],
        ["\xE2\x94\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xB6"],
        ["\xE2\x94\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xB9"],
        ["\xE2\x94\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xBD"],
        ["\xE2\x94\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xC0"],
        ["\xE2\x94\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xA2"],
        ["\xE2\x94\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xA5"],
        ["\xE2\x94\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xAB"],
        ["\xE2\x94\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xA8"],
        ["\xE2\x94\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xAE"],
        ["\xE2\x94\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xB4"],
        ["\xE2\x94\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xB1"],
        ["\xE2\x94\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xB7"],
        ["\xE2\x95\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF\xBA"],
        ["\xE2\x94\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],
        ["\xE2\x94\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],
        ["\xE2\x94\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],
        ["\xE2\x94\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],
        ["\xE2\x94\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],
        ["\xE2\x94\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],
        ["\xE2\x94\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],
        ["\xE2\x94\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],
        ["\xE2\x94\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],
        ["\xE2\x95\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],
        ["\xE2\x91\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB1"],
        ["\xE2\x91\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB2"],
        ["\xE2\x91\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB3"],
        ["\xE2\x91\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB4"],
        ["\xE2\x91\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB5"],
        ["\xE2\x91\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB6"],
        ["\xE2\x91\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB7"],
        ["\xE2\x91\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB8"],
        ["\xE2\x91\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xB9"],
        ["\xE2\x91\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xBA"],
        ["\xE2\x91\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA1"],
        ["\xE2\x91\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA2"],
        ["\xE2\x91\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA3"],
        ["\xE2\x91\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA4"],
        ["\xE2\x91\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA5"],
        ["\xE2\x91\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA6"],
        ["\xE2\x91\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA7"],
        ["\xE2\x91\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA8"],
        ["\xE2\x91\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xA9"],
        ["\xE2\x91\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xAA"],
        ["\xE2\x85\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB1"],
        ["\xE2\x85\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB2"],
        ["\xE2\x85\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB3"],
        ["\xE2\x85\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB4"],
        ["\xE2\x85\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB5"],
        ["\xE2\x85\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB6"],
        ["\xE2\x85\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB7"],
        ["\xE2\x85\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB8"],
        ["\xE2\x85\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xB9"],
        ["\xE2\x85\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xBA"],
        ["\xE3\x8D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"],
        ["\xE3\x8C\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],
        ["\xE3\x8C\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],
        ["\xE3\x8D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],
        ["\xE3\x8C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"],
        ["\xE3\x8C\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"],
        ["\xE3\x8C\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"],
        ["\xE3\x8C\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"],
        ["\xE3\x8D\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x8D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xDB"],
        ["\xE3\x8C\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xDC"],
        ["\xE3\x8C\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"],
        ["\xE3\x8C\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"],
        ["\xE3\x8C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"],
        ["\xE3\x8D\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xDA"],
        ["\xE3\x8C\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"],
        ["\xE3\x8E\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xCC"],
        ["\xE3\x8E\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xCB"],
        ["\xE3\x8E\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xCA"],
        ["\xE3\x8E\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xDA"],
        ["\xE3\x8E\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"],
        ["\xE3\x8F\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xFA"],
        ["\xE3\x8E\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"],
        ["\xE3\x8D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"],
        ["\xE3\x80\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x84\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x72\xBE"],
        ["\xE3\x8F\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x72\xB6"],
        ["\xE2\x84\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x72\xB8"],
        ["\xE3\x8A\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xEA"],
        ["\xE3\x8A\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xEB"],
        ["\xE3\x8A\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xEC"],
        ["\xE3\x8A\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xED"],
        ["\xE3\x8A\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xEE"],
        ["\xE3\x88\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"],
        ["\xE3\x88\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xB1"],
        ["\xE3\x88\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x73\xBD"],
        ["\xE3\x8D\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"],
        ["\xE3\x8D\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"],
        ["\xE3\x8D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"],
        ["\xE2\x88\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB8"],
        ["\xE2\x88\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xA2"],
        ["\xE2\x88\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB7"],
        ["\xE2\x8A\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xBA"],
        ["\xE4\xBA\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],
        ["\xE5\x94\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],
        ["\xE5\xA8\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],
        ["\xE9\x98\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],
        ["\xE5\x93\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],
        ["\xE6\x84\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],
        ["\xE6\x8C\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],
        ["\xE5\xA7\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],
        ["\xE9\x80\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],
        ["\xE8\x91\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],
        ["\xE8\x8C\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],
        ["\xE7\xA9\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],
        ["\xE6\x82\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],
        ["\xE6\x8F\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],
        ["\xE6\xB8\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],
        ["\xE6\x97\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],
        ["\xE8\x91\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],
        ["\xE8\x8A\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],
        ["\xE9\xAF\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\xE6\xA2\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],
        ["\xE5\x9C\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],
        ["\xE6\x96\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],
        ["\xE6\x89\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],
        ["\xE5\xAE\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],
        ["\xE5\xA7\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],
        ["\xE8\x99\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],
        ["\xE9\xA3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],
        ["\xE7\xB5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],
        ["\xE7\xB6\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],
        ["\xE9\xAE\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],
        ["\xE6\x88\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],
        ["\xE7\xB2\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],
        ["\xE8\xA2\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],
        ["\xE5\xAE\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],
        ["\xE5\xBA\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],
        ["\xE6\x8C\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],
        ["\xE6\x9A\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],
        ["\xE6\xA1\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],
        ["\xE9\x97\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],
        ["\xE9\x9E\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],
        ["\xE6\x9D\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],
        ["\xE4\xBB\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],
        ["\xE4\xBC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],
        ["\xE4\xBD\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],
        ["\xE4\xBE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],
        ["\xE5\x81\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],
        ["\xE5\x9B\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],
        ["\xE5\xA4\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],
        ["\xE5\xA7\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],
        ["\xE5\xA8\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],
        ["\xE5\xB0\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],
        ["\xE6\x83\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],
        ["\xE6\x84\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],
        ["\xE6\x85\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],
        ["\xE6\x98\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],
        ["\xE6\xA4\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],
        ["\xE7\x82\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],
        ["\xE7\x95\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],
        ["\xE7\x95\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],
        ["\xE7\xA7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],
        ["\xE7\xB6\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],
        ["\xE7\xB7\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],
        ["\xE8\x83\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],
        ["\xE8\x90\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],
        ["\xE8\xA1\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],
        ["\xE8\xAC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],
        ["\xE9\x81\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],
        ["\xE9\x81\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],
        ["\xE5\x8C\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],
        ["\xE4\xBA\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],
        ["\xE4\xBA\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],
        ["\xE5\x9F\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],
        ["\xE8\x82\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],
        ["\xE9\x83\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],
        ["\xE7\xA3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],
        ["\xE4\xB8\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],
        ["\xE5\xA3\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],
        ["\xE6\xBA\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],
        ["\xE9\x80\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],
        ["\xE7\xA8\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],
        ["\xE8\x8C\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],
        ["\xE8\x8A\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],
        ["\xE9\xB0\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],
        ["\xE5\x85\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],
        ["\xE5\x8D\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],
        ["\xE5\x92\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],
        ["\xE5\x93\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],
        ["\xE5\x9B\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],
        ["\xE5\xA7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],
        ["\xE5\xBC\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],
        ["\xE9\xA3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],
        ["\xE6\xB7\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],
        ["\xE8\x83\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],
        ["\xE8\x94\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],
        ["\xE9\x99\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],
        ["\xE9\x99\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],
        ["\xE9\x9A\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],
        ["\xE9\x9F\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],
        ["\xE5\x90\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],
        ["\xE5\x8F\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],
        ["\xE5\xAE\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],
        ["\xE7\x83\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],
        ["\xE7\xBE\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],
        ["\xE8\xBF\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],
        ["\xE9\x9B\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],
        ["\xE5\x8D\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],
        ["\xE9\xB5\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],
        ["\xE7\xAA\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],
        ["\xE4\xB8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],
        ["\xE7\xA2\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],
        ["\xE8\x87\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],
        ["\xE6\xB8\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],
        ["\xE5\x98\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],
        ["\xE5\x94\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],
        ["\xE6\xAC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],
        ["\xE8\x94\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],
        ["\xE9\xB0\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],
        ["\xE5\xA7\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],
        ["\xE5\x8E\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],
        ["\xE6\xB5\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],
        ["\xE7\x93\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],
        ["\xE9\x96\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],
        ["\xE5\x99\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],
        ["\xE4\xBA\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],
        ["\xE9\x81\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],
        ["\xE9\x9B\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],
        ["\xE8\x8D\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],
        ["\xE9\xA4\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],
        ["\xE5\x8F\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],
        ["\xE5\x96\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],
        ["\xE5\xAC\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],
        ["\xE5\xBD\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],
        ["\xE6\x98\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],
        ["\xE6\x9B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],
        ["\xE6\xA0\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],
        ["\xE6\xB0\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],
        ["\xE6\xB3\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],
        ["\xE6\xB4\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],
        ["\xE7\x91\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],
        ["\xE7\x9B\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],
        ["\xE7\xA9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],
        ["\xE9\xA0\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],
        ["\xE8\x8B\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],
        ["\xE8\xA1\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],
        ["\xE8\xA9\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],
        ["\xE9\x8B\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],
        ["\xE6\xB6\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],
        ["\xE7\x96\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],
        ["\xE7\x9B\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],
        ["\xE9\xA7\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],
        ["\xE6\x82\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],
        ["\xE8\xAC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],
        ["\xE8\xB6\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],
        ["\xE9\x96\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],
        ["\xE6\xA6\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],
        ["\xE5\x8E\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],
        ["\xE5\x86\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],
        ["\xE5\x9C\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],
        ["\xE5\xA0\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],
        ["\xE5\xA5\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],
        ["\xE5\xAE\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],
        ["\xE5\xBB\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],
        ["\xE6\x80\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],
        ["\xE6\x8E\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],
        ["\xE6\x8F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],
        ["\xE6\xB2\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],
        ["\xE6\xBC\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],
        ["\xE7\x82\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],
        ["\xE7\x84\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],
        ["\xE7\x85\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],
        ["\xE7\x87\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],
        ["\xE7\x8C\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],
        ["\xE7\xB8\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],
        ["\xE8\x89\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],
        ["\xE8\x8B\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],
        ["\xE8\x96\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],
        ["\xE9\x81\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],
        ["\xE9\x89\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],
        ["\xE9\xB4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],
        ["\xE5\xA1\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],
        ["\xE6\x96\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],
        ["\xE6\xB1\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],
        ["\xE7\x94\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],
        ["\xE5\x87\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],
        ["\xE5\xA4\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],
        ["\xE5\xA5\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],
        ["\xE5\xBE\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],
        ["\xE5\xBF\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],
        ["\xE6\x8A\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\xE6\x97\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],
        ["\xE6\xA8\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],
        ["\xE6\xAC\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],
        ["\xE6\xAE\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],
        ["\xE7\x8E\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],
        ["\xE7\xBF\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\xE8\xA5\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],
        ["\xE9\xB4\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xE9\xB4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],
        ["\xE9\xBB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xE5\xB2\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\xE6\xB2\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\xE8\x8D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],
        ["\xE5\x84\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\xE5\xB1\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],
        ["\xE6\x86\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],
        ["\xE8\x87\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],
        ["\xE6\xA1\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],
        ["\xE7\x89\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\xE4\xB9\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],
        ["\xE4\xBF\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],
        ["\xE5\x8D\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],
        ["\xE6\x81\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],
        ["\xE6\xB8\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],
        ["\xE7\xA9\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],
        ["\xE9\x9F\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\xE4\xB8\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],
        ["\xE5\x8C\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],
        ["\xE4\xBB\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],
        ["\xE4\xBD\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\xE4\xBC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],
        ["\xE4\xBE\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],
        ["\xE4\xBD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xE5\x8A\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],
        ["\xE5\x8F\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],
        ["\xE5\x98\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],
        ["\xE5\xA4\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\xE5\xAB\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],
        ["\xE5\xAE\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\xE5\xAF\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],
        ["\xE7\xA7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],
        ["\xE6\x9A\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],
        ["\xE6\x9E\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\xE6\x9E\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xE6\xAD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xE6\xB2\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],
        ["\xE7\x81\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\xE7\x8F\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],
        ["\xE7\xA6\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\xE7\xA6\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xE7\xA8\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\xE7\xAE\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\xE8\x8A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xE8\x8B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\xE8\x8C\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],
        ["\xE8\x8D\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],
        ["\xE8\x8F\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],
        ["\xE8\x8F\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xE8\x9D\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],
        ["\xE8\xAA\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],
        ["\xE5\x98\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\xE8\xB2\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],
        ["\xE8\xBF\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\xE9\x81\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xE9\x9C\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],
        ["\xE8\x9A\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],
        ["\xE4\xBF\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],
        ["\xE5\xB3\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],
        ["\xE6\x88\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],
        ["\xE7\x89\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xE7\x94\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],
        ["\xE8\x87\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\xE8\x8A\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xE8\x9B\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\xE8\xB3\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],
        ["\xE9\x9B\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],
        ["\xE9\xA4\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\xE9\xA7\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],
        ["\xE4\xBB\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\xE4\xBC\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\xE8\xA7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\xE5\x9B\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],
        ["\xE5\xA1\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\xE5\xA3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xE5\xBB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xE5\xBF\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],
        ["\xE6\x80\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],
        ["\xE6\x82\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\xE6\x81\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],
        ["\xE6\x87\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],
        ["\xE6\x88\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],
        ["\xE6\x8B\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],
        ["\xE6\x94\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\xE9\xAD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xE6\x99\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xE6\xA2\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xE6\xB5\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xE7\x81\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xE7\x95\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xE7\x9A\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xE7\xB5\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xE8\x8A\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xE8\x9F\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xE9\x96\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xE9\x9A\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\xE8\xB2\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\xE5\x87\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xE5\x8A\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xE5\xA4\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xE5\x92\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\xE5\xAE\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xE5\xB4\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xE6\x85\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xE6\xA6\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xE6\xB6\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xE7\xA2\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xE8\x93\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xE8\xA1\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xE8\xA9\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xE9\x8E\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xE9\xAA\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xE6\xB5\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xE9\xA6\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xE8\x9B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xE5\x9E\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xE6\x9F\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\xE8\x9B\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xE9\x88\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xE5\x8A\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xE5\x9A\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xE5\x90\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xE5\xBB\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\xE6\x8B\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xE6\x92\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xE6\xA0\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xE6\xA0\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xE6\xAE\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xE7\x8D\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xE7\xA2\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xE7\xA9\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xE8\xA6\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xE8\xA7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xE8\xB5\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xE8\xBC\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xE9\x83\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xE9\x96\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xE9\x9A\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xE9\x9D\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xE5\xAD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xE5\xB2\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\xE6\xA5\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xE9\xA1\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xE9\xA1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xE6\x8E\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xE7\xAC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xE6\xA8\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xE6\xA9\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xE6\xA2\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xE9\xB0\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\xE6\xBD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xE5\x89\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xE5\x96\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xE6\x81\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xE6\x8B\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\xE6\xB4\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xE6\xB8\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xE6\xBB\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xE8\x91\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xE8\xA4\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xE8\xBD\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xE4\xB8\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xE9\xB0\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xE5\x8F\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xE6\xA4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xE6\xA8\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xE9\x9E\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\xE6\xA0\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xE5\x85\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\xE7\xAB\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE8\x92\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xE9\x87\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xE9\x8E\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xE5\x99\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\xE9\xB4\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\xE6\xA0\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\xE8\x8C\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xE8\x90\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xE7\xB2\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xE5\x88\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xE8\x8B\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xE7\x93\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xE4\xB9\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xE4\xBE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xE5\x86\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xE5\xAF\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xE5\x88\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xE5\x8B\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xE5\x8B\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xE5\xB7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xE5\x96\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xE5\xA0\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xE5\xA7\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xE5\xAE\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xE5\xAE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xE5\xAF\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xE5\xB9\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xE5\xB9\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xE6\x82\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xE6\x84\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xE6\x85\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xE6\x86\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xE6\x8F\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xE6\x95\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xE6\x9F\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xE6\xA1\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xE6\xA3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xE6\xAC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xE6\xAD\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xE6\xB1\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xE6\xBC\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xE6\xBE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\xE6\xBD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\xE7\x92\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xE7\x94\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xE7\x9B\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xE7\x9C\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xE7\xAB\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xE7\xAE\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xE7\xB0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xE7\xB7\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xE7\xBC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xE7\xBF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xE8\x82\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xE8\x89\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xE8\x8E\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xE8\xA6\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xE8\xAB\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\xE8\xB2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xE9\x82\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xE9\x91\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xE9\x96\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xE9\x96\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xE9\x96\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xE9\x99\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xE9\x9F\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xE9\xA4\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xE8\x88\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xE4\xB8\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xE5\x90\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xE5\xB2\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xE5\xB7\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xE7\x8E\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xE7\x99\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xE7\x9C\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xE5\xB2\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xE7\xBF\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xE8\xB4\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xE9\x9B\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xE9\xA0\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xE9\xA1\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xE9\xA1\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xE4\xBC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xE4\xBC\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xE5\x8D\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xE5\x96\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xE5\x99\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xE5\x9F\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xE5\xA5\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xE5\xAC\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xE5\xAF\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xE5\xB2\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xE5\xB8\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xE5\xB9\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xE5\xBF\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xE6\x8F\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xE6\x9C\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xE6\x97\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xE6\x97\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xE6\x9C\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xE6\xA3\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xE6\xA3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xE6\xA9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xE5\xB8\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xE6\xAF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xE6\xB0\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xE6\xB1\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xE7\x95\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xE7\xA5\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xE5\xAD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xE7\xA8\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xE7\xB4\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xE5\xBE\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xE8\xA6\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xE8\xA8\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xE8\xB2\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xE8\xB5\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xE8\xBB\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xE8\xBC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xE9\xA3\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xE9\xA8\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xE9\xAC\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xE4\xBA\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xE5\x81\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xE5\x84\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xE5\xA6\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xE5\xAE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xE6\x88\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xE6\x8A\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xE6\x93\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xE6\xAC\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xE7\x8A\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xE7\x96\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xE7\xA5\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xE7\xBE\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xE8\x9F\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xE8\xAA\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xE8\xAD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xE6\x8E\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xE8\x8F\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xE9\x9E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xE5\x90\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xE5\x90\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xE5\x96\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xE6\xA1\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xE6\xA9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xE8\xA9\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xE7\xA0\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xE6\x9D\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xE9\xBB\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xE5\x8D\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xE5\xAE\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xE8\x84\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xE8\x99\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xE9\x80\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xE4\xB8\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xE4\xB9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xE4\xBB\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xE4\xBC\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xE5\x8F\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xE5\x90\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xE5\xAE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xE5\xBC\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xE6\x80\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xE6\x95\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xE6\x9C\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xE6\xB1\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xE6\xB1\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xE6\xB3\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xE7\x81\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xE7\x90\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xE7\xA9\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xE7\xAA\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xE7\xAC\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xE7\xB4\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xE7\xB3\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xE7\xB5\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xE6\x97\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xE7\x89\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xE5\x8E\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xE5\xB1\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xE5\xB7\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xE6\x8B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xE6\x8B\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xE6\x8C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xE6\xB8\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xE8\x99\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xE8\xA8\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xE8\xB7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xE9\x8B\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xE6\xBC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xE7\xA6\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xE9\xAD\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xE4\xBA\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xE4\xBA\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xE4\xBA\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xE4\xBE\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xE4\xBE\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xE5\x83\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xE5\x85\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xE7\xAB\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xE5\x85\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xE5\x87\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xE5\x8D\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xE5\x8C\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xE5\x8D\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xE5\x8F\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xE5\x96\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xE5\xA2\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xE5\xB3\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xE5\xBC\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xE5\xBD\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xE6\x80\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xE6\x81\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xE6\x81\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xE6\x8C\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xE6\x95\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xE6\xA9\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xE6\xB3\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xE7\x8B\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xE7\x8B\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xE7\x9F\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xE8\x83\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xE8\x84\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xE8\x88\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xE8\x95\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xE9\x83\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xE9\x8F\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xE9\x9F\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xE9\xA5\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xE9\xA9\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xE4\xBB\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xE5\x87\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xE5\xB0\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xE6\x9A\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xE6\xA5\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xE5\xB1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xE6\x9B\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xE6\xA5\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xE7\x8E\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xE6\xA1\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xE7\xB2\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xE5\x83\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xE5\x8B\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xE5\x9D\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xE5\xB7\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xE9\x8C\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xE6\x96\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xE6\xAC\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xE6\xAC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xE7\x90\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xE7\xA6\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xE7\xA6\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xE7\xAD\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xE7\xB7\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xE8\x8A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xE8\x8F\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xE8\xA1\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xE8\xA5\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xE8\xAC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xE8\xBF\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xE9\x87\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xE5\x90\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xE9\x8A\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xE4\xB9\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xE5\x80\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xE5\x8F\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xE5\x8C\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xE7\x8B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xE7\x8E\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xE7\x9F\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xE8\x8B\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xE8\xBA\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xE9\xA7\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xE9\xA7\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xE9\xA7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xE5\x85\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],
        ["\xE6\x84\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\xE8\x99\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xE5\x96\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xE7\xA9\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xE5\x81\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xE5\xAF\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xE9\x81\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xE9\x9A\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xE4\xB8\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\xE6\xAB\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xE9\x87\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],
        ["\xE5\xB1\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\xE5\xB1\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xE6\x8E\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xE7\xAA\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xE6\xB2\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xE9\x9D\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xE8\xBD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xE7\xAA\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xE7\x86\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],
        ["\xE9\x9A\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xE7\xB2\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xE6\xA0\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xE7\xB9\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xE6\xA1\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xE9\x8D\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xE5\x8B\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xE5\x90\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xE8\x96\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xE8\xA8\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xE7\xBE\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xE8\xBB\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xE9\x83\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xE5\x8D\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xE8\xA2\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xE7\xA5\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xE4\xBF\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xE5\x82\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xE5\x88\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xE5\x85\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xE5\x95\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xE5\x9C\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xE7\x8F\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xE5\x9E\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xE5\xA5\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xE5\xBD\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xE5\xBE\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xE6\x81\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xE6\x85\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xE6\x85\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xE6\x86\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xE6\x8E\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xE6\x90\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xE6\x95\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xE6\x99\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xE6\xA1\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xE6\xB8\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xE7\x95\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xE7\xA8\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xE7\xB3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xE7\xB5\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xE7\xB6\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
        ["\xE7\xB9\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],
        ["\xE7\xBD\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\xE8\x8C\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],
        ["\xE8\x8D\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],
        ["\xE8\x9B\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],
        ["\xE8\xA8\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\xE8\xA9\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\xE8\xAD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],
        ["\xE8\xBB\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],
        ["\xE9\xA0\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xE9\xB6\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\xE8\x8A\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],
        ["\xE8\xBF\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\xE9\xAF\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\xE5\x8A\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],
        ["\xE6\x88\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],
        ["\xE6\x92\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],
        ["\xE6\xBF\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\xE9\x9A\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\xE6\xA1\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\xE5\x82\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\xE6\xAC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],
        ["\xE6\xB1\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],
        ["\xE6\xBD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\xE7\xA9\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\xE7\xB5\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\xE8\xA1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\xE8\xA8\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],
        ["\xE6\x9C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\xE4\xBB\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\xE5\x80\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],
        ["\xE5\x80\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\xE5\x81\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\xE5\x85\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\xE5\x88\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],
        ["\xE5\x89\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],
        ["\xE5\x96\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],
        ["\xE5\x9C\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\xE5\xA0\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\xE5\xAB\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],
        ["\xE5\xBB\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],
        ["\xE6\x86\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\xE6\x87\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],
        ["\xE6\x8B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\xE6\x8D\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\xE6\xA4\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],
        ["\xE6\xA8\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\xE7\x89\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xE7\x8A\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\xE7\x8C\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],
        ["\xE7\xA0\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],
        ["\xE7\xA1\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],
        ["\xE7\xB5\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],
        ["\xE7\x9C\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xE8\x82\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],
        ["\xE8\xA6\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],
        ["\xE8\xAC\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xE8\xB3\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\xE8\xBB\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\xE9\x81\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xE9\x8D\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\xE9\x99\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xE9\xA1\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xE9\xA8\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\xE9\xB9\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xE5\x85\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],
        ["\xE5\x8E\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],
        ["\xE5\x8E\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xE5\xB9\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],
        ["\xE5\xBC\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\xE6\xB8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xE6\xBA\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\xE7\x8E\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\xE7\x8F\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\xE7\xB5\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],
        ["\xE8\x88\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],
        ["\xE8\xA8\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xE8\xAB\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xE9\x99\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xE4\xB9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],
        ["\xE5\x80\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\xE5\x8F\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],
        ["\xE5\x91\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xE5\x9B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],
        ["\xE5\xA7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\xE5\xAD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\xE5\xB7\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\xE5\xBA\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],
        ["\xE5\xBC\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\xE6\x88\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\xE6\x95\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\xE6\x9E\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\xE6\xB9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],
        ["\xE7\x8B\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],
        ["\xE7\xB3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],
        ["\xE8\xA2\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xE8\x82\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\xE8\x83\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],
        ["\xE8\x8F\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xE8\x99\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xE8\xAA\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],
        ["\xE8\xB7\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],
        ["\xE9\x88\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],
        ["\xE9\x9B\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],
        ["\xE9\xA1\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xE9\xBC\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xE4\xBA\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],
        ["\xE4\xBA\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xE4\xBC\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],
        ["\xE5\x8D\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],
        ["\xE5\x91\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],
        ["\xE5\x90\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\xE5\xA8\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],
        ["\xE5\xBE\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\xE5\xBE\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],
        ["\xE6\x82\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],
        ["\xE6\xA2\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],
        ["\xE6\xAA\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],
        ["\xE7\x91\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xE7\xA2\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xE8\xAA\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xE8\xAA\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],
        ["\xE8\xAD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xE9\x86\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],
        ["\xE4\xB9\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],
        ["\xE9\xAF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],
        ["\xE4\xBA\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\xE4\xBD\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],
        ["\xE4\xBE\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xE5\x80\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\xE5\x80\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],
        ["\xE5\x85\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\xE5\x85\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xE5\x8A\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\xE5\x8A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],
        ["\xE5\x8B\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\xE5\x8E\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xE5\x8F\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xE5\x90\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xE5\x90\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\xE5\x96\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xE5\x9D\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\xE5\x9E\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\xE5\xA5\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\xE5\xAD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xE5\xAD\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],
        ["\xE5\xAE\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],
        ["\xE5\xB7\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xE5\xB7\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],
        ["\xE5\xB7\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\xE5\xB9\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xE5\xBA\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],
        ["\xE5\xBA\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],
        ["\xE5\xBA\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],
        ["\xE5\xBC\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xE6\x81\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\xE6\x85\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],
        ["\xE6\x8A\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],
        ["\xE6\x8B\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xE6\x8E\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\xE6\x94\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],
        ["\xE6\x98\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAE"],
        ["\xE6\x99\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xE6\x9B\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],
        ["\xE6\x9D\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xE6\xA0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],
        ["\xE6\xA2\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],
        ["\xE6\xA7\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\xE6\xB1\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],
        ["\xE6\xB4\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],
        ["\xE6\xB5\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\xE6\xB8\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xE6\xBA\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xE7\x94\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],
        ["\xE7\x9A\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],
        ["\xE7\xA1\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],
        ["\xE7\xA8\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xE7\xB3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\xE7\xB4\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],
        ["\xE7\xB4\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xE7\xB5\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],
        ["\xE7\xB6\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\xE8\x80\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],
        ["\xE8\x80\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\xE8\x82\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\xE8\x82\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],
        ["\xE8\x85\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\xE8\x86\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],
        ["\xE8\x88\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\xE8\x8D\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xE8\xA1\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],
        ["\xE8\xA1\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\xE8\xAC\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],
        ["\xE8\xB2\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xE8\xB3\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],
        ["\xE9\x83\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xE9\x85\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xE9\x89\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],
        ["\xE7\xA0\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE9\x8B\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\xE9\x96\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],
        ["\xE9\x99\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],
        ["\xE9\xA0\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\xE9\xA6\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],
        ["\xE9\xAB\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],
        ["\xE9\xB4\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\xE5\x89\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],
        ["\xE5\x8A\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],
        ["\xE5\x8F\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],
        ["\xE5\x90\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\xE5\xA3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\xE6\x8B\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\xE6\xBF\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],
        ["\xE8\xB1\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\xE8\xBD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xE9\xBA\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],
        ["\xE5\x85\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],
        ["\xE5\x88\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xE5\x91\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xE5\x9B\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\xE7\xA9\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],
        ["\xE9\x85\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],
        ["\xE9\xB5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],
        ["\xE9\xBB\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\xE7\x8D\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\xE6\xBC\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],
        ["\xE8\x85\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xE7\x94\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],
        ["\xE5\xBF\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\xE6\x83\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],
        ["\xE9\xAA\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],
        ["\xE7\x8B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],
        ["\xE8\xBE\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],
        ["\xE6\xAD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],
        ["\xE9\xA0\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\xE4\xBB\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],
        ["\xE5\x9B\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\xE5\x9D\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],
        ["\xE5\xA2\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],
        ["\xE5\xA9\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xE6\x81\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],
        ["\xE6\x87\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\xE6\x98\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xE6\x98\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],
        ["\xE6\xA0\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\xE6\xA2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],
        ["\xE6\xB7\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\xE7\x97\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],
        ["\xE7\xB4\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],
        ["\xE8\x89\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\xE9\xAD\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],
        ["\xE4\xBA\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\xE4\xBD\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\xE5\x8F\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\xE5\x94\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\xE5\xB5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],
        ["\xE5\xB7\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\xE5\xB7\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\xE6\x9F\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xE6\xB2\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xE7\x91\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\xE7\xA0\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],
        ["\xE8\xA9\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xE9\x8E\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\xE8\xA3\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],
        ["\xE5\x9D\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\xE5\xBA\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\xE6\x8C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],
        ["\xE5\x82\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],
        ["\xE5\x82\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\xE5\x86\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\xE6\x9C\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xE5\x93\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],
        ["\xE5\xA1\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],
        ["\xE5\xA6\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],
        ["\xE5\xAE\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\xE5\xBD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],
        ["\xE6\x89\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xE6\x8E\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\xE6\xA0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\xE6\xAD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\xE6\xB8\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\xE7\x81\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],
        ["\xE9\x87\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],
        ["\xE7\x8A\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],
        ["\xE7\xA0\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],
        ["\xE7\xA0\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\xE7\xA5\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\xE6\x96\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],
        ["\xE7\xB4\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\xE8\x8F\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\xE8\xA3\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\xE8\xBC\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\xE9\x9A\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],
        ["\xE5\x89\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\xE5\x9C\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],
        ["\xE6\x9D\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\xE7\xBD\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],
        ["\xE8\xB2\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],
        ["\xE5\x86\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],
        ["\xE5\x9D\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],
        ["\xE9\x98\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\xE5\xA0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],
        ["\xE6\xA6\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],
        ["\xE8\x82\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xE5\x92\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],
        ["\xE5\xB4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\xE5\x9F\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],
        ["\xE7\xA2\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xE9\xB7\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\xE4\xBD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xE5\x89\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],
        ["\xE5\x92\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\xE6\x90\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\xE6\x98\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],
        ["\xE6\x9C\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\xE6\x9F\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\xE7\xAA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\xE7\xAD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],
        ["\xE7\xB4\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\xE9\x8C\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xE6\xA1\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\xE9\xAE\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],
        ["\xE7\xAC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],
        ["\xE5\x8C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],
        ["\xE5\x86\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\xE5\x88\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\xE5\xAF\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\xE6\x8B\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\xE6\x92\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\xE6\x93\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\xE6\x9C\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],
        ["\xE6\xAE\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\xE8\x96\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],
        ["\xE9\x9B\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],
        ["\xE7\x9A\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\xE9\xAF\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xE6\x8D\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\xE9\x8C\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\xE9\xAE\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\xE7\x9A\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],
        ["\xE6\x99\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],
        ["\xE4\xB8\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],
        ["\xE5\x82\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xE5\x8F\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\xE5\xB1\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\xE6\x83\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],
        ["\xE6\x92\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\xE6\x95\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\xE6\xA1\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],
        ["\xE7\x87\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],
        ["\xE7\x8F\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\xE7\x94\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],
        ["\xE7\xAE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\xE7\xBA\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\xE8\x9A\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\xE8\xAE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\xE8\xB3\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\xE9\x85\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\xE9\xA4\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\xE6\x96\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\xE6\x9A\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\xE6\xAE\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xE4\xBB\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],
        ["\xE4\xBB\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\xE4\xBC\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],
        ["\xE4\xBD\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\xE5\x88\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\xE5\x8F\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\xE5\x8F\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\xE5\x97\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\xE5\x9B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\xE5\xA3\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xE5\xA7\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],
        ["\xE5\xA7\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\xE5\xA7\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],
        ["\xE5\xAD\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\xE5\xB1\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],
        ["\xE5\xB8\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xE5\xB8\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\xE5\xBF\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\xE6\x80\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\xE6\x8C\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xE6\x94\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],
        ["\xE5\xAD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\xE6\x96\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],
        ["\xE6\x96\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],
        ["\xE6\x97\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],
        ["\xE6\x9E\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\xE6\xAD\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\xE6\xAD\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\xE6\xB0\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],
        ["\xE7\x8D\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],
        ["\xE7\xA5\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\xE7\xA7\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],
        ["\xE7\xB3\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],
        ["\xE7\xB4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\xE7\xB4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\xE8\x82\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\xE8\x84\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\xE8\x87\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xE8\xA6\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],
        ["\xE8\xA9\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\xE8\xA9\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\xE8\xA9\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xE8\xAA\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\xE8\xAB\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\xE8\xB3\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xE8\xB3\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],
        ["\xE9\x9B\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],
        ["\xE9\xA3\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],
        ["\xE6\xAD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],
        ["\xE4\xBA\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\xE4\xBC\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\xE4\xBE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],
        ["\xE5\x85\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\xE5\xAD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],
        ["\xE5\xAF\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\xE6\x85\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\xE6\x8C\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\xE6\x99\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],
        ["\xE6\xAC\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],
        ["\xE6\xBB\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\xE6\xB2\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\xE7\x88\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],
        ["\xE7\x92\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xE7\x97\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\xE7\xA3\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\xE7\xA4\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\xE8\x80\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\xE8\x80\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\xE8\x87\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\xE8\x92\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xE8\xBE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\xE6\xB1\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\xE9\xB9\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],
        ["\xE5\xBC\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],
        ["\xE8\xAD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xE9\xB4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\xE7\xAB\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\xE8\xBB\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xE5\xAE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\xE9\x9B\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\xE4\xB8\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],
        ["\xE5\x8F\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xE5\x9F\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\xE5\xA4\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xE5\xAB\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\xE5\xAE\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],
        ["\xE6\x82\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xE6\xB9\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\xE6\xBC\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\xE7\x96\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\xE8\xB3\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],
        ["\xE5\xAE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],
        ["\xE8\x94\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],
        ["\xE7\xAF\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xE5\x81\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\xE6\x9F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\xE8\x8A\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\xE5\xB1\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\xE8\x95\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE7\xB8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\xE8\x88\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],
        ["\xE5\x86\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\xE5\xB0\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\xE6\x8D\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\xE8\xB5\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\xE6\x96\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\xE7\x85\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\xE7\xA4\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],
        ["\xE7\xB4\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\xE8\x80\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],
        ["\xE8\xAC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\xE8\xBB\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\xE9\x81\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\xE8\x9B\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\xE9\x82\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\xE5\x80\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],
        ["\xE5\x8B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xE5\xB0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xE6\x9D\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],
        ["\xE7\x81\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xE7\x88\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\xE9\x85\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xE9\x87\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xE9\x8C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\xE8\x8B\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],
        ["\xE5\xAF\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\xE5\xBC\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\xE6\x83\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\xE4\xB8\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],
        ["\xE5\x8F\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\xE5\xAE\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],
        ["\xE6\x89\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\xE6\x9C\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\xE6\xAE\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\xE7\x8B\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],
        ["\xE7\x8F\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\xE7\xA8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],
        ["\xE8\x85\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\xE8\xB6\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\xE9\x85\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],
        ["\xE9\xA6\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],
        ["\xE5\x84\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\xE5\x8F\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],
        ["\xE5\x91\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],
        ["\xE5\xAF\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],
        ["\xE6\x8E\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],
        ["\xE6\xA8\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\xE7\xB6\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],
        ["\xE9\x9C\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],
        ["\xE5\x9B\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\xE5\x8F\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],
        ["\xE5\x91\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],
        ["\xE5\xAE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],
        ["\xE5\xB0\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\xE5\xB7\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],
        ["\xE4\xBF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],
        ["\xE6\x84\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\xE6\x8B\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\xE6\xB4\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],
        ["\xE7\xA7\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\xE7\xA7\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\xE7\xB5\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xE7\xB9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],
        ["\xE7\xBF\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\xE8\x87\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\xE8\x88\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],
        ["\xE8\x92\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\xE8\xA1\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],
        ["\xE8\xA5\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\xE8\xAE\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\xE8\xB9\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xE8\xBC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],
        ["\xE9\x80\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\xE9\x85\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xE9\x85\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\xE9\x9B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\xE9\x86\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xE4\xBB\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\xE4\xBD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xE5\x85\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\xE5\x8D\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xE5\xBE\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],
        ["\xE6\x88\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\xE6\x9F\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xE6\xB1\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],
        ["\xE6\xB8\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\xE7\x8D\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xE7\xB8\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xE9\x87\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],
        ["\xE9\x8A\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\xE5\x8F\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\xE5\xA4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xE5\xAE\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xE6\xB7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\xE7\xA5\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],
        ["\xE7\xB8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\xE7\xB2\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\xE5\xA1\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\xE7\x86\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\xE5\x87\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\xE8\xA1\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xE8\xBF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\xE4\xBF\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],
        ["\xE5\xB3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],
        ["\xE6\x98\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\xE7\x9E\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\xE7\xAB\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],
        ["\xE8\x88\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],
        ["\xE9\xA7\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xE5\x87\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],
        ["\xE5\xBE\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\xE6\x97\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\xE6\xA5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\xE6\xAE\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\xE6\xB7\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],
        ["\xE6\xBA\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xE6\xBD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\xE7\x9B\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\xE7\xB4\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xE5\xB7\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\xE9\x81\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],
        ["\xE9\x86\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\xE9\xA0\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\xE5\x87\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],
        ["\xE5\x88\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\xE6\x89\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\xE6\x9A\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],
        ["\xE6\x9B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],
        ["\xE6\xB8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],
        ["\xE5\xBA\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\xE7\xB7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\xE7\xBD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\xE6\x9B\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xE8\x96\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xE8\x97\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\xE8\xAB\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\xE5\x8A\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\xE5\x8F\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],
        ["\xE5\xA5\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xE5\xBA\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],
        ["\xE5\xBE\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],
        ["\xE6\x81\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],
        ["\xE9\x8B\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],
        ["\xE9\x99\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],
        ["\xE5\x82\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],
        ["\xE5\x84\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xE5\x8B\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\xE5\x8C\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\xE5\x8D\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\xE5\x8F\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],
        ["\xE5\x93\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\xE5\x95\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\xE5\x94\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\xE5\x98\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\xE5\xA5\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],
        ["\xE5\xA6\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\xE5\xA8\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xE5\xAE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\xE5\xB0\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],
        ["\xE5\xB0\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\xE5\xB0\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],
        ["\xE5\xB0\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],
        ["\xE5\xBA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\xE5\xBA\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],
        ["\xE5\xBB\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\xE5\xBD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\xE6\x89\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\xE6\x8A\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\xE6\x8B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xE6\x8E\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],
        ["\xE6\x8D\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\xE6\x98\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\xE6\x98\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\xE6\x98\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\xE6\x99\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\xE6\x9D\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\xE6\xA2\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],
        ["\xE6\xA8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\xE6\xA8\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],
        ["\xE6\xB2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xE6\xB6\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xE6\xB8\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\xE6\xB9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],
        ["\xE7\x84\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],
        ["\xE7\x84\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\xE7\x85\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xE7\x97\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\xE7\x9C\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\xE7\xA1\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],
        ["\xE7\xA4\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\xE7\xA5\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xE7\xA7\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],
        ["\xE7\xAB\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\xE7\xAC\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],
        ["\xE7\xB2\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],
        ["\xE7\xB4\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\xE8\x82\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],
        ["\xE8\x8F\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xE8\x92\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],
        ["\xE8\x95\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],
        ["\xE8\xA1\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xE8\xA3\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\xE8\xA8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\xE8\xA8\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],
        ["\xE8\xA9\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\xE8\xA9\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\xE8\xB1\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\xE8\xB3\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],
        ["\xE9\x86\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],
        ["\xE9\x89\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\xE9\x8D\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],
        ["\xE9\x90\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\xE9\x9A\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\xE9\x9E\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\xE4\xB8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xE4\xB8\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\xE4\xB8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],
        ["\xE4\xB9\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\xE5\x86\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],
        ["\xE5\x89\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\xE5\x9F\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xE5\xA0\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\xE5\xA3\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\xE5\xAC\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\xE5\xB8\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],
        ["\xE6\x83\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xE6\x93\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xE6\x9D\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],
        ["\xE6\x9D\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],
        ["\xE6\xB5\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],
        ["\xE7\x8A\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],
        ["\xE7\x95\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],
        ["\xE7\xA9\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\xE8\x92\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],
        ["\xE8\xAD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xE9\x86\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],
        ["\xE9\x8C\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xE5\x98\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],
        ["\xE5\x9F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],
        ["\xE9\xA3\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],
        ["\xE6\x8B\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],
        ["\xE6\xA4\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],
        ["\xE6\xAE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\xE7\x87\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\xE7\xB9\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\xE8\x81\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],
        ["\xE8\x89\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],
        ["\xE8\xA7\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\xE9\xA3\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\xE8\x9D\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xE8\xBE\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\xE5\xB0\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\xE4\xBC\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\xE4\xBF\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\xE4\xBE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],
        ["\xE5\x94\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\xE5\xA8\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\xE5\xAF\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\xE5\xAF\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\xE5\xBF\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],
        ["\xE6\x85\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],
        ["\xE6\x8C\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],
        ["\xE6\x96\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\xE6\x99\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],
        ["\xE6\xA3\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\xE6\xA6\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xE6\xB5\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xE6\xB7\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xE7\x94\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\xE7\x96\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],
        ["\xE7\x9C\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xE7\xA5\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xE7\xA7\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\xE7\xB4\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],
        ["\xE8\x87\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\xE8\x8A\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xE8\x96\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\xE8\xA6\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\xE8\xA8\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],
        ["\xE8\xBA\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\xE8\xBE\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],
        ["\xE9\x80\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xE9\x87\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],
        ["\xE9\x9C\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xE4\xBA\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],
        ["\xE4\xBB\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xE5\x88\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\xE5\xA1\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],
        ["\xE5\xA3\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\xE5\xB0\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\xE7\x94\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],
        ["\xE5\xB0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],
        ["\xE8\x85\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],
        ["\xE8\xA8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],
        ["\xE8\xBF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\xE9\x99\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\xE9\x9D\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xE7\xAC\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],
        ["\xE8\xAB\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\xE9\xA0\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\xE9\x85\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\xE5\x9B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],
        ["\xE5\x8E\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xE9\x80\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\xE5\x90\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],
        ["\xE5\x9E\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],
        ["\xE5\xB8\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\xE6\x8E\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xE6\xB0\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\xE7\x82\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\xE7\x9D\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xE7\xB2\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\xE7\xBF\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xE8\xA1\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\xE9\x81\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],
        ["\xE9\x85\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xE9\x8C\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],
        ["\xE9\x8C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],
        ["\xE9\x9A\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\xE7\x91\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xE9\xAB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],
        ["\xE5\xB4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\xE5\xB5\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],
        ["\xE6\x95\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\xE6\x9E\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],
        ["\xE8\xB6\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],
        ["\xE9\x9B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],
        ["\xE6\x8D\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xE6\x9D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\xE6\xA4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xE8\x8F\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\xE9\xA0\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\xE9\x9B\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\xE8\xA3\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\xE6\xBE\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],
        ["\xE6\x91\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],
        ["\xE5\xAF\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\xE4\xB8\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],
        ["\xE7\x80\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\xE7\x95\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\xE6\x98\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xE5\x87\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xE5\x88\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\xE5\x8B\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xE5\xA7\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\xE5\xBE\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],
        ["\xE6\x80\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\xE6\x88\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\xE6\x94\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\xE6\x95\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\xE6\x98\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\xE6\x99\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xE6\xA3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xE6\xA0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],
        ["\xE6\xAD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xE6\xB8\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\xE7\x89\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],
        ["\xE7\x94\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],
        ["\xE7\x9B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\xE7\xB2\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\xE8\x81\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\xE5\xA3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\xE8\xA3\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\xE8\xA5\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xE8\xAA\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\xE8\xAA\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],
        ["\xE8\xAB\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],
        ["\xE9\x80\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],
        ["\xE9\x86\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],
        ["\xE9\x9D\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\xE9\x9D\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\xE6\x96\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xE7\xA8\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\xE8\x84\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],
        ["\xE9\x9A\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\xE5\xB8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],
        ["\xE6\x83\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\xE6\x88\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],
        ["\xE6\x96\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\xE6\x98\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],
        ["\xE6\x9E\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\xE7\x9F\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\xE7\xA9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],
        ["\xE7\xB1\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xE7\xB8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],
        ["\xE8\x84\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xE8\xB2\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\xE8\xB5\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xE8\xB7\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],
        ["\xE8\xB9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\xE7\xA2\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xE5\x88\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],
        ["\xE6\x8B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],
        ["\xE6\x8E\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\xE6\x91\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xE6\x8A\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\xE8\xA8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],
        ["\xE7\xAA\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\xE7\xAF\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\xE8\xAA\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\xE9\x9B\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\xE7\xB5\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\xE8\x88\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xE8\x9D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],
        ["\xE4\xBB\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\xE5\x85\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\xE5\x8D\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\xE5\x8D\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xE5\xAE\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xE5\xB0\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],
        ["\xE5\xB0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\xE5\xB7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],
        ["\xE6\x88\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],
        ["\xE6\x89\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xE6\x92\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\xE6\xA0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xE6\xA0\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\xE6\xB3\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xE6\xB5\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\xE6\xB4\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],
        ["\xE6\x9F\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xE6\xBD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\xE7\x85\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],
        ["\xE7\x85\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\xE6\x97\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\xE7\xA9\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\xE7\xAE\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],
        ["\xE7\xB7\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xE7\xB9\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xE7\xBE\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xE8\x85\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],
        ["\xE8\x88\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xE8\x88\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],
        ["\xE8\x96\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xE8\xA9\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xE8\xB3\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\xE8\xB7\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\xE9\x81\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xE9\x81\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xE9\x8A\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],
        ["\xE9\x8A\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\xE9\x96\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xE9\xAE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xE5\x89\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xE5\x96\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xE6\xBC\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xE7\x84\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],
        ["\xE5\x85\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xE7\xA6\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xE7\xB9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\xE8\x86\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xE7\xB3\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xE5\x99\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],
        ["\xE5\xA1\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\xE5\xB2\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xE6\x8E\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],
        ["\xE6\x9B\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xE6\x9B\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],
        ["\xE6\xA5\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xE7\x8B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xE7\x96\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xE7\x96\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xE7\xA4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xE7\xA5\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xE7\xA7\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xE7\xB2\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xE7\xB4\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xE7\xB5\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xE8\x98\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xE8\xA8\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xE9\x98\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xE9\x81\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xE9\xBC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\xE5\x83\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\xE5\x89\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\xE5\x8F\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xE5\x8F\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xE5\x80\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xE5\x96\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xE5\xA3\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xE5\xA5\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xE7\x88\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xE5\xAE\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xE5\xB1\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xE5\x8C\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xE6\x83\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],
        ["\xE6\x83\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xE6\x8D\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xE6\x8E\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xE6\x8C\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xE6\x8E\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xE6\x93\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xE6\x97\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xE6\x9B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xE5\xB7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xE6\xA7\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xE6\xA7\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xE6\xBC\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xE7\x87\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xE4\xBA\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xE7\x97\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xE7\x9B\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\xE7\xAA\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],
        ["\xE7\xB3\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],
        ["\xE7\xB7\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xE7\xB6\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],
        ["\xE8\x81\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\xE8\x8D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xE8\x8D\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xE8\x91\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xE8\x92\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xE8\x97\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xE8\xA3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xE8\xB5\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xE9\x80\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xE9\x81\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xE9\x8E\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xE9\x9C\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],
        ["\xE9\xA8\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\xE5\x83\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],
        ["\xE5\xA2\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xE6\x86\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\xE8\x87\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xE8\x94\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xE8\xB4\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\xE9\x80\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\xE4\xBF\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xE5\x81\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xE5\x89\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xE5\x8D\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xE6\x81\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xE6\x8D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xE6\x9D\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xE6\xB8\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xE8\xB6\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xE9\x80\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xE4\xBF\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xE5\xB1\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xE8\xB3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xE6\x97\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xE7\xB6\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xE5\x8D\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xE8\xA2\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xE5\x85\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xE6\x8F\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xE5\xAD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xE5\xAD\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xE5\xB0\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xE6\x90\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xE6\x9D\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xE9\x81\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xE4\xBB\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xE5\xA4\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xE5\xA4\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xE6\xB1\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xE8\xA9\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xE5\x94\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xE5\xA0\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xE5\xA6\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xE6\x83\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xE6\x89\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xE6\x9F\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xE8\x88\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xE6\xA5\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xE9\x99\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],
        ["\xE9\xA7\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],
        ["\xE9\xA8\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xE4\xBD\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xE5\xA0\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xE5\xAF\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xE8\x80\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xE5\xB2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xE5\xB8\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xE5\xBE\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xE6\x80\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xE6\x85\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xE6\x88\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xE6\x9B\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xE6\xB3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xE6\xBB\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xE8\x83\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\xE8\x85\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],
        ["\xE8\x8B\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],
        ["\xE8\xA2\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],
        ["\xE8\xB2\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xE9\x80\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xE9\x80\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\xE9\x9A\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xE9\xBB\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xE9\xAF\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xE4\xBB\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xE5\x8F\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xE5\xA4\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xE7\xAC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xE9\x86\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xE9\xA1\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\xE9\xB7\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],
        ["\xE6\xBB\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xE7\x80\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],
        ["\xE5\x8D\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xE5\x95\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\xE5\xAE\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xE6\x89\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xE6\x8A\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xE6\x8B\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xE6\xB2\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xE6\xBF\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xE7\x90\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xE8\xA8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xE9\x90\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xE6\xBF\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xE8\xAB\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\xE8\x8C\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xE5\x87\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xE8\x9B\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xE5\x8F\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xE5\x8F\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xE4\xBD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xE9\x81\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xE8\xBE\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xE5\xA5\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xE8\x84\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xE5\xB7\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xE7\xAB\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xE8\xBE\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xE6\xA3\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xE8\xB0\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xE7\x8B\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xE9\xB1\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xE6\xA8\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xE8\xAA\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xE4\xB8\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xE5\x8D\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xE5\x98\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xE5\x9D\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xE6\x8B\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xE6\x8E\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xE6\x97\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xE6\xAD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xE6\xB7\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xE6\xB9\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xE7\x82\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xE7\x9F\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xE7\xAB\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xE7\xAE\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xE7\xB6\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xE8\x80\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xE8\x83\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xE8\x9B\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xE8\xAA\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xE9\x8D\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xE5\x9B\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xE5\xA3\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xE5\xBC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xE6\x96\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xE6\x9A\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xE6\xAA\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xE6\xAE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xE7\x94\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],
        ["\xE8\xAB\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],
        ["\xE5\x80\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],
        ["\xE7\x9F\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xE5\x9C\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xE5\xBC\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xE6\x81\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xE6\x99\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xE6\xB1\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xE7\x97\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xE7\xA8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xE7\xBD\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xE8\x87\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xE8\x9C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xE9\x81\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xE9\xA6\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xE7\xAF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xE7\x95\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xE7\xAB\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xE7\xAD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xE8\x93\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xE9\x80\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xE7\xA7\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xE7\xAA\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xE8\x8C\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xE5\xAB\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xE7\x9D\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xE4\xB8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xE4\xBB\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xE5\xAE\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xE5\xBF\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xE6\x8A\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xE6\x98\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\xE6\x9F\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xE6\xB3\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],
        ["\xE8\x99\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xE8\xA1\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xE8\xA8\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xE9\x85\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xE9\x8B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xE9\xA7\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xE6\xA8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xE7\x80\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xE7\x8C\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xE8\x8B\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xE8\x91\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xE8\xB2\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xE4\xB8\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\xE5\x85\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xE5\x87\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xE5\x96\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],
        ["\xE5\xAF\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xE5\xB8\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xE5\xB8\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],
        ["\xE5\xBA\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xE5\xBC\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xE5\xBC\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xE5\xBD\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\xE5\xBE\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xE6\x87\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\xE6\x8C\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xE6\x9A\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xE6\x9C\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xE6\xBD\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xE7\x89\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],
        ["\xE7\x94\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\xE7\x9C\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],
        ["\xE8\x81\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xE8\x84\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xE8\x85\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\xE8\x9D\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\xE8\xAA\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xE8\xAB\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xE8\xB6\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xE8\xB7\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xE9\x8A\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\xE9\x95\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xE9\xA0\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xE9\xB3\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xE5\x8B\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xE6\x8D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xE7\x9B\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xE6\x9C\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\xE6\xB2\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xE7\x8F\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xE8\xB3\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xE9\x8E\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xE9\x99\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xE6\xB4\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xE5\xA2\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xE6\xA4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xE6\xA7\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xE8\xBF\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xE9\x8E\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\xE7\x97\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\xE9\x80\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],
        ["\xE5\xA1\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC4"],
        ["\xE6\xA0\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],
        ["\xE6\x8E\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],
        ["\xE6\xA7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xE4\xBD\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xE6\xBC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xE6\x9F\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xE8\xBE\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xE8\x94\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xE7\xB6\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xE9\x8D\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xE6\xA4\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xE6\xBD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xE5\x9D\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xE5\xA3\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xE5\xAC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\xE7\xB4\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\xE7\x88\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],
        ["\xE5\x90\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xE9\x87\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xE9\xB6\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xE4\xBA\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xE4\xBD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xE5\x81\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xE5\x81\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xE5\x89\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xE8\xB2\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xE5\x91\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xE5\xA0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xE5\xAE\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xE5\xB8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\xE5\xBA\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xE5\xBA\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xE5\xBB\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xE5\xBC\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xE6\x82\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xE6\x8A\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xE6\x8C\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xE6\x8F\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xE6\xA2\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xE6\xB1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xE7\xA2\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xE7\xA6\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xE7\xA8\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xE7\xB7\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xE8\x89\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\xE8\xA8\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xE8\xAB\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xE8\xB9\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\xE9\x80\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],
        ["\xE9\x82\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xE9\x84\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xE9\x87\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xE9\xBC\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xE6\xB3\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xE6\x91\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xE6\x93\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xE6\x95\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\xE6\xBB\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xE7\x9A\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xE7\xAC\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xE9\x81\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xE9\x8F\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xE6\xBA\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xE5\x93\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xE5\xBE\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xE6\x92\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xE8\xBD\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],
        ["\xE8\xBF\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\xE9\x89\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xE5\x85\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xE5\xA1\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],
        ["\xE5\xA4\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\xE5\xB1\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\xE5\xBA\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xE6\xB7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xE7\xBA\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xE7\x94\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xE8\xB2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xE8\xBB\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xE9\xA1\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],
        ["\xE7\x82\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xE4\xBC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xE6\xAE\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xE6\xBE\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xE7\x94\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xE9\x9B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xE5\x85\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xE5\x90\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xE5\xA0\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xE5\xA1\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xE5\xA6\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\xE5\xB1\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xE5\xBE\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\xE6\x96\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xE6\x9D\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xE6\xB8\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\xE7\x99\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xE8\x8F\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xE8\xB3\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xE9\x80\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xE9\x83\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xE9\x8D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xE7\xA0\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xE7\xA0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE5\x8A\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xE5\xBA\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xE5\x9C\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xE5\xA5\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xE6\x80\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xE5\x80\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xE5\x85\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],
        ["\xE5\x86\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xE5\x87\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xE5\x88\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\xE5\x94\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xE5\xA1\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xE5\xA1\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xE5\xA5\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xE5\xAE\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xE5\xB3\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xE5\xB6\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xE6\x82\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xE6\x8A\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xE6\x90\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\xE6\x9D\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xE6\xA1\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\xE6\xA2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],
        ["\xE6\xA3\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xE7\x9B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xE6\xB7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xE6\xB9\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xE6\xB6\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\xE7\x81\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xE7\x87\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xE5\xBD\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xE7\x97\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xE7\xA5\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xE7\xAD\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xE7\xAD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xE7\xAD\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xE7\xB3\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],
        ["\xE7\xB5\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\xE5\x88\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xE8\x91\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xE8\x95\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\xE8\x97\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],
        ["\xE8\xA8\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xE8\xAC\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xE8\xB1\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xE8\xB8\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\xE9\x80\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xE9\x80\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],
        ["\xE9\x90\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\xE9\x99\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xE9\xA0\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\xE9\xA8\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],
        ["\xE9\x97\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\xE5\x83\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\xE5\x8B\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xE5\x90\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\xE5\xA0\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],
        ["\xE5\xB0\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],
        ["\xE6\x86\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xE6\x92\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xE6\xB4\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xE7\x9E\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xE7\xAB\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xE8\x83\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xE8\x90\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xE9\x81\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xE9\x8A\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],
        ["\xE5\xB3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xE9\xB4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],
        ["\xE5\x8C\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xE5\xBE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xE5\xBE\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xE6\xB6\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xE7\x89\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xE7\x9D\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xE7\xA6\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xE7\xAF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xE6\xAF\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xE7\x8B\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xE8\xAA\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xE6\xA0\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],
        ["\xE6\xA9\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],
        ["\xE5\x87\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\xE7\xAA\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],
        ["\xE6\xA4\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xE5\xB1\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\xE9\xB3\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xE8\x8B\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xE5\xAF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xE9\x85\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xE7\x80\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xE5\x99\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xE5\xB1\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xE6\x83\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xE6\x95\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xE6\xB2\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xE8\xB1\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xE9\x81\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xE9\xA0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\xE5\x91\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xE6\x9B\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],
        ["\xE9\x88\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xE5\xA5\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xE9\x82\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xE5\x86\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xE4\xB9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xE5\x87\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xE8\x96\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xE8\xAC\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xE7\x81\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xE6\x8D\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xE9\x8D\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xE6\xA5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],
        ["\xE9\xA6\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\xE7\xB8\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],
        ["\xE7\x95\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xE5\x8D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],
        ["\xE6\xA5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],
        ["\xE8\xBB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xE9\x9B\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xE6\xB1\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xE4\xBA\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xE5\xB0\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xE5\xBC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\xE8\xBF\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\xE5\x8C\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xE8\xB3\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xE8\x82\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xE8\x99\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\xE5\xBB\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xE6\x97\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xE4\xB9\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xE5\x85\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xE5\xA6\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xE5\xB0\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],
        ["\xE9\x9F\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\xE4\xBB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],
        ["\xE5\xA6\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\xE5\xBF\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xE8\xAA\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xE6\xBF\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],
        ["\xE7\xA6\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],
        ["\xE7\xA5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\xE5\xAF\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xE8\x91\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],
        ["\xE7\x8C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xE7\x86\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],
        ["\xE5\xB9\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xE5\xBF\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xE6\x8D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xE6\x92\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xE7\x87\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xE7\xB2\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xE4\xB9\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],
        ["\xE5\xBB\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xE4\xB9\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xE5\x9F\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xE5\x9A\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xE6\x82\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xE6\xBF\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\xE7\xB4\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],
        ["\xE8\x83\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xE8\x84\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xE8\x86\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],
        ["\xE8\xBE\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xE8\xA6\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xE8\x9A\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xE5\xB7\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xE6\x8A\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xE6\x92\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xE8\xA6\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xE6\x9D\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xE6\xB3\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xE6\xB4\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xE7\x90\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\xE7\xA0\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xE5\xA9\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xE7\xBD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xE8\x8A\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],
        ["\xE9\xA6\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],
        ["\xE4\xBF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xE5\xBB\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xE6\x8B\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xE6\x8E\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xE6\x95\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xE6\x9D\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xE7\x9B\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xE7\x89\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xE8\x83\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xE8\x82\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xE8\xBC\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],
        ["\xE9\x85\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xE5\x80\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],
        ["\xE5\x9F\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],
        ["\xE5\xAA\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\xE6\xA2\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xE6\xA5\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xE7\x85\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xE7\x8B\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xE8\xB2\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xE5\xA3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xE8\xB3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xE9\x99\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xE9\x80\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xE8\x9D\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xE7\xA7\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xE7\x9F\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],
        ["\xE8\x90\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],
        ["\xE4\xBC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xE5\x89\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xE5\x8D\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xE6\x8B\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xE6\x9F\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xE6\xB3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xE7\x99\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xE7\xAE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xE7\xB2\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xE8\x88\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xE8\x96\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xE8\xBF\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xE6\x9B\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xE6\xBC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xE7\x88\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],
        ["\xE7\xB8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],
        ["\xE8\x8E\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],
        ["\xE9\xA7\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xE9\xBA\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xE5\x87\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xE7\xAE\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],
        ["\xE7\xA1\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xE7\xAE\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\xE8\x82\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\xE7\xAD\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\xE6\xAB\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xE5\xB9\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xE8\x82\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xE7\x95\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\xE7\x95\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xE5\x85\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xE9\x89\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],
        ["\xE6\xBA\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xE7\x99\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xE9\x86\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xE9\xAB\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xE4\xBC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xE7\xBD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xE6\x8A\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\xE7\xAD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\xE9\x96\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xE9\xB3\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xE5\x99\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],
        ["\xE5\xA1\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xE8\x9B\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xE9\x9A\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xE4\xBC\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\xE5\x88\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],
        ["\xE5\x8D\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],
        ["\xE5\x8F\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xE5\x8F\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xE5\xB8\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xE6\x90\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xE6\x96\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xE6\x9D\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xE6\xB0\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xE6\xB1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xE7\x89\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xE7\x8A\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xE7\x8F\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xE7\x95\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xE7\xB9\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xE8\x88\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],
        ["\xE8\x97\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\xE8\xB2\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],
        ["\xE7\xAF\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xE9\x87\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xE7\x85\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xE9\xA0\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xE9\xA3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xE6\x8C\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xE6\x99\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xE7\x95\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xE7\x9B\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xE7\xA3\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xE8\x95\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xE8\x9B\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xE5\x8C\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xE5\x8D\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xE5\x90\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\xE5\xA6\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\xE5\xBA\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\xE5\xBD\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xE6\x82\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xE6\x89\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xE6\x89\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xE6\x8A\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xE6\x96\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xE6\xAF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xE6\xB3\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xE7\x96\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xE7\x9A\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xE7\xA2\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],
        ["\xE7\xA7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],
        ["\xE7\xB7\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\xE7\xBD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],
        ["\xE8\x82\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xE8\xA2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],
        ["\xE8\xAA\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xE8\xB2\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xE9\x81\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xE9\x9D\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xE9\xA3\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xE6\xA8\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xE7\xB0\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xE5\x82\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xE5\xB0\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xE5\xBE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xE6\x9E\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],
        ["\xE6\xAF\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\xE7\x90\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xE7\x9C\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],
        ["\xE7\xBE\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],
        ["\xE9\xBC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xE6\x9F\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],
        ["\xE7\xA8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\xE5\x8C\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xE7\x96\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xE9\xAB\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xE5\xBD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xE8\x86\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xE8\x8F\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],
        ["\xE8\x82\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xE5\xBC\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xE5\xBF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xE7\x95\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xE7\xAD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xE9\x80\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\xE6\xA1\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],
        ["\xE5\xA7\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xE5\xAA\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xE7\xB4\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xE7\x99\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xE8\xAC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xE4\xBF\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xE5\xBD\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],
        ["\xE6\xA8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xE6\xB0\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xE6\xBC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xE7\x93\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xE7\xA5\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xE8\xA1\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xE8\xA9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xE8\xB1\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],
        ["\xE5\xBB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xE6\x8F\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xE7\x97\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xE7\xA7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xE8\x8B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xE9\x8C\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xE9\x8B\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xE8\x92\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xE8\x9B\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xE9\xB0\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xE5\x93\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],
        ["\xE5\xBD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],
        ["\xE6\x96\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xE6\xB5\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\xE7\x80\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xE8\xB2\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],
        ["\xE8\xB3\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xE9\xA0\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xE6\x95\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xE7\x93\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xE4\xB8\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xE4\xBB\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xE5\x9F\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xE5\xA4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xE5\xA9\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xE5\xAF\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xE5\x86\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],
        ["\xE5\xB8\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\xE5\xBA\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\xE6\x80\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xE6\x89\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\xE6\x95\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\xE6\x96\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xE6\x99\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],
        ["\xE6\xB5\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xE7\x88\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xE7\xAC\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xE8\x85\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xE8\x86\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xE8\x8A\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xE8\xAD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xE8\xB2\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xE8\xB3\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xE8\xB5\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xE9\x98\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xE9\x99\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\xE4\xBE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xE6\x92\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\xE6\xAD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xE8\x88\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xE8\x91\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xE8\x95\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xE9\x83\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xE5\xB0\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xE6\xA5\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xE9\xA2\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xE8\x91\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xE8\x95\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xE4\xBC\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xE5\x89\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xE5\xBE\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xE5\xB9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\xE6\x9C\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\xE7\xA6\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xE8\x85\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xE8\xA4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xE8\xA6\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xE6\xB7\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xE5\xBC\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xE6\x89\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xE6\xB2\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xE4\xBB\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],
        ["\xE7\x89\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xE9\xAE\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\xE5\x88\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],
        ["\xE5\x90\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xE5\x99\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],
        ["\xE5\xA2\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xE6\x86\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\xE6\x89\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],
        ["\xE7\x84\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],
        ["\xE5\xA5\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],
        ["\xE7\xB2\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xE7\xB3\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xE7\xB4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xE9\x9B\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xE6\x96\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xE8\x81\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xE4\xB8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],
        ["\xE4\xBD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],
        ["\xE5\x85\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xE5\xA1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xE5\xB9\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],
        ["\xE5\xB9\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\xE5\xBC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\xE6\x9F\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xE4\xB8\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],
        ["\xE8\x94\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xE9\x96\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],
        ["\xE9\x99\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xE7\xB1\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],
        ["\xE9\xA0\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],
        ["\xE5\x83\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xE5\xA3\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xE7\x99\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],
        ["\xE7\xA2\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],
        ["\xE5\x88\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xE7\x9E\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xE8\x94\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xE7\xAE\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],
        ["\xE5\x81\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],
        ["\xE5\xA4\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xE7\x89\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],
        ["\xE7\xAF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xE7\xB7\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xE8\xBE\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],
        ["\xE8\xBF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xE9\x81\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],
        ["\xE4\xBE\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],
        ["\xE5\x8B\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xE5\xA8\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\xE5\xBC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\xE9\x9E\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],
        ["\xE4\xBF\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xE8\x88\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xE9\x8B\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xE5\x9C\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xE6\x8D\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xE6\xAD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xE7\x94\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],
        ["\xE8\xA3\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xE8\xBC\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\xE7\xA9\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xE5\x8B\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],
        ["\xE5\xA2\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xE6\x85\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xE6\x88\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],
        ["\xE6\x9A\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],
        ["\xE6\xAF\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],
        ["\xE7\xB0\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xE8\x8F\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xE5\x80\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xE4\xBF\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xE5\x8C\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xE5\x91\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xE5\xA0\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xE5\xA5\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xE5\xAE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],
        ["\xE5\xB3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xE5\xB3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],
        ["\xE5\xB4\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xE5\xBA\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],
        ["\xE6\x8A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xE6\x8D\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xE6\x94\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xE6\x96\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xE6\x9C\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xE6\xB3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],
        ["\xE6\xB3\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xE7\x83\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xE7\xA0\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xE7\xB8\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xE8\x83\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xE8\x8A\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xE8\x90\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xE8\x93\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xE8\x9C\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],
        ["\xE8\xA4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xE8\xA8\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xE8\xB1\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xE9\x82\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],
        ["\xE9\x8B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xE9\xA3\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xE9\xB3\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],
        ["\xE9\xB5\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xE4\xB9\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],
        ["\xE4\xBA\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\xE5\x82\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xE5\x89\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],
        ["\xE5\x9D\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],
        ["\xE5\xA6\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xE5\xB8\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],
        ["\xE5\xBF\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xE5\xBF\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],
        ["\xE6\x88\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],
        ["\xE6\x9A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],
        ["\xE6\x9C\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],
        ["\xE6\x9F\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xE6\xA3\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xE5\x86\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xE7\xB4\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xE8\x82\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xE8\x86\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],
        ["\xE8\xAC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xE8\xB2\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],
        ["\xE8\xB2\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xE9\x89\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],
        ["\xE9\x98\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xE5\x90\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],
        ["\xE9\xA0\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xE5\x8C\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],
        ["\xE5\x83\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xE5\x8D\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xE5\xA2\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xE6\x92\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xE6\x9C\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],
        ["\xE7\x89\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],
        ["\xE7\x9D\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xE7\xA9\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xE9\x87\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xE5\x8B\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xE6\xB2\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],
        ["\xE6\xAE\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],
        ["\xE5\xA0\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xE5\xB9\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xE5\xA5\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xE6\x9C\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xE7\xBF\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],
        ["\xE5\x87\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xE7\x9B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],
        ["\xE6\x91\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xE7\xA3\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\xE9\xAD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xE9\xBA\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\xE5\x9F\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\xE5\xA6\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],
        ["\xE6\x98\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],
        ["\xE6\x9E\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xE6\xAF\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xE5\x93\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xE6\xA7\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],
        ["\xE5\xB9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],
        ["\xE8\x86\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],
        ["\xE6\x9E\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],
        ["\xE9\xAE\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],
        ["\xE6\x9F\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xE9\xB1\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],
        ["\xE6\xA1\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],
        ["\xE4\xBA\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],
        ["\xE4\xBF\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xE5\x8F\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xE6\x8A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xE6\x9C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],
        ["\xE6\xB2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xE8\xBF\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xE4\xBE\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],
        ["\xE7\xB9\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xE9\xBA\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xE4\xB8\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\xE6\x85\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xE6\xBA\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],
        ["\xE6\xBC\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\xE8\x94\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],
        ["\xE5\x91\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xE6\x9C\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xE9\xAD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xE5\xB7\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],
        ["\xE7\xAE\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],
        ["\xE5\xB2\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],
        ["\xE5\xAF\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xE8\x9C\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xE6\xB9\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xE8\x93\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xE7\xA8\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xE8\x84\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xE5\xA6\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xE7\xB2\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xE6\xB0\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],
        ["\xE7\x9C\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\xE5\x8B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],
        ["\xE5\xA4\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xE7\x84\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xE7\x89\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xE7\x9F\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xE9\x9C\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],
        ["\xE9\xB5\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xE6\xA4\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xE5\xA9\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xE5\xA8\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xE5\x86\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xE5\x90\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xE5\x91\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],
        ["\xE6\x98\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],
        ["\xE7\x9B\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],
        ["\xE8\xBF\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\xE9\x8A\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\xE9\xB3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],
        ["\xE5\xA7\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xE7\x89\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xE6\xBB\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],
        ["\xE5\x85\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xE6\xA3\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\xE7\xB6\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xE7\xB7\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],
        ["\xE9\x9D\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],
        ["\xE9\xBA\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],
        ["\xE6\x91\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],
        ["\xE6\xA8\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],
        ["\xE8\x8C\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],
        ["\xE5\xA6\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],
        ["\xE5\xAD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],
        ["\xE6\xAF\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xE7\x8C\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],
        ["\xE7\x9B\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],
        ["\xE7\xB6\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],
        ["\xE8\x80\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],
        ["\xE8\x92\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],
        ["\xE5\x84\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xE6\x9C\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],
        ["\xE9\xBB\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],
        ["\xE7\x9B\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xE6\x9D\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],
        ["\xE5\x8B\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xE9\xA4\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xE5\xB0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],
        ["\xE6\x88\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],
        ["\xE7\xB1\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],
        ["\xE8\xB2\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],
        ["\xE5\x95\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xE6\x82\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],
        ["\xE7\xB4\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],
        ["\xE9\x96\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],
        ["\xE5\x8C\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],
        ["\xE4\xB9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xE5\x86\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\xE5\xA4\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xE7\x88\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],
        ["\xE8\x80\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xE9\x87\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xE5\xBC\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xE7\x9F\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xE5\x8E\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],
        ["\xE5\xBD\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],
        ["\xE7\xB4\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],
        ["\xE8\x96\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xE8\xA8\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xE8\xBA\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xE9\x9D\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xE6\x9F\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\xE8\x96\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\x91\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],
        ["\xE6\x84\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],
        ["\xE6\x84\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xE6\xB2\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xE7\x99\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\xE8\xAB\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xE8\xBC\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],
        ["\xE5\x94\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xE4\xBD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xE5\x84\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],
        ["\xE5\x8B\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],
        ["\xE5\x8F\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],
        ["\xE5\xAE\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xE5\xB9\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\xE6\x82\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xE6\x86\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xE6\x8F\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],
        ["\xE6\x9C\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],
        ["\xE6\x9F\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xE6\xB9\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],
        ["\xE6\xB6\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],
        ["\xE7\x8C\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],
        ["\xE7\x8C\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],
        ["\xE7\x94\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],
        ["\xE7\xA5\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],
        ["\xE8\xA3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],
        ["\xE8\xAA\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],
        ["\xE9\x81\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],
        ["\xE9\x82\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],
        ["\xE9\x83\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\xE9\x9B\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xE8\x9E\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],
        ["\xE5\xA4\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\xE4\xBA\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],
        ["\xE4\xBD\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],
        ["\xE4\xB8\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\xE8\xAA\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],
        ["\xE8\xBC\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xE9\xA0\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\xE5\x82\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],
        ["\xE5\xB9\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],
        ["\xE5\xA6\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xE5\xAE\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],
        ["\xE5\xBA\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\xE6\x8F\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\xE6\x8F\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],
        ["\xE6\x93\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],
        ["\xE6\x9B\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],
        ["\xE6\xA5\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\xE6\xA7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\xE6\xB4\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\xE6\xBA\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],
        ["\xE7\x86\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xE7\x94\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],
        ["\xE7\xAA\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\xE7\xBE\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\xE8\x80\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xE8\x91\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\xE8\x93\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xE8\xA6\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],
        ["\xE8\xAC\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xE8\xB8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xE9\x81\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xE9\x99\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],
        ["\xE9\xA4\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],
        ["\xE6\x85\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xE6\x8A\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\xE6\xAC\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xE6\xB2\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xE6\xB5\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],
        ["\xE7\xBF\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\xE7\xBF\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\xE6\xB7\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],
        ["\xE7\xBE\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xE8\x9E\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\xE8\xA3\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\xE6\x9D\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xE8\x8E\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],
        ["\xE9\xA0\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],
        ["\xE9\x9B\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],
        ["\xE6\xB4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xE7\xB5\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xE8\x90\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xE9\x85\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],
        ["\xE4\xB9\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],
        ["\xE5\x8D\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xE5\xB5\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\xE6\xAC\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],
        ["\xE6\xBF\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\xE8\x97\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],
        ["\xE8\x98\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xE8\xA6\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],
        ["\xE5\x88\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\xE5\x90\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xE5\xB1\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],
        ["\xE6\x9D\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],
        ["\xE6\xA2\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xE7\x90\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xE7\x92\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xE7\x97\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xE8\xA3\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xE8\xA3\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xE9\x87\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xE9\x9B\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xE9\x99\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xE5\xBE\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xE7\x8E\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xE7\xAB\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xE8\x91\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],
        ["\xE6\x8E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],
        ["\xE7\x95\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\xE5\x8A\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\xE6\xB5\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],
        ["\xE6\xBA\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],
        ["\xE7\x90\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xE7\x95\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xE7\xA1\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xE7\xB2\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xE9\x9A\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xE7\xAB\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xE9\xBE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xE4\xBE\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xE6\x85\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xE6\x97\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xE8\x99\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xE4\xBA\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xE4\xBA\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xE5\x83\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xE4\xB8\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xE5\x87\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xE5\xAF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],
        ["\xE6\x96\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\xE6\xA2\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],
        ["\xE6\xB6\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],
        ["\xE7\x8C\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],
        ["\xE7\x99\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xE7\x9E\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],
        ["\xE7\xA8\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],
        ["\xE7\xB3\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],
        ["\xE8\x89\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\xE8\xAB\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\xE9\x81\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\xE9\x87\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],
        ["\xE9\x99\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],
        ["\xE9\xA0\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\xE5\x8A\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],
        ["\xE7\xB7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],
        ["\xE5\x80\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\xE5\x8E\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\xE6\x9E\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\xE6\xB7\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],
        ["\xE7\x87\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],
        ["\xE7\x90\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],
        ["\xE8\x87\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xE8\xBC\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],
        ["\xE9\x9A\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\xE9\xB1\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\xE9\xBA\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xE7\x91\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],
        ["\xE5\xA1\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\xE6\xB6\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\xE7\xB4\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\xE9\xA1\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],
        ["\xE4\xBB\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],
        ["\xE4\xBC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\xE4\xBE\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\xE5\x86\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\xE5\x8A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],
        ["\xE5\xB6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],
        ["\xE6\x80\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],
        ["\xE7\x8E\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],
        ["\xE7\xA4\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],
        ["\xE8\x8B\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\xE9\x88\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\xE9\x9A\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\xE9\x9B\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\xE9\x9C\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],
        ["\xE9\xBA\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xE9\xBD\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],
        ["\xE6\x9A\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],
        ["\xE6\xAD\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],
        ["\xE5\x88\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],
        ["\xE5\x8A\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],
        ["\xE7\x83\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\xE8\xA3\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\xE5\xBB\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\xE6\x81\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\xE6\x86\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],
        ["\xE6\xBC\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],
        ["\xE7\x85\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],
        ["\xE7\xB0\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],
        ["\xE7\xB7\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],
        ["\xE8\x81\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xE8\x93\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xE9\x80\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],
        ["\xE9\x8C\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\xE5\x91\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],
        ["\xE9\xAD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\xE6\xAB\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xE7\x82\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xE8\xB3\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],
        ["\xE8\xB7\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xE9\x9C\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xE5\x8A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],
        ["\xE5\xA9\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],
        ["\xE5\xBB\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xE5\xBC\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],
        ["\xE6\x9C\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],
        ["\xE6\xA5\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],
        ["\xE6\xA6\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xE6\xB5\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],
        ["\xE6\xBC\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],
        ["\xE7\x89\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],
        ["\xE7\x8B\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xE7\xAF\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE8\x80\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xE8\x81\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xE8\x9D\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xE9\x83\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],
        ["\xE5\x85\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\xE9\xBA\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\xE7\xA6\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],
        ["\xE8\x82\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xE9\x8C\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],
        ["\xE8\xAB\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],
        ["\xE5\x80\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],
        ["\xE5\x92\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xE8\xA9\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],
        ["\xE6\xAD\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],
        ["\xE8\xB3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xE8\x84\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xE6\x83\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\xE6\x9E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xE9\xB7\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],
        ["\xE4\xBA\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],
        ["\xE4\xBA\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],
        ["\xE9\xB0\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],
        ["\xE8\xA9\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],
        ["\xE8\x97\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],
        ["\xE8\x95\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],
        ["\xE6\xA4\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\xE6\xB9\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\xE7\xA2\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\xE8\x85\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xE5\xBC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xE4\xB8\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xE4\xB8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xE4\xB8\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xE4\xB8\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xE4\xB8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xE4\xB8\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xE4\xB8\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xE4\xB9\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xE4\xB9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xE4\xB9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xE4\xBA\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xE4\xBA\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xE8\xB1\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xE4\xBA\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xE8\x88\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xE5\xBC\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xE4\xBA\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xE4\xBA\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xE4\xBA\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xE4\xBA\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xE4\xBA\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xE4\xBA\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xE4\xBA\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xE4\xBA\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xE4\xBB\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xE4\xBB\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xE4\xBB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xE4\xBB\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xE4\xBB\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xE4\xBB\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xE4\xBB\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],
        ["\xE4\xBB\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\xE4\xBB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\xE4\xBB\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],
        ["\xE4\xBC\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xE4\xBD\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],
        ["\xE4\xBC\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],
        ["\xE4\xBD\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],
        ["\xE4\xBD\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],
        ["\xE4\xBD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],
        ["\xE4\xBD\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],
        ["\xE4\xBD\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],
        ["\xE4\xBE\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],
        ["\xE4\xBE\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\xE4\xBE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xE4\xBD\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],
        ["\xE4\xBD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],
        ["\xE4\xBD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],
        ["\xE4\xBE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],
        ["\xE4\xBD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],
        ["\xE4\xBE\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\xE4\xBE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],
        ["\xE5\x84\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\xE4\xBF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],
        ["\xE4\xBF\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xE4\xBF\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],
        ["\xE4\xBF\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],
        ["\xE4\xBF\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],
        ["\xE4\xBF\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],
        ["\xE4\xBF\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],
        ["\xE4\xBF\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],
        ["\xE4\xBF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],
        ["\xE4\xBF\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xE5\x80\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xE5\x80\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\xE5\x80\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],
        ["\xE5\x80\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xE5\x80\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],
        ["\xE5\x80\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],
        ["\xE4\xBC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],
        ["\xE4\xBF\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\xE5\x80\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\xE5\x80\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\xE5\x80\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],
        ["\xE4\xBF\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\xE4\xBF\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\xE5\x80\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],
        ["\xE5\x80\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\xE5\x81\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\xE5\x81\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],
        ["\xE6\x9C\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\xE5\x81\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xE5\x81\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\xE5\x81\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],
        ["\xE5\x81\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],
        ["\xE5\x81\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],
        ["\xE5\x81\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\xE5\x81\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xE5\x82\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\xE5\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\xE5\x82\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xE5\x82\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],
        ["\xE5\x82\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\xE5\x83\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xE5\x83\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xE5\x82\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],
        ["\xE5\x83\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],
        ["\xE5\x83\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],
        ["\xE5\x83\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],
        ["\xE5\x83\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],
        ["\xE5\x83\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],
        ["\xE5\x83\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],
        ["\xE5\x83\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],
        ["\xE5\x83\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xE5\x83\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],
        ["\xE5\x84\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xE5\x84\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],
        ["\xE5\x84\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xE5\x84\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xE5\x84\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],
        ["\xE5\x84\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],
        ["\xE5\x84\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],
        ["\xE5\x84\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xE5\x84\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],
        ["\xE5\x84\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],
        ["\xE5\x84\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\xE5\x84\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\xE5\x84\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\xE5\x85\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],
        ["\xE5\x85\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xE5\x85\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\xE5\x85\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\xE5\x85\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\xE7\xAB\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],
        ["\xE5\x85\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xE5\x85\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xE5\x85\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xE5\x86\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xE5\x86\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xE5\x9B\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xE5\x86\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xE5\x86\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xE5\x86\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xE5\x86\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xE5\x86\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],
        ["\xE5\x86\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\xE5\x86\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xE5\x86\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xE5\x86\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],
        ["\xE5\x86\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],
        ["\xE5\x86\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xE5\x86\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xE5\x86\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xE5\x86\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xE5\x86\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xE5\x86\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xE5\x86\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xE5\x86\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xE5\x86\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xE5\x87\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xE5\x87\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xE5\x87\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xE5\x87\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\xE8\x99\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\xE5\x87\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],
        ["\xE5\x87\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],
        ["\xE5\x87\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xE5\x87\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],
        ["\xE5\x87\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xE5\x88\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xE5\x88\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xE5\x88\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xE5\x88\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xE5\x88\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xE5\x88\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xE5\x88\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xE5\x88\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],
        ["\xE5\x88\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\xE5\x89\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xE5\x89\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xE5\x89\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\xE5\x89\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xE5\x89\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xE5\x89\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xE5\x89\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xE5\x89\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xE5\x89\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xE5\x89\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xE5\x89\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xE5\x89\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xE5\x8A\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xE5\x8A\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xE5\x8A\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],
        ["\xE5\x89\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],
        ["\xE5\x8A\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],
        ["\xE5\x8A\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],
        ["\xE8\xBE\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xE8\xBE\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xE5\x8A\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],
        ["\xE5\x8A\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\xE5\x8A\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xE5\x8A\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],
        ["\xE5\x8B\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\xE5\x8B\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\xE5\x8B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],
        ["\xE5\x8B\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\xE5\x8B\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],
        ["\xE5\x8B\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xE9\xA3\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],
        ["\xE5\x8B\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],
        ["\xE5\x8B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],
        ["\xE5\x8B\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\xE5\x8B\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xE5\x8B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xE5\x8C\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\xE5\x8C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\xE7\x94\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\xE5\x8C\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\xE5\x8C\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xE5\x8C\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\xE5\x8C\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\xE5\x8C\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xE5\x8C\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],
        ["\xE5\x8C\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\xE5\x8C\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],
        ["\xE5\x8C\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\xE5\x8C\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],
        ["\xE5\x8D\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],
        ["\xE5\x8D\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xE5\x8D\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xE4\xB8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xE5\x8D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xE5\x8D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xE5\x87\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xE5\x8D\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xE5\x8D\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xE5\x8D\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xE5\xA4\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xE5\x8D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],
        ["\xE5\x8D\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],
        ["\xE5\x8E\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],
        ["\xE5\x8E\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xE5\x8E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],
        ["\xE5\x8E\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],
        ["\xE5\x8E\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xE5\x8E\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xE5\x8E\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xE5\x8E\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xE5\x8F\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xE7\xB0\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xE9\x9B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xE5\x8F\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xE6\x9B\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xE7\x87\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xE5\x8F\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\xE5\x8F\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],
        ["\xE5\x8F\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],
        ["\xE5\x8F\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],
        ["\xE5\x90\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],
        ["\xE5\x90\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\xE5\x91\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xE5\x90\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],
        ["\xE5\x90\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xE5\x90\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xE5\x90\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xE5\x90\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xE5\x90\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xE5\x90\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xE5\x91\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xE5\x92\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xE5\x91\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\xE5\x92\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],
        ["\xE5\x91\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xE5\x91\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xE5\x91\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\xE5\x91\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],
        ["\xE5\x92\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xE5\x91\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xE5\x92\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xE5\x91\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xE5\x92\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xE5\x92\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xE5\x92\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xE5\x93\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xE5\x92\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xE5\x92\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xE5\x92\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xE5\x92\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xE5\x93\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\xE5\x93\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\xE5\x92\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xE5\x92\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xE5\x93\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xE5\x92\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],
        ["\xE5\x92\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],
        ["\xE5\x92\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xE5\x93\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\xE5\x93\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\xE5\x93\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],
        ["\xE5\x94\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],
        ["\xE5\x94\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xE5\x93\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xE5\x93\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],
        ["\xE5\x93\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],
        ["\xE5\x93\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],
        ["\xE5\x93\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],
        ["\xE5\x94\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xE5\x95\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xE5\x95\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xE5\x95\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xE5\x94\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],
        ["\xE5\x95\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xE5\x95\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],
        ["\xE5\x95\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xE5\x95\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\xE5\x94\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xE5\x94\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],
        ["\xE5\x95\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xE5\x96\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],
        ["\xE5\x96\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xE5\x92\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xE5\x96\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],
        ["\xE5\x96\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xE5\x95\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xE5\x95\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xE5\x96\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xE5\x96\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xE5\x96\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xE5\x95\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xE5\x96\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xE5\x96\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xE5\x96\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xE5\x96\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xE5\x97\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xE5\x97\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xE5\x97\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xE5\x97\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],
        ["\xE5\x97\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xE5\x97\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xE5\x97\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xE5\x98\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xE5\x97\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xE5\x98\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xE5\x97\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xE5\x97\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xE5\x98\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xE5\x97\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xE5\x99\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xE5\x99\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],
        ["\xE7\x87\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\xE5\x98\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xE5\x98\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xE5\x98\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\xE5\x98\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xE5\x99\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xE5\x99\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xE5\x98\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xE5\x99\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xE5\x99\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xE5\x9A\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xE5\x9A\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xE5\x9A\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xE5\x9A\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xE5\x9A\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xE5\x9A\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],
        ["\xE5\x9A\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xE5\x9A\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xE5\x9A\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xE5\x9A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],
        ["\xE5\x9B\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xE5\x9A\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xE5\x9B\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xE5\x9B\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xE5\x9B\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xE5\x9B\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xE5\x9B\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xE5\x9B\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xE5\x9B\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xE5\x9B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xE5\x9B\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xE5\x9B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xE5\x9C\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],
        ["\xE5\x9B\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xE5\x9C\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xE5\x9C\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xE5\x9C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xE5\x9C\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\xE5\x9C\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xE5\x9C\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xE5\x9C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xE5\x9C\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\xE5\x97\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],
        ["\xE5\x9C\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\xE5\x9C\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xE5\x9C\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],
        ["\xE5\x9C\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xE5\x9D\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],
        ["\xE5\x9C\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\xE5\x9D\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],
        ["\xE5\x9D\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xE5\x9D\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xE5\x9F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xE5\x9E\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xE5\x9D\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xE5\x9D\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\xE5\x9E\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xE5\x9E\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],
        ["\xE5\x9E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\xE5\x9E\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xE5\x9E\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xE5\x9E\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\xE5\x9E\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],
        ["\xE5\x9F\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],
        ["\xE5\x9F\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],
        ["\xE5\x9F\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xE5\x9F\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],
        ["\xE5\x9F\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xE5\xA0\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xE5\x9F\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xE5\x9F\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xE5\xA0\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xE5\xA0\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xE5\xA0\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xE5\xA1\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xE5\xA0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xE5\xA1\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xE5\xA1\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xE5\xA1\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xE6\xAF\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\xE5\xA1\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\xE5\xA0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xE5\xA1\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],
        ["\xE5\xA2\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xE5\xA2\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xE5\xA2\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xE5\xA2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xE5\xA2\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xE5\xA3\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xE5\xA2\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xE5\xA2\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xE5\xA2\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xE5\xA3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xE5\xA3\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\xE5\xA3\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],
        ["\xE5\xA3\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xE5\xA3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],
        ["\xE5\xA3\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\xE5\xA3\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],
        ["\xE5\xA3\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xE5\xA3\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xE5\xA3\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xE5\xA3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xE5\xA3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\xE5\xA3\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xE5\xA3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xE5\xA3\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xE5\xA3\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xE5\xA4\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xE5\xA4\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xE5\xA4\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\xE5\xA4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xE6\xA2\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xE5\xA4\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\xE5\xA4\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xE5\xA4\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xE5\xA4\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xE5\xA4\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xE5\xA4\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xE7\xAB\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xE5\xA5\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xE5\xA5\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xE5\xA5\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xE5\xA5\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xE5\xA5\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xE5\xA5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\xE5\xA5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\xE5\xA5\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xE5\xA5\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],
        ["\xE5\xA5\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],
        ["\xE5\xA5\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xE5\xA6\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],
        ["\xE5\xA6\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],
        ["\xE4\xBD\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],
        ["\xE4\xBE\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\xE5\xA6\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],
        ["\xE5\xA6\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],
        ["\xE5\xA7\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\xE5\xA7\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\xE5\xA7\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\xE5\xA6\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xE5\xA7\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],
        ["\xE5\xA7\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\xE5\xA8\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],
        ["\xE5\xA8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\xE5\xA8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xE5\xA8\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\xE5\xA8\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],
        ["\xE5\xA8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\xE5\xA9\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\xE5\xA9\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],
        ["\xE5\xA9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\xE5\xA8\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\xE5\xA8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],
        ["\xE5\xA9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\xE5\xA9\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],
        ["\xE5\xAA\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\xE5\xAA\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\xE5\xAA\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\xE5\xAB\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\xE5\xAB\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\xE5\xAA\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xE5\xAB\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xE5\xAB\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xE5\xAB\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xE5\xAB\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xE5\xAB\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xE5\xAB\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xE5\xAB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xE5\xAC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xE5\xAC\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xE5\xAC\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\xE5\xAC\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],
        ["\xE5\xAB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\xE5\xAC\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\xE5\xAC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],
        ["\xE5\xAC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\xE5\xAD\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xE5\xAD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xE5\xAD\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xE5\xAD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xE5\xAD\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xE5\xAD\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xE5\xAD\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xE5\xAD\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xE5\xAD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xE5\xAD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xE5\xAD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\xE5\xAD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],
        ["\xE5\xAD\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\xE6\x96\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\xE5\xAD\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],
        ["\xE5\xAE\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],
        ["\xE5\xAE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xE5\xAE\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],
        ["\xE5\xAE\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xE5\xAF\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xE5\xAF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xE5\xAF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xE5\xAF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xE5\xAF\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xE5\xAF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xE5\xAF\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xE5\xAF\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],
        ["\xE5\xAF\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\xE5\xAF\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],
        ["\xE5\xAF\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],
        ["\xE5\xAF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],
        ["\xE5\xAF\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\xE5\xAF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xE5\xB0\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xE5\xB0\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xE5\xB0\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xE5\xB0\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xE5\xB0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xE5\xB0\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xE5\xB0\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xE5\xB0\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xE5\xB0\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xE5\xB0\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],
        ["\xE5\xB1\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],
        ["\xE5\xB1\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],
        ["\xE5\xB1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],
        ["\xE5\xB1\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],
        ["\xE5\xB1\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],
        ["\xE5\xB1\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],
        ["\xE5\xAD\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],
        ["\xE5\xB1\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],
        ["\xE5\xB1\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],
        ["\xE4\xB9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],
        ["\xE5\xB1\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],
        ["\xE5\xB1\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],
        ["\xE5\xB2\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],
        ["\xE5\xB2\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],
        ["\xE5\xB2\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],
        ["\xE5\xA6\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],
        ["\xE5\xB2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],
        ["\xE5\xB2\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],
        ["\xE5\xB2\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],
        ["\xE5\xB2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],
        ["\xE5\xB2\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],
        ["\xE5\xB3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],
        ["\xE5\xB2\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],
        ["\xE5\xB3\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],
        ["\xE5\xB3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],
        ["\xE5\xB3\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],
        ["\xE5\xB3\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],
        ["\xE5\xB3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\xE5\xB3\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\xE5\xB6\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\xE5\xB3\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xE5\xB4\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\xE5\xB4\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\xE5\xB4\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\xE5\xB5\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\xE5\xB4\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\xE5\xB4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xE5\xB4\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xE5\xB4\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xE5\xB4\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xE5\xB4\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xE5\xB4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xE5\xB4\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xE5\xB5\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xE5\xB5\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xE5\xB5\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\xE5\xB5\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\xE5\xB5\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],
        ["\xE5\xB5\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],
        ["\xE5\xB5\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],
        ["\xE5\xB6\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],
        ["\xE5\xB6\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\xE5\xB6\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xE5\xB6\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xE5\xB6\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xE5\xB6\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xE5\xB6\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xE5\xB6\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xE5\xB6\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xE5\xB6\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xE5\xB6\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xE5\xB7\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],
        ["\xE5\xB7\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],
        ["\xE5\xB7\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\xE5\xB7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\xE5\xB7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],
        ["\xE5\xB7\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\xE5\xB7\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xE5\xB7\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],
        ["\xE5\xB7\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xE5\xB8\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\xE5\xB8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],
        ["\xE5\xB8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],
        ["\xE5\xB8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xE5\xB8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],
        ["\xE5\xB8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],
        ["\xE5\xB8\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],
        ["\xE5\xB9\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],
        ["\xE5\xB9\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],
        ["\xE5\xB9\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\xE5\xB9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\xE5\xB9\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],
        ["\xE5\xB9\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],
        ["\xE5\xB9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xE5\xB9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xE5\xB9\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xE5\xB9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xE5\xB9\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xE5\xB9\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xE5\xB9\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xE9\xBA\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xE5\xB9\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xE5\xBA\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xE5\xBB\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\xE5\xBB\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\xE5\xBB\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\xE5\xBB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],
        ["\xE5\xBB\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],
        ["\xE5\xBB\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xE5\xBB\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],
        ["\xE5\xBB\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],
        ["\xE5\xBB\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],
        ["\xE5\xBB\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],
        ["\xE5\xBB\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],
        ["\xE5\xBB\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],
        ["\xE5\xBB\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],
        ["\xE5\xBB\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],
        ["\xE5\xBB\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],
        ["\xE5\xBB\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xE5\xBB\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],
        ["\xE5\xBB\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],
        ["\xE5\xBB\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],
        ["\xE5\xBB\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],
        ["\xE5\xBB\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xE5\xBC\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],
        ["\xE5\xBC\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],
        ["\xE5\xBD\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],
        ["\xE5\xBD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],
        ["\xE5\xBC\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],
        ["\xE5\xBC\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],
        ["\xE5\xBC\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],
        ["\xE5\xBC\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],
        ["\xE5\xBC\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],
        ["\xE5\xBC\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],
        ["\xE5\xBD\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],
        ["\xE5\xBD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],
        ["\xE5\xBD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],
        ["\xE5\xBC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],
        ["\xE5\xBD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xE5\xBD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xE5\xBD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xE5\xBD\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xE5\xBD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xE5\xBD\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xE5\xBD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xE5\xBD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xE5\xBE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xE5\xBE\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xE5\xBD\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],
        ["\xE5\xBE\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],
        ["\xE5\xBE\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],
        ["\xE5\xBE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],
        ["\xE5\xBE\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],
        ["\xE5\xBE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],
        ["\xE5\xBE\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xE5\xBE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xE5\xBE\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xE5\xBE\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xE5\xBE\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xE5\xBE\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xE5\xBF\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xE5\xBF\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xE5\xBF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xE5\xBF\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xE5\xBF\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],
        ["\xE5\xBF\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],
        ["\xE6\x82\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],
        ["\xE5\xBF\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],
        ["\xE6\x80\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],
        ["\xE6\x81\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],
        ["\xE6\x80\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xE6\x80\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],
        ["\xE6\x80\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xE6\x80\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xE6\x80\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xE6\x80\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xE6\x80\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xE6\x80\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xE6\x80\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xE6\x80\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xE6\x80\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],
        ["\xE6\x81\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],
        ["\xE6\x81\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],
        ["\xE6\x81\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],
        ["\xE6\x81\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],
        ["\xE6\x81\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],
        ["\xE6\x81\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xE6\x81\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xE6\x81\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xE6\x81\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xE6\x81\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xE6\x81\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xE6\x81\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xE6\x81\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xE6\x81\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xE6\x81\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xE6\x82\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],
        ["\xE6\x82\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],
        ["\xE6\x83\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],
        ["\xE6\x82\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],
        ["\xE6\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],
        ["\xE6\x82\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xE6\x82\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\xE6\x82\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\xE6\x82\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\xE6\x82\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],
        ["\xE6\x82\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],
        ["\xE6\x82\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],
        ["\xE6\x83\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\xE6\x82\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\xE6\x83\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\xE6\x83\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xE6\x82\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\xE5\xBF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\xE6\x82\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\xE6\x83\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\xE6\x82\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xE6\x83\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\xE6\x85\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],
        ["\xE6\x84\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],
        ["\xE6\x84\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],
        ["\xE6\x83\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\xE6\x83\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\xE6\x84\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\xE6\x83\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],
        ["\xE6\x83\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\xE6\x84\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\xE6\x84\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],
        ["\xE6\x83\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],
        ["\xE6\x83\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\xE6\x84\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\xE6\x84\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\xE6\x85\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xE6\x84\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xE6\x84\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xE6\x84\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xE6\x85\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xE6\x84\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xE6\x84\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xE6\x84\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xE6\x84\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xE6\x84\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xE6\x85\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\xE6\x85\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],
        ["\xE6\x85\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\xE6\x85\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\xE6\x85\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\xE6\x85\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],
        ["\xE6\x85\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xE6\x85\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xE6\x85\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xE6\x85\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xE6\x85\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xE6\x85\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xE6\x85\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xE6\x85\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xE6\x85\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xE6\x85\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xE6\x86\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],
        ["\xE6\x86\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],
        ["\xE6\x86\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],
        ["\xE6\x86\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\xE6\x86\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\xE6\x86\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],
        ["\xE6\x86\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xE6\x86\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],
        ["\xE6\x86\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xE6\x86\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xE6\x87\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xE6\x87\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xE6\x87\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xE6\x87\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xE6\x87\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xE6\x87\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xE6\x87\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],
        ["\xE6\x86\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],
        ["\xE6\x87\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],
        ["\xE7\xBD\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\xE6\x87\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\xE6\x87\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],
        ["\xE6\x87\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xE6\x87\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xE6\x87\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xE6\x87\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xE6\x87\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xE6\x87\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xE6\x87\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xE6\x87\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xE6\x88\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xE6\x88\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xE6\x88\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\xE6\x88\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],
        ["\xE6\x88\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\xE6\x88\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],
        ["\xE6\x88\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\xE6\x88\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xE6\x88\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],
        ["\xE6\x88\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],
        ["\xE6\x88\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],
        ["\xE6\x88\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],
        ["\xE6\x88\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],
        ["\xE6\x88\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],
        ["\xE6\x89\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],
        ["\xE6\x89\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],
        ["\xE6\x89\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],
        ["\xE6\x89\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xE6\x89\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],
        ["\xE6\x89\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],
        ["\xE6\x89\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],
        ["\xE6\x89\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],
        ["\xE6\x8A\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xE6\x8A\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],
        ["\xE6\x89\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],
        ["\xE6\x8A\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],
        ["\xE6\x8A\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],
        ["\xE6\x8A\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],
        ["\xE6\x8B\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],
        ["\xE6\x8A\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],
        ["\xE6\x8A\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],
        ["\xE6\x8B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],
        ["\xE6\x8B\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],
        ["\xE6\x8A\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],
        ["\xE6\x8B\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],
        ["\xE6\x8B\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],
        ["\xE6\x8B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],
        ["\xE6\x93\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],
        ["\xE6\x8B\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xE6\x8B\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xE6\x8B\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xE6\x8B\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xE6\x8B\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xE6\x8B\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xE6\x8A\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xE6\x8B\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xE6\x8C\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xE6\x8B\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xE6\x8B\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],
        ["\xE6\x8C\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],
        ["\xE6\x8C\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],
        ["\xE6\x8C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],
        ["\xE6\x8B\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],
        ["\xE6\x8B\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],
        ["\xE6\x8D\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xE6\x8C\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xE6\x8D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xE6\x90\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xE6\x8D\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xE6\x8E\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xE6\x8E\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xE6\x8E\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xE6\x8E\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xE6\x8D\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xE6\x8E\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],
        ["\xE6\x8E\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],
        ["\xE6\x8E\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],
        ["\xE6\x8E\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],
        ["\xE6\x8E\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],
        ["\xE6\x8D\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],
        ["\xE6\x8D\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xE6\x8E\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],
        ["\xE6\x8F\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xE6\x8F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xE6\x8F\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xE6\x8F\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xE6\x8F\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xE6\x8F\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xE6\x8F\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xE6\x8F\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xE6\x90\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],
        ["\xE6\x90\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],
        ["\xE6\x90\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],
        ["\xE6\x90\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],
        ["\xE6\x90\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],
        ["\xE6\x90\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],
        ["\xE6\x94\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xE6\x90\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xE6\x90\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xE6\x90\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xE6\x91\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xE6\x91\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xE6\x91\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xE6\x91\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xE6\x94\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xE6\x92\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xE6\x92\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],
        ["\xE6\x92\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],
        ["\xE6\x92\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],
        ["\xE6\x92\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],
        ["\xE6\x92\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],
        ["\xE6\x93\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],
        ["\xE6\x93\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],
        ["\xE6\x93\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],
        ["\xE6\x93\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],
        ["\xE6\x92\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],
        ["\xE6\x93\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],
        ["\xE6\x93\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],
        ["\xE6\x93\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],
        ["\xE6\x93\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],
        ["\xE8\x88\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],
        ["\xE6\x93\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],
        ["\xE6\x93\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],
        ["\xE6\x8A\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],
        ["\xE6\x93\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],
        ["\xE6\x93\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],
        ["\xE6\x94\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],
        ["\xE6\x93\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],
        ["\xE6\x93\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],
        ["\xE6\x93\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],
        ["\xE6\x93\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],
        ["\xE6\x94\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],
        ["\xE6\x93\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],
        ["\xE6\x94\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],
        ["\xE6\x94\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],
        ["\xE6\x94\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],
        ["\xE6\x94\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],
        ["\xE6\x94\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],
        ["\xE6\x94\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],
        ["\xE6\x94\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],
        ["\xE6\x94\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],
        ["\xE6\x94\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],
        ["\xE6\x94\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],
        ["\xE6\x94\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],
        ["\xE7\x95\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],
        ["\xE6\x95\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],
        ["\xE6\x95\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],
        ["\xE6\x95\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],
        ["\xE6\x95\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],
        ["\xE6\x95\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],
        ["\xE6\x95\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],
        ["\xE6\x95\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],
        ["\xE6\x95\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],
        ["\xE6\x95\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],
        ["\xE6\x96\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],
        ["\xE6\x96\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],
        ["\xE8\xAE\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],
        ["\xE6\x96\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],
        ["\xE6\x96\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],
        ["\xE6\x96\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],
        ["\xE6\x96\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],
        ["\xE6\x97\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],
        ["\xE6\x97\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],
        ["\xE6\x97\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],
        ["\xE6\x97\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],
        ["\xE6\x97\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],
        ["\xE6\x97\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],
        ["\xE6\x97\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],
        ["\xE6\x97\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],
        ["\xE6\x97\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],
        ["\xE6\x97\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],
        ["\xE6\x97\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],
        ["\xE6\x9D\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\xE6\x98\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\xE6\x98\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],
        ["\xE6\x97\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],
        ["\xE6\x9D\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],
        ["\xE6\x98\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],
        ["\xE6\x98\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],
        ["\xE6\x98\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],
        ["\xE6\x98\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],
        ["\xE6\x99\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],
        ["\xE6\x99\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],
        ["\xE6\x99\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],
        ["\xE6\x99\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],
        ["\xE6\x99\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],
        ["\xE6\x99\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],
        ["\xE6\x99\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],
        ["\xE6\x99\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],
        ["\xE6\x99\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],
        ["\xE6\x99\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],
        ["\xE6\x99\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],
        ["\xE6\x99\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],
        ["\xE6\x9A\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],
        ["\xE6\x9A\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],
        ["\xE6\x9A\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],
        ["\xE6\x9A\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],
        ["\xE6\x9A\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],
        ["\xE6\x9A\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],
        ["\xE6\x9A\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],
        ["\xE6\x9B\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],
        ["\xE6\x9A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],
        ["\xE6\x9B\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],
        ["\xE6\x9A\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],
        ["\xE6\x9A\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],
        ["\xE6\x9B\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],
        ["\xE6\x9A\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],
        ["\xE6\x9B\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],
        ["\xE6\x9B\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],
        ["\xE6\x9B\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],
        ["\xE6\x98\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],
        ["\xE6\x9B\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],
        ["\xE6\x9B\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],
        ["\xE6\x9B\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],
        ["\xE6\x9B\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],
        ["\xE6\x9B\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],
        ["\xE6\x9C\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],
        ["\xE6\x9C\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],
        ["\xE6\x9C\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],
        ["\xE6\x9C\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],
        ["\xE6\x9C\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],
        ["\xE9\x9C\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],
        ["\xE6\x9C\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],
        ["\xE6\x9C\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],
        ["\xE6\x9C\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],
        ["\xE6\x9D\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],
        ["\xE6\x9C\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],
        ["\xE6\x9C\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],
        ["\xE6\x9D\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],
        ["\xE6\x9D\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],
        ["\xE6\x9D\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],
        ["\xE6\x9D\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],
        ["\xE6\x9D\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],
        ["\xE6\x9D\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],
        ["\xE6\x9E\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],
        ["\xE6\x9D\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],
        ["\xE6\x9E\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],
        ["\xE6\x9D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],
        ["\xE6\x9D\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],
        ["\xE6\x9E\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],
        ["\xE6\x9E\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],
        ["\xE6\x9E\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],
        ["\xE6\x9E\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],
        ["\xE6\x9E\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],
        ["\xE6\x9E\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],
        ["\xE6\x9F\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],
        ["\xE6\x9E\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],
        ["\xE6\x9F\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],
        ["\xE6\x9E\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],
        ["\xE6\x9F\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],
        ["\xE6\x9E\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],
        ["\xE6\x9F\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],
        ["\xE6\x9F\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],
        ["\xE6\x9F\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],
        ["\xE6\x9F\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],
        ["\xE6\x9F\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],
        ["\xE6\x9E\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],
        ["\xE6\x9F\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],
        ["\xE6\x9F\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],
        ["\xE6\x9F\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],
        ["\xE6\xAA\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xE6\xA0\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],
        ["\xE6\xA1\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],
        ["\xE6\xA0\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],
        ["\xE6\xA1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],
        ["\xE6\xA1\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],
        ["\xE6\xA0\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],
        ["\xE6\xA1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],
        ["\xE6\xA2\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],
        ["\xE6\xA0\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],
        ["\xE6\xA1\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],
        ["\xE6\xA1\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],
        ["\xE6\xA1\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],
        ["\xE6\xA1\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],
        ["\xE6\xA2\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],
        ["\xE6\xA2\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],
        ["\xE6\xA2\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],
        ["\xE6\xA2\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],
        ["\xE6\xA2\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],
        ["\xE6\xA2\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],
        ["\xE6\xA2\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],
        ["\xE6\xAA\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xE6\xA2\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],
        ["\xE6\xA1\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],
        ["\xE6\xA2\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],
        ["\xE6\xA2\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],
        ["\xE6\xA2\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],
        ["\xE6\xA4\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],
        ["\xE6\xA2\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],
        ["\xE6\xA1\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],
        ["\xE6\xA4\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],
        ["\xE6\xA3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],
        ["\xE6\xA4\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],
        ["\xE6\xA3\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],
        ["\xE6\xA4\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],
        ["\xE6\xA4\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],
        ["\xE6\xA3\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],
        ["\xE6\xA4\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],
        ["\xE6\xA3\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],
        ["\xE6\xA3\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],
        ["\xE6\xA3\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],
        ["\xE6\xA3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],
        ["\xE6\xA4\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],
        ["\xE6\xA4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],
        ["\xE6\xA4\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],
        ["\xE6\xA3\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],
        ["\xE6\xA3\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],
        ["\xE6\xA4\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],
        ["\xE6\xA3\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],
        ["\xE6\xA3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],
        ["\xE6\xA3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],
        ["\xE6\xA4\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],
        ["\xE6\xA4\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],
        ["\xE6\xA4\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],
        ["\xE6\xA4\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],
        ["\xE6\xA4\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],
        ["\xE6\xA3\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],
        ["\xE6\xA5\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],
        ["\xE6\xA5\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],
        ["\xE6\xA5\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],
        ["\xE6\xA5\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],
        ["\xE6\xA5\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],
        ["\xE6\xA5\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],
        ["\xE6\xA5\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],
        ["\xE6\xA5\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],
        ["\xE6\xA4\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],
        ["\xE6\xA5\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],
        ["\xE6\xA4\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],
        ["\xE6\xA5\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],
        ["\xE6\xA4\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],
        ["\xE6\xA5\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],
        ["\xE6\xA5\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],
        ["\xE6\xA5\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],
        ["\xE6\xA6\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],
        ["\xE6\xA5\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],
        ["\xE6\xA6\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],
        ["\xE6\xA6\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],
        ["\xE6\xA7\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],
        ["\xE6\xA6\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],
        ["\xE6\xA7\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],
        ["\xE6\xA7\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],
        ["\xE6\xA6\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],
        ["\xE6\xA7\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],
        ["\xE5\xAF\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],
        ["\xE6\xA7\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],
        ["\xE6\xA7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],
        ["\xE6\xA6\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],
        ["\xE6\xA7\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],
        ["\xE6\xA6\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],
        ["\xE6\xA8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],
        ["\xE6\xA6\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],
        ["\xE6\xA6\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],
        ["\xE6\xA6\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],
        ["\xE6\xA6\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],
        ["\xE6\xA6\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],
        ["\xE6\xA7\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],
        ["\xE6\xA7\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],
        ["\xE6\xA8\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],
        ["\xE6\xA8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],
        ["\xE6\xA7\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],
        ["\xE6\xAC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],
        ["\xE6\xA7\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],
        ["\xE6\xA7\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],
        ["\xE6\xA7\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],
        ["\xE6\xA8\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],
        ["\xE6\xA6\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],
        ["\xE6\xA8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],
        ["\xE6\xA7\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],
        ["\xE6\xA8\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],
        ["\xE6\xA7\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],
        ["\xE6\xA8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],
        ["\xE6\xA8\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],
        ["\xE6\xAB\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],
        ["\xE6\xA8\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],
        ["\xE6\xA8\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],
        ["\xE6\xA9\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],
        ["\xE6\xA8\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],
        ["\xE6\xA9\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],
        ["\xE6\xA8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],
        ["\xE6\xA9\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],
        ["\xE6\xA9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],
        ["\xE6\xA9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],
        ["\xE6\xA9\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],
        ["\xE6\xA9\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],
        ["\xE6\xA9\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],
        ["\xE6\xA8\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],
        ["\xE6\xA8\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],
        ["\xE6\xAA\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],
        ["\xE6\xAA\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],
        ["\xE6\xAA\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],
        ["\xE6\xAA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],
        ["\xE6\xAA\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],
        ["\xE6\xAA\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],
        ["\xE6\xAA\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],
        ["\xE8\x98\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],
        ["\xE6\xAA\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],
        ["\xE6\xAB\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],
        ["\xE6\xAB\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],
        ["\xE6\xAA\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],
        ["\xE6\xAA\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],
        ["\xE6\xAA\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],
        ["\xE6\xAB\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],
        ["\xE6\xAB\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],
        ["\xE6\xAB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],
        ["\xE6\xAA\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],
        ["\xE6\xAB\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],
        ["\xE6\xAB\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],
        ["\xE6\xAB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],
        ["\xE6\xAC\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],
        ["\xE8\x98\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],
        ["\xE6\xAB\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],
        ["\xE6\xAC\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],
        ["\xE6\xAC\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],
        ["\xE9\xAC\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],
        ["\xE6\xAC\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\xE6\xAC\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xE6\xAC\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],
        ["\xE7\x9B\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],
        ["\xE6\xAC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],
        ["\xE9\xA3\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],
        ["\xE6\xAD\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],
        ["\xE6\xAD\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\xE6\xAD\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],
        ["\xE6\xAD\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],
        ["\xE6\xAD\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],
        ["\xE6\xAD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],
        ["\xE6\xAD\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],
        ["\xE6\xAD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],
        ["\xE6\xAD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],
        ["\xE6\xAD\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],
        ["\xE6\xAD\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],
        ["\xE6\xAD\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],
        ["\xE6\xAE\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],
        ["\xE6\xAE\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],
        ["\xE6\xAE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],
        ["\xE6\xAE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],
        ["\xE6\xAE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],
        ["\xE6\xAE\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],
        ["\xE6\xAE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],
        ["\xE6\xAE\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],
        ["\xE6\xAE\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\xE6\xAE\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],
        ["\xE6\xAE\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\xE6\xAE\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],
        ["\xE6\xAE\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],
        ["\xE6\xAE\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\xE6\xAE\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],
        ["\xE6\xAE\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],
        ["\xE6\xAF\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],
        ["\xE6\xAF\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],
        ["\xE6\xAF\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\xE6\xAF\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\xE6\xAF\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\xE6\xAF\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\xE6\xAF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],
        ["\xE6\xAF\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],
        ["\xE9\xBA\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],
        ["\xE6\xB0\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],
        ["\xE6\xB0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],
        ["\xE6\xB0\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],
        ["\xE6\xB0\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],
        ["\xE6\xB0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],
        ["\xE6\xB0\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],
        ["\xE6\xB1\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],
        ["\xE6\xB1\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],
        ["\xE6\xB1\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],
        ["\xE6\xB1\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],
        ["\xE6\xB2\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],
        ["\xE6\xB2\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],
        ["\xE6\xB2\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],
        ["\xE6\xB2\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],
        ["\xE6\xB2\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],
        ["\xE6\xB1\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],
        ["\xE6\xB1\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],
        ["\xE6\xB1\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],
        ["\xE6\xB2\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],
        ["\xE6\xB2\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],
        ["\xE6\xB3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],
        ["\xE6\xB3\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],
        ["\xE6\xB3\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],
        ["\xE6\xB2\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],
        ["\xE6\xB3\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],
        ["\xE6\xB3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],
        ["\xE6\xB3\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],
        ["\xE6\xB2\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],
        ["\xE6\xB2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],
        ["\xE6\xB2\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],
        ["\xE6\xB2\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],
        ["\xE6\xB3\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],
        ["\xE6\xB3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],
        ["\xE6\xB3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],
        ["\xE6\xB3\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],
        ["\xE6\xB4\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],
        ["\xE8\xA1\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],
        ["\xE6\xB4\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],
        ["\xE6\xB4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],
        ["\xE6\xB4\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],
        ["\xE6\xB4\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],
        ["\xE6\xB4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],
        ["\xE6\xB4\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],
        ["\xE6\xB4\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],
        ["\xE6\xB4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],
        ["\xE6\xB4\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],
        ["\xE6\xB5\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],
        ["\xE6\xB6\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],
        ["\xE6\xB5\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],
        ["\xE6\xB5\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],
        ["\xE6\xB5\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\xE6\xB5\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],
        ["\xE6\xB6\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],
        ["\xE6\xB6\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],
        ["\xE6\xBF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xE6\xB6\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],
        ["\xE6\xB7\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],
        ["\xE6\xB8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],
        ["\xE6\xB8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],
        ["\xE6\xB6\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],
        ["\xE6\xB7\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],
        ["\xE6\xB7\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],
        ["\xE6\xB6\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],
        ["\xE6\xB7\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],
        ["\xE6\xB7\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],
        ["\xE6\xB7\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],
        ["\xE6\xB7\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],
        ["\xE6\xB7\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],
        ["\xE6\xB7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],
        ["\xE6\xB7\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],
        ["\xE6\xB7\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],
        ["\xE6\xB7\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],
        ["\xE6\xB7\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\xE6\xB7\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],
        ["\xE6\xB7\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],
        ["\xE6\xB7\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],
        ["\xE6\xB8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],
        ["\xE6\xB9\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],
        ["\xE6\xB8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],
        ["\xE6\xB8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],
        ["\xE6\xB9\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],
        ["\xE6\xB9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],
        ["\xE6\xB8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],
        ["\xE6\xB8\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],
        ["\xE6\xB9\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],
        ["\xE6\xB8\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\xE6\xB9\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],
        ["\xE6\xB9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],
        ["\xE6\xB8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],
        ["\xE6\xB9\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],
        ["\xE6\xB8\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],
        ["\xE6\xB9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],
        ["\xE6\xB8\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],
        ["\xE6\xBB\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],
        ["\xE6\xB8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],
        ["\xE6\xB8\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],
        ["\xE6\xBA\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],
        ["\xE6\xBA\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],
        ["\xE6\xBA\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],
        ["\xE6\xBB\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],
        ["\xE6\xBA\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],
        ["\xE6\xBB\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],
        ["\xE6\xBA\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],
        ["\xE6\xBA\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],
        ["\xE6\xBB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],
        ["\xE6\xBA\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],
        ["\xE6\xBB\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],
        ["\xE6\xBB\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],
        ["\xE6\xBA\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],
        ["\xE6\xBA\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],
        ["\xE6\xBB\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],
        ["\xE6\xBA\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],
        ["\xE6\xBD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\xE6\xBC\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\xE7\x81\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xE6\xBB\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],
        ["\xE6\xBB\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],
        ["\xE6\xBB\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],
        ["\xE6\xBC\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],
        ["\xE6\xBB\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],
        ["\xE6\xBC\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],
        ["\xE6\xBB\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],
        ["\xE6\xBC\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],
        ["\xE6\xBB\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],
        ["\xE6\xBC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],
        ["\xE6\xBC\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],
        ["\xE6\xBB\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],
        ["\xE6\xBE\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],
        ["\xE6\xBD\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],
        ["\xE6\xBD\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],
        ["\xE6\xBE\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],
        ["\xE6\xBE\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],
        ["\xE6\xBD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],
        ["\xE6\xBD\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],
        ["\xE6\xBF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],
        ["\xE6\xBD\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],
        ["\xE6\xBE\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],
        ["\xE6\xBD\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],
        ["\xE6\xBD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],
        ["\xE6\xBE\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],
        ["\xE6\xBE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\xE6\xBF\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\xE6\xBD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\xE6\xBE\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\xE6\xBE\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],
        ["\xE6\xBE\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],
        ["\xE6\xBE\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],
        ["\xE6\xBE\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],
        ["\xE6\xBF\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],
        ["\xE6\xBE\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],
        ["\xE6\xBF\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],
        ["\xE6\xBF\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],
        ["\xE6\xBF\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],
        ["\xE6\xBF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],
        ["\xE6\xBF\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],
        ["\xE6\xBF\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],
        ["\xE6\xBF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],
        ["\xE6\xBF\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],
        ["\xE7\x80\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],
        ["\xE7\x80\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],
        ["\xE6\xBF\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],
        ["\xE7\x80\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],
        ["\xE7\x80\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],
        ["\xE7\x80\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],
        ["\xE6\xBF\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],
        ["\xE7\x80\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],
        ["\xE7\x80\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],
        ["\xE6\xBD\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],
        ["\xE7\x80\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\xE7\x80\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],
        ["\xE7\x80\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\xE7\x80\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],
        ["\xE7\x80\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],
        ["\xE7\x80\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],
        ["\xE7\x81\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],
        ["\xE7\x81\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],
        ["\xE7\x82\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],
        ["\xE7\x82\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xE7\x82\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\xE7\x83\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],
        ["\xE7\x82\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],
        ["\xE7\x82\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],
        ["\xE7\x82\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],
        ["\xE7\x82\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],
        ["\xE7\x83\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],
        ["\xE7\x83\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],
        ["\xE7\x83\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],
        ["\xE7\x83\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xE7\x84\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],
        ["\xE7\x83\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],
        ["\xE7\x84\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],
        ["\xE7\x84\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],
        ["\xE7\x85\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xE7\x85\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\xE7\x86\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],
        ["\xE7\x85\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xE7\x85\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],
        ["\xE7\x85\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],
        ["\xE7\x85\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],
        ["\xE7\x85\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],
        ["\xE7\x86\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],
        ["\xE7\x87\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],
        ["\xE7\x86\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],
        ["\xE7\x86\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],
        ["\xE7\x86\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],
        ["\xE7\x86\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],
        ["\xE7\x87\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],
        ["\xE7\x86\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],
        ["\xE7\x86\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],
        ["\xE7\x87\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],
        ["\xE7\x87\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],
        ["\xE7\x87\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],
        ["\xE7\x87\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],
        ["\xE7\x87\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\xE7\x87\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],
        ["\xE7\x87\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\xE7\x87\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],
        ["\xE7\x87\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],
        ["\xE7\x87\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE7\x87\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE7\x88\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE7\x88\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE7\x88\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE7\x88\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE7\x88\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE7\x88\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE7\x88\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE7\x88\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE7\x88\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE7\x88\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE7\x88\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE7\x89\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE7\x89\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE7\x89\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE7\x89\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE7\x89\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE7\x89\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE7\x8A\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE7\x8A\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE7\x8A\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE7\x8A\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE7\x8A\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE7\x8A\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE7\x8A\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE7\x8A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE7\x8A\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE7\x8B\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE7\x8B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE7\x8B\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE7\x8B\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE7\x8B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE7\x8B\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE7\x8B\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE7\x8B\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE7\x8B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE7\x8B\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE5\x80\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE7\x8C\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE7\x8C\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE7\x8C\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE7\x8C\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE7\x8C\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE7\x8C\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE7\x8C\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE7\x8C\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE7\x8C\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE7\x8C\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE7\x8D\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE7\x8D\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE9\xBB\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE7\x8D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE7\x8D\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE7\x8D\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE7\x8D\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE7\x8D\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE7\x8D\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE7\x8D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE7\x8D\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE7\x8F\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE7\x8E\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE7\x8F\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE7\x8E\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE7\x8F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE7\x8F\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE7\x8F\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE7\x8F\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE7\x92\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE7\x90\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE7\x91\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE7\x90\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE7\x8F\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE7\x90\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE7\x90\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE7\x91\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE7\x90\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE7\x91\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE7\x91\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE7\x91\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE7\x91\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE7\x91\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE7\x91\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE7\x91\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE7\x91\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE7\x91\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE7\x91\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE7\x92\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE7\x92\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE7\x92\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE7\x93\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE7\x93\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE7\x93\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\xE7\x8F\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\xE7\x93\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE7\x93\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE7\x93\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE7\x93\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE7\x93\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE7\x93\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE7\x93\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE7\x93\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE7\x93\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE7\x93\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE7\x94\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE7\x94\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE7\x94\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE7\x94\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE7\x94\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE7\x94\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE7\x94\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE7\x94\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE7\x94\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE7\x94\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE7\x94\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE7\x94\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE7\x95\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE7\x95\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE7\x95\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE7\x95\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE7\x95\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE7\x95\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE7\x95\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE7\x95\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE7\x95\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE7\x95\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE7\x95\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE7\x95\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE7\x95\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE7\x95\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE7\x96\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE7\x96\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE7\x95\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE7\x96\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE7\x96\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE7\x96\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE7\x96\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE7\x96\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE7\x96\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE7\x96\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE7\x96\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE7\x97\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE7\x96\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE7\x97\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE7\x96\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE7\x96\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE7\x96\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE7\x96\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE7\x96\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE7\x97\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE7\x97\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE7\x97\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE7\x97\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE7\x97\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE7\x97\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE7\x97\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE7\x97\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE7\x97\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE7\x98\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE7\x97\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE7\x97\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE7\x97\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE7\x97\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE7\x98\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE7\x98\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE7\x98\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE7\x98\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE7\x98\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE7\x98\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE7\x98\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE7\x98\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE7\x98\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE7\x98\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE7\x98\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE7\x98\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE7\x99\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE7\x99\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE7\x99\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE7\x99\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE7\x99\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE7\x99\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE7\x99\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE7\x99\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE7\x99\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE7\x99\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE7\x99\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE7\x99\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],
        ["\xE7\x99\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],
        ["\xE7\x99\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE7\x99\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE7\x99\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE7\x99\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE7\x9A\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE7\x9A\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE7\x9A\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE7\x9A\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE7\x9A\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE7\x9A\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE7\x9A\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE7\x9A\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE7\x9A\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE7\x9A\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE7\x9A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE7\x9A\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE7\x9A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE7\x9A\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE7\x9B\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE7\x9B\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE7\x9B\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE7\x9B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE7\x9B\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE7\x9B\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE7\x9B\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE7\x9B\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE7\x9B\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE8\x98\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE7\x9B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE7\x9C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE7\x9C\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE7\x9C\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE7\x9C\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE7\x9C\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE7\x9C\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE7\x9C\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE7\x9C\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE7\x9C\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE7\x9C\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE7\x9C\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE7\x9D\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE7\x9D\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE7\x9D\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE7\x9D\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE7\x9D\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE7\x9D\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE7\x9D\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE7\x9D\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE7\x9D\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE7\x9E\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE7\x9E\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE7\x9E\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE7\x9E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE7\x9E\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE7\x9E\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE7\x9E\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE7\x9E\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE7\x9E\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE7\x9E\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE7\x9E\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE7\x9E\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE7\x9F\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE7\x9F\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE7\x9F\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE7\x9F\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE7\x9F\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE7\x9F\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE7\x9F\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE7\x9F\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE7\xA0\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE7\xA0\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE7\xA4\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],
        ["\xE7\xA0\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE7\xA4\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xE7\xA1\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE7\xA2\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE7\xA1\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE7\xA2\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE7\xA1\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE7\xA2\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE7\xA2\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE7\xA2\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE7\xA2\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE7\xA2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE7\xA2\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE7\xA3\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE7\xA3\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE7\xA3\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE7\xA3\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE7\xA2\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE7\xA2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE7\xA3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE7\xA3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\xE7\xA3\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\xE7\xA3\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE7\xA3\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE7\xA3\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE7\xA3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE7\xA4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE7\xA4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE7\xA4\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE7\xA4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE7\xA4\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE7\xA4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE7\xA5\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE7\xA5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE7\xA5\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE7\xA5\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE7\xA5\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE7\xA5\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE7\xA5\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE7\xA5\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE7\xA5\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE7\xA6\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE7\xA6\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE7\xA6\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE9\xBD\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE7\xA6\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE7\xA6\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE7\xA6\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE7\xA6\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE7\xA6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE7\xA7\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE7\xA7\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE7\xA7\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE7\xA7\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE7\xA7\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE7\xA7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE7\xA8\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE7\xA8\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE7\xA8\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE7\xA8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE7\xA8\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE7\xA8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE7\xA6\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE7\xA8\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE7\xA8\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE7\xA8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE7\xA8\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE7\xA9\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE7\xA9\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE7\xA9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE7\xA9\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE7\xA9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE7\xA9\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE9\xBE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE7\xA9\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE7\xA9\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE7\xA9\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE7\xAA\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE7\xAA\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE7\xAA\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE7\xAA\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE7\xAA\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE7\xAA\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE7\xAB\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xE7\xAA\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE7\xAA\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE7\xAB\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE7\xAB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE7\xAA\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE9\x82\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE7\xAB\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE7\xAB\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE7\xAB\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE7\xAB\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE7\xAB\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE7\xAB\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE7\xAB\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE7\xAB\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE7\xAB\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE7\xAB\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE7\xAB\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE7\xAB\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE7\xAB\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE7\xAB\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE7\xAC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE7\xAC\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE7\xAC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE7\xAC\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE7\xAC\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE7\xAC\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE7\xAC\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE7\xAC\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE7\xAC\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE7\xAC\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE7\xAC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],
        ["\xE7\xAD\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],
        ["\xE7\xAD\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE7\xAC\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE7\xAD\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE7\xAC\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE7\xAD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE7\xAD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE7\xAD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE7\xAD\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE7\xAD\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE7\xAD\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE7\xAD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE7\xAD\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE7\xAD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE7\xAD\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE7\xAE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE7\xAE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE7\xAE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE7\xAE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE7\xAE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE7\xAE\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE7\xAE\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE7\xAE\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE7\xAE\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE7\xAD\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE7\xAE\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE7\xAF\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE7\xAF\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE7\xAF\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE7\xAF\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE7\xAE\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE7\xAF\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE7\xAF\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE7\xAF\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE7\xB0\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE7\xB0\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE7\xAF\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE7\xAF\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE7\xB1\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],
        ["\xE7\xB0\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE7\xB0\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE7\xB0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE7\xAF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE7\xAF\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE7\xB0\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE7\xB0\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE7\xAF\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE7\xB0\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE7\xB0\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE7\xB0\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE7\xB0\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE7\xB0\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE7\xB0\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE7\xB0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE7\xB1\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE7\xB1\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE7\xB1\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE7\xB1\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE7\xB1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE7\xB1\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE7\xB1\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE7\xB1\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE7\xB1\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE7\xB1\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE7\xB1\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE7\xB1\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE7\xB1\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE7\xB2\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE7\xB2\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE7\xB2\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE7\xB2\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE7\xB2\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE7\xB2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE7\xB2\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE7\xB2\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE7\xB2\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE7\xB2\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE7\xB2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE7\xB2\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE7\xB2\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE7\xB2\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE7\xB3\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE7\xB3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE7\xB3\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE7\xB3\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE7\xB3\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE7\xB3\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE7\xB3\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE9\xAC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE7\xB3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE7\xB3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE7\xB3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE7\xB3\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE7\xB3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],
        ["\xE7\xB4\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],
        ["\xE7\xB4\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE7\xB4\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE7\xB4\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE7\xB4\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE7\xB5\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE7\xB5\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE7\xB4\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE7\xB4\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE7\xB4\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE7\xB4\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE7\xB5\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE7\xB5\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE7\xB5\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE7\xB5\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE7\xB5\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE7\xB5\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE7\xB5\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE7\xB5\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE7\xB5\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE7\xB6\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE7\xB6\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE7\xB5\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE7\xB6\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE7\xB5\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE7\xB6\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE7\xB6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE7\xB6\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE7\xB6\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE7\xB6\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE7\xB7\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE7\xB6\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE7\xB6\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE7\xB8\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE7\xB6\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE7\xB6\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE7\xB7\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE7\xB6\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE7\xB6\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE7\xB6\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE7\xB7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE7\xB7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE7\xB7\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE7\xB7\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE7\xB7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE7\xB7\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE7\xB7\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE7\xB8\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE7\xB8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE7\xB8\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE7\xB8\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE7\xB8\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE7\xB8\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE7\xB8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE7\xB8\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE7\xB8\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE7\xB8\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE7\xB9\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE7\xB9\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE7\xB8\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE7\xB8\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE7\xB8\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE7\xB9\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE7\xB8\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE7\xB8\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE7\xB8\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE7\xB9\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE7\xB9\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE7\xB9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE7\xB9\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE7\xB9\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE7\xB9\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE7\xB9\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE7\xB9\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE7\xB9\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE7\xB9\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE7\xB9\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE7\xBA\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE7\xB7\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE7\xB9\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE8\xBE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE7\xB9\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE7\xBA\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE7\xBA\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE7\xBA\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE7\xBA\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE7\xBA\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE7\xBA\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE7\xBA\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE7\xBA\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE7\xBA\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE7\xBA\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE7\xBA\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE7\xBC\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],
        ["\xE7\xBC\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\xE7\xBD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE7\xBD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE7\xBD\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE7\xBD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE7\xBD\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE7\xBD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE7\xBD\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE7\xBD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE7\xBD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE7\xBD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE7\xBD\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE7\xBD\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE7\xBD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE7\xBD\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE7\xBD\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE7\xBE\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE7\xBE\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE7\xBE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE7\xBE\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE7\xBE\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE7\xBE\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE7\xBE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE7\xBE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE7\xBE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE7\xBE\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE7\xBE\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE7\xBE\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE7\xBE\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE7\xBE\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE7\xBE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE7\xBE\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE7\xBE\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE8\xAD\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE7\xBF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE7\xBF\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE7\xBF\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE7\xBF\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE7\xBF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE7\xBF\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE7\xBF\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE7\xBF\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE7\xBF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE7\xBF\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE9\xA3\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE8\x80\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE8\x80\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE8\x80\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE8\x80\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE8\x80\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE8\x80\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE8\x80\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE8\x80\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE8\x80\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE8\x80\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE8\x80\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE8\x81\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE8\x81\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE8\x81\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE8\x81\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE8\x81\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE8\x81\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE8\x81\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE8\x81\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE8\x81\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE8\x81\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE8\x81\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE8\x81\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE8\x81\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE8\x81\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE8\x81\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE8\x82\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE8\x82\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE8\x82\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE8\x82\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE8\x82\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE8\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE8\x82\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE5\x86\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE8\x82\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE8\x83\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE8\x83\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE8\x83\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE8\x83\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE8\x83\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE8\x83\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE8\x83\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE8\x84\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE8\x83\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE8\x83\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE8\x84\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE8\x84\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE8\x84\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE8\x84\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],
        ["\xE8\x85\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],
        ["\xE9\x9A\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE8\x85\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE8\x84\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE8\x85\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE8\x85\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE8\x83\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE8\x85\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE8\x85\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE8\x85\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE8\x85\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE8\x85\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE8\x86\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE8\x86\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE8\x86\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE8\x86\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE8\x86\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE8\x86\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE8\x86\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE8\x86\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE8\x86\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE8\x85\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE8\x86\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE8\x86\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE8\x86\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE8\x86\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE8\x86\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE8\x86\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE8\x86\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE8\x87\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE8\x87\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE8\x86\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE8\x87\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE8\x87\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE8\x87\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE8\x87\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE8\x87\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE8\x87\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE8\x87\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE8\x87\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE8\x87\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE8\x87\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE8\x87\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE8\x87\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE8\x87\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE8\x88\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE8\x88\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE8\x88\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE8\x88\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE8\x88\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE8\x88\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE8\x88\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE8\x88\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE8\x88\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE8\x88\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE8\x88\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE8\x88\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE8\x89\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE8\x89\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE8\x89\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE8\x89\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE8\x89\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE8\x89\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE8\x89\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE8\x89\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE8\x89\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE8\x89\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE8\x89\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE8\x88\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE8\x89\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE8\x89\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE8\x89\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE8\x89\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE8\x8A\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE8\x8A\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE8\x8A\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE8\x8A\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE8\x8A\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE8\x8A\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE8\x8B\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE8\x8B\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE8\x8B\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE8\x8B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE8\x8B\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE8\x8B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE8\x8B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE8\x8E\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE8\x8C\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE8\x8B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE8\x8B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE8\x8B\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE8\x8C\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE8\x8B\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE8\x8C\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],
        ["\xE8\x8B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],
        ["\xE8\x8C\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE8\x8C\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE8\x8C\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE8\x8C\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE8\x8C\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE8\x8D\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE8\x8C\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE8\x8D\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE8\x8D\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE8\x8C\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\x8C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\x8C\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE8\x8C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE8\x8E\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\x8E\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE8\x8E\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE8\x8E\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE8\x8E\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\x8E\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE8\x8C\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\x8E\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE8\x8E\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE8\x8E\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE8\x8D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\x8E\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE8\x8D\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE8\x8D\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE8\x8E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE8\x8E\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE8\x8E\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE8\x8F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE8\x90\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE8\x8F\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE8\x8F\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE8\x8F\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE8\x90\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE8\x8F\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE8\x90\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE8\x8F\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE8\x8F\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE8\x90\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE8\x8F\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE8\x8F\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE8\x90\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE8\x90\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE8\x90\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE8\x8E\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE8\x90\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE8\x94\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE8\x8F\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE8\x91\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE8\x90\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE8\x90\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE8\x95\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE8\x92\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE8\x91\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\x91\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\x92\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\x91\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\x92\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE8\x91\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE8\x91\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE8\x90\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE8\x91\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE8\x91\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE8\x90\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE8\x93\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE8\x91\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE8\x92\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE8\x92\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE8\x92\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE8\x93\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE8\x93\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE8\x92\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE8\x93\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\x93\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\x93\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE8\x93\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE8\x93\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE8\x92\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE8\x94\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE8\x93\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE8\x93\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE8\x94\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE8\x94\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE8\x94\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE8\x94\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE8\x94\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE8\x94\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\x93\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\x95\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\x95\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE8\x95\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],
        ["\xE8\x95\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xE8\x95\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE8\x98\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xE8\x95\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE8\x95\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE8\x96\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE8\x96\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE8\x96\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE8\x96\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE8\x96\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE8\x96\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE8\x95\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE8\x96\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE8\x96\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE8\x97\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],
        ["\xE8\x96\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE8\x96\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE8\x95\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE8\x95\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE8\x96\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE8\x97\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE8\x96\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE8\x97\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE8\x96\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE8\x97\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE8\x97\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE8\x97\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE8\x97\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE8\x97\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE8\x97\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE8\x98\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE8\x98\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE8\x98\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE8\x97\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE8\x97\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE8\x98\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE8\x98\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE8\x98\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE8\x98\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE8\x98\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE8\x99\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE4\xB9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE8\x99\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xE8\x99\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xE8\x99\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xE8\x99\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xE8\x9A\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xE8\x9A\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xE8\x9A\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE8\x9A\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE8\x9A\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE8\x9A\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE8\x9A\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE8\x9A\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE8\x9B\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE8\x9B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE8\x9A\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE8\x9B\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE8\xA0\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\xE8\x9A\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xE8\x9B\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xE8\x9B\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xE8\x9B\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xE8\x9B\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xE8\x9B\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE8\x9B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xE8\x9B\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE8\x9C\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE8\x9C\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE8\x9C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE8\x9C\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE8\x9C\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE8\x9B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE8\x9C\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE8\x9C\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xE8\x9C\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xE8\x9B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xE8\x9C\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xE8\x9C\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xE8\x9C\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xE8\x9C\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE8\x9C\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE8\x9C\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE8\x9C\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE8\x9C\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE8\x9D\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE8\x9D\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE8\x9D\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE8\x9D\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE8\x9D\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE8\x9D\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xE8\x9D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xE8\x9D\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xE8\x9D\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],
        ["\xE8\x9D\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],
        ["\xE8\x9D\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xE8\x9D\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xE8\x9D\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xE8\xA0\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xE8\x9E\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\xE8\x9E\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\xE8\x9E\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\xE8\x9E\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\xE8\x9F\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\xE8\x9E\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\xE8\x9F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\xE8\x9F\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\xE9\x9B\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\xE8\x9E\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\xE8\x9F\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\xE8\x9E\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\xE8\x9F\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\xE8\x9F\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xE8\x9E\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\xE8\x9F\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\xE8\x9F\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\xE8\x9F\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\xE8\xA0\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\xE8\xA0\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\xE8\x9F\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\xE8\x9F\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\xE8\x9F\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\xE8\xA0\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\xE8\x9F\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\xE8\xA0\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\xE8\xA0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\xE8\xA0\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\xE8\xA0\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\xE8\xA0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\xE8\xA0\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\xE8\xA0\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\xE8\xA0\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\xE8\xA0\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\xE8\xA0\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\xE8\xA1\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\xE8\xA1\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\xE8\xA1\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\xE8\xA1\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\xE8\xA1\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\xE8\xA1\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\xE8\xA1\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\xE8\xA2\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\xE8\xA1\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\xE8\xA2\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\xE8\xA1\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\xE8\xA1\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\xE8\xA2\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\xE8\xA1\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\xE8\xA2\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\xE8\xA2\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\xE8\xA2\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\xE8\xA2\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\xE8\xA2\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\xE8\xA2\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\xE8\xA2\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\xE8\xA2\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\xE8\xA2\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\xE8\xA2\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\xE8\xA2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\xE8\xA3\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\xE8\xA3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\xE8\xA3\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\xE8\xA3\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xE8\xA3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\xE8\xA3\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\xE8\xA3\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\xE8\xA4\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\xE8\xA3\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\xE8\xA3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\xE8\xA3\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\xE8\xA3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\xE8\xA4\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\xE8\xA4\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\xE8\xA4\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\xE8\xA4\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\xE8\xA5\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\xE8\xA4\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\xE8\xA4\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\xE8\xA4\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\xE8\xA4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\xE8\xA5\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\xE8\xA5\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\xE8\xA4\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\xE8\xA4\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\xE8\xA4\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\xE8\xA5\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\xE8\xA4\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\xE8\xA5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],
        ["\xE8\xA5\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],
        ["\xE8\xA5\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\xE8\xA5\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\xE8\xA5\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\xE8\xA5\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\xE8\xA5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\xE8\xA5\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\xE8\xA5\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\xE8\xA5\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\xE8\xA6\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\xE8\xA6\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\xE8\xA6\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\xE8\xA6\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\xE8\xA6\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\xE8\xA6\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\xE8\xA6\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\xE8\xA6\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\xE8\xA6\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\xE8\xA6\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\xE8\xA6\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\xE8\xA6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\xE8\xA6\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\xE8\xA6\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\xE8\xA7\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\xE8\xA7\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\xE8\xA7\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\xE8\xA7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\xE8\xA7\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\xE8\xA7\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\xE8\xA7\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\xE8\xA8\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\xE8\xA8\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\xE8\xA8\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\xE8\xA8\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\xE8\xA8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\xE8\xA8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\xE8\xA8\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\xE8\xA8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\xE8\xA9\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\xE8\xA9\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\xE8\xA9\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\xE8\xA9\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\xE8\xA9\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\xE8\xA9\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\xE8\xA9\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\xE8\xA9\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\xE8\xA9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\xE8\xAA\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\xE8\xAA\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\xE8\xAA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\xE8\xAA\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\xE8\xAA\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\xE8\xAA\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\xE8\xAA\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\xE8\xAA\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\xE8\xAA\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\xE8\xAA\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\xE8\xAB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\xE8\xAB\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\xE8\xAB\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\xE8\xAB\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xE8\xAB\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xE8\xAB\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\xE8\xAB\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\xE8\xAB\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\xE8\xAB\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\xE8\xAC\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\xE8\xAB\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\xE8\xAB\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\xE8\xAB\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\xE8\xAB\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\xE8\xAB\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\xE8\xAC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\xE8\xAC\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\xE8\xAC\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\xE8\xAB\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\xE8\xAC\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\xE8\xAC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\xE8\xAC\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\xE8\xAC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\xE8\xAC\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\xE9\x9E\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\xE8\xAC\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\xE8\xAC\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\xE8\xAC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\xE8\xAC\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\xE8\xAD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\xE8\xAD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\xE8\xAD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\xE8\xAD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\xE8\xAD\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\xE8\xAD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\xE8\xAD\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\xE8\xAD\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],
        ["\xE8\xAD\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],
        ["\xE8\xAD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\xE8\xAD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\xE8\xAD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\xE8\xAD\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\xE8\xAD\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\xE8\xAE\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\xE8\xAE\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\xE8\xAE\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\xE8\xAE\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\xE8\xAE\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xE8\xAE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xE8\xAE\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\xE8\xAE\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\xE8\xB0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\xE8\xB1\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\xE8\xB0\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\xE8\xB1\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\xE8\xB1\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\xE8\xB1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\xE8\xB1\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\xE8\xB1\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\xE8\xB1\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\xE8\xB1\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\xE8\xB1\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\xE8\xB1\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\xE8\xB2\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\xE8\xB2\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\xE8\xB2\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\xE8\xB2\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\xE8\xB2\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\xE8\xB2\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\xE8\xB2\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\xE8\xB1\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\xE8\xB2\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\xE6\x88\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\xE8\xB2\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\xE8\xB2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\xE8\xB2\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\xE8\xB2\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\xE8\xB2\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\xE8\xB2\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\xE8\xB2\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\xE8\xB3\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\xE8\xB3\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xE8\xB3\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\xE8\xB3\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\xE8\xB3\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\xE8\xB3\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\xE8\xB3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\xE8\xB3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\xE8\xB4\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\xE8\xB4\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\xE8\xB4\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\xE8\xB4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\xE8\xB4\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\xE8\xB4\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\xE8\xB4\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\xE9\xBD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\xE8\xB4\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\xE8\xB3\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\xE8\xB4\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\xE8\xB4\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\xE8\xB5\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\xE8\xB5\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\xE8\xB5\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\xE8\xB5\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\xE8\xB6\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\xE8\xB6\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\xE8\xB7\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\xE8\xB6\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\xE8\xB6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\xE8\xB7\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\xE8\xB7\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\xE8\xB7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\xE8\xB7\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\xE8\xB7\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\xE8\xB7\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\xE8\xB7\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\xE8\xB7\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\xE8\xB7\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\xE8\xB7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\xE8\xB7\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\xE8\xB8\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\xE8\xB8\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\xE8\xB7\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\xE8\xB8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\xE8\xB8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\xE8\xB8\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\xE8\xB8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\xE8\xB9\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\xE8\xB8\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\xE8\xB8\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\xE8\xB8\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],
        ["\xE8\xB9\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],
        ["\xE8\xB9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\xE8\xB9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\xE8\xB9\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\xE8\xB9\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\xE8\xB9\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\xE8\xB9\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\xE8\xB9\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\xE8\xB9\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\xE8\xB8\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\xE8\xB9\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\xE8\xB9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\xE8\xB9\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\xE8\xB9\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\xE8\xB9\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\xE8\xBA\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\xE8\xBA\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\xE8\xBA\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\xE8\xBA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\xE8\xBA\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\xE8\xBA\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\xE8\xBA\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\xE8\xBA\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\xE8\xBA\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\xE8\xBA\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\xE8\xBA\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\xE8\xBA\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\xE8\xBA\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\xE8\xBA\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\xE8\xBB\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\xE8\xBA\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\xE8\xBA\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\xE8\xBB\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\xE8\xBB\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\xE8\xBB\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\xE8\xBB\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\xE8\xBB\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\xE8\xBB\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\xE8\xBB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\xE8\xBB\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\xE8\xBB\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\xE8\xBC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\xE8\xBC\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\xE8\xBC\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\xE8\xBC\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\xE8\xBC\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\xE8\xBC\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\xE8\xBC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\xE8\xBC\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\xE8\xBC\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\xE8\xBC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\xE8\xBC\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\xE8\xBC\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\xE8\xBC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\xE8\xBC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\xE8\xBD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\xE8\xBD\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\xE8\xBC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\xE8\xBD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\xE8\xBD\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\xE8\xBD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\xE8\xBD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\xE8\xBD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\xE8\xBD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\xE8\xBD\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\xE8\xBD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\xE8\xBD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\xE8\xBE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\xE8\xBE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\xE8\xBE\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\xE8\xBE\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\xE8\xBE\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\xE8\xBE\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\xE8\xBF\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\xE8\xBF\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\xE8\xBF\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\xE8\xBF\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\xE8\xBF\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xE9\x82\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xE8\xBF\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\xE9\x80\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\xE8\xBF\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\xE8\xBF\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\xE9\x80\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\xE9\x80\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\xE9\x80\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\xE9\x80\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\xE9\x80\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\xE9\x80\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\xE9\x80\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\xE9\x80\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\xE9\x80\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\xE9\x80\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\xE9\x80\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],
        ["\xE8\xBF\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],
        ["\xE9\x81\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\xE9\x81\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\xE9\x81\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\xE9\x81\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\xE9\x80\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\xE9\x81\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\xE9\x80\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\xE9\x81\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\xE9\x81\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\xE9\x81\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\xE9\x81\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\xE9\x81\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\xE9\x81\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\xE9\x9A\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\xE9\x81\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\xE9\x82\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\xE9\x81\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\xE9\x82\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\xE9\x82\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\xE9\x82\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\xE9\x82\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\xE9\x82\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\xE9\x82\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\xE9\x82\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\xE9\x82\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\xE9\x82\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\xE9\x83\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\xE9\x83\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\xE6\x89\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\xE9\x83\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\xE9\x84\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\xE9\x84\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\xE9\x84\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\xE9\x84\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\xE9\x84\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\xE9\x85\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\xE9\x85\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\xE9\x85\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\xE9\x85\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\xE9\x85\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\xE9\x85\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\xE9\x85\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\xE9\x85\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\xE9\x86\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\xE9\x86\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\xE9\x86\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\xE9\x86\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\xE9\x86\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\xE9\x86\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\xE9\x86\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\xE9\x86\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\xE9\x86\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\xE9\x86\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\xE9\x87\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\xE9\x87\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\xE9\x87\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\xE9\x87\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\xE9\x87\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\xE9\x87\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\xE9\x87\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\xE9\x87\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\xE9\x87\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\xE9\x87\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\xE9\x87\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\xE9\x87\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\xE9\x88\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\xE9\x87\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\xE9\x88\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\xE9\x88\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\xE9\x88\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\xE9\x88\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\xE9\x89\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\xE9\x89\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\xE9\x89\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\xE9\x89\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\xE9\x89\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\xE9\x89\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\xE9\x8A\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\xE9\x88\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\xE9\x89\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\xE9\x89\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\xE9\x8A\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\xE9\x8A\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\xE9\x8A\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\xE9\x8A\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\xE9\x89\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\xE9\x8B\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\xE9\x8A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\xE9\x8A\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\xE9\x8B\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\xE9\x8C\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\xE9\x8B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\xE9\x8D\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],
        ["\xE9\x8C\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],
        ["\xE9\x8C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\xE9\x8C\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\xE9\x8C\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\xE9\x8C\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\xE9\x8C\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\xE9\x8C\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\xE9\x8C\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\xE9\x8D\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\xE9\x8D\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\xE9\x8D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\xE9\x8D\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\xE9\x8D\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\xE9\x8E\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\xE9\x8E\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\xE9\x8E\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\xE9\x8E\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\xE9\x8E\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\xE9\x8F\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\xE9\x8F\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\xE9\x8F\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\xE9\x8F\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\xE9\x8F\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\xE9\x8F\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\xE9\x8F\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\xE9\x8F\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\xE9\x8F\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\xE9\x8F\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\xE9\x90\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\xE9\x90\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\xE9\x90\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\xE9\x90\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\xE9\x90\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\xE9\x90\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\xE9\x90\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\xE9\x90\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\xE9\x90\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\xE9\x90\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\xE9\x90\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\xE9\x91\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\xE9\x91\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\xE9\x91\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\xE9\x91\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\xE9\x91\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\xE9\x91\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\xE9\x91\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\xE9\x91\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\xE9\x88\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\xE9\x91\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\xE9\x91\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\xE9\x91\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\xE9\x91\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\xE9\x91\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\xE9\x91\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\xE9\x91\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\xE9\x92\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\xE9\x91\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\xE9\x96\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\xE9\x96\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\xE9\x96\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\xE9\x96\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\xE9\x96\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\xE9\x96\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\xE9\x96\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\xE9\x96\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\xE9\x96\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\xE9\x96\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\xE9\x96\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\xE9\x96\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\xE9\x96\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\xE9\x96\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\xE9\x96\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\xE9\x97\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\xE6\xBF\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\xE9\x97\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\xE9\x97\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\xE9\x97\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\xE9\x97\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\xE9\x97\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\xE9\x97\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\xE9\x97\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\xE9\x97\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\xE9\x97\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\xE9\x97\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\xE9\x98\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\xE9\x98\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\xE9\x98\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\xE9\x98\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\xE9\x99\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\xE9\x99\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\xE9\x99\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\xE9\x99\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\xE9\x99\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\xE9\x99\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],
        ["\xE9\x99\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],
        ["\xE9\x99\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xE9\x99\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\xE9\x99\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\xE9\x99\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\xE9\x99\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\xE9\x9A\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\xE9\x9A\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\xE9\x9A\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\xE9\x9A\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\xE9\x9A\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\xE9\x9A\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xE9\x9A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\xE9\x9A\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\xE9\x9A\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\xE9\x9A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\xE9\x9A\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xE9\x9A\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\xE9\x9A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\xE9\x9B\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\xE9\x9B\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\xE9\x9B\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\xE9\x9B\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\xE8\xA5\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\xE9\x9B\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\xE9\x9C\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\xE9\x9B\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\xE9\x9B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\xE9\x9C\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\xE9\x9C\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\xE9\x9C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\xE9\x9C\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\xE9\x9C\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xE9\x9C\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xE9\x9C\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xE9\x9C\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xE9\x9C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xE9\x9C\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xE9\x9C\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xE9\x9C\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xE9\x9C\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xE9\x9C\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xE9\x9C\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\xE9\x9D\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\xE9\x9D\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\xE9\x9D\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\xE9\x9D\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\xE9\x9D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\xE9\x9D\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xE9\x9D\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xE9\x9D\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xE9\x9D\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xE9\x9D\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xE5\x8B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xE9\x9D\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xE9\x9D\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],
        ["\xE9\x9D\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xE9\x9E\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xE9\x9D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\xE9\x9E\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\xE9\x9D\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\xE9\x9E\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\xE9\x9E\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\xE9\x9E\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\xE9\x9E\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xE9\x9E\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\xE9\x9E\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xE9\x9E\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xE9\x9E\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xE9\x9E\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xE9\x9E\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xE9\x9F\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xE9\x9F\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xE9\x9F\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xE9\x9F\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\xE9\x9F\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\xE9\x9F\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\xE9\xBD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\xE9\x9F\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\xE7\xAB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\xE9\x9F\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xE9\x9F\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xE9\xA0\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xE9\xA0\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xE9\xA0\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\xE9\xA0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xE9\xA0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xE9\xA0\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xE9\xA0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xE9\xA1\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xE9\xA1\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\xE9\xA1\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\xE9\xA1\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\xE9\xA1\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],
        ["\xE9\xA1\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],
        ["\xE9\xA1\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xE9\xA1\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\xE9\xA1\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\xE9\xA2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\xE9\xA2\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\xE9\xA2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\xE9\xA2\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\xE9\xA3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\xE9\xA3\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\xE9\xA3\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\xE9\xA3\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xE9\xA3\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\xE9\xA4\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\xE9\xA4\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\xE9\xA4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\xE9\xA4\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xE9\xA4\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\xE9\xA4\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\xE9\xA4\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\xE9\xA4\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\xE9\xA4\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\xE9\xA4\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\xE9\xA4\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\xE9\xA4\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\xE9\xA4\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\xE9\xA4\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\xE9\xA5\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\xE9\xA5\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\xE9\xA5\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\xE9\xA5\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\xE9\xA5\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\xE9\xA5\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xE9\xA5\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xE9\xA5\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xE9\xA5\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xE9\xA6\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xE9\xA6\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xE9\xA6\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xE9\xA6\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xE9\xA6\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xE9\xA6\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xE9\xA7\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\xE9\xA7\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\xE9\xA7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\xE9\xA7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\xE9\xA7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\xE9\xA7\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\xE9\xA7\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xE9\xA7\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xE9\xA7\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xE9\xA7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xE9\xA7\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xE9\xA8\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xE9\xA8\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xE9\xA8\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xE9\xA7\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xE9\xA8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xE9\xA8\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\xE9\xA8\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\xE9\xA9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\xE9\xA9\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\xE9\xA9\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\xE9\xA9\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\xE9\xA8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xE9\xA9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\xE9\xA9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xE9\xA9\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xE9\xA9\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xE9\xA9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xE9\xA9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xE9\xA9\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xE9\xA9\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xE9\xA9\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xE9\xA9\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\xE9\xA9\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\xE9\xAA\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\xE9\xAA\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\xE9\xAA\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\xE9\xAB\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\xE9\xAB\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xE9\xAB\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xE9\xAB\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xE9\xAB\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xE9\xAB\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xE9\xAB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xE9\xAB\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xE9\xAB\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xE9\xAB\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xE9\xAB\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xE9\xAB\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\xE9\xAB\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\xE9\xAB\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\xE9\xAB\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],
        ["\xE9\xAB\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],
        ["\xE9\xAB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xE9\xAC\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\xE9\xAC\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\xE9\xAC\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\xE9\xAC\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\xE9\xAC\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\xE9\xAC\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\xE9\xAC\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\xE9\xAC\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\xE9\xAC\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\xE9\xAC\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xE9\xAC\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\xE9\xAC\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\xE9\xAC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\xE9\xAC\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\xE9\xAD\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xE9\xAD\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\xE9\xAD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\xE9\xAD\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\xE9\xAD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\xE9\xAD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\xE9\xAD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\xE9\xAD\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\xE9\xAE\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\xE9\xAE\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\xE9\xAE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\xE9\xAE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\xE9\xAE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\xE9\xAE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\xE9\xAE\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\xE9\xAE\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\xE9\xAE\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xE9\xAF\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xE9\xAF\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xE9\xAE\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xE9\xAF\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xE9\xAF\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xE9\xAF\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xE9\xAF\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xE9\xAF\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xE9\xAF\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xE9\xAF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\xE9\xAF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\xE9\xAF\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\xE9\xB0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],
        ["\xE9\xAF\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\xE9\xAF\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\xE9\xAF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xE9\xB0\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xE9\xB0\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xE9\xB0\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xE9\xB0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xE9\xB0\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xE9\xB0\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xE9\xB0\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xE9\xB0\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xE9\xB0\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xE9\xB0\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\xE9\xB0\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\xE9\xB0\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\xE9\xB0\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\xE9\xB0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\xE9\xB0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\xE9\xB0\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xE9\xB1\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\xE9\xB0\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xE9\xB1\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xE9\xB0\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xE9\xB1\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xE9\xB1\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xE9\xB1\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xE9\xB1\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xE9\xB1\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xE9\xB3\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\xE9\xB3\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\xE9\xB3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\xE9\xB4\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\xE9\xB4\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\xE9\xB3\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\xE9\xB4\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xE9\xB4\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xE9\xB4\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xE9\xB4\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xE9\xB6\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],
        ["\xE9\xB4\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xE9\xB4\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xE9\xB5\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xE9\xB4\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xE9\xB4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xE9\xB5\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\xE9\xB4\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\xE9\xB4\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\xE9\xB5\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],
        ["\xE9\xB5\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],
        ["\xE9\xB5\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xE9\xB5\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\xE9\xB5\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\xE9\xB5\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\xE9\xB5\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\xE9\xB5\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\xE9\xB5\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\xE9\xB6\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\xE9\xB6\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\xE9\xB6\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\xE9\xB5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xE9\xB5\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\xE9\xB6\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\xE9\xB6\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\xE9\xB6\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\xE9\xB6\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xE9\xB7\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\xE9\xB7\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\xE9\xB6\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\xE9\xB6\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\xE9\xB6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\xE9\xB7\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\xE9\xB7\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\xE9\xB7\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\xE9\xB7\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\xE9\xB7\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\xE9\xB7\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\xE9\xB7\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\xE9\xB7\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\xE9\xB7\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\xE9\xB7\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\xE9\xB8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xE9\xB8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xE9\xB8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xE9\xB9\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xE9\xB9\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xE9\xB9\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xE9\xBA\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xE9\xBA\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xE9\xBA\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xE9\xBA\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xE9\xBA\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\xE9\xBA\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\xE9\xBA\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\xE9\xBA\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\xE9\xBA\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\xE9\xBA\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\xE9\xBA\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xE9\xBA\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xE9\xBA\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xE9\x9D\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xE9\xBB\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xE9\xBB\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xE9\xBB\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xE9\xBB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xE9\xBB\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xE9\xBB\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xE9\xBB\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\xE9\xBB\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\xE9\xBB\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\xE9\xBB\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\xE9\xBB\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\xE9\xBB\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\xE9\xBB\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xE9\xBB\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\xE9\xBB\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xE9\xBB\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xE9\xBB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xE9\xBB\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xE9\xBB\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xE9\xBC\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xE9\xBC\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xE7\x9A\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xE9\xBC\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\xE9\xBC\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\xE9\xBC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\xE9\xBC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\xE9\xBD\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\xE9\xBD\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\xE9\xBD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xE9\xBD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xE9\xBD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xE9\xBD\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xE9\xBD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xE9\xBD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xE9\xBD\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xE9\xBD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xE9\xBD\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xE9\xBD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xE9\xBD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\xE9\xBD\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\xE9\xBE\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\xE9\xBE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],
        ["\xE9\xBE\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],
        ["\xE5\xA0\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC3"],
        ["\xE6\xA7\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFC"],
        ["\xE9\x81\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xA2"],
        ["\xE7\x91\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA7"],
        ["\xE5\x87\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB8"],
        ["\xE2\x85\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC1"],
        ["\xE2\x85\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC2"],
        ["\xE2\x85\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC3"],
        ["\xE2\x85\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC4"],
        ["\xE2\x85\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC5"],
        ["\xE2\x85\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC6"],
        ["\xE2\x85\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC7"],
        ["\xE2\x85\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC8"],
        ["\xE2\x85\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xC9"],
        ["\xE2\x85\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xCA"],
        ["\xEF\xBF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xBC\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xBC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBA\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xFE"],
        ["\xE8\xA4\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"],
        ["\xE9\x8D\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC7"],
        ["\xE9\x8A\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xA3"],
        ["\xE8\x93\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xAE"],
        ["\xE4\xBF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\xE7\x82\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFE"],
        ["\xE6\x98\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\xE6\xA3\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDC"],
        ["\xE9\x8B\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xBB"],
        ["\xE6\x9B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\xE5\xBD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\xE4\xB8\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAC"],
        ["\xE4\xBB\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\xE4\xBB\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\xE4\xBC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],
        ["\xE4\xBC\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\xE4\xBC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCE"],
        ["\xE4\xBD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCB"],
        ["\xE4\xBE\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"],
        ["\xE4\xBE\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\xE4\xBE\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\xE4\xBE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\xE4\xBF\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\xE5\x81\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\xE5\x80\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],
        ["\xE4\xBF\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"],
        ["\xE5\x80\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\xE5\x81\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"],
        ["\xE5\x81\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\xE5\x81\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"],
        ["\xE5\x82\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\xE5\x83\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBE"],
        ["\xE5\x83\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\xE5\x85\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCB"],
        ["\xE5\x85\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\xE5\x86\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"],
        ["\xE5\x86\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\xE5\x87\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC3"],
        ["\xE5\x88\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\xE5\x8A\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\xE5\x8A\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\xE5\x8B\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\xE5\x8B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"],
        ["\xE5\x8C\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\xE5\x8C\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"],
        ["\xE5\x8C\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAF"],
        ["\xE5\x8D\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBC"],
        ["\xE5\x8E\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\xE5\x8E\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],
        ["\xE5\x8F\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"],
        ["\xEF\xA8\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\xE5\x92\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"],
        ["\xE5\x92\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDA"],
        ["\xE5\x92\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"],
        ["\xE5\x93\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"],
        ["\xE5\x96\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xED"],
        ["\xE5\x9D\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\xE5\x9D\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB6"],
        ["\xE5\x9E\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB9"],
        ["\xE5\x9F\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"],
        ["\xE5\x9F\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\xEF\xA8\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBB"],
        ["\xEF\xA8\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xE5\xA2\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD1"],
        ["\xE5\xA2\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"],
        ["\xE5\xA4\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCD"],
        ["\xE5\xA5\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\xE5\xA5\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\xE5\xA5\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\xE5\xA5\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE9"],
        ["\xE5\xA6\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"],
        ["\xE5\xA6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"],
        ["\xE5\xAD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB3"],
        ["\xE5\xAF\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC2"],
        ["\xE7\x94\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"],
        ["\xE5\xAF\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC6"],
        ["\xE5\xAF\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC7"],
        ["\xE5\xB0\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD2"],
        ["\xE5\xB2\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDE"],
        ["\xE5\xB2\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"],
        ["\xE5\xB3\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE6"],
        ["\xE5\xB4\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE8"],
        ["\xE5\xB5\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF0"],
        ["\xEF\xA8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"],
        ["\xE5\xB5\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"],
        ["\xE5\xB5\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\xE5\xB6\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"],
        ["\xE5\xB6\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA5"],
        ["\xE5\xB7\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA7"],
        ["\xE5\xBC\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\xE5\xBC\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\xE5\xBD\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"],
        ["\xE5\xBE\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\xE5\xBF\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"],
        ["\xE6\x81\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\xE6\x82\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\xE6\x82\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\xE6\x83\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA5"],
        ["\xE6\x83\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"],
        ["\xE6\x84\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAA"],
        ["\xE6\x83\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"],
        ["\xE6\x84\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAF"],
        ["\xE6\x84\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"],
        ["\xE6\x84\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB3"],
        ["\xE6\x86\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"],
        ["\xE6\x88\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\xE6\x8A\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\xE6\x8F\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\xE6\x91\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEB"],
        ["\xE6\x92\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"],
        ["\xE6\x93\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\xE6\x95\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\xE6\x98\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB3"],
        ["\xE6\x98\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB1"],
        ["\xE6\x98\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],
        ["\xE6\x98\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAF"],
        ["\xE6\x98\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBE"],
        ["\xE6\x98\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"],
        ["\xE6\x98\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB9"],
        ["\xE6\x99\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\xE6\x99\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\xE6\x99\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\xEF\xA8\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDD"],
        ["\xE6\x99\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE1"],
        ["\xE6\x9A\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE6"],
        ["\xE6\x9A\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEA"],
        ["\xE6\x9A\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEE"],
        ["\xE6\x9A\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEF"],
        ["\xE6\x9B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\xE6\x9C\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFC"],
        ["\xEF\xA4\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"],
        ["\xE6\x9D\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB2"],
        ["\xE6\x9E\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"],
        ["\xE6\xA1\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"],
        ["\xE6\x9F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\xE6\xA0\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"],
        ["\xE6\xA1\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"],
        ["\xE6\xA3\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDF"],
        ["\xEF\xA8\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE0"],
        ["\xE6\xA5\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"],
        ["\xEF\xA8\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF8"],
        ["\xE6\xA6\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],
        ["\xE6\xA7\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"],
        ["\xE6\xA8\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"],
        ["\xE6\xA9\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA9"],
        ["\xE6\xA9\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"],
        ["\xE6\xA9\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"],
        ["\xE6\xA9\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"],
        ["\xE6\xAB\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB9"],
        ["\xE6\xAB\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"],
        ["\xE6\xAF\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\xE6\xB0\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\xE6\xB1\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\xE6\xB2\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\xE6\xB1\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\xE6\xB3\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"],
        ["\xE6\xB4\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\xE6\xB6\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"],
        ["\xE6\xB5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\xE6\xB6\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"],
        ["\xE6\xB6\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFC"],
        ["\xE6\xB7\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA4"],
        ["\xE6\xB7\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFD"],
        ["\xE6\xB7\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA6"],
        ["\xE6\xB7\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBD"],
        ["\xE6\xB8\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB7"],
        ["\xE6\xB9\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB4"],
        ["\xE6\xB8\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAE"],
        ["\xE6\xB8\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB8"],
        ["\xE6\xBA\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\xE6\xBE\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\xE6\xBE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDF"],
        ["\xE6\xBF\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\xE7\x80\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"],
        ["\xE7\x80\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\xE7\x80\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\xE7\x82\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\xE7\x82\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFD"],
        ["\xE7\x84\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\xE7\x84\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA5"],
        ["\xE7\x85\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"],
        ["\xE7\x85\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"],
        ["\xE7\x85\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"],
        ["\xEF\xA8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB9"],
        ["\xE7\x87\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB4"],
        ["\xE7\x87\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\xE7\x8A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCC"],
        ["\xE7\x8A\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\xE7\x8C\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\xEF\xA8\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCE"],
        ["\xE7\x8D\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\xE7\x8E\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDF"],
        ["\xE7\x8F\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDB"],
        ["\xE7\x8F\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\xE7\x8F\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\xE7\x8F\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\xE7\x90\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"],
        ["\xE7\x8F\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"],
        ["\xE7\x90\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\xE7\x90\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\xE7\x90\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFC"],
        ["\xE7\x90\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\xE7\x91\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA8"],
        ["\xE7\x92\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAE"],
        ["\xE7\x92\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB2"],
        ["\xE7\x94\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB9"],
        ["\xE7\x95\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"],
        ["\xE7\x9A\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCA"],
        ["\xE7\x9A\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCE"],
        ["\xE7\x9A\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCF"],
        ["\xE7\x9A\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\xE7\x9A\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\xEF\xA8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"],
        ["\xE7\x9D\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\xE5\x8A\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"],
        ["\xE7\xA0\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\xE7\xA1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"],
        ["\xE7\xA1\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],
        ["\xE7\xA1\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA5"],
        ["\xE7\xA4\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAE"],
        ["\xEF\xA8\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],
        ["\xEF\xA8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBB"],
        ["\xEF\xA8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\xE7\xA6\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],
        ["\xEF\xA8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],
        ["\xE7\xA6\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],
        ["\xE7\xAB\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFE"],
        ["\xE7\xAB\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA2"],
        ["\xEF\xA8\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA6"],
        ["\xE7\xAB\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA4"],
        ["\xE7\xAE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB7"],
        ["\xEF\xA8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCC"],
        ["\xE7\xB5\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDD"],
        ["\xE7\xB5\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE1"],
        ["\xE7\xB6\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEC"],
        ["\xE7\xB6\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEB"],
        ["\xE7\xB7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"],
        ["\xE7\xB9\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xFB"],
        ["\xE7\xBD\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xA5"],
        ["\xE7\xBE\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xAE"],
        ["\xEF\xA8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xB2"],
        ["\xE8\x8C\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xDA"],
        ["\xE8\x8D\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xDD"],
        ["\xE8\x8D\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xF2"],
        ["\xE8\x8F\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xFC"],
        ["\xE8\x8F\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xF8"],
        ["\xE8\x91\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xA3"],
        ["\xE8\x92\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xAF"],
        ["\xE8\x95\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xBE"],
        ["\xE8\x95\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xBF"],
        ["\xE8\x95\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xBA"],
        ["\xEF\xA8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"],
        ["\xE8\x96\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xC9"],
        ["\xEF\xA8\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"],
        ["\xEF\xA8\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xD7"],
        ["\xE8\xA0\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xDA"],
        ["\xE8\xA3\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xE6"],
        ["\xE8\xA8\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xFE"],
        ["\xE8\xA8\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xA5"],
        ["\xE8\xA9\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xAA"],
        ["\xE8\xAA\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xAB"],
        ["\xE8\xAA\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xAD"],
        ["\xE8\xAB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xB3"],
        ["\xEF\xA8\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xB2"],
        ["\xE8\xAB\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xB4"],
        ["\xE8\xAD\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xBE"],
        ["\xE8\xAD\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xC3"],
        ["\xE8\xB3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xD0"],
        ["\xE8\xB3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xCF"],
        ["\xE8\xB4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xD5"],
        ["\xE8\xB5\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xD8"],
        ["\xEF\xA8\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xD9"],
        ["\xE8\xBB\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xE1"],
        ["\xEF\xA8\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xEB"],
        ["\xEF\xA8\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xFA"],
        ["\xE9\x81\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xA3"],
        ["\xE9\x83\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xC7"],
        ["\xEF\xA8\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xCA"],
        ["\xE9\x84\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xCD"],
        ["\xE9\x84\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xD1"],
        ["\xE9\x87\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xD9"],
        ["\xE9\x87\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xD8"],
        ["\xE9\x87\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xDA"],
        ["\xE9\x87\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xDC"],
        ["\xE9\x87\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xE1"],
        ["\xE9\x87\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xE0"],
        ["\xE9\x87\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xDF"],
        ["\xE9\x88\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xE5"],
        ["\xE9\x88\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xE9"],
        ["\xE9\x88\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xE7"],
        ["\xE9\x88\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xF2"],
        ["\xE9\x89\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xEE"],
        ["\xE9\x88\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xF3"],
        ["\xE9\x89\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xEF"],
        ["\xE9\x89\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xF1"],
        ["\xE9\x89\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xEC"],
        ["\xE9\x88\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xED"],
        ["\xE9\x89\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xF6"],
        ["\xE9\x8A\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xA6"],
        ["\xE9\x89\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xA8"],
        ["\xE9\x89\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xA5"],
        ["\xE9\x8B\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xB1"],
        ["\xE9\x8B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xAC"],
        ["\xE9\x8B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xB8"],
        ["\xE9\x8B\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xB3"],
        ["\xEF\xA8\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xB7"],
        ["\xE9\x8B\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xB5"],
        ["\xE9\x8B\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xB0"],
        ["\xE9\x8B\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\xE9\x8C\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC3"],
        ["\xE9\x8C\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xBE"],
        ["\xE9\x8B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xCD"],
        ["\xEF\xA8\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC2"],
        ["\xE9\x8C\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xBF"],
        ["\xE9\x8B\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC1"],
        ["\xE9\x8C\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC4"],
        ["\xE9\x8C\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC5"],
        ["\xE9\x8D\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xCA"],
        ["\xE9\x8D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xCC"],
        ["\xE9\x8E\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xD8"],
        ["\xE9\x8F\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xE0"],
        ["\xE9\x8F\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xDF"],
        ["\xE9\x8F\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xE6"],
        ["\xE9\x90\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xEF"],
        ["\xE9\x91\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xF0"],
        ["\xE9\x91\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xF1"],
        ["\xE9\x96\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xF8"],
        ["\xEF\xA7\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xA2"],
        ["\xEF\xA8\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xA4"],
        ["\xE9\x9A\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xA5"],
        ["\xE9\x9A\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xA6"],
        ["\xE9\x9C\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\xE9\x9C\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\xE9\x9D\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xAE"],
        ["\xE9\x9D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xB0"],
        ["\xE9\x9D\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\xE9\x9D\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xB1"],
        ["\xE9\x9D\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xB2"],
        ["\xE9\xA1\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC1"],
        ["\xE9\xA1\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC2"],
        ["\xEF\xA8\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC5"],
        ["\xEF\xA8\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC6"],
        ["\xE9\xA4\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC8"],
        ["\xEF\xA8\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC9"],
        ["\xE9\xA6\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xCC"],
        ["\xE9\xA9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xD9"],
        ["\xE9\xAB\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xD4"],
        ["\xE9\xAB\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xDC"],
        ["\xE9\xAD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\xE9\xAD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xE0"],
        ["\xE9\xAE\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xE2"],
        ["\xE9\xAE\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xE5"],
        ["\xE9\xAE\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xE7"],
        ["\xE9\xB0\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\xE9\xB5\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\xE9\xB5\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xF2"],
        ["\xEF\xA8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xF4"],
        ["\xE9\xB8\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xAC"],
        ["\xE9\xBB\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xA1"],
        ["\xE2\x80\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x80\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x88\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x83\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8A\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8A\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xAC"],
        ["\xE2\x8A\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8A\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x88\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x88\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xB7"],
        ["\xE2\x8C\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8C\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8A\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xB4"],
        ["\xE2\x8A\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xB5"],
        ["\xE2\x8A\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xB3"],
        ["\xE2\x88\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xBD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xBD\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x89\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x89\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xAF"],
        ["\xE2\x89\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB0"],
        ["\xE2\x89\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB6"],
        ["\xE2\x89\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x89\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB2"],
        ["\xE2\x86\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xEA"],
        ["\xE2\x99\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x99\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x99\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x99\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x96\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xFB"],
        ["\xE2\x96\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xFD"],
        ["\xE2\x97\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xFA"],
        ["\xE2\x97\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xFC"],
        ["\xE2\x86\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xED"],
        ["\xE2\x86\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xEE"],
        ["\xE2\x86\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xEF"],
        ["\xE2\x86\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xEC"],
        ["\xE2\x87\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xE9"],
        ["\xE2\x87\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xA8"],
        ["\xE2\x87\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xA9"],
        ["\xE2\x87\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xAA"],
        ["\xE2\x87\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xAB"],
        ["\xE2\xA4\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\xA4\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\xA6\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x97\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xB8"],
        ["\xE3\x80\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF1"],
        ["\xEF\xB9\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xB9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x97\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x80\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x88\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB1"],
        ["\xE2\x84\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x84\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x8F\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xA7"],
        ["\xE2\x84\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xD0"],
        ["\xE2\x84\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x80\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\xA7\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\xA7\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x81\x8B\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x81\x8D\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x81\x8F\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x81\x91\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x81\x93\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\xAB\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\xAD\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\xAF\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\xB1\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\xB3\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x82\xBB\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x83\x84\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x83\x88\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x99\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF4"],
        ["\xE2\x99\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF8"],
        ["\xE2\x99\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF5"],
        ["\xE2\x99\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF9"],
        ["\xE2\x99\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF3"],
        ["\xE2\x99\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF7"],
        ["\xE2\x99\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF2"],
        ["\xE2\x99\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xF6"],
        ["\xCF\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x98\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x98\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x80\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x71\xA4"],
        ["\xE2\x98\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x98\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x98\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x98\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x98\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x99\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x96\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB5"],
        ["\xE3\x87\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xB7\xE3\x82\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x87\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8E\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8E\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x83\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x83\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x83\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x83\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8B\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xB3"],
        ["\xE2\x85\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x85\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x85\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9C\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x90\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x8F\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x89\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xAB"],
        ["\xE3\x89\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xAC"],
        ["\xE3\x89\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xAD"],
        ["\xE3\x89\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xAE"],
        ["\xE3\x89\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xAF"],
        ["\xE3\x89\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB0"],
        ["\xE3\x89\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB1"],
        ["\xE3\x89\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB2"],
        ["\xE3\x89\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB3"],
        ["\xE3\x89\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB4"],
        ["\xE3\x89\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB5"],
        ["\xE3\x89\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB6"],
        ["\xE3\x89\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB7"],
        ["\xE3\x89\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB8"],
        ["\xE3\x89\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xB9"],
        ["\xE3\x8A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xBA"],
        ["\xE3\x8A\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xBB"],
        ["\xE3\x8A\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xBC"],
        ["\xE3\x8A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xBD"],
        ["\xE3\x8A\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xBE"],
        ["\xE3\x8A\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xBF"],
        ["\xE3\x8A\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC0"],
        ["\xE3\x8A\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC1"],
        ["\xE3\x8A\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC2"],
        ["\xE3\x8A\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC3"],
        ["\xE3\x8A\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC4"],
        ["\xE3\x8A\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC5"],
        ["\xE3\x8A\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC6"],
        ["\xE3\x8A\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC7"],
        ["\xE3\x8A\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC8"],
        ["\xE2\x97\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x97\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x97\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x97\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x80\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x81\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x81\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x81\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE1\xB8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE1\xB8\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x82\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC2\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC4\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC6\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC5\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC3\xA6\xCC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC7\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE1\xBD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE1\xBD\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x94\xCC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x94\xCC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x8C\xCC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCA\x8C\xCC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x99\xCC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x99\xCC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x9A\xCC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xC9\x9A\xCC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE1\xBD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE1\xBD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x80\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA9\xCB\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\xA5\xCB\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCB\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xCC\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x9D\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x93\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x85\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xCB"],
        ["\xE2\x85\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xCC"],
        ["\xE2\x93\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE1"],
        ["\xE2\x93\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],
        ["\xE2\x93\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],
        ["\xE2\x93\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],
        ["\xE2\x93\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],
        ["\xE2\x93\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],
        ["\xE2\x93\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],
        ["\xE2\x93\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE8"],
        ["\xE2\x93\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],
        ["\xE2\x93\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xEA"],
        ["\xE2\x93\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xEB"],
        ["\xE2\x93\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xEC"],
        ["\xE2\x93\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xED"],
        ["\xE2\x93\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xEE"],
        ["\xE2\x93\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xEF"],
        ["\xE2\x93\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF0"],
        ["\xE2\x93\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF1"],
        ["\xE2\x93\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF2"],
        ["\xE2\x93\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF3"],
        ["\xE2\x93\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],
        ["\xE2\x93\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF5"],
        ["\xE2\x93\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],
        ["\xE2\x93\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF7"],
        ["\xE2\x93\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF8"],
        ["\xE2\x93\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF9"],
        ["\xE2\x93\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xFA"],
        ["\xE3\x8B\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA1"],
        ["\xE3\x8B\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA2"],
        ["\xE3\x8B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA3"],
        ["\xE3\x8B\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA4"],
        ["\xE3\x8B\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA5"],
        ["\xE3\x8B\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA6"],
        ["\xE3\x8B\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA7"],
        ["\xE3\x8B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA8"],
        ["\xE3\x8B\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xA9"],
        ["\xE3\x8B\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xAA"],
        ["\xE3\x8B\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xAB"],
        ["\xE3\x8B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xAC"],
        ["\xE3\x8B\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xAD"],
        ["\xE3\x8B\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xAE"],
        ["\xE3\x8B\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xAF"],
        ["\xE3\x8B\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xB0"],
        ["\xE3\x8B\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xB1"],
        ["\xE3\x8B\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xB2"],
        ["\xE3\x8B\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xB3"],
        ["\xE3\x8B\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xB4"],
        ["\xE3\x8B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xCB"],
        ["\xE3\x8B\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xBA"],
        ["\xE3\x8B\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xB6"],
        ["\xE3\x8B\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xBE"],
        ["\xE3\x8B\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x79\xBD"],
        ["\xE2\x81\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x81\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x85\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xBB"],
        ["\xE2\x85\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x74\xBC"],
        ["\xE2\x9D\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE2\x98\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBF\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFC"],
        ["\xF0\xA0\x80\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA4"],
        ["\xE3\x90\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA8"],
        ["\xE4\xB8\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB8\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBA\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBB\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\xE4\xBB\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBC\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\xE4\xBD\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\xE4\xBE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],
        ["\xEF\xA8\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],
        ["\xE4\xBF\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xB0"],
        ["\xE5\x80\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x80\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x80\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\xE5\x80\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\xE5\x80\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\xE5\x80\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x80\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x81\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBC"],
        ["\xE5\x83\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBD"],
        ["\xE5\x84\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x84\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x84\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x84\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x84\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCE"],
        ["\xE5\x85\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x85\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\xE3\x92\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC9"],
        ["\xE5\x87\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x87\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x87\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x87\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],
        ["\xE5\x87\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEA"],
        ["\xE5\x88\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x93\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA9"],
        ["\xE5\x88\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8A\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8B\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],
        ["\xE5\x8B\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8B\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8B\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"],
        ["\xEF\xA8\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA3"],
        ["\xE5\x8B\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA8"],
        ["\xE5\x8C\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8D\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8D\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8D\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBF"],
        ["\xE5\x8E\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x90\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x90\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDD"],
        ["\xE5\x92\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\xE5\x93\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDF"],
        ["\xE5\x94\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x94\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x94\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xBC"],
        ["\xE5\x96\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],
        ["\xE5\x96\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEF"],
        ["\xE5\x96\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF9"],
        ["\xE5\x98\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFB"],
        ["\xE5\x99\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA2"],
        ["\xE5\x99\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFD"],
        ["\xE5\x99\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFE"],
        ["\xE5\x9A\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xC3"],
        ["\xE5\x9A\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA4"],
        ["\xE5\x9A\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xC6"],
        ["\xE5\x9C\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x88\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAD"],
        ["\xE5\x9C\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"],
        ["\xE5\x9C\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9C\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9C\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB0"],
        ["\xE5\x9D\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9E\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x8C\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBA"],
        ["\xE5\x9E\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC0"],
        ["\xE5\x9F\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBF"],
        ["\xE5\x9F\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA0\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC1"],
        ["\xE5\xA1\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xC9"],
        ["\xE5\xA1\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA1\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD2"],
        ["\xE5\xA2\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x91\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD5"],
        ["\xE5\xA3\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA4\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\xE8\x99\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA5\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xED"],
        ["\xE5\xA6\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA6\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA7\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF6"],
        ["\xE5\xA7\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF9"],
        ["\xE5\xA8\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA8\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFC"],
        ["\xE5\xA9\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA6"],
        ["\xE5\xA9\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA9\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA9\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA9"],
        ["\xE5\xAA\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA8"],
        ["\xE5\xAA\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xA2\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAC\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAC\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xB8"],
        ["\xF0\xA0\xAE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\xE5\xAD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAD\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAE\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB0\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB0\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB0\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9E\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD4"],
        ["\xE5\xB1\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xCF"],
        ["\xEF\xA8\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD7"],
        ["\xEF\xA8\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x9A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD8"],
        ["\xE5\xB2\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB3\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE3"],
        ["\xE5\xB3\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB3\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE7"],
        ["\xF0\xA1\xB8\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9F\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\xE5\xB4\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB5\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB5\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB5\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF9"],
        ["\xE5\xB6\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA1"],
        ["\xE5\xB7\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA6"],
        ["\xE5\x90\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBB"],
        ["\xE5\x99\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xBF"],
        ["\xE5\xB7\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCF"],
        ["\xE5\xB8\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB8\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB2"],
        ["\xE5\xB9\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBA\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBF"],
        ["\xEF\xA4\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],
        ["\xE5\xBB\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBB\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCA"],
        ["\xE5\xBC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBC\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCC"],
        ["\xE5\xBC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBC\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBE\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE1"],
        ["\xE5\xBE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBE\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBE\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],
        ["\xE5\xBF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\xE5\xBF\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEC"],
        ["\xE6\x80\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x80\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x80\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x80\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xED"],
        ["\xE6\x80\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x81\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],
        ["\xE6\x82\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x82\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x84\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x84\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB8"],
        ["\xEF\xA8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x86\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA8\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],
        ["\xE6\x86\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\xE6\x86\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\xE6\x88\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCD"],
        ["\xE6\x88\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\xE6\x89\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8A\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8B\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8B\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8B\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD9"],
        ["\xE6\x8D\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8D\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDF"],
        ["\xE6\x90\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x90\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xDD"],
        ["\xE6\x90\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x91\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x91\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xDF"],
        ["\xE6\x91\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x92\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x92\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\xE6\x93\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x94\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xE2"],
        ["\xE6\x94\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\xE6\x95\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x96\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x98\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],
        ["\xE6\x98\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBF"],
        ["\xE6\x98\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x98\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB8"],
        ["\xE6\x98\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],
        ["\xE6\x99\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],
        ["\xE6\x99\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCB"],
        ["\xF0\xA3\x87\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],
        ["\xE6\x99\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDB"],
        ["\xE6\x99\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x99\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDC"],
        ["\xE6\x99\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9A\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],
        ["\xE6\x9A\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\xE6\x9B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],
        ["\xE6\x9B\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\xE3\xAC\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],
        ["\xE6\x9B\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9B\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9C\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA4"],
        ["\xE6\x9C\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB0"],
        ["\xE6\x9D\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\xE6\x9E\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB3"],
        ["\xE6\x9E\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9E\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB7"],
        ["\xE6\x9E\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9F\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCA"],
        ["\xE6\x9F\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBA"],
        ["\xE6\x9F\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD4"],
        ["\xEF\xA9\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCD"],
        ["\xE6\xA2\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD6"],
        ["\xE6\xA3\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE7"],
        ["\xE6\xA3\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA4\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE5"],
        ["\xE6\xA5\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDE"],
        ["\xF0\xA3\x97\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA4\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\xE6\xA5\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE8"],
        ["\xE6\xA5\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA6\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\xE6\xA6\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA6\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF5"],
        ["\xE6\xA7\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAE\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAF\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xEC"],
        ["\xE6\xA8\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x9C\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\xE6\xA9\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA9\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x9D\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xED"],
        ["\xE6\xAA\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\xE6\xAA\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB0\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA4\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBE"],
        ["\xE6\xAC\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\xE6\xAD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\xE6\xAD\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAD\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\xE6\xAD\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC7"],
        ["\xE6\xAE\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAE\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAE\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA5\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCF"],
        ["\xE6\xAF\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB0\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB0\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\xE6\xB0\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB1\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB1\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB1\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDC"],
        ["\xE6\xB2\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB2\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB2\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],
        ["\xE6\xB3\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB3\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDE"],
        ["\xE6\xB3\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDD"],
        ["\xE6\xB3\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xB3\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFA"],
        ["\xE6\xB4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\xE6\xB4\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\xE6\xB4\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB5\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB5\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xED"],
        ["\xEF\xA9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEA"],
        ["\xE6\xB6\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEC"],
        ["\xE6\xB6\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\xE6\xB6\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEF"],
        ["\xE6\xB7\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\xE6\xB8\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAC"],
        ["\xE6\xB9\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBA"],
        ["\xE6\xBA\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\xE6\xBA\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\xE6\xBB\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBB\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\xE6\xBB\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCB"],
        ["\xE6\xBC\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\xE6\xBD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xF4"],
        ["\xE6\xBD\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDA"],
        ["\xE6\xBD\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\xE6\xBE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDE"],
        ["\xE6\xBE\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x80\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xF5"],
        ["\xE7\x81\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\xE7\x81\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],
        ["\xE7\x81\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x82\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFC"],
        ["\xE7\x82\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x83\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x83\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA2"],
        ["\xE7\x83\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA8"],
        ["\xE7\x84\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xFA"],
        ["\xE7\x85\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAC"],
        ["\xE7\x85\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB2"],
        ["\xE7\x85\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x85\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB3"],
        ["\xE7\x86\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],
        ["\xE7\x87\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x88\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\xE7\x88\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB8\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8A\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8A\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8B\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\xE7\x8B\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x9F\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\xE7\x8D\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],
        ["\xE7\x8E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8F\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDC"],
        ["\xE7\x8F\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\xE7\x8F\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\xE7\x90\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x90\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFA"],
        ["\xE7\x90\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\xEF\xA9\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],
        ["\xE7\x90\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x90\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFB"],
        ["\xE7\x90\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x90\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x90\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA6"],
        ["\xE7\x91\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA4"],
        ["\xE7\x91\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAD"],
        ["\xE7\x92\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB1"],
        ["\xE7\x92\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],
        ["\xE7\x92\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB5"],
        ["\xE7\x93\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x94\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x96\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\xE7\x98\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],
        ["\xE7\x98\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC6"],
        ["\xE7\x98\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\xE7\x99\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC8"],
        ["\xE7\x99\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD5"],
        ["\xE7\x9B\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9C\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9C\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9C\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\xE7\x9D\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\xE7\x9D\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA0\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x92\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA1\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA1\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\xE7\xA1\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFB"],
        ["\xE7\xA1\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA1\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFC"],
        ["\xEF\xA9\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x94\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB4"],
        ["\xEF\xA9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB6"],
        ["\xE7\xA5\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA5\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB5"],
        ["\xEF\xA9\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBD"],
        ["\xEF\xA9\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBC"],
        ["\xE7\xA5\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB9"],
        ["\xEF\xA9\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBA"],
        ["\xE7\xA5\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCE"],
        ["\xEF\xA9\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCF"],
        ["\xEF\xA9\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD1"],
        ["\xE7\xA6\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA6\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA6"],
        ["\xE7\xA6\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDA"],
        ["\xF0\xA5\x9D\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDD"],
        ["\xE7\xA7\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA8\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEB"],
        ["\xE7\xA8\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEC"],
        ["\xE7\xA9\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\xE7\xA9\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF7"],
        ["\xE7\xAA\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFB"],
        ["\xF0\xA5\xA7\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFC"],
        ["\xE7\xAA\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAB\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAB\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAB"],
        ["\xE7\xAC\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB2"],
        ["\xE7\xAD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB6"],
        ["\xE7\xAF\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBB"],
        ["\xE7\xB0\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB0\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC5"],
        ["\xE7\xB0\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xAD"],
        ["\xE7\xB0\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB0\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB0\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x89\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC7"],
        ["\xF0\xA5\xB6\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB2\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB2\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB2\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\xE7\xB2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\xE7\xB3\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\xE7\xB4\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],
        ["\xE7\xB4\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD4"],
        ["\xE7\xB4\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE4"],
        ["\xE7\xB5\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE6"],
        ["\xE7\xB6\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF5"],
        ["\xEF\xA9\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF2"],
        ["\xE7\xB8\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],
        ["\xE7\xB8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF8"],
        ["\xE7\xB9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB9\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xB5"],
        ["\xE7\xBA\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xA8"],
        ["\xE7\xBE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBE\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xB7"],
        ["\xE7\xBF\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xBA"],
        ["\xE8\x80\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xBB"],
        ["\xE8\x80\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFA"],
        ["\xE8\x83\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFB"],
        ["\xE8\x83\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x84\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x85\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x85\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x85\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x85\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x85\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x86\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xC6"],
        ["\xE4\x91\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCC"],
        ["\xE4\x91\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xAB\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\xE8\x8A\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xD2"],
        ["\xE8\x8A\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8B\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8B\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8B\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xDC"],
        ["\xE8\x8D\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xF4"],
        ["\xE8\x8E\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xA2"],
        ["\xE8\x8F\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xC4"],
        ["\xEF\xA9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xAC"],
        ["\xE8\x91\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xA8"],
        ["\xE8\x91\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xAB"],
        ["\xE8\x91\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x92\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x92\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x92\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x92\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xB9\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xC6"],
        ["\xE8\x94\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\xE8\x95\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xC0"],
        ["\xE8\x96\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xCD"],
        ["\xE8\x97\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xCE"],
        ["\xE8\x98\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x83\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xCF"],
        ["\xE8\x98\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xD2"],
        ["\xEF\xA4\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xD3"],
        ["\xE8\x99\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x96\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xD5"],
        ["\xE8\x99\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x97\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xCE"],
        ["\xE8\xA0\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xD0"],
        ["\xE8\xA2\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x9A\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xE4"],
        ["\xE8\xA4\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA5\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA6\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC7"],
        ["\xE8\xA7\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xF9"],
        ["\xE8\xA7\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xFA"],
        ["\xE8\xA7\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xFD"],
        ["\xE8\xA8\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xA2"],
        ["\xE8\xA9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xA6"],
        ["\xE8\xA9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xA3"],
        ["\xE8\xA9\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA9\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA9\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAB\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xB1"],
        ["\xEF\xA9\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xB9"],
        ["\xE8\xAD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xBB"],
        ["\xE8\xAD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xBF"],
        ["\xE8\xAD\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAE\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB1\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB1\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xCE"],
        ["\xE8\xB3\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB3\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB3\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xD4"],
        ["\xE8\xB4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB6\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB7\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB7\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB8\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB8\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB8\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB9\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB9\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA8\x89\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBB\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xD6"],
        ["\xE4\xA1\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBB\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBC\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBC\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xE5"],
        ["\xF0\xA8\x8F\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBE\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA7"],
        ["\xE8\xBE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBF\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBF\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xF0"],
        ["\xE8\xBF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xEF"],
        ["\xE9\x80\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x80\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x82\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x82\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x82\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x82\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x82\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x82\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xC4"],
        ["\xE9\x82\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x82\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x83\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xC6"],
        ["\xE9\x83\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x83\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x83\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x83\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x83\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x83\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x84\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x85\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x85\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x86\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x86\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x86\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xE4"],
        ["\xE9\x86\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xE5"],
        ["\xE9\x86\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x87\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x87\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xDD"],
        ["\xE9\x88\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x88\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xFB"],
        ["\xE9\x89\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x89\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8B\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8B\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xB9"],
        ["\xE9\x8B\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8C\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC0"],
        ["\xE9\x8C\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xBC"],
        ["\xE9\x8D\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xCF"],
        ["\xE9\x8D\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xC9"],
        ["\xE9\x8D\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8D\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8D\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8E\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8E\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8E\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\xE9\x8F\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xDE"],
        ["\xE9\x90\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8F\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x90\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xEE"],
        ["\xE9\x91\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x91\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x91\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xF5"],
        ["\xE9\x91\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x91\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x96\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xF7"],
        ["\xE9\x96\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x96\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x96\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x96\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xF9"],
        ["\xE9\x96\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x96\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x97\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x97\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x97\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xA6\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xFD"],
        ["\xE9\x97\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x97\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x99\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9A\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9A\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9A\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9B\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9B\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xAA"],
        ["\xEF\xA9\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xAB"],
        ["\xE9\x9B\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9B\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xAD"],
        ["\xE9\x9D\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9D\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9D\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9D\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9E\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9E\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9E\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9F\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9F\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9F\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9F\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xBA"],
        ["\xE9\xA0\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xBC"],
        ["\xE9\xA0\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA0\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA0\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xEC"],
        ["\xEF\xA9\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA1\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA1\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA1\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA1\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA1\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xED"],
        ["\xEF\xA7\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xC0"],
        ["\xE9\xA1\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA2\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA3\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA3\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA5\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xD6"],
        ["\xE9\xA8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA9\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xD8"],
        ["\xE9\xA9\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xF0"],
        ["\xE9\xAA\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB0\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\xE9\xAE\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\xE9\xB1\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB4\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB4\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\xE9\xB5\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\xE9\xB7\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xF4"],
        ["\xF0\xAA\x86\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB8\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB9\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xF5"],
        ["\xE9\xBA\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xF7"],
        ["\xE9\xBA\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xF8"],
        ["\xE9\xBB\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBE\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xAB"],
        ["\xE9\xBE\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBE\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEE"],
        ["\xE5\xA7\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xCD"],
        ["\xE5\xB9\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA3"],
        ["\xE7\xB9\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xB4"],
        ["\xF0\xA0\x82\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB8\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\xE4\xB8\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB8\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA5"],
        ["\xE4\xB8\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB8\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB9\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB1"],
        ["\xE4\xB9\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x82\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB9\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x90\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x82\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB9\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB9\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBA\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x90\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x90\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xE3"],
        ["\xE4\xBA\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBF"],
        ["\xE4\xBA\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x86\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBA\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBB\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBB\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBB\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBB\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],
        ["\xE4\xBB\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\xE4\xBB\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBC\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBC\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\xE4\xBD\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x88\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBD\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBE\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBE\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBF\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\xE4\xBE\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\xE4\xBE\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEC"],
        ["\xE4\xBF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBF\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEA"],
        ["\xE4\xBF\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBF\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x91\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xBF\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x80\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x80\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x80\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x80\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\xE3\x91\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFE"],
        ["\xE5\x81\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x81\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x81\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA8"],
        ["\xE5\x81\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA9"],
        ["\xE5\x81\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAA"],
        ["\xE5\x81\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB3"],
        ["\xE5\x82\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x8C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x82\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x8E\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x8D\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x83\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBF"],
        ["\xE5\x83\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x92\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAE\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9D\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC3"],
        ["\xE3\x9D\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAF\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAF\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9D\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9D\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAF\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAF\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9D\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB0\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB0\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB0\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB1\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB4\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB5\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB1\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB5\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDC"],
        ["\xE5\xB2\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD9"],
        ["\xE3\x9F\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB6\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB6\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB6\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB2\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE1"],
        ["\xE5\xB2\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDF"],
        ["\xF0\xA1\xB6\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB3\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"],
        ["\xF0\xA1\xB7\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xB8\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEA"],
        ["\xE5\xB4\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB4\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9F\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB5\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF1"],
        ["\xE5\xB5\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB5\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xBC\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9F\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA0\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF5"],
        ["\xE5\xB6\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFB"],
        ["\xE5\xB6\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFA"],
        ["\xE5\xB6\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB6\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xBD\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB7\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB7\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xBF\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB7\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB7\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA0\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB8\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA0\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB8\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA1\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB8\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA1\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA1\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB9\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB9\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xB9\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x84\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x8F\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x84\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x84\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x91\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x85\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x94\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x85\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x86\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x86\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x92\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x86\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x86\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x86\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x93\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x86\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\xF0\xA0\x97\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x98\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x87\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x87\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x88\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x88\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x88\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\x9D\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x89\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8A\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8A\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xA0\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8A\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xA0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8A\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\xE5\x8A\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8A\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8B\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],
        ["\xE3\x94\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFB"],
        ["\xE5\x8B\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFA"],
        ["\xF0\xA0\xA2\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8B\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8C\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8C\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xA4"],
        ["\xE5\x8C\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8C\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8D\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB1"],
        ["\xF0\xA0\xA5\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xA6\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8D\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xC4"],
        ["\xE5\x8D\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBB"],
        ["\xE5\x8D\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8E\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8E\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xAB\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8E\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8F\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xAC\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x95\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x95\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8F\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8F\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\xE3\x95\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x8F\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x90\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x90\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x95\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x91\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x92\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x93\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xB5\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x93\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x93\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x93\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x93\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x94\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],
        ["\xE5\x94\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x94\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x94\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x96\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x96\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\xE5\x95\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xB7\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x95\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x96\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x96\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x96\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x97\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xBA\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xB9\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x96\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x97\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xB9\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x97\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA0\xBD\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFA"],
        ["\xE5\x98\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x97\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x98\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x99\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x98\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA3"],
        ["\xE5\x9A\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9A\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA6"],
        ["\xE5\x9A\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9B\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x88\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9C\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9C\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAF"],
        ["\xF0\xA1\x89\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9C\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x89\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB1"],
        ["\xE5\x9D\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x89\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\xE5\x9D\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9D\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x8B\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x8B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9E\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9E\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9E\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9E\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x8B\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBE"],
        ["\xF0\xA1\x8C\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x8D\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\xE5\x9F\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x99\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x9F\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA0\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA0\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA0\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA0\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA0\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA0\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x8F\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA1\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA1\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA1\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCD"],
        ["\xE5\xA2\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\xE5\xA2\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA2\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x91\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA3\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA4\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA4\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDB"],
        ["\xE5\xA4\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA4\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA4\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x97\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9A\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA4\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9A\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA5\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9A\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xB0\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA5\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE7"],
        ["\xF0\xA1\x99\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA5\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF0"],
        ["\xE5\xA5\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA5\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA6\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"],
        ["\xE5\xA6\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA6\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA7\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF5"],
        ["\xE5\xA7\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA7\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFA"],
        ["\xE5\xA7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA7\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF8"],
        ["\xE5\xA7\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA7\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x9C\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\x9D\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x9B\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA8\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA8\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA8\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA9\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA9\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xA9\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA7"],
        ["\xE5\xAA\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAD"],
        ["\xE5\xAA\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAA\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAB\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAB\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAB\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAB\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAB\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB0"],
        ["\xE5\xAB\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAB\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAC\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAC\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAC\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAC\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAC\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAD\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAD\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAD\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAD\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAD\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAE\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xAE\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA1\xA7\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBA"],
        ["\xE5\xB9\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\x85\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBA\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBA\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBA\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBA"],
        ["\xE5\xBA\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBA\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBB\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBB\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBB\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\x8C\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBB\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCB"],
        ["\xE5\xBC\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBC\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCF"],
        ["\xE5\xBC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],
        ["\xF0\xA2\x8E\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBC\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDA"],
        ["\xE5\xBD\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBD\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBE\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBE\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBE\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\xE5\xBE\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\xE5\xBF\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\xE5\xBF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\xBF\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA4\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],
        ["\xE6\x80\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x80\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x80\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA4\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\xE6\x81\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x81\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFE"],
        ["\xE6\x82\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x82\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\x9B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x82\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA4"],
        ["\xE6\x82\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x82\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x83\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x84\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x84\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x84\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\xE6\x84\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x84\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x84\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x85\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x85\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x85\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x85\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xA1\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x86\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x86\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\xE6\x86\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x86\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x86\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x86\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\xF0\xA2\xA2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x87\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x87\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],
        ["\xE6\x87\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x87\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xA6\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x88\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x88\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x88\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCE"],
        ["\xE6\x89\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x89\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],
        ["\xE6\x8A\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8B\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xAA\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8B\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xAD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xAD\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8C\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8D\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8D\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8D\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xAD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8D\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xB0\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xAE\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8D\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8E\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8E\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xB0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8E\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8E\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x8F\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x90\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\xE6\x90\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x90\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x90\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x90\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x91\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x91\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x91\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x91\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x91\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x92\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x92\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x92\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\xB7\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x93\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x94\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA9\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x94\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x94\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x94\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xA9\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x94\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x94\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x95\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x95\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x95\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x95\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x96\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x96\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x96\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB9"],
        ["\xE6\x96\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA3"],
        ["\xE6\x96\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x96\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x96\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x96\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x97\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x97\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x97\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAB\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA8"],
        ["\xE6\x97\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAC"],
        ["\xE6\x97\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x97\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x98\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x98\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB5"],
        ["\xE6\x98\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\xE6\x98\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x99\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x99\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCC"],
        ["\xE6\x99\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD0"],
        ["\xE3\xAB\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x87\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x99\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD4"],
        ["\xE6\x99\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],
        ["\xF0\xA3\x87\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],
        ["\xF0\xA3\x86\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x99\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\xE6\x99\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\xE6\x99\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x99\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x99\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9A\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9A\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9A\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE8"],
        ["\xE3\xAC\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9A\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9A\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAC\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],
        ["\xE3\xAC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9B\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAB\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9C\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9C\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9C\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x8D\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA5"],
        ["\xF0\xA3\x8F\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB8"],
        ["\xF0\xA3\x8F\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x8F\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x8F\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x8F\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9D\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x8F\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9E\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x8F\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9E\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9E\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9F\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9F\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9F\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9F\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBC"],
        ["\xE6\x9F\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9F\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\x9F\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x91\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x91\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x91\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x91\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA0\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC9"],
        ["\xE6\xA1\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\xE6\xA1\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA1\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCB"],
        ["\xE6\xA1\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD8"],
        ["\xE6\xA2\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAD\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE6"],
        ["\xE6\xA2\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA2\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x93\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x95\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA3\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA4\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAE\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAE\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE4"],
        ["\xF0\xA3\x96\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA4\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAE\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA5\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA6\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\xE3\xAE\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA6\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA6\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA6\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA6\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF3"],
        ["\xE6\xA6\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAD"],
        ["\xE6\xA6\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF4"],
        ["\xE6\xA7\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x98\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x99\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x98\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x98\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFD"],
        ["\xE6\xA7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA6"],
        ["\xE6\xA7\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAF\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA7\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA5"],
        ["\xE6\xA8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x9C\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA8\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA9\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xA9\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAA"],
        ["\xE6\xA9\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAF"],
        ["\xE6\xA9\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x9C\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xAF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x9D\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAA\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB5"],
        ["\xE6\xAB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x9F\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\x9F\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAB\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E\xEE"],
        ["\xE6\xAB\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xA0\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xA0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB0\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAD\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\xE6\xAD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAD\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAE\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAE\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xAA\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAE\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAE\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCD"],
        ["\xE6\xAF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xAF\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\xE6\xB0\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB0\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB0\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB0\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB0\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB0\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xB1\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB1\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB1\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB1\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE1"],
        ["\xE6\xB2\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB2\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB3\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB2\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB2\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB2\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\xE6\xB2\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB3\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\xE6\xB3\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB3\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB3\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\xE6\xB3\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB3\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDF"],
        ["\xE6\xB3\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB3\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xB4\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB1\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],
        ["\xE6\xB4\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB5\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB5\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB5\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\xE6\xB6\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\xE6\xB6\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\xE6\xB6\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xB5\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xB7\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xB7\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xB7\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB6\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB4\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA9"],
        ["\xE6\xB7\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA7"],
        ["\xE6\xB7\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB7\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],
        ["\xE6\xB7\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAA"],
        ["\xE6\xB8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB8\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB4\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB8\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB1"],
        ["\xE6\xB9\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB2"],
        ["\xE6\xB9\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xB9\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\xE6\xB9\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB4\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBA\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBA\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBA\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBB\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBB\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBB\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFB"],
        ["\xE6\xBC\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBB\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBB\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBB\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCC"],
        ["\xE6\xBC\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBC\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA3\xBD\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBD\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBE\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\xE3\xB5\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\xE6\xBF\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x82\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE6\xBF\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x80\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x80\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x80\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x84\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x80\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x80\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x80\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB6\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x81\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x82\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x82\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFB"],
        ["\xE7\x82\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x82\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x87\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x82\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x82\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x87\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x83\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x83\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x83\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x83\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA3"],
        ["\xE7\x83\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\xE7\x84\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB7\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x84\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAA"],
        ["\xE7\x84\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x85\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x85\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x85\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x85\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB7\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\xE7\x86\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x86\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x8E\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x87\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBF"],
        ["\xE7\x87\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x87\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x87\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x88\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB8\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x88\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x88\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x88\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x88\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB8\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x98\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x89\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8A\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\x9A\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8A\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8A\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8A\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8B\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB9\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8B\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB9\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xB9\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8B\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8B\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBA\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8C\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBA\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xA2\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8D\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\xE7\x8E\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"],
        ["\xE7\x8E\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\xE7\x8E\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\xE7\x8E\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],
        ["\xE7\x8E\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8E\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE1"],
        ["\xE7\x8F\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8F\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDD"],
        ["\xE7\x8F\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8F\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],
        ["\xE7\x8F\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\xE7\x90\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x8F\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x90\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEE"],
        ["\xE7\x90\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x90\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x90\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\xE7\x91\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA3"],
        ["\xE7\x91\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x91\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAB"],
        ["\xE7\x92\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xA9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"],
        ["\xE7\x92\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x92\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xAD\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x93\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB8"],
        ["\xF0\xA4\xAD\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x94\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x94\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x94\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBD\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xB0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x94\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x94\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC1"],
        ["\xE7\x95\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBF"],
        ["\xE7\x95\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x95\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\xE7\x96\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xB4\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x96\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x96\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x96\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x96\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x96\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x97\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBE\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xB8\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xB8\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x98\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xB9\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBF\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA4\xBA\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\xBF\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x99\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCB"],
        ["\xE7\x9A\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\xE7\x9A\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9A\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x81\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x81\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9B\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x84\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9C\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9C\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9C\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],
        ["\xE7\x9C\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x86\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x80\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x87\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x87\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x88\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xED"],
        ["\xE7\x9D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9D\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x89\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x81\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9E\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\xE7\x9F\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x82\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],
        ["\xE7\x9F\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\x9F\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x90\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA0\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA0\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA0\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA0\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA0\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA0\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA1\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA1\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x93\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA7"],
        ["\xE7\xA2\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA2\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA9"],
        ["\xE7\xA3\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA3\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAC"],
        ["\xE7\xA3\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\xE7\xA3\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x96\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA4\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAF"],
        ["\xE7\xA4\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA5\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA5\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],
        ["\xE7\xA5\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x84\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],
        ["\xE7\xA5\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA5\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA6\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA6\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA6\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA6\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA6\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA6\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDB"],
        ["\xE7\xA7\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDC"],
        ["\xE4\x85\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE2"],
        ["\xF0\xA5\x9E\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\x9E\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x85\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE5"],
        ["\xE7\xA8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA8\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x85\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE9"],
        ["\xE7\xA8\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA8\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA9\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA9\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA9\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA9\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA9\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],
        ["\xE7\xA9\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF0"],
        ["\xE7\xA9\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF3"],
        ["\xE7\xA9\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\xE7\xA9\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xA9\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xA7\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x86\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAA\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x86\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAB\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAB\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA8"],
        ["\xE7\xAB\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xAB\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xAB\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xAB\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAE"],
        ["\xE7\xAC\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAC\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x87\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x87\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x87\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB3"],
        ["\xE7\xAD\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xAE\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x88\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAE\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAE\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAE\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x88\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAE\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAE\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAE\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xB1\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBC"],
        ["\xF0\xA5\xB1\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xAF\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB0\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB0\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB0\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB0\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC1"],
        ["\xE7\xB0\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB1\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xB8\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB8"],
        ["\xF0\xA5\xB9\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xB9\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB2\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xB9\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB2\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB2\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCD"],
        ["\xE7\xB2\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBB\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBB\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBB\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBC\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBD\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB3\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD1"],
        ["\xE7\xB4\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD2"],
        ["\xE4\x8B\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBF\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBF\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB4\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDE"],
        ["\xE7\xB5\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDA"],
        ["\xF0\xA6\x80\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA5\xBF\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x8B\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x8B\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB5\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x80\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x81\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB6\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEF"],
        ["\xE7\xB7\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB7\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x8C\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x83\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB8\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB9\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB9\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xB9\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBA\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBA\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x8C\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBA\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBA\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBA\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x8D\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBC\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBC\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xA6"],
        ["\xE7\xBD\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE3\x93\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x89\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x8A\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBD\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x8D\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBE\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE5\x85\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xAB"],
        ["\xF0\xA3\xB4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBE\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBE\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x90\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE7\xBF\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xBD"],
        ["\xE8\x80\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x80\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x81\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x81\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x81\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x81\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x81\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x82\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x82\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x82\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x82\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x82\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x99\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x9A\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA3"],
        ["\xE8\x84\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x83\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x8F\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA1"],
        ["\xE8\x84\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA8"],
        ["\xE8\x84\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x84\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x8F\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x84\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x84\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x84\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\x9C\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x84\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x90\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x85\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x90\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x86\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x90\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x86\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x86\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x90\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x86\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x86\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xA3\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xC5"],
        ["\xF0\xA6\xA3\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xA5\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x87\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xA5\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x88\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xA7\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x88\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x88\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x88\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xA8\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x88\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x88\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x88\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xA9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x91\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x91\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xAA\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xAA\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xEF\xA9\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x92\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x89\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xCB"],
        ["\xE8\x8A\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xCD"],
        ["\xE8\x8A\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xCE"],
        ["\xE8\x8A\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xD0"],
        ["\xE8\x8A\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xD1"],
        ["\xE8\x8A\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8A\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xCF"],
        ["\xE8\x8A\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8B\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8B\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8B\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xD3"],
        ["\xE8\x8C\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8C\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\xE8\x8C\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x92\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\xE9"],
        ["\xE4\x93\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x92\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8E\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x8F\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xB1\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x90\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xA4"],
        ["\xE8\x91\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\xE8\x91\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xB3\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x91\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x92\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x94\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x92\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x92\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xB5"],
        ["\xE8\x92\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x94\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xB9\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x93\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x94\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xBC"],
        ["\xE8\x95\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x94\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x95\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xBD"],
        ["\xE8\x94\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xBE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x95\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xC4"],
        ["\xE8\x96\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xBF\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xBF\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA6\xBF\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x96\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xC3"],
        ["\xE8\x97\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x97\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x84\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x98\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x84\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xD1"],
        ["\xE8\x99\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x99\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9A\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9B\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x96\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9C\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xD8"],
        ["\xE8\x9D\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9D\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x8F\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x8F\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x8F\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x97\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9E\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x90\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x91\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\x9F\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\xE8\xA0\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA0\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x98\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA1\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA1\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA1\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA1\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x98\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x98\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA1\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x98\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA1\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA2\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA2\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA2\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA2\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x9A\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA3\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x99\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x9C\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA4\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x9C\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA5\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA5\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA5\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\x9D\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x99\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA6\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA9"],
        ["\xE8\xA6\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA6\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x69\xF1"],
        ["\xE8\xA6\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA6\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA6\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA7\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA7\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x9A\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA7\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA7\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA7\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA7\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x9A\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xA1"],
        ["\xE8\xA8\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xA6\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA8\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA8\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA8\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA9\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA9\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xA9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAA\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAA\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAA\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAB\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xAE"],
        ["\xE8\xAB\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xAA\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAC\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAC\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAC\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xBA"],
        ["\xE8\xAC\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAC\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAD\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x9C\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAD\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAD\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAD\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAE\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAE\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAE\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAE\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAE\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xAE\x9E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB0\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xAE\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB0\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xAE\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xAF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB1\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB1\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB1\x8F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB1\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xC5"],
        ["\xE8\xB2\xA4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xCA"],
        ["\xE8\xB3\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB3\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB3\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xB6\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB3\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xB8\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB4\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB4\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB5\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB6\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB6\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB6\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA7\xBE\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB7\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB7\x88",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB7\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\x9F\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB7\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xB8\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xA0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xA1\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE8\xBF\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x81\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x81\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A\xFE"],
        ["\xE4\xA2\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x83\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x89\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x89\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B\xFD"],
        ["\xE9\x8A\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xA9"],
        ["\xE9\x8A\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8E\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x8F\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x96\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\xE9\x98\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x98\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xFE"],
        ["\xE9\x98\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x98\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9A\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xA1"],
        ["\xE4\xA7\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xA7\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9B\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xA8\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xA8\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9D\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9D\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\x9F\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA0\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA0\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xAA\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA0\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xAC\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA4\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA5\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA6\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xCE"],
        ["\xE9\xA7\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA7\xBC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA8\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA9\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA9\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xA9\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xAF\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAA\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xAF\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAA\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xAF\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAA\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xAF\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xDB"],
        ["\xE9\xAB\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAB\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x90",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x92",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB0\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xA5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAD\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\xAC",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xB7\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xB8\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\xB8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAE\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xB8\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xBA\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xAF\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xB9\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xBB\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB0\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xBB\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xBB\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x94",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xAA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xAB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB1\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB3\xA6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB3\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB4\x8B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D\xEE"],
        ["\xE9\xB4\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA9\xBF\x8E",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB4\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB4\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB4\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x80\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB3\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x80\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB4\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB3\x91",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xA2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\xF0\xAA\x83\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x82\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xB3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xB6",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB5\xBE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\x84",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\xA1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\xB9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB6\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\x89",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\x96",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\xA0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\xA3",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB7\xB4",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB4\x87",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB8\x8A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB8\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB8\x8D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB8\x9C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB8\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xB9\xBB",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xA2\x88\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\x80",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\x9B",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\xA8",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x8E\x8C",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBA\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],
        ["\xF0\xAA\x90\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBB\x9F",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBB\xA7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBB\xAE",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBB\xBF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE4\xB5\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\x83",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\x97",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\x99",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\xAF",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\xB7",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\xBA",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBC\xBD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x81",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x85",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x86",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x93",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x95",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x98",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x97\xB1",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\x9D",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x98\x82",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\xA9",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x98\x9A",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\xAD",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\xB0",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xE9\xBD\xB5",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF0\xAA\x9A\xB2",'keis78','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
