package Sorter::from_comparer;

use 5.010001;
use strict 'subs', 'vars';
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-01-24'; # DATE
our $DIST = 'Sorter-from_comparer'; # DIST
our $VERSION = '0.001'; # VERSION

sub meta {
    return +{
        v => 1,
        args => {
            comparer => {schema=>'perl::comparer::modname_with_optional_args*', req=>1},
            reverse => {schema=>'bool*'},
        },
    };
}

sub gen_sorter {
    my %args = @_;

    my $comparer = $args{comparer} or die "Please specify comparer";
    my $reverse = $args{reverse};

    require Module::Load::Util;

    my ($mod, $args) = Module::Load::Util::_normalize_module_with_optional_args($comparer);
    $mod = Module::Load::Util::_load_module({ns_prefix=>"Comparer"}, $mod);
    my $cmp = &{"$mod\::gen_comparer"}(@$args);

    sub {
        sort { $reverse ? $cmp->($b,$a) : $cmp->($a,$b) } @_;
    };
}

1;
# ABSTRACT: Sort by comparer generated by a Comparer:: module

__END__

=pod

=encoding UTF-8

=head1 NAME

Sorter::from_comparer - Sort by comparer generated by a Comparer:: module

=head1 VERSION

This document describes version 0.001 of Sorter::from_comparer (from Perl distribution Sorter-from_comparer), released on 2024-01-24.

=head1 SYNOPSIS

 use Sorter::from_comparer;

 my $sorter = Sorter::from_comparer::gen_sorter(comparer => "similarity=string,foo");
 my @sorted = $sorter->("food", "foolish", "foo", "bar");
 # => ("foo","food","bar","foolish")

=head1 DESCRIPTION

=for Pod::Coverage ^(meta|gen_sorter)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sorter-from_comparer>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sorter-from_comparer>.

=head1 SEE ALSO

L<Comparer>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sorter-from_comparer>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
