/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowConfiguration;

public class MessageExo
extends AbstractMessage {
    private final MessageExoType type;
    private final Participant participant;
    private final boolean shortArrow;

    public MessageExo(Participant participant, MessageExoType messageExoType, Display display, ArrowConfiguration arrowConfiguration, String string, boolean bl) {
        super(display, arrowConfiguration, string);
        this.participant = participant;
        this.type = messageExoType;
        this.shortArrow = bl;
    }

    public boolean isShortArrow() {
        return this.shortArrow;
    }

    protected NotePosition overideNotePosition(NotePosition notePosition) {
        if (this.type == MessageExoType.FROM_LEFT || this.type == MessageExoType.TO_LEFT) {
            return NotePosition.RIGHT;
        }
        if (this.type == MessageExoType.FROM_RIGHT || this.type == MessageExoType.TO_RIGHT) {
            return NotePosition.LEFT;
        }
        throw new IllegalStateException();
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public final MessageExoType getType() {
        return this.type;
    }

    public boolean dealWith(Participant participant) {
        return this.participant == participant;
    }

    public boolean compatibleForCreate(Participant participant) {
        return participant == this.participant;
    }

    public boolean isSelfMessage() {
        return false;
    }
}

