/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FontMeasurer {
    private static final String fontFamilyName = "Dialog";
    private static final boolean DEBUG = false;
    private static final FontMeasurer instance = new FontMeasurer();
    FontRenderContext fakeRenderContext;
    Graphics2D fakeGraphics;

    public int getWidthFor(String string, int n) {
        Font font = this.getFontFor(n);
        Rectangle2D rectangle2D = font.getStringBounds(string, this.fakeRenderContext);
        return (int)rectangle2D.getWidth();
    }

    public int getHeightFor(String string, int n) {
        Font font = this.getFontFor(n);
        Rectangle2D rectangle2D = font.getStringBounds(string, this.fakeRenderContext);
        return (int)rectangle2D.getHeight();
    }

    public int getWidthFor(String string, Font font) {
        Rectangle2D rectangle2D = font.getStringBounds(string, this.fakeRenderContext);
        return (int)rectangle2D.getWidth();
    }

    public int getHeightFor(String string, Font font) {
        Rectangle2D rectangle2D = font.getStringBounds(string, this.fakeRenderContext);
        return (int)rectangle2D.getHeight();
    }

    public Rectangle2D getBoundsFor(String string, Font font) {
        return font.getStringBounds(string, this.fakeRenderContext);
    }

    public Font getFontFor(int n) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        return this.getFontFor(n, this.fakeRenderContext);
    }

    public int getAscent(Font font) {
        this.fakeGraphics.setFont(font);
        FontMetrics fontMetrics = this.fakeGraphics.getFontMetrics();
        return fontMetrics.getAscent();
    }

    public int getZHeight(Font font) {
        int n = (int)font.createGlyphVector(this.fakeRenderContext, "Z").getOutline().getBounds().getHeight();
        return n;
    }

    public Font getFontFor(int n, String string) {
        int n2;
        float f = 12.0f;
        Font font = new Font(fontFamilyName, 1, (int)f);
        int n3 = this.getWidthFor(string, font);
        if (n3 > n) {
            font = font.deriveFont(f - 1.0f);
            f -= 1.0f;
            n2 = -1;
        } else {
            font = font.deriveFont(f + 1.0f);
            f += 1.0f;
            n2 = 1;
        }
        while (f > 0.0f) {
            font = font.deriveFont(f);
            n3 = this.getWidthFor(string, font);
            if (n2 == 1) {
                if (n3 > n) {
                    return font.deriveFont(f -= 1.0f);
                }
                f += 1.0f;
                continue;
            }
            if (n3 < n) {
                return font;
            }
            f -= 1.0f;
        }
        return null;
    }

    public Font getFontFor(int n, FontRenderContext fontRenderContext) {
        int n2;
        float f = 12.0f;
        Font font = new Font(fontFamilyName, 1, (int)f);
        int n3 = this.getAscent(font);
        if (n3 > n) {
            font = font.deriveFont(f - 1.0f);
            f -= 1.0f;
            n2 = -1;
        } else {
            font = font.deriveFont(f + 1.0f);
            f += 1.0f;
            n2 = 1;
        }
        while (f > 0.0f) {
            font = font.deriveFont(f);
            n3 = this.getAscent(font);
            if (n2 == 1) {
                if (n3 > n) {
                    return font.deriveFont(f -= 0.5f);
                }
                f += 0.5f;
                continue;
            }
            if (n3 < n) {
                return font;
            }
            f -= 0.5f;
        }
        return null;
    }

    public static FontMeasurer instance() {
        return instance;
    }

    public FontMeasurer() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        this.fakeGraphics = bufferedImage.createGraphics();
        this.fakeRenderContext = this.fakeGraphics.getFontRenderContext();
    }

    public static void main(String[] stringArray) {
        float f = 12.0f;
        Font font = new Font("Sans", 1, (int)f);
        System.out.println(font.getSize());
        font = font.deriveFont(f -= 1.0f);
        System.out.println(font.getSize());
        font = font.deriveFont(f -= 1.0f);
        System.out.println(font.getSize());
        font = font.deriveFont(f -= 1.0f);
        System.out.println(font.getSize());
        font = font.deriveFont(f -= 1.0f);
        System.out.println(font.getSize());
        font = font.deriveFont(f -= 1.0f);
        System.out.println(font.getSize());
    }
}

