/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorOverSequence;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.PrependIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class NamespaceNode
implements NodeInfo,
FingerprintedNode {
    NodeInfo element;
    NamespaceBinding nsBinding;
    int position;
    int namecode;

    public NamespaceNode(NodeInfo element, NamespaceBinding nscode, int position) {
        this.element = element;
        this.nsBinding = nscode;
        this.position = position;
        this.namecode = -1;
    }

    public int getNodeKind() {
        return 13;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return other instanceof NamespaceNode && this.element.isSameNodeInfo(((NamespaceNode)other).element) && this.nsBinding.equals(((NamespaceNode)other).nsBinding);
    }

    public boolean equals(Object other) {
        return other instanceof NamespaceNode && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return ((Object)this.element).hashCode() ^ this.position << 13;
    }

    public String getSystemId() {
        return this.element.getSystemId();
    }

    public String getBaseURI() {
        return null;
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public int getColumnNumber() {
        return this.element.getColumnNumber();
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof NamespaceNode && this.element.isSameNodeInfo(((NamespaceNode)other).element)) {
            int c = this.position - ((NamespaceNode)other).position;
            if (c == 0) {
                return 0;
            }
            if (c < 0) {
                return -1;
            }
            return 1;
        }
        if (this.element.isSameNodeInfo(other)) {
            return 1;
        }
        return this.element.compareOrder(other);
    }

    public String getStringValue() {
        return this.nsBinding.getURI();
    }

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public int getNameCode() {
        if (this.namecode == -1) {
            if (this.nsBinding.getPrefix().length() == 0) {
                return -1;
            }
            this.namecode = this.element.getNamePool().allocate("", "", this.nsBinding.getPrefix());
        }
        return this.namecode;
    }

    public int getFingerprint() {
        if (this.nsBinding.getPrefix().length() == 0) {
            return -1;
        }
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        return this.nsBinding.getPrefix();
    }

    public String getURI() {
        return "";
    }

    public String getDisplayName() {
        return this.getLocalPart();
    }

    public String getPrefix() {
        return "";
    }

    public Configuration getConfiguration() {
        return this.element.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.element.getNamePool();
    }

    public int getTypeAnnotation() {
        return 513;
    }

    public SchemaType getSchemaType() {
        return BuiltInAtomicType.STRING;
    }

    public NodeInfo getParent() {
        return this.element;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return this.element.iterateAxis((byte)1, nodeTest);
            }
            case 1: {
                if (nodeTest.matches(this)) {
                    return new PrependIterator(this, this.element.iterateAxis((byte)1, nodeTest));
                }
                return this.element.iterateAxis((byte)1, nodeTest);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                return EmptyAxisIterator.emptyAxisIterator();
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.element, nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public String getAttributeValue(int fingerprint) {
        return null;
    }

    public String getAttributeValue(String uri, String local) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.element.getRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.element.getDocumentRoot();
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void generateId(FastStringBuffer buffer) {
        this.element.generateId(buffer);
        buffer.append("n");
        buffer.append(Integer.toString(this.position));
    }

    public long getDocumentNumber() {
        return this.element.getDocumentNumber();
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        out.namespace(this.nsBinding, 32);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    public void setSystemId(String systemId) {
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return SingletonIterator.makeIterator(new StringValue(this.getStringValueCS()));
    }

    public Value atomize() throws XPathException {
        return new StringValue(this.getStringValueCS());
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    public static AxisIterator makeIterator(NodeInfo element, NodeTest test) {
        NamespaceNode node;
        ArrayList<NamespaceNode> nodes = new ArrayList<NamespaceNode>();
        Iterator<NamespaceBinding> bindings = NamespaceIterator.iterateNamespaces(element);
        int position = 0;
        while (bindings.hasNext()) {
            node = new NamespaceNode(element, bindings.next(), position++);
            if (!test.matches(node)) continue;
            nodes.add(node);
        }
        node = new NamespaceNode(element, NamespaceBinding.XML, position);
        if (test.matches(node)) {
            nodes.add(node);
        }
        return new AxisIteratorOverSequence(new ListIterator(nodes));
    }
}

