/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.expression;

import java.util.HashMap;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.LF;
import opennlp.common.unify.FeatureStructure;
import opennlp.common.unify.ModFcn;
import opennlp.common.unify.Mutable;
import opennlp.common.unify.Substitution;
import opennlp.common.unify.Unifier;
import opennlp.common.unify.UnifyFailure;
import opennlp.common.unify.Variable;
import opennlp.grok.expression.AbstractCat;
import opennlp.grok.expression.TargetCat;
import opennlp.grok.unify.GFeatStruc;
import opennlp.hylo.HyloHelper;
import opennlp.hylo.HyloVar;
import org.jdom.Element;

public final class AtomCat
extends AbstractCat
implements TargetCat {
    public static final int NP = 0;
    public static final int N = 1;
    public static final int S = 2;
    private int type;
    private LF _semantics;
    private int _index = 0;

    public AtomCat(Element acel) {
        Element fsEl;
        this.type = AtomCat.getType(acel.getAttributeValue("t"));
        String id = acel.getAttributeValue("id");
        if (id != null) {
            this._index = Integer.parseInt(id);
        }
        this._featStruc = (fsEl = acel.getChild("fs")) != null ? new GFeatStruc(fsEl) : new GFeatStruc();
        this._featStruc.setIndex(this._index);
        Element lf = acel.getChild("lf");
        this._semantics = lf != null ? HyloHelper.getLF((Element)((Element)lf.getChildren().get(0))) : new HyloVar();
    }

    public AtomCat(String t) {
        this.type = AtomCat.getType(t);
        this._featStruc = new GFeatStruc();
        this._semantics = new HyloVar();
    }

    protected AtomCat(int t, FeatureStructure fs, LF s) {
        this.type = t;
        this._featStruc = fs;
        this._semantics = s;
    }

    public String getType() {
        switch (this.type) {
            case 0: {
                return "np";
            }
            case 1: {
                return "n";
            }
            case 2: {
                return "s";
            }
        }
        return null;
    }

    public void setLF(LF lf) {
        this._semantics = lf;
    }

    public LF getLF() {
        return this._semantics;
    }

    public Category copy() {
        return new AtomCat(this.type, this._featStruc.copy(), this._semantics.copy());
    }

    public void deepMap(ModFcn mf) {
        this._semantics.deepMap(mf);
        mf.modify((Mutable)this);
    }

    public boolean occurs(Variable v) {
        return this._semantics.occurs(v);
    }

    public void unifyCheck(Object u) throws UnifyFailure {
        if (u instanceof AtomCat ? this.type != ((AtomCat)u).type : !(u instanceof Variable)) {
            throw new UnifyFailure();
        }
    }

    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof AtomCat && this.type == ((AtomCat)u).type) {
            AtomCat u_ac = (AtomCat)u;
            FeatureStructure $fs = this._featStruc == null ? u_ac._featStruc : (u_ac._featStruc == null ? this._featStruc : (FeatureStructure)this._featStruc.unify((Object)u_ac._featStruc, sub));
            LF $sem = (LF)Unifier.unify((Object)this._semantics, (Object)u_ac._semantics, (Substitution)sub);
            return new AtomCat(this.type, $fs, $sem);
        }
        throw new UnifyFailure();
    }

    public Object fill(Substitution s) throws UnifyFailure {
        AtomCat $ac = new AtomCat(this.type, this._featStruc.copy(), (LF)this._semantics.fill(s));
        return $ac;
    }

    public boolean shallowEquals(Object c) {
        if (c instanceof AtomCat) {
            AtomCat ac = (AtomCat)c;
            return this.type == ac.type;
        }
        return false;
    }

    public boolean equals(Object c) {
        if (c instanceof AtomCat) {
            AtomCat ac = (AtomCat)c;
            return this.type == ac.type && this._featStruc.equals(ac._featStruc);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 0: {
                sb.append("np");
                break;
            }
            case 1: {
                sb.append('n');
                break;
            }
            case 2: {
                sb.append('s');
            }
        }
        if (this._featStruc != null && AbstractCat.showFeature()) {
            sb.append(this._featStruc.toString());
        }
        sb.append(':').append(this._semantics.toString());
        if (sb.length() == 0) {
            return "UnknownCat";
        }
        return sb.toString();
    }

    protected String getHashString(HashMap subst, int[] c) {
        return this.toString();
    }

    private static int getType(String type) {
        if (type == null) {
            return 1;
        }
        if (type.equalsIgnoreCase("s")) {
            return 2;
        }
        if (type.equalsIgnoreCase("n")) {
            return 1;
        }
        if (type.equalsIgnoreCase("NP")) {
            return 0;
        }
        return 1;
    }
}

