#!/usr/bin/perl

# originally generated by wxGlade -- manually maintained

use Wx 0.26 (
  qw(
    :allclasses
  ),
);
use Wx::DND; # clipboard+drag-n-drop support
use File::Spec;

use warnings;
use strict;

use dtRdr;
# fixup for appbundle context (TODO maybe goes in dtRdr.pm?)
my $location = eval {PerlWrapper->ResourcesPath} || __FILE__;
dtRdr->init_app_dir($location); # requires us to be next to data/

package MainApp;

use Wx (
  qw(
    wxTheClipboard
  ),
);
use base 'dtRdr::GUI::Wx';
use dtRdr::GUI::Wx::MainFrame;

# testing accessor:
my $frame_main;
sub _main_frame {$frame_main};

{
  my $on_first_idle;
  sub _on_first_idle {$on_first_idle};
  sub _set_on_first_idle {$on_first_idle = $_[1]};
}
sub OnInit {
  my $self = shift;

  ######################################################################
  dtRdr->init; # ***** MUST CALL ** dtRdr->init ** EARLY *****
  ######################################################################

  Wx::InitAllImageHandlers();
  # XXX wish I could: Wx::Image::RemoveHandler('wxPCXHandler');

  $frame_main = dtRdr::GUI::Wx::MainFrame->new();
  $self->SetTopWindow($frame_main);

  $self->init($frame_main);
  $frame_main->init;

  # setting the the "on-load-done" to happen at idle gets all of the
  # focus and fun to work correctly
  my $did_idle = 0;
  if(my $on_first_idle = $self->_on_first_idle) {
    $self->Connect(-1, -1, &Wx::wxEVT_IDLE, sub {
      #$_[1]->Skip; # makes macs mad?
      (++$did_idle > 1) and return(); # eek
      dtRdr::Logger::RL('#idle')->info("run startup idle");
      $on_first_idle->();
      $self->Disconnect(-1, -1, &Wx::wxEVT_IDLE);
    });
  }

  $frame_main->Show(1);
  return 1;
} # end subroutine OnInit definition
########################################################################


=head2 OnExit

  $app->OnExit;

=cut

sub OnExit {
  my $self = shift;
  wxTheClipboard->Open;
  # this seems to achieve nothing:
  wxTheClipboard->Clear;
  #wxTheClipboard->Flush;
  wxTheClipboard->Close;
} # end subroutine OnExit definition
########################################################################

# end of class MainApp

package main;

use dtRdr::Logger;
unless($ENV{JUST_DIE}) {
  $SIG{__DIE__} = sub {
    die @_ if $^S; # get out if we're in an eval
    my @error = @_;

    RL('#caught')->error(@error);
    my $dialog = Wx::MessageDialog->new(
      MainApp->_main_frame,
      "Exception caught:\n\n  @error\n\n      Would you like to continue?",
      'Oops!',
      Wx::wxICON_ERROR|Wx::wxSTAY_ON_TOP|Wx::wxYES_NO,
    ) or die("Could not create Wx::MessageDialog");
    if(Wx::wxID_YES == $dialog->ShowModal) {
      goto &recover; # only way to break out of a die handler
    }
  };
}

=head2 recover

Where we go when we die.

  recover();

=cut

{ # closure for $app
my $app;
sub recover {
  unless($app) {
    local($SIG{__DIE__});
    die "cannot recover from this context";
  }
  $app->MainLoop();
} # end subroutine recover definition
########################################################################

main::main(@ARGV) if(
  ($^O eq 'MSWin32' and $ENV{PAR_ARGV_0}) # windows par (assumes main)
  or ($0 eq ( $ENV{PAR_ARGV_0} || __FILE__)) # saner situations
);

# macs are too special to pass a meaningful argv, so the MacMaker main.c
# is going to call this directly
sub main::main {
  my @args = @_;

  if(@args) { # XXX no, not pretty
    MainApp->_set_on_first_idle(sub {
      MainApp->_main_frame->backend_file_open($args[0]);
    });
  }
  elsif(1) {
    # unfortunately, we have to run this as a deferred sub because we
    # won't have an environment until later
    MainApp->_set_on_first_idle(sub {
      dtRdr->first_time and MainApp->_main_frame->_open_first_book;
    });
  }
  $app = MainApp->new();

  $app->MainLoop();
}
} # end $app closure

# tell perlwrapper we want to handle SIG{__DIE__}
eval {PerlWrapper->NoEval(1)};

# vim:ts=2:sw=2:et:sta
my $package = 'MainApp';
