package Locales::DB::Language::ro;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::ro::VERSION = '0.09';

$Locales::DB::Language::ro::cldr_version = '2.0';

%Locales::DB::Language::ro::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Limbă\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ şi\ \{1\}",
            'end'    => "\{0\}\ şi\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regiune\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '»',
        'alternate_quotation_start' => '«',
        'quotation_end'             => '”',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'other'
        ],
        'category_rules' => {
            'few' => "n\ is\ 0\ OR\ n\ is\ not\ 1\ AND\ n\ mod\ 100\ in\ 1\.\.19",
            'one' => "n\ is\ 1"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( $_[0] == 0 ) ) || ( ( $_[0] != 1 ) && ( int( $_[0] ) == $_[0] && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) >= 1 && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) <= 19 ) ) ) { return 'few'; }
                return;
            },
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "nu\:n",
        'yesstr' => "da\:d"
    },
);

%Locales::DB::Language::ro::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'abhază',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'afrikaans',
    'afa'    => "limbă\ afro\-asiatică",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'ainu',
    'ak'     => 'Akan',
    'akk'    => 'akkadiană',
    'ale'    => 'aleută',
    'alg'    => "Algonquian\ Language",
    'alt'    => "altaică\ meridională",
    'am'     => 'amharică',
    'an'     => 'aragoneză',
    'ang'    => "engleză\ veche",
    'anp'    => 'Angika',
    'apa'    => "limbă\ apașă",
    'ar'     => 'arabă',
    'arc'    => 'aramaică',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "limbă\ artificială",
    'arw'    => 'Arawak',
    'as'     => 'asameză',
    'asa'    => 'Asu',
    'ast'    => 'asturiană',
    'ath'    => "Athapascan\ Language",
    'aus'    => "limbă\ australiană",
    'av'     => 'avară',
    'awa'    => 'Awadhi',
    'ay'     => 'aymara',
    'az'     => 'azeră',
    'ba'     => 'bașkiră',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "limbă\ baltică",
    'be'     => 'bielorusă',
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'berberă',
    'bez'    => 'Bena',
    'bg'     => 'bulgară',
    'bh'     => 'bihari',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'bengaleză',
    'bnt'    => 'bantu',
    'bo'     => 'tibetană',
    'br'     => 'bretonă',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'bosniacă',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'catalană',
    'cad'    => 'Caddo',
    'cai'    => "limbă\ central\-amerindiană",
    'car'    => 'Carib',
    'cau'    => "limbă\ caucaziană",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'cecenă',
    'ceb'    => 'Cebuano',
    'cel'    => "limbă\ celtică",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'corsicană',
    'cop'    => 'coptă',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => 'cehă',
    'csb'    => 'Kashubian',
    'cu'     => 'slavonă',
    'cus'    => "Cushitic\ Language",
    'cv'     => 'ciuvașă',
    'cy'     => 'velșă',
    'da'     => 'daneză',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'germană',
    'de_at'  => "germană\ austriacă",
    'de_ch'  => "germană\ standard\ elvețiană",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "limbă\ dravidiană",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'dzongkha',
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'efik',
    'egy'    => "egipteană\ veche",
    'eka'    => 'Ekajuk',
    'el'     => 'greacă',
    'elx'    => 'elamită',
    'en'     => 'engleză',
    'en_au'  => "engleză\ australiană",
    'en_ca'  => "engleză\ canadiană",
    'en_gb'  => "engleză\ britanică",
    'en_us'  => "engleză\ americană",
    'enm'    => "Middle\ English",
    'eo'     => 'esperanto',
    'es'     => 'spaniolă',
    'es_419' => "spaniolă\ latino\-americană",
    'es_es'  => "spaniolă\ iberică",
    'et'     => 'estoniană',
    'eu'     => 'bască',
    'ewo'    => 'Ewondo',
    'fa'     => 'persană',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'finlandeză',
    'fil'    => 'filipineză',
    'fiu'    => "limbă\ fino\-ugrică",
    'fj'     => 'fijiană',
    'fo'     => 'faroeză',
    'fon'    => 'Fon',
    'fr'     => 'franceză',
    'fr_ca'  => "franceză\ canadiană",
    'fr_ch'  => "franceză\ elvețiană",
    'frm'    => "Middle\ French",
    'fro'    => "franceză\ veche",
    'frr'    => "Northern\ Frisian",
    'frs'    => "frizonă\ orientală",
    'fur'    => 'Friulian',
    'fy'     => "frizonă\ occidentală",
    'ga'     => 'irlandeză',
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "gaelică\ scoțiană",
    'gem'    => "limbă\ germanică",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'galiciană',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'guarani',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'gotică',
    'grb'    => 'Grebo',
    'grc'    => "greacă\ veche",
    'gsw'    => "germană\ elvețiană",
    'gu'     => 'gujarati',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'hausa',
    'hai'    => 'Haida',
    'haw'    => 'hawaiană',
    'he'     => 'ebraică',
    'hi'     => 'hindi',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'hitită',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'croată',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'haitiană',
    'hu'     => 'maghiară',
    'hup'    => 'Hupa',
    'hy'     => 'armeană',
    'hz'     => 'Herero',
    'ia'     => 'interlingua',
    'iba'    => 'Iban',
    'id'     => 'indoneziană',
    'ie'     => 'interlingue',
    'ig'     => 'igbo',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'inupiak',
    'ilo'    => 'Iloko',
    'inc'    => "limbă\ indiană",
    'ine'    => "limbă\ indo\-europeană",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "limbă\ iraniană",
    'iro'    => "Iroquoian\ Language",
    'is'     => 'islandeză',
    'it'     => 'italiană',
    'iu'     => 'Inuktitut',
    'ja'     => 'japoneză',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "iudeo\-persană",
    'jrb'    => "iudeo\-arabă",
    'jv'     => 'javaneză',
    'ka'     => 'georgiană',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'congoleză',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'kazahă',
    'kl'     => 'kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => 'khmeră',
    'kmb'    => 'Kimbundu',
    'kn'     => 'kannada',
    'ko'     => 'coreeană',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'cașmireză',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'kurdă',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'kîrgîză',
    'la'     => 'latină',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'luxemburgheză',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'lingala',
    'lo'     => 'laoțiană',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'lituaniană',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => 'letonă',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => 'austroneziană',
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'malgașă',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'maori',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "limbi\ diverse",
    'mk'     => 'macedoneană',
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => 'malayalam',
    'mn'     => 'mongolă',
    'mnc'    => 'manciuriană',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'moldovenească',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'marathi',
    'ms'     => 'malay',
    'mt'     => 'malteză',
    'mua'    => 'Mundang',
    'mul'    => "limbi\ multiple",
    'mun'    => "limbă\ munda",
    'mus'    => 'Creek',
    'mwl'    => 'mirandeză',
    'mwr'    => 'Marwari',
    'my'     => 'birmaneză',
    'myn'    => "limbă\ mayașă",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "limbă\ nord\-amerindiană",
    'nap'    => 'napolitană',
    'naq'    => 'Nama',
    'nb'     => "norvegiana\ bokmål",
    'nd'     => "ndebele\ de\ nord",
    'nds'    => "Low\ German",
    'ne'     => 'nepaleză',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'olandeză',
    'nl_be'  => 'flamandă',
    'nmg'    => 'Kwasio',
    'nn'     => "norvegiană\ nynorsk",
    'no'     => 'norvegiană',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "sotho\ de\ nord",
    'nub'    => "limbă\ nubiană",
    'nus'    => 'Nuer',
    'nv'     => 'navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'nyanja',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'occitană',
    'oj'     => 'Ojibwa',
    'om'     => 'oromo',
    'or'     => 'oriya',
    'os'     => 'osetă',
    'osa'    => 'Osage',
    'ota'    => "turcă\ otomană",
    'oto'    => "limbă\ otomi",
    'pa'     => 'punjabi',
    'paa'    => "limbă\ papuașă",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "persană\ veche",
    'phi'    => "limbă\ filipineză",
    'phn'    => 'feniciană',
    'pi'     => 'pali',
    'pl'     => 'poloneză',
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "provensală\ veche",
    'ps'     => 'pushto',
    'pt'     => 'portugheză',
    'pt_br'  => "portugheză\ braziliană",
    'pt_pt'  => "portugheză\ iberică",
    'qu'     => 'quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'retoromană',
    'rn'     => 'kirundi',
    'ro'     => 'română',
    'roa'    => "limbă\ romanică",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => 'rusă',
    'rup'    => 'aromână',
    'rw'     => 'kinyarwanda',
    'rwk'    => 'Rwa',
    'sa'     => 'sanscrită',
    'sad'    => 'Sandawe',
    'sah'    => 'sakha',
    'sai'    => "limbă\ sud\-amerindiană",
    'sal'    => "Salishan\ Language",
    'sam'    => "aramaică\ samariteană",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'sardiniană',
    'scn'    => 'siciliană',
    'sco'    => 'scots',
    'sd'     => 'sindhi',
    'se'     => "sami\ de\ nord",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "limbă\ semitică",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'sango',
    'sga'    => "irlandeză\ veche",
    'sgn'    => "limbaj\ mimico\-gestual",
    'sh'     => "sârbo\-croată",
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'singaleză',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "limbă\ sino\-tibetană",
    'sk'     => 'slovacă',
    'sl'     => 'slovenă',
    'sla'    => "limbă\ slavă",
    'sm'     => 'samoană',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'shona',
    'snk'    => 'Soninke',
    'so'     => 'somaleză',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => 'albaneză',
    'sr'     => 'sârbă',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'swati',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => 'sesotho',
    'su'     => 'sundaneză',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'sumeriană',
    'sv'     => 'suedeză',
    'sw'     => 'swahili',
    'swb'    => 'comoreză',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'siriacă',
    'ta'     => 'tamilă',
    'tai'    => "limbă\ thai",
    'te'     => 'telugu',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'tetum',
    'tg'     => 'tadjică',
    'th'     => 'thailandeză',
    'ti'     => 'tigrinya',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'turkmenă',
    'tkl'    => 'Tokelau',
    'tl'     => 'tagalog',
    'tlh'    => 'klingoniană',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'setswana',
    'to'     => 'tonga',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "tok\ pisin",
    'tr'     => 'turcă',
    'trv'    => 'Taroko',
    'ts'     => 'tsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'tătară',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "limbă\ altaică",
    'tvl'    => 'Tuvalu',
    'tw'     => 'twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'tahitiană',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'uigur',
    'uga'    => 'Ugaritic',
    'uk'     => 'ucraineană',
    'umb'    => 'Umbundu',
    'und'    => "limbă\ necunoscută\ sau\ nevalidă",
    'ur'     => 'urdu',
    'uz'     => 'uzbecă',
    'vai'    => 'Vai',
    've'     => 'venda',
    'vi'     => 'vietnameză',
    'vo'     => 'volapuk',
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'valonă',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'wolof',
    'xal'    => 'calmucă',
    'xh'     => 'xhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'idiș',
    'yo'     => 'yoruba',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'cantoneză',
    'za'     => 'Zhuang',
    'zap'    => 'zapotecă',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => 'chineză',
    'znd'    => 'Zande',
    'zu'     => 'zulu',
    'zun'    => 'Zuni',
    'zxx'    => "fară\ conținut\ lingvistic",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::ro::name_to_code = (
    'abhază'                        => 'ab',
    'achinese'                       => 'ace',
    'acoli'                          => 'ach',
    'adangme'                        => 'ada',
    'adyghe'                         => 'ady',
    'afar'                           => 'aa',
    'afrihili'                       => 'afh',
    'afrikaans'                      => 'af',
    'aghem'                          => 'agq',
    'ainu'                           => 'ain',
    'akan'                           => 'ak',
    'akkadiană'                     => 'akk',
    'albaneză'                      => 'sq',
    'aleută'                        => 'ale',
    'algonquianlanguage'             => 'alg',
    'altaicămeridională'           => 'alt',
    'amharică'                      => 'am',
    'angika'                         => 'anp',
    'arabă'                         => 'ar',
    'aragoneză'                     => 'an',
    'aramaică'                      => 'arc',
    'aramaicăsamariteană'          => 'sam',
    'arapaho'                        => 'arp',
    'araucanian'                     => 'arn',
    'arawak'                         => 'arw',
    'armeană'                       => 'hy',
    'aromână'                      => 'rup',
    'asameză'                       => 'as',
    'asturiană'                     => 'ast',
    'asu'                            => 'asa',
    'athapascanlanguage'             => 'ath',
    'atsam'                          => 'cch',
    'austroneziană'                 => 'map',
    'avară'                         => 'av',
    'avestan'                        => 'ae',
    'awadhi'                         => 'awa',
    'aymara'                         => 'ay',
    'azeră'                         => 'az',
    'bafia'                          => 'ksf',
    'balinese'                       => 'ban',
    'baluchi'                        => 'bal',
    'bambara'                        => 'bm',
    'bamilekelanguage'               => 'bai',
    'banda'                          => 'bad',
    'bantu'                          => 'bnt',
    'basaa'                          => 'bas',
    'bască'                         => 'eu',
    'batak'                          => 'btk',
    'bașkiră'                      => 'ba',
    'beja'                           => 'bej',
    'bemba'                          => 'bem',
    'bena'                           => 'bez',
    'bengaleză'                     => 'bn',
    'berberă'                       => 'ber',
    'bhojpuri'                       => 'bho',
    'bielorusă'                     => 'be',
    'bihari'                         => 'bh',
    'bikol'                          => 'bik',
    'bini'                           => 'bin',
    'birmaneză'                     => 'my',
    'bislama'                        => 'bi',
    'blin'                           => 'byn',
    'blissymbols'                    => 'zbl',
    'bodo'                           => 'brx',
    'bosniacă'                      => 'bs',
    'braj'                           => 'bra',
    'bretonă'                       => 'br',
    'buginese'                       => 'bug',
    'bulgară'                       => 'bg',
    'buriat'                         => 'bua',
    'caddo'                          => 'cad',
    'calmucă'                       => 'xal',
    'cantoneză'                     => 'yue',
    'carib'                          => 'car',
    'catalană'                      => 'ca',
    'cayuga'                         => 'cay',
    'cașmireză'                    => 'ks',
    'cebuano'                        => 'ceb',
    'cecenă'                        => 'ce',
    'cehă'                          => 'cs',
    'centralmoroccotamazight'        => 'tzm',
    'chagatai'                       => 'chg',
    'chamiclanguage'                 => 'cmc',
    'chamorro'                       => 'ch',
    'cherokee'                       => 'chr',
    'cheyenne'                       => 'chy',
    'chibcha'                        => 'chb',
    'chiga'                          => 'cgg',
    'chineză'                       => 'zh',
    'chinookjargon'                  => 'chn',
    'chipewyan'                      => 'chp',
    'choctaw'                        => 'cho',
    'chuukese'                       => 'chk',
    'ciuvașă'                      => 'cv',
    'classicalnewari'                => 'nwc',
    'classicalsyriac'                => 'syc',
    'colognian'                      => 'ksh',
    'comoreză'                      => 'swb',
    'congoleză'                     => 'kg',
    'congoswahili'                   => 'swc',
    'coptă'                         => 'cop',
    'coreeană'                      => 'ko',
    'cornish'                        => 'kw',
    'corsicană'                     => 'co',
    'cree'                           => 'cr',
    'creek'                          => 'mus',
    'creoleorpidgin'                 => 'crp',
    'crimeanturkish'                 => 'crh',
    'croată'                        => 'hr',
    'cushiticlanguage'               => 'cus',
    'dakota'                         => 'dak',
    'daneză'                        => 'da',
    'dargwa'                         => 'dar',
    'dayak'                          => 'day',
    'delaware'                       => 'del',
    'dinka'                          => 'din',
    'divehi'                         => 'dv',
    'dogri'                          => 'doi',
    'dogrib'                         => 'dgr',
    'duala'                          => 'dua',
    'dyula'                          => 'dyu',
    'dzongkha'                       => 'dz',
    'ebraică'                       => 'he',
    'efik'                           => 'efi',
    'egipteanăveche'                => 'egy',
    'ekajuk'                         => 'eka',
    'elamită'                       => 'elx',
    'embu'                           => 'ebu',
    'engleză'                       => 'en',
    'englezăamericană'             => 'en_us',
    'englezăaustraliană'           => 'en_au',
    'englezăbritanică'             => 'en_gb',
    'englezăcanadiană'             => 'en_ca',
    'englezăveche'                  => 'ang',
    'englishbasedcreoleorpidgin'     => 'cpe',
    'erzya'                          => 'myv',
    'esperanto'                      => 'eo',
    'estoniană'                     => 'et',
    'ewe'                            => 'ee',
    'ewondo'                         => 'ewo',
    'fang'                           => 'fan',
    'fanti'                          => 'fat',
    'faroeză'                       => 'fo',
    'farăconținutlingvistic'       => 'zxx',
    'feniciană'                     => 'phn',
    'fijiană'                       => 'fj',
    'filipineză'                    => 'fil',
    'finlandeză'                    => 'fi',
    'flamandă'                      => 'nl_be',
    'fon'                            => 'fon',
    'franceză'                      => 'fr',
    'francezăcanadiană'            => 'fr_ca',
    'francezăelvețiană'           => 'fr_ch',
    'francezăveche'                 => 'fro',
    'frenchbasedcreoleorpidgin'      => 'cpf',
    'friulian'                       => 'fur',
    'frizonăoccidentală'           => 'fy',
    'frizonăorientală'             => 'frs',
    'fulah'                          => 'ff',
    'ga'                             => 'gaa',
    'gaelicăscoțiană'             => 'gd',
    'galiciană'                     => 'gl',
    'ganda'                          => 'lg',
    'gayo'                           => 'gay',
    'gbaya'                          => 'gba',
    'geez'                           => 'gez',
    'georgiană'                     => 'ka',
    'germană'                       => 'de',
    'germanăaustriacă'             => 'de_at',
    'germanăelvețiană'            => 'gsw',
    'germanăstandardelvețiană'    => 'de_ch',
    'gilbertese'                     => 'gil',
    'gondi'                          => 'gon',
    'gorontalo'                      => 'gor',
    'gotică'                        => 'got',
    'greacă'                        => 'el',
    'greacăveche'                   => 'grc',
    'grebo'                          => 'grb',
    'guarani'                        => 'gn',
    'gujarati'                       => 'gu',
    'gusii'                          => 'guz',
    "gwich\Ê\¼in"                  => 'gwi',
    'haida'                          => 'hai',
    'haitiană'                      => 'ht',
    'hausa'                          => 'ha',
    'hawaiană'                      => 'haw',
    'herero'                         => 'hz',
    'hiligaynon'                     => 'hil',
    'himachali'                      => 'him',
    'hindi'                          => 'hi',
    'hirimotu'                       => 'ho',
    'hitită'                        => 'hit',
    'hmong'                          => 'hmn',
    'hupa'                           => 'hup',
    'iban'                           => 'iba',
    'idiș'                          => 'yi',
    'ido'                            => 'io',
    'igbo'                           => 'ig',
    'ijo'                            => 'ijo',
    'iloko'                          => 'ilo',
    'inarisami'                      => 'smn',
    'indoneziană'                   => 'id',
    'ingush'                         => 'inh',
    'interlingua'                    => 'ia',
    'interlingue'                    => 'ie',
    'inuktitut'                      => 'iu',
    'inupiak'                        => 'ik',
    'irlandeză'                     => 'ga',
    'irlandezăveche'                => 'sga',
    'iroquoianlanguage'              => 'iro',
    'islandeză'                     => 'is',
    'italiană'                      => 'it',
    'iudeoarabă'                    => 'jrb',
    'iudeopersană'                  => 'jpr',
    'japoneză'                      => 'ja',
    'javaneză'                      => 'jv',
    'jju'                            => 'kaj',
    'jolafonyi'                      => 'dyo',
    'kabardian'                      => 'kbd',
    'kabuverdianu'                   => 'kea',
    'kabyle'                         => 'kab',
    'kachin'                         => 'kac',
    'kalaallisut'                    => 'kl',
    'kalenjin'                       => 'kln',
    'kamba'                          => 'kam',
    'kannada'                        => 'kn',
    'kanuri'                         => 'kr',
    'karachaybalkar'                 => 'krc',
    'karakalpak'                     => 'kaa',
    'karelian'                       => 'krl',
    'karen'                          => 'kar',
    'kashubian'                      => 'csb',
    'kawi'                           => 'kaw',
    'kazahă'                        => 'kk',
    'khasi'                          => 'kha',
    'khmeră'                        => 'km',
    'khoisanlanguage'                => 'khi',
    'khotanese'                      => 'kho',
    'kikuyu'                         => 'ki',
    'kimbundu'                       => 'kmb',
    'kinyarwanda'                    => 'rw',
    'kirundi'                        => 'rn',
    'klingoniană'                   => 'tlh',
    'komi'                           => 'kv',
    'konkani'                        => 'kok',
    'koro'                           => 'kfo',
    'kosraean'                       => 'kos',
    'koyraborosenni'                 => 'ses',
    'koyrachiini'                    => 'khq',
    'kpelle'                         => 'kpe',
    'kru'                            => 'kro',
    'kuanyama'                       => 'kj',
    'kumyk'                          => 'kum',
    'kurdă'                         => 'ku',
    'kurukh'                         => 'kru',
    'kutenai'                        => 'kut',
    'kwasio'                         => 'nmg',
    'kîrgîză'                     => 'ky',
    'ladino'                         => 'lad',
    'lahnda'                         => 'lah',
    'lamba'                          => 'lam',
    'langi'                          => 'lag',
    'laoțiană'                     => 'lo',
    'latină'                        => 'la',
    'letonă'                        => 'lv',
    'lezghian'                       => 'lez',
    'limbajmimicogestual'            => 'sgn',
    'limbidiverse'                   => 'mis',
    'limbimultiple'                  => 'mul',
    'limburgish'                     => 'li',
    'limbăafroasiatică'            => 'afa',
    'limbăaltaică'                 => 'tut',
    'limbăapașă'                  => 'apa',
    'limbăartificială'             => 'art',
    'limbăaustraliană'             => 'aus',
    'limbăbaltică'                 => 'bat',
    'limbăcaucaziană'              => 'cau',
    'limbăceltică'                 => 'cel',
    'limbăcentralamerindiană'      => 'cai',
    'limbădravidiană'              => 'dra',
    'limbăfilipineză'              => 'phi',
    'limbăfinougrică'              => 'fiu',
    'limbăgermanică'               => 'gem',
    'limbăindiană'                 => 'inc',
    'limbăindoeuropeană'           => 'ine',
    'limbăiraniană'                => 'ira',
    'limbămayașă'                 => 'myn',
    'limbămunda'                    => 'mun',
    'limbănecunoscutăsaunevalidă' => 'und',
    'limbănordamerindiană'         => 'nai',
    'limbănubiană'                 => 'nub',
    'limbăotomi'                    => 'oto',
    'limbăpapuașă'                => 'paa',
    'limbăromanică'                => 'roa',
    'limbăsemitică'                => 'sem',
    'limbăsinotibetană'            => 'sit',
    'limbăslavă'                   => 'sla',
    'limbăsudamerindiană'          => 'sai',
    'limbăthai'                     => 'tai',
    'lingala'                        => 'ln',
    'lituaniană'                    => 'lt',
    'lojban'                         => 'jbo',
    'lowersorbian'                   => 'dsb',
    'lowgerman'                      => 'nds',
    'lozi'                           => 'loz',
    'lubakatanga'                    => 'lu',
    'lubalulua'                      => 'lua',
    'luiseno'                        => 'lui',
    'lulesami'                       => 'smj',
    'lunda'                          => 'lun',
    'luo'                            => 'luo',
    'lushai'                         => 'lus',
    'luxemburgheză'                 => 'lb',
    'luyia'                          => 'luy',
    'macedoneană'                   => 'mk',
    'machame'                        => 'jmc',
    'madurese'                       => 'mad',
    'magahi'                         => 'mag',
    'maghiară'                      => 'hu',
    'maithili'                       => 'mai',
    'makasar'                        => 'mak',
    'makhuwameetto'                  => 'mgh',
    'makonde'                        => 'kde',
    'malay'                          => 'ms',
    'malayalam'                      => 'ml',
    'malgașă'                      => 'mg',
    'malteză'                       => 'mt',
    'manciuriană'                   => 'mnc',
    'mandar'                         => 'mdr',
    'mandingo'                       => 'man',
    'manipuri'                       => 'mni',
    'manobolanguage'                 => 'mno',
    'manx'                           => 'gv',
    'maori'                          => 'mi',
    'marathi'                        => 'mr',
    'mari'                           => 'chm',
    'marshallese'                    => 'mh',
    'marwari'                        => 'mwr',
    'masai'                          => 'mas',
    'mende'                          => 'men',
    'meru'                           => 'mer',
    'micmac'                         => 'mic',
    'middledutch'                    => 'dum',
    'middleenglish'                  => 'enm',
    'middlefrench'                   => 'frm',
    'middlehighgerman'               => 'gmh',
    'middleirish'                    => 'mga',
    'minangkabau'                    => 'min',
    'mirandeză'                     => 'mwl',
    'mohawk'                         => 'moh',
    'moksha'                         => 'mdf',
    'moldovenească'                 => 'mo',
    'mongo'                          => 'lol',
    'mongolă'                       => 'mn',
    'monkhmerlanguage'               => 'mkh',
    'morisyen'                       => 'mfe',
    'mossi'                          => 'mos',
    'mundang'                        => 'mua',
    'nahuatl'                        => 'nah',
    'nama'                           => 'naq',
    'napolitană'                    => 'nap',
    'nauru'                          => 'na',
    'navajo'                         => 'nv',
    'ndebeledenord'                  => 'nd',
    'ndonga'                         => 'ng',
    'nepaleză'                      => 'ne',
    'newari'                         => 'new',
    'nias'                           => 'nia',
    'nigerkordofanianlanguage'       => 'nic',
    'nilosaharanlanguage'            => 'ssa',
    'niuean'                         => 'niu',
    'nogai'                          => 'nog',
    'northernfrisian'                => 'frr',
    'norvegianabokmål'              => 'nb',
    'norvegiană'                    => 'no',
    'norvegianănynorsk'             => 'nn',
    'nuer'                           => 'nus',
    'nyamwezi'                       => 'nym',
    'nyanja'                         => 'ny',
    'nyankole'                       => 'nyn',
    'nyasatonga'                     => 'tog',
    'nyoro'                          => 'nyo',
    'nzima'                          => 'nzi',
    "n\â\\ko"                   => 'nqo',
    'occitană'                      => 'oc',
    'ojibwa'                         => 'oj',
    'olandeză'                      => 'nl',
    'oldhighgerman'                  => 'goh',
    'oldnorse'                       => 'non',
    'oriya'                          => 'or',
    'oromo'                          => 'om',
    'osage'                          => 'osa',
    'osetă'                         => 'os',
    'pahlavi'                        => 'pal',
    'palauan'                        => 'pau',
    'pali'                           => 'pi',
    'pampanga'                       => 'pam',
    'pangasinan'                     => 'pag',
    'papiamento'                     => 'pap',
    'persană'                       => 'fa',
    'persanăveche'                  => 'peo',
    'pohnpeian'                      => 'pon',
    'poloneză'                      => 'pl',
    'portugheză'                    => 'pt',
    'portughezăbraziliană'         => 'pt_br',
    'portughezăiberică'            => 'pt_pt',
    'portuguesebasedcreoleorpidgin'  => 'cpp',
    'prakritlanguage'                => 'pra',
    'provensalăveche'               => 'pro',
    'punjabi'                        => 'pa',
    'pushto'                         => 'ps',
    'quechua'                        => 'qu',
    'rajasthani'                     => 'raj',
    'rapanui'                        => 'rap',
    'rarotongan'                     => 'rar',
    'retoromană'                    => 'rm',
    'romany'                         => 'rom',
    'rombo'                          => 'rof',
    'română'                       => 'ro',
    'rusă'                          => 'ru',
    'rwa'                            => 'rwk',
    'saho'                           => 'ssy',
    'sakha'                          => 'sah',
    'salishanlanguage'               => 'sal',
    'samburu'                        => 'saq',
    'samidenord'                     => 'se',
    'samilanguage'                   => 'smi',
    'samoană'                       => 'sm',
    'sandawe'                        => 'sad',
    'sango'                          => 'sg',
    'sangu'                          => 'sbp',
    'sanscrită'                     => 'sa',
    'santali'                        => 'sat',
    'sardiniană'                    => 'sc',
    'sasak'                          => 'sas',
    'scots'                          => 'sco',
    'selkup'                         => 'sel',
    'sena'                           => 'seh',
    'seneca'                         => 'see',
    'serer'                          => 'srr',
    'sesotho'                        => 'st',
    'setswana'                       => 'tn',
    'shambala'                       => 'ksb',
    'shan'                           => 'shn',
    'shona'                          => 'sn',
    'sichuanyi'                      => 'ii',
    'siciliană'                     => 'scn',
    'sidamo'                         => 'sid',
    'siksika'                        => 'bla',
    'sindhi'                         => 'sd',
    'singaleză'                     => 'si',
    'siouanlanguage'                 => 'sio',
    'siriacă'                       => 'syr',
    'skoltsami'                      => 'sms',
    'slave'                          => 'den',
    'slavonă'                       => 'cu',
    'slovacă'                       => 'sk',
    'slovenă'                       => 'sl',
    'soga'                           => 'xog',
    'sogdien'                        => 'sog',
    'somaleză'                      => 'so',
    'songhai'                        => 'son',
    'soninke'                        => 'snk',
    'sorbianlanguage'                => 'wen',
    'sothodenord'                    => 'nso',
    'southernsami'                   => 'sma',
    'southndebele'                   => 'nr',
    'spaniolă'                      => 'es',
    'spaniolăiberică'              => 'es_es',
    'spaniolălatinoamericană'      => 'es_419',
    'sranantongo'                    => 'srn',
    'suedeză'                       => 'sv',
    'sukuma'                         => 'suk',
    'sumeriană'                     => 'sux',
    'sundaneză'                     => 'su',
    'susu'                           => 'sus',
    'swahili'                        => 'sw',
    'swati'                          => 'ss',
    'sârbocroată'                  => 'sh',
    'sârbă'                        => 'sr',
    'tachelhit'                      => 'shi',
    'tadjică'                       => 'tg',
    'tagalog'                        => 'tl',
    'tahitiană'                     => 'ty',
    'taita'                          => 'dav',
    'tamashek'                       => 'tmh',
    'tamilă'                        => 'ta',
    'taroko'                         => 'trv',
    'tasawaq'                        => 'twq',
    'telugu'                         => 'te',
    'tereno'                         => 'ter',
    'teso'                           => 'teo',
    'tetum'                          => 'tet',
    'thailandeză'                   => 'th',
    'tibetană'                      => 'bo',
    'tigre'                          => 'tig',
    'tigrinya'                       => 'ti',
    'timne'                          => 'tem',
    'tiv'                            => 'tiv',
    'tlingit'                        => 'tli',
    'tokelau'                        => 'tkl',
    'tokpisin'                       => 'tpi',
    'tonga'                          => 'to',
    'tsimshian'                      => 'tsi',
    'tsonga'                         => 'ts',
    'tumbuka'                        => 'tum',
    'tupilanguage'                   => 'tup',
    'turcă'                         => 'tr',
    'turcăotomană'                 => 'ota',
    'turkmenă'                      => 'tk',
    'tuvalu'                         => 'tvl',
    'tuvinian'                       => 'tyv',
    'twi'                            => 'tw',
    'tyap'                           => 'kcg',
    'tătară'                       => 'tt',
    'ucraineană'                    => 'uk',
    'udmurt'                         => 'udm',
    'ugaritic'                       => 'uga',
    'uigur'                          => 'ug',
    'umbundu'                        => 'umb',
    'uppersorbian'                   => 'hsb',
    'urdu'                           => 'ur',
    'uzbecă'                        => 'uz',
    'vai'                            => 'vai',
    'valonă'                        => 'wa',
    'velșă'                        => 'cy',
    'venda'                          => 've',
    'vietnameză'                    => 'vi',
    'volapuk'                        => 'vo',
    'votic'                          => 'vot',
    'vunjo'                          => 'vun',
    'wakashanlanguage'               => 'wak',
    'walamo'                         => 'wal',
    'walser'                         => 'wae',
    'waray'                          => 'war',
    'washo'                          => 'was',
    'wolof'                          => 'wo',
    'xhosa'                          => 'xh',
    'yangben'                        => 'yav',
    'yao'                            => 'yao',
    'yapese'                         => 'yap',
    'yoruba'                         => 'yo',
    'yupiklanguage'                  => 'ypk',
    'zande'                          => 'znd',
    'zapotecă'                      => 'zap',
    'zarma'                          => 'dje',
    'zaza'                           => 'zza',
    'zenaga'                         => 'zen',
    'zhuang'                         => 'za',
    'zulu'                           => 'zu',
    'zuni'                           => 'zun',
);

1;
