### -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Morph::TAGH.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: morphological analysis via Gfsm automata, for use with TAGH-style transducers
##  + currently just an alias for 'Morph'


##==============================================================================
## Package: Analyzer::Morph
##==============================================================================
package DTA::CAB::Analyzer::Morph::TAGH;
use DTA::CAB::Analyzer::Morph;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Morph);

1; ##-- nothing to see here, move along

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Morph - morphological analysis via Gfsm automata, for TAGH-style transducers

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::Morph::TAGH;
 
 $morph = DTA::CAB::Analyzer::Morph::TAGH->new(%args);
 $morph->analyze($tok);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::Morph::TAGH
is a subclass of
L<DTA::CAB::Analyzer::Morph|DTA::CAB::Analyzer::Morph>
suitable for use with TAGH-style transducers.
It is currently just an alias for
L<DTA::CAB::Analyzer::Morph|DTA::CAB::Analyzer::Morph>.

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2021 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
