/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.web;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HTMLParser
extends HTMLEditorKit.ParserCallback {
    protected StringBuffer textBuffer;
    protected String title = "";
    protected boolean isTitle = false;
    protected boolean isBody = false;
    protected boolean isScript = false;

    public void handleText(char[] data, int pos) {
        if (this.isTitle) {
            this.title = new String(data);
        } else if (this.isBody && !this.isScript) {
            this.textBuffer.append(data).append(" ");
        }
    }

    public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
        if (tag == HTML.Tag.TITLE) {
            this.isTitle = true;
        } else if (tag == HTML.Tag.BODY) {
            this.isBody = true;
        } else if (tag == HTML.Tag.SCRIPT) {
            this.isScript = true;
        }
    }

    public void handleEndTag(HTML.Tag tag, int pos) {
        if (tag == HTML.Tag.TITLE) {
            this.isTitle = false;
        } else if (tag == HTML.Tag.BODY) {
            this.isBody = false;
        } else if (tag == HTML.Tag.SCRIPT) {
            this.isScript = false;
        }
    }

    public String parse(URL url) throws IOException {
        return this.parse(IOUtils.slurpURL(url));
    }

    public String parse(Reader r) throws IOException {
        return this.parse(IOUtils.slurpReader(r));
    }

    public String parse(String text) throws IOException {
        text = StringUtils.searchAndReplace(text, "/>", ">");
        StringReader r = new StringReader(text);
        this.textBuffer = new StringBuffer(200);
        new ParserDelegator().parse(r, this, true);
        return this.textBuffer.toString();
    }

    public String title() {
        return this.title;
    }

    public static void main(String[] args) throws IOException {
        HTMLParser parser = new HTMLParser();
        String result = parser.parse(new URL(args[0]));
        System.out.println(result);
    }
}

