# Generated by default/object.tt
package Paws::ES::OutboundCrossClusterSearchConnectionStatus;
  use Moose;
  has Message => (is => 'ro', isa => 'Str');
  has StatusCode => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::OutboundCrossClusterSearchConnectionStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::OutboundCrossClusterSearchConnectionStatus object:

  $service_obj->Method(Att1 => { Message => $value, ..., StatusCode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::OutboundCrossClusterSearchConnectionStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->Message

=head1 DESCRIPTION

Specifies the connection status of an outbound cross-cluster search
connection.

=head1 ATTRIBUTES


=head2 Message => Str

Specifies verbose information for the outbound connection status.


=head2 StatusCode => Str

The state code for outbound connection. This can be one of the
following:

=over

=item * VALIDATING: The outbound connection request is being validated.

=item * VALIDATION_FAILED: Validation failed for the connection
request.

=item * PENDING_ACCEPTANCE: Outbound connection request is validated
and is not yet accepted by destination domain owner.

=item * PROVISIONING: Outbound connection request is in process.

=item * ACTIVE: Outbound connection is active and ready to use.

=item * REJECTED: Outbound connection request is rejected by
destination domain owner.

=item * DELETING: Outbound connection deletion is in progress.

=item * DELETED: Outbound connection is deleted and cannot be used
further.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

