# Generated by default/object.tt
package Paws::FMS::NetworkFirewallMissingSubnetViolation;
  use Moose;
  has AvailabilityZone => (is => 'ro', isa => 'Str');
  has TargetViolationReason => (is => 'ro', isa => 'Str');
  has ViolationTarget => (is => 'ro', isa => 'Str');
  has VPC => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::NetworkFirewallMissingSubnetViolation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::NetworkFirewallMissingSubnetViolation object:

  $service_obj->Method(Att1 => { AvailabilityZone => $value, ..., VPC => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::NetworkFirewallMissingSubnetViolation object:

  $result = $service_obj->Method(...);
  $result->Att1->AvailabilityZone

=head1 DESCRIPTION

Violation details for AWS Network Firewall for an Availability Zone
that's missing the expected Firewall Manager managed subnet.

=head1 ATTRIBUTES


=head2 AvailabilityZone => Str

The Availability Zone of a violating subnet.


=head2 TargetViolationReason => Str

The reason the resource has this violation, if one is available.


=head2 ViolationTarget => Str

The ID of the AWS Network Firewall or VPC resource that's in violation.


=head2 VPC => Str

The resource ID of the VPC associated with a violating subnet.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

