/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZeroOrMore<T extends Item>
implements GroundedValue {
    private List<T> content;

    public ZeroOrMore(T[] content) {
        this.content = Arrays.asList(content);
    }

    public ZeroOrMore(List<T> content) {
        this.content = content;
    }

    public ZeroOrMore(SequenceIterator iter) throws XPathException {
        Item item;
        this.content = new ArrayList<T>();
        while ((item = iter.next()) != null) {
            this.content.add(item);
        }
    }

    public T head() {
        return (T)(this.content.isEmpty() ? null : (Item)this.content.get(0));
    }

    @Override
    public UnfailingIterator iterate() {
        return new ListIterator(this.content);
    }

    @Override
    public Item itemAt(int n) {
        if (n >= 0 && n < this.content.size()) {
            return (Item)this.content.get(n);
        }
        return null;
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (start < 0) {
            start = 0;
        }
        if (start + length > this.content.size()) {
            length = this.content.size() - start;
        }
        return new ZeroOrMore<T>(this.content.subList(start, start + length));
    }

    @Override
    public int getLength() {
        return this.content.size();
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public GroundedValue reduce() {
        if (this.content.isEmpty()) {
            return EmptySequence.getInstance();
        }
        if (this.content.size() == 1) {
            Item first = (Item)this.content.get(0);
            if (first instanceof AtomicValue) {
                return (AtomicValue)first;
            }
            return new One<T>(this.head());
        }
        return this;
    }
}

