/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.extractor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;

public class XWPFWordExtractor
extends POIXMLTextExtractor {
    public static final XWPFRelation[] SUPPORTED_TYPES = new XWPFRelation[]{XWPFRelation.DOCUMENT, XWPFRelation.TEMPLATE, XWPFRelation.MACRO_DOCUMENT, XWPFRelation.MACRO_TEMPLATE_DOCUMENT};
    private XWPFDocument document;
    private boolean fetchHyperlinks = false;

    public XWPFWordExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XWPFDocument(container));
    }

    public XWPFWordExtractor(XWPFDocument document) {
        super(document);
        this.document = document;
    }

    public void setFetchHyperlinks(boolean fetch) {
        this.fetchHyperlinks = fetch;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  HXFWordExtractor <filename.docx>");
            System.exit(1);
        }
        XWPFWordExtractor extractor = new XWPFWordExtractor(POIXMLDocument.openPackage(args[0]));
        System.out.println(((POITextExtractor)extractor).getText());
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        XWPFHeaderFooterPolicy hfPolicy = this.document.getHeaderFooterPolicy();
        this.extractHeaders(text, hfPolicy);
        Iterator<XWPFParagraph> i = this.document.getParagraphsIterator();
        while (i.hasNext()) {
            XWPFParagraph paragraph = i.next();
            try {
                CTSectPr ctSectPr = null;
                if (paragraph.getCTP().getPPr() != null) {
                    ctSectPr = paragraph.getCTP().getPPr().getSectPr();
                }
                XWPFHeaderFooterPolicy headerFooterPolicy = null;
                if (ctSectPr != null) {
                    headerFooterPolicy = new XWPFHeaderFooterPolicy(this.document, ctSectPr);
                    this.extractHeaders(text, headerFooterPolicy);
                }
                for (XWPFRun run : paragraph.getRuns()) {
                    XWPFHyperlink link;
                    text.append(run.toString());
                    if (!(run instanceof XWPFHyperlinkRun) || !this.fetchHyperlinks || (link = ((XWPFHyperlinkRun)run).getHyperlink(this.document)) == null) continue;
                    text.append(" <" + link.getURL() + ">");
                }
                XWPFCommentsDecorator decorator = new XWPFCommentsDecorator(paragraph, null);
                text.append(decorator.getCommentText()).append('\n');
                String footnameText = paragraph.getFootnoteText();
                if (footnameText != null && footnameText.length() > 0) {
                    text.append(footnameText + "\n");
                }
                if (ctSectPr == null) continue;
                this.extractFooters(text, headerFooterPolicy);
            }
            catch (IOException e) {
                throw new POIXMLException(e);
            }
            catch (XmlException e) {
                throw new POIXMLException(e);
            }
        }
        Iterator<XWPFTable> j = this.document.getTablesIterator();
        while (j.hasNext()) {
            text.append(j.next().getText()).append('\n');
        }
        this.extractFooters(text, hfPolicy);
        return text.toString();
    }

    private void extractFooters(StringBuffer text, XWPFHeaderFooterPolicy hfPolicy) {
        if (hfPolicy.getFirstPageFooter() != null) {
            text.append(hfPolicy.getFirstPageFooter().getText());
        }
        if (hfPolicy.getEvenPageFooter() != null) {
            text.append(hfPolicy.getEvenPageFooter().getText());
        }
        if (hfPolicy.getDefaultFooter() != null) {
            text.append(hfPolicy.getDefaultFooter().getText());
        }
    }

    private void extractHeaders(StringBuffer text, XWPFHeaderFooterPolicy hfPolicy) {
        if (hfPolicy.getFirstPageHeader() != null) {
            text.append(hfPolicy.getFirstPageHeader().getText());
        }
        if (hfPolicy.getEvenPageHeader() != null) {
            text.append(hfPolicy.getEvenPageHeader().getText());
        }
        if (hfPolicy.getDefaultHeader() != null) {
            text.append(hfPolicy.getDefaultHeader().getText());
        }
    }
}

