#!/usr/bin/perl

package eBay::API::XML::DataType::CartType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CartType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CartType

=head1 DESCRIPTION

Details about an eBay Express shopping cart.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CartType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::CartItemArrayType;
use eBay::API::XML::DataType::CheckoutCompleteRedirectType;
use eBay::API::XML::DataType::CheckoutOrderDetailType;
use eBay::API::XML::DataType::Enum::OrderStatusCodeType;


my @gaProperties = ( [ 'CartID', 'xs:long', '', '', '' ]
	, [ 'CartItemArray', 'ns:CartItemArrayType', ''
	     ,'eBay::API::XML::DataType::CartItemArrayType', '1' ]
	, [ 'CartStatus', 'ns:OrderStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::OrderStatusCodeType', '' ]
	, [ 'CheckoutCompleteRedirect', 'ns:CheckoutCompleteRedirectType', ''
	     ,'eBay::API::XML::DataType::CheckoutCompleteRedirectType', '1' ]
	, [ 'CheckoutURL', 'xs:anyURI', '', '', '' ]
	, [ 'CreationTime', 'xs:dateTime', '', '', '' ]
	, [ 'ExpirationTime', 'xs:dateTime', '', '', '' ]
	, [ 'OrderDetail', 'ns:CheckoutOrderDetailType', ''
	     ,'eBay::API::XML::DataType::CheckoutOrderDetailType', '1' ]
	, [ 'ShippingAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCartID()

The ID of the shopping cart.

Default: 
#    Argument: 'xs:long'

=cut

sub setCartID {
  my $self = shift;
  $self->{'CartID'} = shift
}

=head2 getCartID()

  Calls: GetCart
         SetCart
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getCartID {
  my $self = shift;
  return $self->{'CartID'};
}


=head2 setCartItemArray()

Array of CartItem (details about items and what is to be done with each,
such as add, delete, update). This is only returned if there are items in the cart.

#    Argument: 'ns:CartItemArrayType'

=cut

sub setCartItemArray {
  my $self = shift;
  $self->{'CartItemArray'} = shift
}

=head2 getCartItemArray()

  Calls: GetCart
         SetCart
  Returned: Conditionally

#    Returns: 'ns:CartItemArrayType'

=cut

sub getCartItemArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CartItemArray'
		,'eBay::API::XML::DataType::CartItemArrayType');
}


=head2 setCartStatus()

Status of the eBay Express cart.

#    Argument: 'ns:OrderStatusCodeType'

=cut

sub setCartStatus {
  my $self = shift;
  $self->{'CartStatus'} = shift
}

=head2 getCartStatus()

  Calls: GetCart
         SetCart
  Returned: Always
  OnlyTheseValues: 
								Active, Authenticated, Cancelled, Completed, InProcess, Inactive
							

#    Returns: 'ns:OrderStatusCodeType'

=cut

sub getCartStatus {
  my $self = shift;
  return $self->{'CartStatus'};
}


=head2 setCheckoutCompleteRedirect()

When the user has completed eBay Express checkout with the shopping cart, the
user is shown a link to your website. The values of this element were established
via SetCart input.

#    Argument: 'ns:CheckoutCompleteRedirectType'

=cut

sub setCheckoutCompleteRedirect {
  my $self = shift;
  $self->{'CheckoutCompleteRedirect'} = shift
}

=head2 getCheckoutCompleteRedirect()

  Calls: GetCart
         SetCart
  Returned: Conditionally

#    Returns: 'ns:CheckoutCompleteRedirectType'

=cut

sub getCheckoutCompleteRedirect {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CheckoutCompleteRedirect'
		,'eBay::API::XML::DataType::CheckoutCompleteRedirectType');
}


=head2 setCheckoutURL()

The eBay-specified URL to which the third party site should direct the
user for checking out.

#    Argument: 'xs:anyURI'

=cut

sub setCheckoutURL {
  my $self = shift;
  $self->{'CheckoutURL'} = shift
}

=head2 getCheckoutURL()

  Calls: GetCart
         SetCart
  Returned: Always

#    Returns: 'xs:anyURI'

=cut

sub getCheckoutURL {
  my $self = shift;
  return $self->{'CheckoutURL'};
}


=head2 setCreationTime()

Cart creation date time.

#    Argument: 'xs:dateTime'

=cut

sub setCreationTime {
  my $self = shift;
  $self->{'CreationTime'} = shift
}

=head2 getCreationTime()

  Calls: GetCart
         SetCart
  Returned: Always

#    Returns: 'xs:dateTime'

=cut

sub getCreationTime {
  my $self = shift;
  return $self->{'CreationTime'};
}


=head2 setExpirationTime()

The time at which the cart will no longer exist in the eBay
Express domain. This is currently 7 days after the CreationTime but
may be changed by eBay in the future.

#    Argument: 'xs:dateTime'

=cut

sub setExpirationTime {
  my $self = shift;
  $self->{'ExpirationTime'} = shift
}

=head2 getExpirationTime()

  Calls: GetCart
         SetCart
  Returned: Always

#    Returns: 'xs:dateTime'

=cut

sub getExpirationTime {
  my $self = shift;
  return $self->{'ExpirationTime'};
}


=head2 setOrderDetail()

Details of the order for the checked out cart. This container and its children
are only returned if checkout was completed on eBay Express.

#    Argument: 'ns:CheckoutOrderDetailType'

=cut

sub setOrderDetail {
  my $self = shift;
  $self->{'OrderDetail'} = shift
}

=head2 getOrderDetail()

  Calls: GetCart
         SetCart
  Returned: Conditionally

#    Returns: 'ns:CheckoutOrderDetailType'

=cut

sub getOrderDetail {
  my $self = shift;
  return $self->_getDataTypeInstance( 'OrderDetail'
		,'eBay::API::XML::DataType::CheckoutOrderDetailType');
}


=head2 setShippingAddress()

The address to which the items in the cart are to be shipped. This is echoed from
the ShippingAddress provided on input, if provided.

#    Argument: 'ns:AddressType'

=cut

sub setShippingAddress {
  my $self = shift;
  $self->{'ShippingAddress'} = shift
}

=head2 getShippingAddress()

  Calls: GetCart
         SetCart
  Returned: Conditionally

#    Returns: 'ns:AddressType'

=cut

sub getShippingAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingAddress'
		,'eBay::API::XML::DataType::AddressType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
