library(tinytest)
library(hutilscpp)

x <- rep_len(letters, 1e6)
y <- integer(1e6)
expect_equal(and3s(x == 'a'), x == 'a')
expect_equal(or3s(x == 'a'), x == 'a')
expect_equal(and3s(y == 0L, x == 'a'), x == 'a')
expect_equal(or3s(y != 0L, x == 'a'), x == 'a')
expect_false(all(and3s(x == 'a')))
expect_false(all(or3s(x == 'a')))

expect_equal(and3s(x != 'a'), x != 'a')
expect_equal(or3s(x != 'a'), x != 'a')
expect_equal(and3s(y == 0L, x != 'a'), x != 'a')
expect_equal(or3s(y != 0L, x != 'a'), x != 'a')
expect_false(all(and3s(x != 'a')))
expect_false(all(or3s(x != 'a')))

a <- rep_len(c(LETTERS, "a"), 1e6)
expect_equal(and3s(x == a), x == a)
expect_equal(or3s(x == a), x == a)
expect_equal(and3s(y == 0L, x == a), x == a)
expect_equal(or3s(y != 0L, x == a), x == a)
expect_false(all(and3s(x == a)))
expect_false(all(or3s(x == a)))

expect_equal(and3s(x != a), x != a)
expect_equal(or3s(x != a), x != a)
expect_equal(and3s(y == 0L, x != a), x != a)
expect_equal(or3s(y != 0L, x != a), x != a)
expect_false(all(and3s(x != a)))
expect_false(all(or3s(x != a)))
