/*
 * Decompiled with CFR 0.152.
 */
package mrmc.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.Matrix;
import mrmc.gui.RowHeaderRenderer;
import org.jfree.ui.RefineryUtilities;
import roemetz.core.RoeMetz;

public class StatPanel {
    private JFrame JFrameApp;
    private InputFile InputFile1;
    private DBRecord DBRecordStat;
    public JPanel JPanelStat = new JPanel();
    private JLabel StatJLabelH0 = new JLabel("1", 2);
    private JLabel StatJLabelAUC = new JLabel("1", 2);
    private JLabel StatJLabelDFNormal = new JLabel("123456789012345678901234567890", 4);
    private JLabel StatJLabelDFBDG = new JLabel("123456789012345678901234567890", 4);
    private JLabel StatJLabelDFHillis = new JLabel("123456789012345678901234567890", 4);
    private JLabel StatJLabelPValNormal = new JLabel("12345678901234567890", 2);
    private JLabel StatJLabelPValBDG = new JLabel("12345678901234567890", 2);
    private JLabel StatJLabelPValHillis = new JLabel("12345678901234567890", 2);
    private JLabel StatJLabelCINormal = new JLabel("123456789012345678901234567890", 2);
    private JLabel StatJLabelCIBDG = new JLabel("123456789012345678901234567890", 2);
    private JLabel StatJLabelCIHillis = new JLabel("123456789012345678901234567890", 2);
    private JLabel StatJLabelRejectNormal = new JLabel("12345678901234567890", 2);
    private JLabel StatJLabelRejectBDG = new JLabel("12345678901234567890", 2);
    private JLabel StatJLabelRejectHillis = new JLabel("12345678901234567890", 2);
    private JLabel StatJLabelTotalVar = new JLabel();
    private JTable BDGtable1;
    private JTable BCKtable1;
    private JTable DBMtable1;
    private JTable ORtable1;
    private JTable MStable1;
    JTabbedPane tabbedPane1;
    private JLabel BDGvar1;
    private JLabel BCKvar1;
    private JLabel DBMvar1;
    private JLabel ORvar1;
    private JLabel MSvar1;
    DecimalFormat twoDec = new DecimalFormat("0.00");
    DecimalFormat threeDec = new DecimalFormat("0.000");
    DecimalFormat fourDec = new DecimalFormat("0.0000");
    DecimalFormat twoDecE = new DecimalFormat("0.00E0");
    DecimalFormat threeDecE = new DecimalFormat("0.000E0");
    DecimalFormat fourDecE = new DecimalFormat("0.0000E0");

    public StatPanel(JFrame JFrameAppTemp, DBRecord DBRecordStatTemp) {
        this.DBRecordStat = DBRecordStatTemp;
        this.JFrameApp = JFrameAppTemp;
        this.InputFile1 = this.DBRecordStat.InputFile1;
        this.JPanelStat.setLayout(new BoxLayout(this.JPanelStat, 1));
        this.StatJLabelDFNormal.setPreferredSize(this.StatJLabelDFNormal.getPreferredSize());
        this.StatJLabelPValNormal.setPreferredSize(this.StatJLabelPValNormal.getPreferredSize());
        this.StatJLabelCINormal.setPreferredSize(this.StatJLabelCINormal.getPreferredSize());
        this.StatJLabelRejectNormal.setPreferredSize(this.StatJLabelRejectNormal.getPreferredSize());
        this.StatJLabelDFBDG.setPreferredSize(this.StatJLabelDFBDG.getPreferredSize());
        this.StatJLabelPValBDG.setPreferredSize(this.StatJLabelPValBDG.getPreferredSize());
        this.StatJLabelCIBDG.setPreferredSize(this.StatJLabelCIBDG.getPreferredSize());
        this.StatJLabelRejectBDG.setPreferredSize(this.StatJLabelRejectBDG.getPreferredSize());
        this.StatJLabelDFHillis.setPreferredSize(this.StatJLabelDFHillis.getPreferredSize());
        this.StatJLabelPValHillis.setPreferredSize(this.StatJLabelPValHillis.getPreferredSize());
        this.StatJLabelCIHillis.setPreferredSize(this.StatJLabelCIHillis.getPreferredSize());
        this.StatJLabelRejectHillis.setPreferredSize(this.StatJLabelRejectHillis.getPreferredSize());
        int width = 0;
        Dimension d = this.StatJLabelDFHillis.getPreferredSize();
        width += d.width;
        d = this.StatJLabelPValHillis.getPreferredSize();
        width += d.width;
        d = this.StatJLabelCIHillis.getPreferredSize();
        width += d.width;
        d = this.StatJLabelRejectHillis.getPreferredSize();
        this.StatJLabelH0.setPreferredSize(new Dimension(width += d.width, d.height));
        this.StatJLabelAUC.setPreferredSize(new Dimension(width, d.height));
        JPanel StatPanelRow1 = new JPanel();
        StatPanelRow1.add(this.StatJLabelH0);
        JPanel StatPanelRow2 = new JPanel();
        StatPanelRow2.add(this.StatJLabelAUC);
        JPanel StatPanelRow3 = new JPanel();
        StatPanelRow3.add(this.StatJLabelDFNormal);
        StatPanelRow3.add(this.StatJLabelPValNormal);
        StatPanelRow3.add(this.StatJLabelCINormal);
        StatPanelRow3.add(this.StatJLabelRejectNormal);
        JPanel StatPanelRow4 = new JPanel();
        StatPanelRow4.add(this.StatJLabelDFBDG);
        StatPanelRow4.add(this.StatJLabelPValBDG);
        StatPanelRow4.add(this.StatJLabelCIBDG);
        StatPanelRow4.add(this.StatJLabelRejectBDG);
        JButton statHillis = new JButton("Hillis Approx");
        JPanel StatPanelRow5 = new JPanel();
        statHillis.addActionListener(new StatHillisButtonListener());
        StatPanelRow5.add(statHillis);
        String[] rowNamesDiff = new String[]{"comp MA", "coeff MA", "comp MB", "coeff MB", "comp product", "- coeff product", "total"};
        String[] rowNamesSingle = new String[]{"components", "coeff", "total"};
        JButton showCompButton = new JButton("Show Variance Component");
        showCompButton.addActionListener(new showVarComponent());
        JPanel panelBDG1 = this.makeBDGTab(rowNamesDiff);
        JPanel panelBCK1 = this.makeBCKTab(rowNamesDiff);
        JPanel panelDBM1 = this.makeDBMTab(rowNamesSingle);
        JPanel panelOR1 = this.makeORTab(rowNamesSingle);
        JPanel panelMS1 = this.makeMSTab(rowNamesSingle);
        this.tabbedPane1 = new JTabbedPane();
        this.tabbedPane1.addTab("BDG", panelBDG1);
        this.tabbedPane1.addTab("BCK", panelBCK1);
        this.tabbedPane1.addTab("DBM", panelDBM1);
        this.tabbedPane1.addTab("OR", panelOR1);
        this.tabbedPane1.addTab("MS", panelMS1);
        StatPanelRow5.add(showCompButton);
        this.JPanelStat.add(StatPanelRow1);
        this.JPanelStat.add(StatPanelRow2);
        this.JPanelStat.add(StatPanelRow3);
        this.JPanelStat.add(StatPanelRow4);
        this.JPanelStat.add(StatPanelRow5);
    }

    void resetStatPanel() {
        this.resetTable1();
        this.StatJLabelH0.setText("Statistical Analysis:");
        this.StatJLabelAUC.setText("AUC = ");
        this.DBRecordStat.totalVar = -1.0;
        this.StatJLabelDFNormal.setText("Large Sample Approx(Normal):");
        this.StatJLabelDFBDG.setText("         T-test with df(BDG) =     :");
        this.StatJLabelDFHillis.setText("T-test with df(Hillis 2008) = ");
        this.StatJLabelPValNormal.setText("p-Value = ");
        this.StatJLabelPValBDG.setText("p-Value = ");
        this.StatJLabelPValHillis.setText("p-Value = ");
        this.StatJLabelCINormal.setText("Conf. Int. = ");
        this.StatJLabelCIBDG.setText("Conf. Int. = ");
        this.StatJLabelCIHillis.setText("Conf. Int. = ");
        this.StatJLabelRejectNormal.setText("Reject Null? = ");
        this.StatJLabelRejectBDG.setText("Reject Null? = ");
        this.StatJLabelRejectHillis.setText("Reject Null? = ");
    }

    public void setStatPanel() {
        if (!this.DBRecordStat.flagFullyCrossed) {
            if (this.DBRecordStat.verbose && !RoeMetz.doValidation) {
                JOptionPane.showMessageDialog(this.JFrameApp, "The study is not fully crossed", "Warning", 2);
            }
            this.tabbedPane1.setEnabledAt(2, false);
            this.tabbedPane1.setEnabledAt(3, false);
            this.tabbedPane1.setEnabledAt(4, false);
        } else {
            this.tabbedPane1.setEnabledAt(2, true);
            this.tabbedPane1.setEnabledAt(3, true);
            this.tabbedPane1.setEnabledAt(4, true);
        }
        switch (this.DBRecordStat.selectedMod) {
            case 0: {
                this.StatJLabelH0.setText("H0: AUC = 0.50,   two-sided alternative,   95% significance,   " + this.DBRecordStat.getSizes());
                this.StatJLabelAUC.setText(String.valueOf(this.DBRecordStat.getAUCsReaderAvgString(this.DBRecordStat.selectedMod)) + ",   S.E(total) = " + this.threeDecE.format(this.DBRecordStat.SE) + ",   test statistic = " + this.threeDecE.format((this.DBRecordStat.AUCsReaderAvg[0] - 0.5) / this.DBRecordStat.SE));
                break;
            }
            case 1: {
                this.StatJLabelH0.setText("H0: AUC = 0.50,   two-sided alternative,   95% significance,   " + this.DBRecordStat.getSizes());
                this.StatJLabelAUC.setText(String.valueOf(this.DBRecordStat.getAUCsReaderAvgString(this.DBRecordStat.selectedMod)) + ",   S.E(total) = " + this.threeDecE.format(this.DBRecordStat.SE) + ",   test statistic = " + this.threeDecE.format((this.DBRecordStat.AUCsReaderAvg[1] - 0.5) / this.DBRecordStat.SE));
                break;
            }
            case 3: {
                this.StatJLabelH0.setText("H0: AUC_A - AUC_B = 0.00,   two-sided alternative,   95% significance,   " + this.DBRecordStat.getSizes());
                this.StatJLabelAUC.setText(String.valueOf(this.DBRecordStat.getAUCsReaderAvgString(this.DBRecordStat.selectedMod)) + ",   S.E(total) = " + this.threeDecE.format(this.DBRecordStat.SE) + ",   test statistic = " + this.threeDecE.format((this.DBRecordStat.AUCsReaderAvg[0] - this.DBRecordStat.AUCsReaderAvg[1]) / this.DBRecordStat.SE));
            }
        }
        this.StatJLabelDFNormal.setText("        Large Sample Approx(Normal):");
        String output = this.fourDec.format(this.DBRecordStat.testStat.pValNormal);
        this.StatJLabelPValNormal.setText("p-Value = " + output);
        output = this.fourDec.format(this.DBRecordStat.testStat.ciBotNormal);
        String output2 = this.fourDec.format(this.DBRecordStat.testStat.ciTopNormal);
        this.StatJLabelCINormal.setText("Conf. Int. = (" + output + ", " + output2 + ")");
        output = this.twoDec.format(this.DBRecordStat.testStat.rejectNormal);
        if (this.DBRecordStat.testStat.rejectNormal == 1.0) {
            this.StatJLabelRejectNormal.setText("Reject Null? = Yes(" + output + ")");
        } else {
            this.StatJLabelRejectNormal.setText("Reject Null? = No(" + output + ")");
        }
        output = this.twoDec.format(this.DBRecordStat.testStat.DF_BDG);
        this.StatJLabelDFBDG.setText("        T-test with df(BDG) = " + output + ": ");
        output = this.fourDec.format(this.DBRecordStat.testStat.pValBDG);
        this.StatJLabelPValBDG.setText("p-Value = " + output);
        output = this.fourDec.format(this.DBRecordStat.testStat.ciBotBDG);
        output2 = this.fourDec.format(this.DBRecordStat.testStat.ciTopBDG);
        this.StatJLabelCIBDG.setText("Conf. Int. = (" + output + ", " + output2 + ")");
        output = this.twoDec.format(this.DBRecordStat.testStat.rejectBDG);
        if (this.DBRecordStat.testStat.rejectBDG == 1.0) {
            this.StatJLabelRejectBDG.setText("Reject Null? = Yes(" + output + ")");
        } else {
            this.StatJLabelRejectBDG.setText("Reject Null? = No(" + output + ")");
        }
        if (this.DBRecordStat.flagFullyCrossed) {
            output = this.twoDec.format(this.DBRecordStat.testStat.DF_Hillis);
            this.StatJLabelDFHillis.setText("T-test with df(Hillis 2008) = " + output + ": ");
            output = this.fourDec.format(this.DBRecordStat.testStat.pValHillis);
            this.StatJLabelPValHillis.setText("p-Value = " + output);
            output = this.fourDec.format(this.DBRecordStat.testStat.ciBotHillis);
            output2 = this.fourDec.format(this.DBRecordStat.testStat.ciTopHillis);
            this.StatJLabelCIHillis.setText("Conf. Int. = (" + output + ", " + output2 + ")");
            output = this.twoDec.format(this.DBRecordStat.testStat.rejectHillis);
            if (this.DBRecordStat.testStat.rejectHillis == 1.0) {
                this.StatJLabelRejectHillis.setText("Reject Null? = Yes(" + output + ")");
            } else {
                this.StatJLabelRejectHillis.setText("Reject Null? = No(" + output + ")");
            }
        } else {
            this.StatJLabelDFHillis.setText("");
            this.StatJLabelPValHillis.setText("");
            this.StatJLabelCIHillis.setText("");
            this.StatJLabelRejectHillis.setText("");
        }
    }

    void resetTable1() {
        int j;
        this.BDGvar1.setText("total var=");
        this.BCKvar1.setText("total var=");
        this.DBMvar1.setText("total var=");
        this.ORvar1.setText("total var=");
        this.MSvar1.setText("total var=");
        this.StatJLabelTotalVar.setText("total var=");
        int i = 0;
        while (i < this.BDGtable1.getRowCount()) {
            j = 0;
            while (j < 8) {
                this.BDGtable1.setValueAt(0, i, j);
                this.BDGtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                ++j;
            }
            j = 0;
            while (j < 7) {
                this.BCKtable1.setValueAt(0, i, j);
                this.BCKtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.MStable1.getRowCount()) {
            j = 0;
            while (j < 6) {
                this.MStable1.setValueAt(0, i, j);
                this.MStable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                ++j;
            }
            j = 0;
            while (j < 6) {
                this.DBMtable1.setValueAt(0, i, j);
                this.ORtable1.setValueAt(0, i, j);
                this.DBMtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                this.ORtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                ++j;
            }
            ++i;
        }
        this.tabbedPane1.setTitleAt(0, "BDG");
        this.tabbedPane1.setTitleAt(1, "BCK");
        this.tabbedPane1.setTitleAt(2, "DBM");
        this.tabbedPane1.setTitleAt(3, "OR");
        this.tabbedPane1.setTitleAt(4, "MS");
    }

    public void setTable1() {
        int j;
        double[][] BDGdata1 = DBRecord.getBDGTab(this.DBRecordStat.selectedMod, this.DBRecordStat.BDG, this.DBRecordStat.BDGcoeff);
        double[][] BCKdata1 = DBRecord.getBCKTab(this.DBRecordStat.selectedMod, this.DBRecordStat.BCK, this.DBRecordStat.BCKcoeff);
        double[][] DBMdata1 = DBRecord.getDBMTab(this.DBRecordStat.selectedMod, this.DBRecordStat.DBM, this.DBRecordStat.DBMcoeff);
        double[][] ORdata1 = DBRecord.getORTab(this.DBRecordStat.selectedMod, this.DBRecordStat.OR, this.DBRecordStat.ORcoeff);
        double[][] MSdata1 = DBRecord.getMSTab(this.DBRecordStat.selectedMod, this.DBRecordStat.MS, this.DBRecordStat.MScoeff);
        if (this.DBRecordStat.flagMLE == 1) {
            BDGdata1 = DBRecord.getBDGTab(this.DBRecordStat.selectedMod, this.DBRecordStat.BDGbias, this.DBRecordStat.BDGcoeff);
            BCKdata1 = DBRecord.getBCKTab(this.DBRecordStat.selectedMod, this.DBRecordStat.BCKbias, this.DBRecordStat.BCKcoeff);
            DBMdata1 = DBRecord.getDBMTab(this.DBRecordStat.selectedMod, this.DBRecordStat.DBMbias, this.DBRecordStat.DBMcoeff);
            ORdata1 = DBRecord.getORTab(this.DBRecordStat.selectedMod, this.DBRecordStat.ORbias, this.DBRecordStat.ORcoeff);
            MSdata1 = DBRecord.getMSTab(this.DBRecordStat.selectedMod, this.DBRecordStat.MSbias, this.DBRecordStat.MScoeff);
        }
        double BDGv = Matrix.total(BDGdata1[6]);
        double BCKv = Matrix.total(BCKdata1[6]);
        double DBMv = Matrix.total(DBMdata1[2]);
        double ORv = Matrix.total(ORdata1[2]);
        double MSv = Matrix.total(MSdata1[2]);
        double[][][] allTableData = new double[][][]{BDGdata1, BCKdata1, DBMdata1, ORdata1, MSdata1};
        int i = 0;
        while (i < 7) {
            j = 0;
            while (j < 8) {
                this.BDGtable1.setValueAt(allTableData[0][i][j], i, j);
                this.BDGtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                ++j;
            }
            j = 0;
            while (j < 7) {
                this.BCKtable1.setValueAt(allTableData[1][i][j], i, j);
                this.BCKtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 6) {
                this.DBMtable1.setValueAt(allTableData[2][i][j], i, j);
                this.ORtable1.setValueAt(allTableData[3][i][j], i, j);
                this.MStable1.setValueAt(allTableData[4][i][j], i, j);
                this.DBMtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                this.ORtable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                this.MStable1.getColumnModel().getColumn(j).setCellRenderer(new DecimalFormatRenderer());
                ++j;
            }
            ++i;
        }
        String output = this.threeDecE.format(BDGv);
        this.BDGvar1.setText("total var=" + output);
        output = this.threeDecE.format(BCKv);
        this.BCKvar1.setText("total var=" + output);
        output = this.threeDecE.format(DBMv);
        this.DBMvar1.setText("total var=" + output);
        output = this.threeDecE.format(ORv);
        this.ORvar1.setText("total var=" + output);
        output = this.threeDecE.format(MSv);
        this.MSvar1.setText("total var=" + output);
        if (this.DBRecordStat.flagMLE == 1) {
            this.tabbedPane1.setTitleAt(0, "BDG**");
            this.tabbedPane1.setTitleAt(1, "BCK**");
            this.tabbedPane1.setTitleAt(2, "DBM**");
            this.tabbedPane1.setTitleAt(3, "OR**");
            this.tabbedPane1.setTitleAt(4, "MS**");
        } else {
            this.tabbedPane1.setTitleAt(0, "BDG");
            this.tabbedPane1.setTitleAt(1, "BCK");
            this.tabbedPane1.setTitleAt(2, "DBM");
            this.tabbedPane1.setTitleAt(3, "OR");
            this.tabbedPane1.setTitleAt(4, "MS");
        }
    }

    public String getStatResults() {
        String results = this.StatJLabelH0.getText();
        results = String.valueOf(results) + "\n";
        results = String.valueOf(results) + "\t" + this.StatJLabelAUC.getText();
        results = String.valueOf(results) + "\n";
        results = String.valueOf(results) + "\t" + this.StatJLabelDFNormal.getText();
        results = String.valueOf(results) + "\t" + this.StatJLabelPValNormal.getText();
        results = String.valueOf(results) + "\t" + this.StatJLabelCINormal.getText();
        results = String.valueOf(results) + "\n";
        results = String.valueOf(results) + "\t" + this.StatJLabelDFBDG.getText();
        results = String.valueOf(results) + "\t" + this.StatJLabelPValBDG.getText();
        results = String.valueOf(results) + "\t" + this.StatJLabelCIBDG.getText();
        results = String.valueOf(results) + "\n";
        if (this.DBRecordStat.flagFullyCrossed) {
            results = String.valueOf(results) + "\t" + this.StatJLabelDFHillis.getText();
            results = String.valueOf(results) + "\t" + this.StatJLabelPValHillis.getText();
            results = String.valueOf(results) + "\t" + this.StatJLabelCIHillis.getText();
        } else {
            results = String.valueOf(results) + "The Hillis degrees of freedom are not calculated when the data is not fully crossed.";
        }
        return results;
    }

    public JScrollPane genTable(JTable table, String[] colNames, String[] rowNames) {
        table.setAutoResizeMode(0);
        int i = 0;
        while (i < colNames.length) {
            table.getColumnModel().getColumn(i).setHeaderValue(colNames[i]);
            ++i;
        }
        JList<String> rowHeader = new JList<String>(rowNames);
        rowHeader.setFixedCellWidth(80);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        JScrollPane scroll = new JScrollPane(table);
        scroll.setRowHeaderView(rowHeader);
        return scroll;
    }

    private JPanel makeBDGTab(String[] rowNames) {
        JPanel panelBDG = new JPanel();
        DefaultTableModel dm = new DefaultTableModel(7, 8);
        String[] BDGnames = new String[]{"M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8"};
        this.BDGtable1 = new JTable(dm);
        JScrollPane BDGscroll = this.genTable(this.BDGtable1, BDGnames, rowNames);
        int height = this.BDGtable1.getRowHeight();
        panelBDG.add(BDGscroll);
        this.BDGtable1.setPreferredScrollableViewportSize(new Dimension(650, height * 8));
        this.BDGtable1.setFillsViewportHeight(true);
        this.BDGvar1 = new JLabel("sqrt(Var)=0.00");
        panelBDG.add(this.BDGvar1);
        return panelBDG;
    }

    private JPanel makeBCKTab(String[] rowNames) {
        JPanel panelBCK = new JPanel();
        DefaultTableModel dm = new DefaultTableModel(7, 7);
        String[] BCKnames = new String[]{"N", "D", "N~D", "R", "N~R", "D~R", "R~N~D"};
        this.BCKtable1 = new JTable(dm);
        JScrollPane BCKscroll = this.genTable(this.BCKtable1, BCKnames, rowNames);
        panelBCK.add(BCKscroll);
        int height = this.BCKtable1.getRowHeight();
        this.BCKtable1.setPreferredScrollableViewportSize(new Dimension(575, height * 8));
        this.BCKtable1.setFillsViewportHeight(true);
        this.BCKvar1 = new JLabel("sqrt(Var)=0.00");
        panelBCK.add(this.BCKvar1);
        return panelBCK;
    }

    private JPanel makeDBMTab(String[] rowNames) {
        JPanel panelDBM = new JPanel();
        DefaultTableModel dm = new DefaultTableModel(3, 6);
        String[] DBMnames = new String[]{"R", "C", "R~C", "T~R", "T~C", "T~R~C"};
        this.DBMtable1 = new JTable(dm);
        JScrollPane DBMscroll = this.genTable(this.DBMtable1, DBMnames, rowNames);
        panelDBM.add(DBMscroll);
        int height = this.DBMtable1.getRowHeight();
        this.DBMtable1.setPreferredScrollableViewportSize(new Dimension(500, height * 4));
        this.DBMtable1.setFillsViewportHeight(true);
        this.DBMvar1 = new JLabel("sqrt(Var)=0.00");
        panelDBM.add(this.DBMvar1);
        return panelDBM;
    }

    private JPanel makeORTab(String[] rowNames) {
        JPanel panelOR = new JPanel();
        DefaultTableModel dm = new DefaultTableModel(3, 6);
        String[] ORnames = new String[]{"R", "TR", "COV1", "COV2", "COV3", "ERROR"};
        this.ORtable1 = new JTable(dm);
        JScrollPane ORscroll = this.genTable(this.ORtable1, ORnames, rowNames);
        panelOR.add(ORscroll);
        int height = this.ORtable1.getRowHeight();
        this.ORtable1.setPreferredScrollableViewportSize(new Dimension(500, height * 4));
        this.ORtable1.setFillsViewportHeight(true);
        this.ORvar1 = new JLabel("sqrt(Var)=0.00");
        panelOR.add(this.ORvar1);
        return panelOR;
    }

    private JPanel makeMSTab(String[] rowNames) {
        JPanel panelMS = new JPanel();
        DefaultTableModel dm = new DefaultTableModel(3, 6);
        String[] MSnames = new String[]{"R", "C", "RC", "MR", "MC", "MRC"};
        this.MStable1 = new JTable(dm);
        JScrollPane MSscroll = this.genTable(this.MStable1, MSnames, rowNames);
        panelMS.add(MSscroll);
        int height = this.MStable1.getRowHeight();
        this.MStable1.setPreferredScrollableViewportSize(new Dimension(500, height * 4));
        this.MStable1.setFillsViewportHeight(true);
        this.MSvar1 = new JLabel("sqrt(Var)=0.00");
        panelMS.add(this.MSvar1);
        return panelMS;
    }

    public void enableTabs() {
        this.tabbedPane1.setEnabledAt(0, true);
        this.tabbedPane1.setEnabledAt(1, true);
        this.tabbedPane1.setEnabledAt(2, true);
        this.tabbedPane1.setEnabledAt(3, true);
        this.tabbedPane1.setEnabledAt(4, true);
    }

    public void enableBCKTab() {
        this.tabbedPane1.setEnabledAt(1, true);
        this.tabbedPane1.setEnabledAt(2, true);
        this.tabbedPane1.setEnabledAt(3, true);
        this.tabbedPane1.setSelectedIndex(1);
    }

    public void enableDBMORTabs() {
        this.tabbedPane1.setEnabledAt(2, true);
        this.tabbedPane1.setEnabledAt(3, true);
        this.tabbedPane1.setSelectedIndex(2);
    }

    public void disableTabs() {
        this.tabbedPane1.setEnabledAt(0, false);
        this.tabbedPane1.setEnabledAt(1, false);
        this.tabbedPane1.setEnabledAt(2, false);
        this.tabbedPane1.setEnabledAt(3, false);
        this.tabbedPane1.setEnabledAt(4, false);
    }

    public void setMCresults(DBRecord avgDBRecordStat, DBRecord varDBRecordStat) {
        double mcAvgAUC_A = avgDBRecordStat.AUCsReaderAvg[0];
        double mcAvgAUC_B = avgDBRecordStat.AUCsReaderAvg[1];
        double mcAvgAUC_AminusB = avgDBRecordStat.AUCsReaderAvg[2];
        double mcVarAUC_A = varDBRecordStat.AUCsReaderAvg[0];
        double mcVarAUC_B = varDBRecordStat.AUCsReaderAvg[1];
        double mcVarAUC_AminusB = varDBRecordStat.AUCsReaderAvg[2];
        double sqrtMCvarAUC_A = Math.sqrt(mcVarAUC_A);
        double sqrtMCvarAUC_B = Math.sqrt(mcVarAUC_B);
        double sqrtMCvarAUC_AminusB = Math.sqrt(mcVarAUC_AminusB);
        System.out.println("      mcAvgvarAUC_A = " + avgDBRecordStat.varA + ",         mcAvgvarAUC_B = " + avgDBRecordStat.varB);
        System.out.println("      mcVarvarAUC_A = " + varDBRecordStat.varA + ",         mcVarvarAUC_B = " + varDBRecordStat.varB + ",         mcVartotalvar = " + varDBRecordStat.totalVar);
        System.out.println("      mcAvgAUC_A = " + mcAvgAUC_A + ",         mcVarAUC_A = " + mcVarAUC_A + ",         mcStdAUC_A = " + Math.sqrt(mcVarAUC_A));
        System.out.println("      mcAvgAUC_B = " + mcAvgAUC_B + ",         mcVarAUC1 = " + mcVarAUC_B + ",         mcStdAUC1 = " + Math.sqrt(mcVarAUC_B));
        System.out.println("mcAvgAUC_AminusB = " + mcAvgAUC_AminusB + ",   mcVarAUC_Aminus1 = " + mcVarAUC_AminusB + ",   mcStdAUC_Aminus1 = " + Math.sqrt(mcVarAUC_AminusB));
        JLabel JLabelVarAUC_A = new JLabel("12345678901234567890123456789012345", 4);
        JLabel JLabelVarAUC_B = new JLabel("12345678901234567890123456789012345", 4);
        JLabel JLabelVarAUC_AminusB = new JLabel("12345678901234567890123456789012345", 4);
        JLabel JLabelSqrtVarAUC_A = new JLabel("12345678901234567890123456789012345", 4);
        JLabel JLabelSqrtVarAUC_B = new JLabel("12345678901234567890123456789012345", 4);
        JLabel JLabelSqrtVarAUC_AminusB = new JLabel("12345678901234567890123456789012345", 4);
        JLabelVarAUC_A.setPreferredSize(JLabelVarAUC_A.getPreferredSize());
        JLabelVarAUC_B.setPreferredSize(JLabelVarAUC_B.getPreferredSize());
        JLabelVarAUC_AminusB.setPreferredSize(JLabelVarAUC_AminusB.getPreferredSize());
        JLabelSqrtVarAUC_A.setPreferredSize(JLabelSqrtVarAUC_A.getPreferredSize());
        JLabelSqrtVarAUC_B.setPreferredSize(JLabelSqrtVarAUC_B.getPreferredSize());
        JLabelSqrtVarAUC_AminusB.setPreferredSize(JLabelSqrtVarAUC_AminusB.getPreferredSize());
        JLabelSqrtVarAUC_A.setText("sqrtMCvarAUC_A = " + this.fourDecE.format(sqrtMCvarAUC_A) + ",");
        JLabelVarAUC_A.setText("mcVarAUC_A = " + this.fourDecE.format(mcVarAUC_A));
        JLabelSqrtVarAUC_B.setText("sqrtMCvarAUC_B = " + this.fourDecE.format(sqrtMCvarAUC_B) + ",");
        JLabelVarAUC_B.setText("mcVarAUC_B = " + this.fourDecE.format(mcVarAUC_B));
        JLabelSqrtVarAUC_AminusB.setText("sqrtMCvarAUC_AminusB = " + this.fourDecE.format(sqrtMCvarAUC_AminusB) + ",");
        JLabelVarAUC_AminusB.setText("mcVarAUC_AminusB = " + this.fourDecE.format(mcVarAUC_AminusB));
        JPanel StatPanelBot1 = new JPanel();
        StatPanelBot1.add(JLabelVarAUC_A);
        StatPanelBot1.add(JLabelSqrtVarAUC_A);
        JPanel StatPanelBot2 = new JPanel();
        StatPanelBot2.add(JLabelVarAUC_B);
        StatPanelBot2.add(JLabelSqrtVarAUC_B);
        JPanel StatPanelBot3 = new JPanel();
        StatPanelBot3.add(JLabelVarAUC_AminusB);
        StatPanelBot3.add(JLabelSqrtVarAUC_AminusB);
        this.JPanelStat.add(StatPanelBot1);
        this.JPanelStat.add(StatPanelBot2);
        this.JPanelStat.add(StatPanelBot3);
    }

    class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        DecimalFormatRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DecimalFormat formatter = new DecimalFormat("0.00000E0");
            try {
                value = formatter.format((Number)value);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    public class StatHillisButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String hillisValues = ((StatPanel)StatPanel.this).DBRecordStat.flagFullyCrossed ? String.valueOf(StatPanel.this.StatJLabelDFHillis.getText()) + "\n" + StatPanel.this.StatJLabelPValHillis.getText() + "\n" + StatPanel.this.StatJLabelCIHillis.getText() + "\n" + StatPanel.this.StatJLabelRejectHillis.getText() : "The Hillis degrees of freedom are not calculated when the data is not fully crossed.";
            JOptionPane.showMessageDialog(StatPanel.this.JFrameApp, hillisValues, "Hillis Approximation", -1);
        }
    }

    class showVarComponent
    implements ActionListener {
        showVarComponent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame JFrameAUC = new JFrame("Variance Component");
            RefineryUtilities.centerFrameOnScreen(JFrameAUC);
            JFrameAUC.setDefaultCloseOperation(2);
            JFrameAUC.add((Component)StatPanel.this.tabbedPane1, "Center");
            JFrameAUC.setSize(900, 250);
            JFrameAUC.setVisible(true);
        }
    }
}

