/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.DigitalNet;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public abstract class DigitalSequence
extends DigitalNet {
    public abstract void extendSequence(int var1);

    private int[][] copyDigitalShift(int[][] S) {
        if (S == null) {
            return null;
        }
        int[][] T = new int[S.length][S[0].length];
        for (int i = 0; i < S.length; ++i) {
            for (int j = 0; j < S[0].length; ++j) {
                T[i][j] = S[i][j];
            }
        }
        return T;
    }

    private DigitalNet initNetVar(boolean shiftFlag) {
        DigitalNet net = new DigitalNet();
        net.dim = shiftFlag ? this.dim + 1 : this.dim;
        net.numPoints = this.numPoints;
        net.numCols = this.numCols;
        net.numRows = this.numRows;
        net.outDigits = this.outDigits;
        net.normFactor = this.normFactor;
        net.b = this.b;
        net.factor = new double[this.outDigits];
        for (int i = 0; i < this.outDigits; ++i) {
            net.factor[i] = this.factor[i];
        }
        net.genMat = new int[net.dim * this.numCols][this.numRows];
        net.shiftStream = this.shiftStream;
        net.capacityShift = this.capacityShift;
        net.dimShift = this.dimShift;
        net.digitalShift = this.copyDigitalShift(this.digitalShift);
        if (shiftFlag && this.shiftStream != null) {
            net.addRandomShift(this.dimShift, this.dimShift + 1, this.shiftStream);
        }
        return net;
    }

    public DigitalNet toNet() {
        DigitalNet net = this.initNetVar(false);
        int N = this.dim * this.numCols;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                net.genMat[i][j] = this.genMat[i][j];
            }
        }
        return net;
    }

    public DigitalNet toNetShiftCj() {
        int l;
        int c;
        DigitalNet net = this.initNetVar(true);
        for (int j = this.dim; j >= 1; --j) {
            int start = j * this.numCols;
            for (c = 0; c < this.numCols; ++c) {
                for (l = 0; l < this.numRows; ++l) {
                    net.genMat[start + c][l] = this.genMat[start - this.numCols + c][l];
                }
            }
        }
        for (c = 0; c < this.numCols; ++c) {
            for (l = 0; l < this.numRows; ++l) {
                net.genMat[c][l] = 0;
            }
            net.genMat[c][this.numCols - c - 1] = 1;
        }
        return net;
    }

    public PointSetIterator iteratorShift() {
        return new DigitalNetIteratorShiftGenerators();
    }

    public PointSetIterator iteratorShiftNoGray() {
        return new DigitalNetIteratorShiftNoGray();
    }

    protected class DigitalNetIteratorShiftNoGray
    extends DigitalNet.DigitalNetIterator {
        public DigitalNetIteratorShiftNoGray() {
            this.dimS = DigitalSequence.this.dim + 1;
            if (DigitalSequence.this.digitalShift != null && DigitalSequence.this.dimShift < this.dimS) {
                DigitalSequence.this.addRandomShift(DigitalSequence.this.dimShift, this.dimS, DigitalSequence.this.shiftStream);
            }
            this.init2();
        }

        public void init() {
        }

        public void init2() {
            this.resetCurPointIndex();
        }

        public void setCurPointIndex(int i) {
            int c;
            int sum;
            int l;
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.idigits = DigitalSequence.this.intToDigitsGray(DigitalSequence.this.b, i, DigitalSequence.this.numCols, this.bdigit, this.gdigit);
            for (int j = 1; j <= DigitalSequence.this.dim; ++j) {
                for (l = 0; l < DigitalSequence.this.outDigits; ++l) {
                    sum = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[j][l];
                    if (l < DigitalSequence.this.numRows) {
                        for (c = 0; c < this.idigits; ++c) {
                            sum += DigitalSequence.this.genMat[(j - 1) * DigitalSequence.this.numCols + c][l] * this.bdigit[c];
                            sum %= DigitalSequence.this.b;
                        }
                    }
                    this.cachedCurPoint[j * DigitalSequence.this.outDigits + l] = sum;
                }
            }
            for (l = 0; l < DigitalSequence.this.outDigits; ++l) {
                sum = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[0][l];
                if (l < DigitalSequence.this.numRows) {
                    for (c = 0; c < this.idigits; ++c) {
                        if (l != DigitalSequence.this.numCols - c - 1) continue;
                        sum += this.bdigit[c];
                    }
                }
                this.cachedCurPoint[l] = sum % DigitalSequence.this.b;
            }
        }

        public int resetToNextPoint() {
            int c;
            int l;
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalSequence.this.numPoints) {
                return this.curPointIndex;
            }
            int pos = 0;
            while (this.bdigit[pos] == DigitalSequence.this.b - 1) {
                this.bdigit[pos] = 0;
                ++pos;
            }
            int n = pos;
            this.bdigit[n] = this.bdigit[n] + 1;
            int lsup = DigitalSequence.this.numRows;
            if (DigitalSequence.this.outDigits < DigitalSequence.this.numRows) {
                lsup = DigitalSequence.this.outDigits;
            }
            for (int j = 1; j <= DigitalSequence.this.dim; ++j) {
                for (l = 0; l < lsup; ++l) {
                    for (c = 0; c <= pos; ++c) {
                        int n2 = j * DigitalSequence.this.outDigits + l;
                        this.cachedCurPoint[n2] = this.cachedCurPoint[n2] + DigitalSequence.this.genMat[(j - 1) * DigitalSequence.this.numCols + c][l];
                    }
                    int n3 = j * DigitalSequence.this.outDigits + l;
                    this.cachedCurPoint[n3] = this.cachedCurPoint[n3] % DigitalSequence.this.b;
                }
            }
            for (l = 0; l < lsup; ++l) {
                for (c = 0; c <= pos; ++c) {
                    if (l != DigitalSequence.this.numCols - c - 1) continue;
                    int n4 = l;
                    this.cachedCurPoint[n4] = this.cachedCurPoint[n4] + 1;
                    int n5 = l;
                    this.cachedCurPoint[n5] = this.cachedCurPoint[n5] % DigitalSequence.this.b;
                }
            }
            return this.curPointIndex;
        }
    }

    protected class DigitalNetIteratorShiftGenerators
    extends DigitalNet.DigitalNetIterator {
        public DigitalNetIteratorShiftGenerators() {
            this.dimS = DigitalSequence.this.dim + 1;
            if (DigitalSequence.this.digitalShift != null && DigitalSequence.this.dimShift < this.dimS) {
                DigitalSequence.this.addRandomShift(DigitalSequence.this.dimShift, this.dimS, DigitalSequence.this.shiftStream);
            }
            this.init2();
        }

        public void init() {
        }

        public void init2() {
            this.resetCurPointIndex();
        }

        public void setCurPointIndex(int i) {
            int c;
            int sum;
            int l;
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.idigits = DigitalSequence.this.intToDigitsGray(DigitalSequence.this.b, i, DigitalSequence.this.numCols, this.bdigit, this.gdigit);
            for (int j = 1; j <= DigitalSequence.this.dim; ++j) {
                for (l = 0; l < DigitalSequence.this.outDigits; ++l) {
                    sum = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[j][l];
                    if (l < DigitalSequence.this.numRows) {
                        for (c = 0; c < this.idigits; ++c) {
                            sum += DigitalSequence.this.genMat[(j - 1) * DigitalSequence.this.numCols + c][l] * this.gdigit[c];
                        }
                    }
                    this.cachedCurPoint[j * DigitalSequence.this.outDigits + l] = sum % DigitalSequence.this.b;
                }
            }
            for (l = 0; l < DigitalSequence.this.outDigits; ++l) {
                sum = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[0][l];
                if (l < DigitalSequence.this.numRows) {
                    for (c = 0; c < this.idigits; ++c) {
                        if (l != DigitalSequence.this.numCols - c - 1) continue;
                        sum += this.gdigit[c];
                    }
                }
                this.cachedCurPoint[l] = sum % DigitalSequence.this.b;
            }
        }

        public int resetToNextPoint() {
            int l;
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalSequence.this.numPoints) {
                return this.curPointIndex;
            }
            int pos = 0;
            while (this.gdigit[pos] == DigitalSequence.this.b - 1) {
                this.gdigit[pos] = 0;
                ++pos;
            }
            int n = pos;
            this.gdigit[n] = this.gdigit[n] + 1;
            int lsup = DigitalSequence.this.numRows;
            if (DigitalSequence.this.outDigits < DigitalSequence.this.numRows) {
                lsup = DigitalSequence.this.outDigits;
            }
            for (int j = 1; j <= DigitalSequence.this.dim; ++j) {
                for (l = 0; l < lsup; ++l) {
                    int n2 = j * DigitalSequence.this.outDigits + l;
                    this.cachedCurPoint[n2] = this.cachedCurPoint[n2] + DigitalSequence.this.genMat[(j - 1) * DigitalSequence.this.numCols + pos][l];
                    int n3 = j * DigitalSequence.this.outDigits + l;
                    this.cachedCurPoint[n3] = this.cachedCurPoint[n3] % DigitalSequence.this.b;
                }
            }
            l = DigitalSequence.this.numCols - pos - 1;
            if (l < lsup) {
                int n4 = l;
                this.cachedCurPoint[n4] = this.cachedCurPoint[n4] + 1;
                int n5 = l;
                this.cachedCurPoint[n5] = this.cachedCurPoint[n5] % DigitalSequence.this.b;
            }
            return this.curPointIndex;
        }
    }
}

