/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalDComplexMatrix2D(double[][] dArray, int n) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, n);
        this.assign(dArray);
    }

    public DiagonalDComplexMatrix2D(int n, int n2, int n3) {
        int n4;
        int n5;
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (n3 < -n + 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = n3;
        this.dlength = n3 == 0 ? Math.min(n, n2) : (n3 > 0 ? (n >= n2 ? n2 - n3 : (n3 <= (n5 = n2 - n) ? n : n - (n3 - n5))) : (n >= n2 ? (-n3 <= (n4 = n - n2) ? n2 : n2 + n3 + n4) : n + n3));
        this.elements = new double[2 * this.dlength];
    }

    public DComplexMatrix2D assign(DComplexDComplexFunction dComplexDComplexFunction) {
        if (dComplexDComplexFunction instanceof DComplexMult) {
            double[] dArray = ((DComplexMult)dComplexDComplexFunction).multiplicator;
            if (dArray[0] == 1.0 && dArray[1] == 0.0) {
                return this;
            }
            if (dArray[0] == 0.0 && dArray[1] == 0.0) {
                return this.assign(dArray);
            }
            if (dArray[0] != dArray[0] || dArray[1] != dArray[1]) {
                return this.assign(dArray);
            }
            double[] dArray2 = new double[2];
            for (int i = 0; i < this.dlength; ++i) {
                dArray2[0] = this.elements[2 * i];
                dArray2[1] = this.elements[2 * i + 1];
                dArray2 = DComplex.mult(dArray2, dArray);
                this.elements[2 * i] = dArray2[0];
                this.elements[2 * i + 1] = dArray2[1];
            }
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.dlength; ++i) {
                dArray[0] = this.elements[2 * i];
                dArray[1] = this.elements[2 * i + 1];
                dArray = dComplexDComplexFunction.apply(dArray);
                this.elements[2 * i] = dArray[0];
                this.elements[2 * i + 1] = dArray[1];
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(double d, double d2) {
        for (int i = 0; i < this.dlength; ++i) {
            this.elements[2 * i] = d;
            this.elements[2 * i + 1] = d2;
        }
        return this;
    }

    public DComplexMatrix2D assign(final double[] dArray) {
        if (dArray.length != 2 * this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + " 2*dlength=" + 2 * this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.dlength);
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalDComplexMatrix2D.this.elements[2 * i] = dArray[2 * i];
                            DiagonalDComplexMatrix2D.this.elements[2 * i + 1] = dArray[2 * i + 1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                this.elements[2 * i] = dArray[2 * i];
                this.elements[2 * i + 1] = dArray[2 * i + 1];
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != 2 * this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " 2*dlength=" + 2 * this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.dlength);
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalDComplexMatrix2D.this.elements[2 * i] = fArray[2 * i];
                            DiagonalDComplexMatrix2D.this.elements[2 * i + 1] = fArray[2 * i + 1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                this.elements[2 * i] = fArray[2 * i];
                this.elements[2 * i + 1] = fArray[2 * i + 1];
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(double[][] dArray) {
        int n;
        int n2;
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            n2 = 0;
            n = this.dindex;
        } else {
            n2 = -this.dindex;
            n = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (dArray[i].length != 2 * this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray[n2].length + "2 * columns()=" + 2 * this.columns());
            }
            this.elements[2 * i] = dArray[n2][2 * n];
            this.elements[2 * i + 1] = dArray[n2][2 * n + 1];
            ++n;
            ++n2;
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(dComplexMatrix2D);
        if (dComplexMatrix2D instanceof DiagonalDComplexMatrix2D) {
            DiagonalDComplexMatrix2D diagonalDComplexMatrix2D = (DiagonalDComplexMatrix2D)dComplexMatrix2D;
            if (this.dindex != diagonalDComplexMatrix2D.dindex || this.dlength != diagonalDComplexMatrix2D.dlength) {
                throw new IllegalArgumentException("source is DiagonalDComplexMatrix2D with different diagonal stored.");
            }
            System.arraycopy(diagonalDComplexMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(dComplexMatrix2D);
    }

    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        this.checkShape(dComplexMatrix2D);
        if (dComplexMatrix2D instanceof DiagonalDComplexMatrix2D) {
            double[] dArray;
            DiagonalDComplexMatrix2D diagonalDComplexMatrix2D = (DiagonalDComplexMatrix2D)dComplexMatrix2D;
            if (this.dindex != diagonalDComplexMatrix2D.dindex || this.dlength != diagonalDComplexMatrix2D.dlength) {
                throw new IllegalArgumentException("y is DiagonalDComplexMatrix2D with different diagonal stored.");
            }
            if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultSecond && (dArray = ((DComplexPlusMultSecond)dComplexDComplexDComplexFunction).multiplicator)[0] == 0.0 && dArray[1] == 0.0) {
                return this;
            }
            dArray = diagonalDComplexMatrix2D.elements;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.dlength);
                Future[] futureArray = new Future[n];
                int n2 = this.dlength / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultSecond) {
                                double[] dArray6 = ((DComplexPlusMultSecond)dComplexDComplexDComplexFunction).multiplicator;
                                if (dArray6[0] == 1.0 && dArray6[1] == 0.0) {
                                    for (int i = n3; i < n4; ++i) {
                                        int n = 2 * i;
                                        DiagonalDComplexMatrix2D.this.elements[n] = DiagonalDComplexMatrix2D.this.elements[n] + dArray[2 * i];
                                        int n2 = 2 * i + 1;
                                        DiagonalDComplexMatrix2D.this.elements[n2] = DiagonalDComplexMatrix2D.this.elements[n2] + dArray[2 * i + 1];
                                    }
                                } else {
                                    double[] dArray2 = new double[2];
                                    for (int i = n3; i < n4; ++i) {
                                        dArray2[0] = dArray[2 * i];
                                        dArray2[1] = dArray[2 * i + 1];
                                        dArray2 = DComplex.mult(dArray6, dArray2);
                                        int n = 2 * i;
                                        DiagonalDComplexMatrix2D.this.elements[n] = DiagonalDComplexMatrix2D.this.elements[n] + dArray2[0];
                                        int n32 = 2 * i + 1;
                                        DiagonalDComplexMatrix2D.this.elements[n32] = DiagonalDComplexMatrix2D.this.elements[n32] + dArray2[1];
                                    }
                                }
                            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                                double[] dArray7 = new double[2];
                                double[] dArray3 = new double[2];
                                for (int i = n3; i < n4; ++i) {
                                    dArray3[0] = dArray[2 * i];
                                    dArray3[1] = dArray[2 * i + 1];
                                    dArray7[0] = DiagonalDComplexMatrix2D.this.elements[2 * i];
                                    dArray7[1] = DiagonalDComplexMatrix2D.this.elements[2 * i + 1];
                                    dArray7 = DComplex.mult(dArray7, dArray3);
                                    DiagonalDComplexMatrix2D.this.elements[2 * i] = dArray7[0];
                                    DiagonalDComplexMatrix2D.this.elements[2 * i + 1] = dArray7[1];
                                }
                            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.div) {
                                double[] dArray8 = new double[2];
                                double[] dArray4 = new double[2];
                                for (int i = n3; i < n4; ++i) {
                                    dArray4[0] = dArray[2 * i];
                                    dArray4[1] = dArray[2 * i + 1];
                                    dArray8[0] = DiagonalDComplexMatrix2D.this.elements[2 * i];
                                    dArray8[1] = DiagonalDComplexMatrix2D.this.elements[2 * i + 1];
                                    dArray8 = DComplex.div(dArray8, dArray4);
                                    DiagonalDComplexMatrix2D.this.elements[2 * i] = dArray8[0];
                                    DiagonalDComplexMatrix2D.this.elements[2 * i + 1] = dArray8[1];
                                }
                            } else {
                                double[] dArray9 = new double[2];
                                double[] dArray5 = new double[2];
                                for (int i = n3; i < n4; ++i) {
                                    dArray5[0] = dArray[2 * i];
                                    dArray5[1] = dArray[2 * i + 1];
                                    dArray9[0] = DiagonalDComplexMatrix2D.this.elements[2 * i];
                                    dArray9[1] = DiagonalDComplexMatrix2D.this.elements[2 * i + 1];
                                    dArray9 = dComplexDComplexDComplexFunction.apply(dArray9, dArray5);
                                    DiagonalDComplexMatrix2D.this.elements[2 * i] = dArray9[0];
                                    DiagonalDComplexMatrix2D.this.elements[2 * i + 1] = dArray9[1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultSecond) {
                double[] dArray2 = ((DComplexPlusMultSecond)dComplexDComplexDComplexFunction).multiplicator;
                if (dArray2[0] == 1.0 && dArray2[1] == 0.0) {
                    for (int i = 0; i < this.dlength; ++i) {
                        int n5 = 2 * i;
                        this.elements[n5] = this.elements[n5] + dArray[2 * i];
                        int n6 = 2 * i + 1;
                        this.elements[n6] = this.elements[n6] + dArray[2 * i + 1];
                    }
                } else {
                    double[] dArray3 = new double[2];
                    for (int i = 0; i < this.dlength; ++i) {
                        dArray3[0] = dArray[2 * i];
                        dArray3[1] = dArray[2 * i + 1];
                        dArray3 = DComplex.mult(dArray2, dArray3);
                        int n7 = 2 * i;
                        this.elements[n7] = this.elements[n7] + dArray3[0];
                        int n8 = 2 * i + 1;
                        this.elements[n8] = this.elements[n8] + dArray3[1];
                    }
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                double[] dArray4 = new double[2];
                double[] dArray5 = new double[2];
                for (int i = 0; i < this.dlength; ++i) {
                    dArray5[0] = dArray[2 * i];
                    dArray5[1] = dArray[2 * i + 1];
                    dArray4[0] = this.elements[2 * i];
                    dArray4[1] = this.elements[2 * i + 1];
                    dArray4 = DComplex.mult(dArray4, dArray5);
                    this.elements[2 * i] = dArray4[0];
                    this.elements[2 * i + 1] = dArray4[1];
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.div) {
                double[] dArray6 = new double[2];
                double[] dArray7 = new double[2];
                for (int i = 0; i < this.dlength; ++i) {
                    dArray7[0] = dArray[2 * i];
                    dArray7[1] = dArray[2 * i + 1];
                    dArray6[0] = this.elements[2 * i];
                    dArray6[1] = this.elements[2 * i + 1];
                    dArray6 = DComplex.div(dArray6, dArray7);
                    this.elements[2 * i] = dArray6[0];
                    this.elements[2 * i + 1] = dArray6[1];
                }
            } else {
                double[] dArray8 = new double[2];
                double[] dArray9 = new double[2];
                for (int i = 0; i < this.dlength; ++i) {
                    dArray9[0] = dArray[2 * i];
                    dArray9[1] = dArray[2 * i + 1];
                    dArray8[0] = this.elements[2 * i];
                    dArray8[1] = this.elements[2 * i + 1];
                    dArray8 = dComplexDComplexDComplexFunction.apply(dArray8, dArray9);
                    this.elements[2 * i] = dArray8[0];
                    this.elements[2 * i + 1] = dArray8[1];
                }
            }
            return this;
        }
        return super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.dlength);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.dlength / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.dlength : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DiagonalDComplexMatrix2D.this.elements[2 * i] == 0.0 && DiagonalDComplexMatrix2D.this.elements[2 * i + 1] == 0.0) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[2 * i] == 0.0 && this.elements[2 * i + 1] == 0.0) continue;
                ++n;
            }
        }
        return n;
    }

    public double[] elements() {
        return this.elements;
    }

    public boolean equals(double[] dArray) {
        double d = DComplexProperty.DEFAULT.tolerance();
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        for (int i = 0; i < this.dlength; ++i) {
            dArray2[0] = this.elements[2 * i];
            dArray2[1] = this.elements[2 * i + 1];
            dArray3[0] = Math.abs(dArray[0] - dArray2[0]);
            dArray3[1] = Math.abs(dArray[1] - dArray2[1]);
            if (!((dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray, dArray2, d))) {
                dArray3[0] = 0.0;
                dArray3[1] = 0.0;
            }
            if (!(dArray3[0] > d) && !(dArray3[1] > d)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DiagonalDComplexMatrix2D) {
            DiagonalDComplexMatrix2D diagonalDComplexMatrix2D = (DiagonalDComplexMatrix2D)object;
            double d = DComplexProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            int n = this.rows();
            int n2 = this.columns();
            if (n2 != diagonalDComplexMatrix2D.columns() || n != diagonalDComplexMatrix2D.rows()) {
                return false;
            }
            if (this.dindex != diagonalDComplexMatrix2D.dindex || this.dlength != diagonalDComplexMatrix2D.dlength) {
                return false;
            }
            double[] dArray = diagonalDComplexMatrix2D.elements;
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[2];
            for (int i = 0; i < this.dlength; ++i) {
                dArray2[0] = this.elements[2 * i];
                dArray2[1] = this.elements[2 * i + 1];
                dArray3[0] = dArray[2 * i];
                dArray3[1] = dArray[2 * i + 1];
                dArray4[0] = Math.abs(dArray3[0] - dArray2[0]);
                dArray4[1] = Math.abs(dArray3[1] - dArray2[1]);
                if (!((dArray4[0] == dArray4[0] && dArray4[1] == dArray4[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray3, dArray2, d))) {
                    dArray4[0] = 0.0;
                    dArray4[1] = 0.0;
                }
                if (!(dArray4[0] > d) && !(dArray4[1] > d)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public DComplexMatrix2D forEachNonZero(IntIntDComplexFunction intIntDComplexFunction) {
        double[] dArray = new double[2];
        for (int i = 0; i < this.dlength; ++i) {
            dArray[0] = this.elements[2 * i];
            dArray[1] = this.elements[2 * i + 1];
            if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
            dArray = intIntDComplexFunction.apply(i, i, dArray);
            this.elements[2 * i] = dArray[0];
            this.elements[2 * i + 1] = dArray[1];
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    public double[] getQuick(int n, int n2) {
        if (this.dindex >= 0) {
            if (n2 < this.dindex) {
                return new double[2];
            }
            if (n < this.dlength && n + this.dindex == n2) {
                return new double[]{this.elements[2 * n], this.elements[2 * n + 1]};
            }
            return new double[2];
        }
        if (n < -this.dindex) {
            return new double[2];
        }
        if (n2 < this.dlength && n + this.dindex == n2) {
            return new double[]{this.elements[2 * n2], this.elements[2 * n2 + 1]};
        }
        return new double[2];
    }

    public DComplexMatrix2D like(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    public DComplexMatrix1D like1D(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    public void setQuick(int n, int n2, double[] dArray) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[2 * n] = dArray[0];
                this.elements[2 * n + 1] = dArray[1];
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[2 * n2] = dArray[0];
            this.elements[2 * n2 + 1] = dArray[1];
        }
    }

    public void setQuick(int n, int n2, double d, double d2) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[2 * n] = d;
                this.elements[2 * n + 1] = d2;
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[2 * n2] = d;
            this.elements[2 * n2 + 1] = d2;
        }
    }

    public DComplexMatrix1D zMult(DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2, double[] dArray, double[] dArray2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = dComplexMatrix1D2 == null;
        if (dComplexMatrix1D2 == null) {
            dComplexMatrix1D2 = new DenseDComplexMatrix1D(n);
        }
        if (!(this.isNoView && dComplexMatrix1D instanceof DenseDComplexMatrix1D && dComplexMatrix1D2 instanceof DenseDComplexMatrix1D)) {
            return super.zMult(dComplexMatrix1D, dComplexMatrix1D2, dArray, dArray2, bl);
        }
        if ((long)n2 != dComplexMatrix1D.size() || (long)n > dComplexMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + dComplexMatrix1D.toStringShort() + ", " + dComplexMatrix1D2.toStringShort());
        }
        if (!(bl2 || dArray2[0] == 1.0 && dArray2[1] == 0.0)) {
            dComplexMatrix1D2.assign(DComplexFunctions.mult(dArray2));
        }
        DenseDComplexMatrix1D denseDComplexMatrix1D = (DenseDComplexMatrix1D)dComplexMatrix1D2;
        double[] dArray3 = denseDComplexMatrix1D.elements;
        int n3 = denseDComplexMatrix1D.stride();
        int n4 = (int)dComplexMatrix1D2.index(0);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = (DenseDComplexMatrix1D)dComplexMatrix1D;
        double[] dArray4 = denseDComplexMatrix1D2.elements;
        int n5 = denseDComplexMatrix1D2.stride();
        int n6 = (int)dComplexMatrix1D.index(0);
        if (dArray4 == null || dArray3 == null) {
            throw new InternalError();
        }
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        if (!bl) {
            if (this.dindex >= 0) {
                for (int i = 0; i < this.dlength; ++i) {
                    dArray5[0] = this.elements[2 * i];
                    dArray5[1] = this.elements[2 * i + 1];
                    dArray6[0] = dArray4[2 * this.dindex + n6 + n5 * i];
                    dArray6[1] = dArray4[2 * this.dindex + n6 + n5 * i + 1];
                    dArray5 = DComplex.mult(dArray5, dArray6);
                    dArray5 = DComplex.mult(dArray, dArray5);
                    int n7 = n4 + n3 * i;
                    dArray3[n7] = dArray3[n7] + dArray5[0];
                    int n8 = n4 + n3 * i + 1;
                    dArray3[n8] = dArray3[n8] + dArray5[1];
                }
            } else {
                for (int i = 0; i < this.dlength; ++i) {
                    dArray5[0] = this.elements[2 * i];
                    dArray5[1] = this.elements[2 * i + 1];
                    dArray6[0] = dArray4[n6 + n5 * i];
                    dArray6[1] = dArray4[n6 + n5 * i + 1];
                    dArray5 = DComplex.mult(dArray5, dArray6);
                    dArray5 = DComplex.mult(dArray, dArray5);
                    int n9 = -2 * this.dindex + n4 + n3 * i;
                    dArray3[n9] = dArray3[n9] + dArray5[0];
                    int n10 = -2 * this.dindex + n4 + n3 * i + 1;
                    dArray3[n10] = dArray3[n10] + dArray5[1];
                }
            }
        } else if (this.dindex >= 0) {
            for (int i = 0; i < this.dlength; ++i) {
                dArray5[0] = this.elements[2 * i];
                dArray5[1] = -this.elements[2 * i + 1];
                dArray6[0] = dArray4[n6 + n5 * i];
                dArray6[1] = dArray4[n6 + n5 * i + 1];
                dArray5 = DComplex.mult(dArray5, dArray6);
                dArray5 = DComplex.mult(dArray, dArray5);
                int n11 = 2 * this.dindex + n4 + n3 * i;
                dArray3[n11] = dArray3[n11] + dArray5[0];
                int n12 = 2 * this.dindex + n4 + n3 * i + 1;
                dArray3[n12] = dArray3[n12] + dArray5[1];
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                dArray5[0] = this.elements[2 * i];
                dArray5[1] = -this.elements[2 * i + 1];
                dArray6[0] = dArray4[-2 * this.dindex + n6 + n5 * i];
                dArray6[1] = dArray4[-2 * this.dindex + n6 + n5 * i + 1];
                dArray5 = DComplex.mult(dArray5, dArray6);
                dArray5 = DComplex.mult(dArray, dArray5);
                int n13 = n4 + n3 * i;
                dArray3[n13] = dArray3[n13] + dArray5[0];
                int n14 = n4 + n3 * i + 1;
                dArray3[n14] = dArray3[n14] + dArray5[1];
            }
        }
        return dComplexMatrix1D2;
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }
}

