/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search;

import org.jamesframework.core.problems.Problem;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.NeighbourhoodSearch;
import org.jamesframework.core.search.neigh.Neighbourhood;

public abstract class SingleNeighbourhoodSearch<SolutionType extends Solution>
extends NeighbourhoodSearch<SolutionType> {
    private Neighbourhood<? super SolutionType> neighbourhood;

    public SingleNeighbourhoodSearch(Problem<SolutionType> problem, Neighbourhood<? super SolutionType> neighbourhood) {
        this(null, problem, neighbourhood);
    }

    public SingleNeighbourhoodSearch(String name, Problem<SolutionType> problem, Neighbourhood<? super SolutionType> neighbourhood) {
        super(name != null ? name : "SingleNeighbourhoodSearch", problem);
        if (neighbourhood == null) {
            throw new NullPointerException("Error while creating single neighbourhood search: neighbourhood can not be null.");
        }
        this.neighbourhood = neighbourhood;
    }

    public Neighbourhood<? super SolutionType> getNeighbourhood() {
        return this.neighbourhood;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeighbourhood(Neighbourhood<? super SolutionType> neighbourhood) {
        Object object = this.getStatusLock();
        synchronized (object) {
            this.assertIdle("Cannot set neighbourhood.");
            if (neighbourhood == null) {
                throw new NullPointerException("Cannot set neighbourhood: received null.");
            }
            this.neighbourhood = neighbourhood;
        }
    }
}

