/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.PUBLIC;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import keel.Algorithms.Decision_Trees.PUBLIC.Register;
import keel.Algorithms.Decision_Trees.PUBLIC.Split;
import keel.Algorithms.Decision_Trees.PUBLIC.myAttribute;
import keel.Algorithms.Decision_Trees.PUBLIC.myDataset;

public class Node {
    int identifier;
    ArrayList<myAttribute> the_attributes;
    ArrayList<ArrayList<Register>> attributes;
    int[] rows;
    int[] columns;
    ArrayList<int[][]> count_matrix;
    ArrayList<int[][]> c_below;
    ArrayList<int[][]> c_above;
    Random generator;

    public Node() {
    }

    public Node(myDataset data, int id) {
        int i;
        this.identifier = id;
        this.the_attributes = new ArrayList();
        this.attributes = new ArrayList();
        for (int j = 0; j < data.getNumAtr(); ++j) {
            ArrayList<Register> reglist = new ArrayList<Register>();
            myAttribute att = data.getAttributeI(j);
            this.the_attributes.add(new myAttribute(att));
            for (int i2 = 0; i2 < data.getNumIns(); ++i2) {
                Register reg = new Register(i2, data.getDataI(i2, j), data.getOutputI(i2));
                reglist.add(reg);
            }
            this.attributes.add(reglist);
        }
        for (i = 0; i < data.getNumAtr(); ++i) {
            if (data.getAttributeI(i).isNominal()) continue;
            for (int j = 0; j < data.getNumIns(); ++j) {
                Collections.sort((List)this.attributes.get(i));
            }
        }
        this.rows = new int[data.getNumAtr()];
        this.columns = new int[data.getNumAtr()];
        for (i = 0; i < data.getNumAtr(); ++i) {
            if (!data.getAttributeI(i).isNominal()) {
                int aux_columns = data.getOutputAttribute().getValues().size();
                this.rows[i] = 1;
                this.columns[i] = aux_columns;
                continue;
            }
            int aux_rows = data.getAttributeI(i).getValues().size();
            int aux_columns = data.getOutputAttribute().getValues().size();
            this.rows[i] = aux_rows;
            this.columns[i] = aux_columns;
        }
        this.calculateHistograms();
        this.generator = new Random(12345678L);
    }

    public Node(Node nod) {
        int j;
        int i;
        this.identifier = nod.identifier;
        this.the_attributes = new ArrayList();
        for (i = 0; i < nod.attributes.size(); ++i) {
            this.the_attributes.add(new myAttribute(nod.the_attributes.get(i)));
        }
        this.attributes = new ArrayList();
        for (i = 0; i < nod.attributes.size(); ++i) {
            ArrayList<Register> auxregister = new ArrayList<Register>();
            for (j = 0; j < nod.attributes.get(i).size(); ++j) {
                auxregister.add(new Register(nod.attributes.get(i).get(j)));
            }
            this.attributes.add(auxregister);
        }
        this.rows = new int[nod.attributes.size()];
        System.arraycopy(nod.rows, 0, this.rows, 0, nod.rows.length);
        this.columns = new int[nod.attributes.size()];
        System.arraycopy(nod.columns, 0, this.columns, 0, nod.columns.length);
        this.count_matrix = new ArrayList();
        this.c_below = new ArrayList();
        this.c_above = new ArrayList();
        for (i = 0; i < nod.attributes.size(); ++i) {
            int[][] aux_c_above;
            int[][] aux_c_below;
            int[][] aux_count_matrix;
            if (!this.the_attributes.get(i).isNominal()) {
                aux_count_matrix = new int[1][1];
                aux_c_below = new int[1][this.columns[i]];
                aux_c_above = new int[1][this.columns[i]];
                for (j = 0; j < this.columns[i]; ++j) {
                    aux_c_below[0][j] = nod.c_below.get(i)[0][j];
                    aux_c_above[0][j] = nod.c_above.get(i)[0][j];
                }
                this.count_matrix.add(aux_count_matrix);
                this.c_below.add(aux_c_below);
                this.c_above.add(aux_c_above);
                continue;
            }
            aux_count_matrix = new int[this.rows[i]][this.columns[i]];
            aux_c_below = new int[1][1];
            aux_c_above = new int[1][1];
            for (j = 0; j < this.rows[i]; ++j) {
                for (int k = 0; k < this.columns[i]; ++k) {
                    aux_count_matrix[j][k] = nod.count_matrix.get(i)[j][k];
                }
            }
            this.count_matrix.add(aux_count_matrix);
            this.c_below.add(aux_c_below);
            this.c_above.add(aux_c_above);
        }
        this.generator = nod.generator;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Node test = (Node)obj;
        boolean eq = this.identifier == test.identifier;
        eq = eq && (this.the_attributes == test.the_attributes || this.the_attributes != null && this.the_attributes.equals(test.the_attributes));
        boolean bl = eq = eq && (this.attributes == test.attributes || this.attributes != null && this.attributes.equals(test.attributes));
        if (eq) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                int j;
                if (this.rows[i] != test.rows[i]) {
                    return false;
                }
                if (this.columns[i] != test.columns[i]) {
                    return false;
                }
                if (this.rows[i] > 1) {
                    for (j = 0; j < this.rows[i]; ++j) {
                        for (int k = 0; k < this.columns[i]; ++k) {
                            if (this.count_matrix.get(i)[j][k] == test.count_matrix.get(i)[j][k]) continue;
                            return false;
                        }
                    }
                    continue;
                }
                for (j = 0; j < this.columns[j]; ++j) {
                    if (this.c_above.get(i)[0][j] != test.c_above.get(i)[0][j]) {
                        return false;
                    }
                    if (this.c_below.get(i)[0][j] == test.c_below.get(i)[0][j]) continue;
                    return false;
                }
            }
        }
        return eq;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.identifier;
        hash = 31 * hash + (null == this.the_attributes ? 0 : this.the_attributes.hashCode());
        hash = 31 * hash + (null == this.attributes ? 0 : this.attributes.hashCode());
        return hash;
    }

    public String toString() {
        String aux = new String("Node " + this.identifier + "\n");
        for (int i = 0; i < this.attributes.size(); ++i) {
            int j;
            aux = aux + this.the_attributes.get(i).getName() + "\nAttribute list:\n";
            for (j = 0; j < this.attributes.get(i).size(); ++j) {
                aux = aux + this.attributes.get(i).get(j) + "\n";
            }
            aux = aux + "Histogram\n";
            if (!this.the_attributes.get(i).isNominal()) {
                aux = aux + "C_below:";
                for (j = 0; j < this.columns[i]; ++j) {
                    aux = aux + " " + this.c_below.get(i)[0][j];
                }
                aux = aux + "\nC_above:";
                for (j = 0; j < this.columns[i]; ++j) {
                    aux = aux + " " + this.c_above.get(i)[0][j];
                }
                aux = aux + "\n";
                continue;
            }
            aux = aux + "Count matrix:\n";
            for (j = 0; j < this.rows[i]; ++j) {
                for (int k = 0; k < this.columns[i]; ++k) {
                    aux = aux + this.count_matrix.get(i)[j][k] + " ";
                }
                aux = aux + "\n";
            }
        }
        return aux;
    }

    private void calculateHistograms() {
        this.count_matrix = new ArrayList();
        this.c_below = new ArrayList();
        this.c_above = new ArrayList();
        for (int i = 0; i < this.attributes.size(); ++i) {
            Register reg;
            int j;
            int[][] aux_c_above;
            int[][] aux_c_below;
            int[][] aux_count_matrix;
            if (!this.the_attributes.get(i).isNominal()) {
                aux_count_matrix = new int[1][1];
                aux_c_below = new int[1][this.columns[i]];
                aux_c_above = new int[1][this.columns[i]];
                for (j = 0; j < this.columns[i]; ++j) {
                    aux_c_below[0][j] = 0;
                    aux_c_above[0][j] = 0;
                }
                for (j = 0; j < this.attributes.get(i).size(); ++j) {
                    reg = this.attributes.get(i).get(j);
                    int[] nArray = aux_c_above[0];
                    int n = reg.getOutputClass();
                    nArray[n] = nArray[n] + 1;
                }
                this.count_matrix.add(aux_count_matrix);
                this.c_below.add(aux_c_below);
                this.c_above.add(aux_c_above);
                continue;
            }
            aux_count_matrix = new int[this.rows[i]][this.columns[i]];
            aux_c_below = new int[1][1];
            aux_c_above = new int[1][1];
            for (j = 0; j < this.rows[i]; ++j) {
                for (int k = 0; k < this.columns[i]; ++k) {
                    aux_count_matrix[j][k] = 0;
                }
            }
            for (j = 0; j < this.attributes.get(i).size(); ++j) {
                reg = this.attributes.get(i).get(j);
                int[] nArray = aux_count_matrix[(int)reg.getAttributeValue()];
                int n = reg.getOutputClass();
                nArray[n] = nArray[n] + 1;
            }
            this.count_matrix.add(aux_count_matrix);
            this.c_below.add(aux_c_below);
            this.c_above.add(aux_c_above);
        }
    }

    public boolean isPure() {
        if (this.attributes.isEmpty()) {
            return true;
        }
        int oclass = this.attributes.get(0).get(0).getOutputClass();
        for (int i = 0; i < this.attributes.size(); ++i) {
            ArrayList<Register> aux = this.attributes.get(i);
            for (int j = 0; j < aux.size(); ++j) {
                if (aux.get(j).getOutputClass() == oclass) continue;
                return false;
            }
        }
        return true;
    }

    public Split evaluateAllSplits() {
        int i;
        double[] attribute_best_entropy = new double[this.attributes.size()];
        int[] attribute_position_entropy = new int[this.attributes.size()];
        for (i = 0; i < this.attributes.size(); ++i) {
            double entropy;
            double pj;
            double entropyS2;
            double entropyS1;
            int cursor;
            Register reg;
            int j;
            int[][] matrix;
            System.out.println("Evaluating split points for: " + this.the_attributes.get(i).getName());
            if (this.the_attributes.get(i).isNominal()) {
                int k;
                matrix = new int[this.rows[i]][this.columns[i] + 1];
                for (j = 0; j < this.rows[i]; ++j) {
                    for (k = 0; k < this.columns[i] + 1; ++k) {
                        matrix[j][k] = 0;
                    }
                }
                for (j = 0; j < this.attributes.get(i).size(); ++j) {
                    reg = this.attributes.get(i).get(j);
                    int[] nArray = matrix[(int)reg.getAttributeValue()];
                    int n = reg.getOutputClass();
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = matrix[(int)reg.getAttributeValue()];
                    int n2 = this.columns[i];
                    nArray2[n2] = nArray2[n2] + 1;
                }
                attribute_position_entropy[i] = -1;
                int total_acc = 1;
                for (cursor = 0; cursor < this.rows[i]; ++cursor) {
                    entropyS1 = 0.0;
                    entropyS2 = 0.0;
                    for (j = 0; j < this.columns[i]; ++j) {
                        pj = matrix[cursor][this.columns[i]] != 0 ? (double)matrix[cursor][j] / (double)matrix[cursor][this.columns[i]] : 0.0;
                        if (pj != 0.0) {
                            entropyS1 += pj * (Math.log(pj) / Math.log(2.0));
                        }
                        int class_acc = 0;
                        total_acc = 0;
                        for (k = 0; k < this.rows[i]; ++k) {
                            if (k == cursor) continue;
                            class_acc += matrix[k][j];
                            total_acc += matrix[k][this.columns[i]];
                        }
                        pj = total_acc != 0 ? (double)class_acc / (double)total_acc : 0.0;
                        if (pj == 0.0) continue;
                        entropyS2 += pj * Math.log(pj) / Math.log(2.0);
                    }
                    entropyS1 = -entropyS1;
                    entropyS2 = -entropyS2;
                    entropy = (double)matrix[cursor][this.columns[i]] / (double)this.attributes.get(i).size() * entropyS1 + (double)total_acc / (double)this.attributes.get(i).size() * entropyS2;
                    int elem_exits = 0;
                    for (int w = 0; w < this.columns[i]; ++w) {
                        elem_exits += matrix[cursor][w];
                    }
                    if (!(entropy < attribute_best_entropy[i]) && attribute_position_entropy[i] != -1 || elem_exits == 0) continue;
                    attribute_best_entropy[i] = entropy;
                    attribute_position_entropy[i] = cursor;
                }
                this.count_matrix.set(i, matrix);
                System.out.println("Best split for " + this.the_attributes.get(i).getName() + " found: " + i + " " + this.the_attributes.get(i).getValues().get(attribute_position_entropy[i]) + " Entropy = " + attribute_best_entropy[i]);
                continue;
            }
            entropy = 0.0;
            attribute_best_entropy[i] = this.attributes.get(i).size();
            attribute_position_entropy[i] = 0;
            reg = this.attributes.get(i).get(0);
            matrix = this.c_below.get(i);
            int[] nArray = matrix[0];
            int n = reg.getOutputClass();
            nArray[n] = nArray[n] + 1;
            this.c_below.set(i, matrix);
            matrix = this.c_above.get(i);
            int[] nArray3 = matrix[0];
            int n3 = reg.getOutputClass();
            nArray3[n3] = nArray3[n3] - 1;
            this.c_above.set(i, matrix);
            for (cursor = 1; cursor < this.attributes.get(i).size(); ++cursor) {
                if (this.attributes.get(i).get(cursor).getAttributeValue() != this.attributes.get(i).get(cursor - 1).getAttributeValue()) {
                    entropyS1 = 0.0;
                    entropyS2 = 0.0;
                    for (j = 0; j < this.columns[i]; ++j) {
                        pj = (double)this.c_below.get(i)[0][j] / (double)cursor;
                        if (pj != 0.0) {
                            entropyS1 += pj * Math.log(pj) / Math.log(2.0);
                        }
                        if ((pj = (double)this.c_above.get(i)[0][j] / (double)(this.attributes.get(i).size() - cursor)) == 0.0) continue;
                        entropyS2 += pj * Math.log(pj) / Math.log(2.0);
                    }
                    entropyS1 = -entropyS1;
                    entropyS2 = -entropyS2;
                    if (this.attributes.get(i).size() != 0) {
                        entropy = (double)cursor / (double)this.attributes.get(i).size() * entropyS1 + (double)(this.attributes.get(i).size() - cursor) / (double)this.attributes.get(i).size() * entropyS2;
                    } else {
                        System.err.println("There aren't any registers in the attribute list");
                        System.exit(-1);
                    }
                    if (entropy < attribute_best_entropy[i]) {
                        attribute_best_entropy[i] = entropy;
                        attribute_position_entropy[i] = cursor;
                    }
                }
                reg = this.attributes.get(i).get(cursor);
                matrix = this.c_below.get(i);
                int[] nArray4 = matrix[0];
                int n4 = reg.getOutputClass();
                nArray4[n4] = nArray4[n4] + 1;
                this.c_below.set(i, matrix);
                matrix = this.c_above.get(i);
                int[] nArray5 = matrix[0];
                int n5 = reg.getOutputClass();
                nArray5[n5] = nArray5[n5] - 1;
                this.c_above.set(i, matrix);
            }
            System.out.println("Best split for " + this.the_attributes.get(i).getName() + " found: " + i + " " + this.attributes.get(i).get(attribute_position_entropy[i]).getAttributeValue() + " Entropy = " + attribute_best_entropy[i]);
        }
        double value_split = attribute_best_entropy[0];
        int attribute_split = 0;
        for (i = 1; i < this.attributes.size(); ++i) {
            if (!(attribute_best_entropy[i] < value_split)) continue;
            value_split = attribute_best_entropy[i];
            attribute_split = i;
        }
        if (this.the_attributes.get(attribute_split).isNominal()) {
            value_split = attribute_position_entropy[attribute_split];
        } else {
            boolean found = false;
            value_split = this.attributes.get(attribute_split).get(attribute_position_entropy[attribute_split]).getAttributeValue();
            for (int i2 = 0; i2 < this.attributes.get(attribute_split).size() && !found; ++i2) {
                if (!(this.attributes.get(attribute_split).get(i2).getAttributeValue() > value_split)) continue;
                value_split = this.attributes.get(attribute_split).get(i2).getAttributeValue();
                found = true;
            }
        }
        Split aux = new Split(attribute_split, value_split);
        System.out.println("\nBEST SPLIT FOUND: " + aux);
        return aux;
    }

    public ArrayList<Node> split(Split best_split, int last_new_node) {
        Register regaux;
        int j;
        int i;
        ArrayList<Node> result = new ArrayList<Node>();
        Hashtable<Integer, Integer> registers = new Hashtable<Integer, Integer>();
        Node left = new Node();
        Node right = new Node();
        left.the_attributes = new ArrayList();
        right.the_attributes = new ArrayList();
        for (i = 0; i < this.the_attributes.size(); ++i) {
            left.the_attributes.add(new myAttribute(this.the_attributes.get(i)));
            right.the_attributes.add(new myAttribute(this.the_attributes.get(i)));
        }
        left.identifier = last_new_node + 1;
        right.identifier = last_new_node + 2;
        left.attributes = new ArrayList(this.attributes.size());
        right.attributes = new ArrayList(this.attributes.size());
        for (i = 0; i < this.attributes.size(); ++i) {
            left.attributes.add(new ArrayList());
            right.attributes.add(new ArrayList());
        }
        ArrayList<Register> aux_left = new ArrayList<Register>();
        ArrayList<Register> aux_right = new ArrayList<Register>();
        if (this.the_attributes.get(best_split.getAttribute()).isNominal()) {
            for (j = 0; j < this.attributes.get(best_split.getAttribute()).size(); ++j) {
                regaux = this.attributes.get(best_split.getAttribute()).get(j);
                if (regaux.getAttributeValue() == best_split.getValue()) {
                    aux_left.add(new Register(regaux));
                    registers.put(regaux.getIdentifier(), new Integer(0));
                    continue;
                }
                aux_right.add(new Register(regaux));
                registers.put(regaux.getIdentifier(), new Integer(1));
            }
        } else {
            for (j = 0; j < this.attributes.get(best_split.getAttribute()).size(); ++j) {
                regaux = this.attributes.get(best_split.getAttribute()).get(j);
                if (regaux.getAttributeValue() < best_split.getValue()) {
                    aux_left.add(new Register(regaux));
                    registers.put(regaux.getIdentifier(), new Integer(0));
                    continue;
                }
                aux_right.add(new Register(regaux));
                registers.put(regaux.getIdentifier(), new Integer(1));
            }
        }
        if (aux_left.size() == 0 || aux_right.size() == 0) {
            return null;
        }
        left.attributes.set(best_split.getAttribute(), aux_left);
        right.attributes.set(best_split.getAttribute(), aux_right);
        for (i = 0; i < this.attributes.size(); ++i) {
            if (i == best_split.getAttribute()) continue;
            aux_left = new ArrayList();
            aux_right = new ArrayList();
            for (int j2 = 0; j2 < this.attributes.get(i).size(); ++j2) {
                regaux = this.attributes.get(i).get(j2);
                Integer leaf = (Integer)registers.get(regaux.getIdentifier());
                if (leaf != null) {
                    if (leaf.equals(0)) {
                        aux_left.add(new Register(regaux));
                        continue;
                    }
                    aux_right.add(new Register(regaux));
                    continue;
                }
                System.out.println(regaux);
                System.err.println("Register not found in hash table");
                System.exit(-1);
            }
            left.attributes.set(i, aux_left);
            right.attributes.set(i, aux_right);
        }
        left.rows = new int[this.attributes.size()];
        right.rows = new int[this.attributes.size()];
        System.arraycopy(this.rows, 0, left.rows, 0, this.rows.length);
        System.arraycopy(this.rows, 0, right.rows, 0, this.rows.length);
        left.columns = new int[this.attributes.size()];
        right.columns = new int[this.attributes.size()];
        System.arraycopy(this.columns, 0, left.columns, 0, this.columns.length);
        System.arraycopy(this.columns, 0, right.columns, 0, this.columns.length);
        left.calculateHistograms();
        right.calculateHistograms();
        left.generator = this.generator;
        right.generator = this.generator;
        result.add(left);
        result.add(right);
        return result;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public int getOutputClass() {
        return this.attributes.get(0).get(0).getOutputClass();
    }

    public int getNumRegisters() {
        return this.attributes.get(0).size();
    }

    public int getNumItemsClassI(int i) {
        myAttribute att = this.the_attributes.get(0);
        if (att.isNominal()) {
            int numitems = 0;
            for (int j = 0; j < this.rows[0]; ++j) {
                numitems += this.count_matrix.get(0)[j][i];
            }
            return numitems;
        }
        return this.c_above.get(0)[0][i] + this.c_below.get(0)[0][i];
    }

    public int getDifferentValuesAttributeI(int i) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int j = 0; j < this.attributes.get(i).size(); ++j) {
            if (values.contains(new Double(this.attributes.get(i).get(j).getAttributeValue()))) continue;
            values.add(new Double(this.attributes.get(i).get(j).getAttributeValue()));
        }
        return values.size();
    }

    public int getMajorOutputClass() {
        int i;
        int[] repetitions = new int[this.columns[0]];
        for (i = 0; i < this.columns[0]; ++i) {
            repetitions[i] = 0;
        }
        for (int j = 0; j < this.attributes.get(0).size(); ++j) {
            int n = this.attributes.get(0).get(j).getOutputClass();
            repetitions[n] = repetitions[n] + 1;
        }
        int max = repetitions[0];
        int posmax = 0;
        for (i = 1; i < this.columns[0]; ++i) {
            if (repetitions[i] > max) {
                max = repetitions[i];
                posmax = i;
                continue;
            }
            if (repetitions[i] != max) continue;
            System.out.println("Can't decide better outputClass between " + posmax + " y " + i);
            int selection = this.generator.nextInt(2);
            if (selection == 1) {
                max = repetitions[i];
                posmax = i;
            }
            System.out.println("Finally selected " + posmax);
        }
        return posmax;
    }

    public int getNumClasses() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int j = 0; j < this.attributes.get(0).size(); ++j) {
            if (values.contains(new Integer(this.attributes.get(0).get(j).getOutputClass()))) continue;
            values.add(new Integer(this.attributes.get(0).get(j).getOutputClass()));
        }
        return values.size();
    }

    public ArrayList<ArrayList<Integer>> getDecreasedNI() {
        int i;
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> classes = new ArrayList<Integer>();
        ArrayList<Integer> frecuencies = new ArrayList<Integer>();
        int[] numitems = new int[this.columns[0]];
        myAttribute att = this.the_attributes.get(0);
        for (i = 0; i < this.columns[0]; ++i) {
            if (att.isNominal()) {
                numitems[i] = 0;
                for (int j = 0; j < this.rows[0]; ++j) {
                    int n = i;
                    numitems[n] = numitems[n] + this.count_matrix.get(0)[j][i];
                }
            } else {
                numitems[i] = this.c_above.get(0)[0][i] + this.c_below.get(0)[0][i];
            }
            classes.add(i);
            frecuencies.add(numitems[i]);
        }
        for (i = 0; i < this.columns[0] - 1; ++i) {
            int current = (Integer)frecuencies.get(i);
            int current_position = (Integer)classes.get(i);
            int k = i;
            for (int j = i + 1; j < frecuencies.size(); ++j) {
                if (current >= (Integer)frecuencies.get(j)) continue;
                k = j;
                current = (Integer)frecuencies.get(j);
                current_position = (Integer)classes.get(j);
            }
            frecuencies.set(k, (Integer)frecuencies.get(i));
            frecuencies.set(i, current);
            classes.set(k, (Integer)classes.get(i));
            classes.set(i, current_position);
        }
        int delete_point = frecuencies.indexOf(0);
        while (delete_point != -1) {
            frecuencies.remove(delete_point);
            classes.remove(delete_point);
            delete_point = frecuencies.indexOf(0);
        }
        result.add(classes);
        result.add(frecuencies);
        return result;
    }

    public ArrayList<ArrayList<Integer>> getDecreasedNIV() {
        int i;
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> classes = new ArrayList<Integer>();
        ArrayList<Integer> frecuencies = new ArrayList<Integer>();
        int[] numitems = new int[this.columns[0]];
        double[] Vni = new double[this.columns[0]];
        myAttribute att = this.the_attributes.get(0);
        for (i = 0; i < this.columns[0]; ++i) {
            if (att.isNominal()) {
                numitems[i] = 0;
                for (int j = 0; j < this.rows[0]; ++j) {
                    int n = i;
                    numitems[n] = numitems[n] + this.count_matrix.get(0)[j][i];
                }
            } else {
                numitems[i] = this.c_above.get(0)[0][i] + this.c_below.get(0)[0][i];
            }
            classes.add(i);
            frecuencies.add(numitems[i]);
            Vni[i] = (double)numitems[i] - this.V(i);
        }
        for (i = 0; i < this.columns[0] - 1; ++i) {
            int current = (Integer)frecuencies.get(i);
            int current_position = (Integer)classes.get(i);
            double current_vi = Vni[i];
            int k = i;
            for (int j = i + 1; j < Vni.length; ++j) {
                if (!(current_vi < Vni[j])) continue;
                k = j;
                current = (Integer)frecuencies.get(j);
                current_position = (Integer)classes.get(j);
                current_vi = Vni[j];
            }
            Vni[k] = Vni[i];
            Vni[i] = current_vi;
            frecuencies.set(k, (Integer)frecuencies.get(i));
            frecuencies.set(i, current);
            classes.set(k, (Integer)classes.get(i));
            classes.set(i, current_position);
        }
        int delete_point = frecuencies.indexOf(0);
        while (delete_point != -1) {
            frecuencies.remove(delete_point);
            classes.remove(delete_point);
            delete_point = frecuencies.indexOf(0);
        }
        result.add(classes);
        result.add(frecuencies);
        return result;
    }

    public double V(int k) {
        int i;
        ArrayList all_values = new ArrayList();
        for (i = 0; i < this.attributes.size(); ++i) {
            ArrayList<Double> values = new ArrayList<Double>();
            for (int j = 0; j < this.attributes.get(i).size(); ++j) {
                if (this.attributes.get(i).get(j).getOutputClass() != k || values.contains(new Double(this.attributes.get(i).get(j).getAttributeValue()))) continue;
                values.add(new Double(this.attributes.get(i).get(j).getAttributeValue()));
            }
            all_values.add(values);
        }
        double min = this.attributes.get(0).size() + 1;
        for (i = 0; i < this.attributes.size(); ++i) {
            double possible_min;
            if (((ArrayList)all_values.get(i)).size() == 0 || !((possible_min = this.the_attributes.get(i).isNominal() ? (double)((ArrayList)all_values.get(i)).size() : Math.log(((ArrayList)all_values.get(i)).size()) / Math.log(2.0)) < min)) continue;
            min = possible_min;
        }
        if (min == (double)(this.attributes.get(0).size() + 1)) {
            return 0.0;
        }
        return min;
    }
}

