/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure.iterators;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateInt;
import java.util.NoSuchElementException;

public final class PSVIndexIterator<E>
extends DisposableIntIterator {
    private int nStaticObjects;
    private int nStoredObjects;
    private E[] staticObjects;
    private int idx;

    public void init(int theNStaticObjects, E[] theStaticObjects, IStateInt theNStoredObjects) {
        super.init();
        this.idx = -1;
        this.nStaticObjects = theNStaticObjects;
        this.staticObjects = theStaticObjects;
        this.nStoredObjects = theNStoredObjects.get();
    }

    @Override
    public boolean hasNext() {
        if (this.idx < 1000000) {
            return this.idx + 1 < this.nStaticObjects || this.nStoredObjects > 0;
        }
        return this.idx + 1 < 1000000 + this.nStoredObjects;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int next() {
        if (this.idx < 1000000) {
            if (this.idx + 1 < this.nStaticObjects) {
                ++this.idx;
                while (this.staticObjects[this.idx] == null && this.idx < this.nStaticObjects) {
                    ++this.idx;
                }
                return this.idx;
            } else {
                if (this.nStoredObjects <= 0) throw new NoSuchElementException();
                this.idx = 1000000;
            }
            return this.idx;
        } else {
            if (this.idx + 1 >= 1000000 + this.nStoredObjects) throw new NoSuchElementException();
            ++this.idx;
        }
        return this.idx;
    }
}

