/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import technology.tabula.Line;
import technology.tabula.Rectangle;
import technology.tabula.RectangularTextContainer;
import technology.tabula.TextElement;

public class TextChunk
extends RectangularTextContainer<TextElement> {
    public static final TextChunk EMPTY = new TextChunk(0.0f, 0.0f, 0.0f, 0.0f);
    private static HashMap<Byte, DirectionalityOptions> directionalities = new HashMap();

    public TextChunk(float top, float left, float width, float height) {
        super(top, left, width, height);
    }

    public TextChunk(TextElement textElement) {
        super(textElement.y, textElement.x, textElement.width, textElement.height);
        this.add(textElement);
    }

    public TextChunk(List<TextElement> textElements) {
        this(textElements.get(0));
        for (int i = 1; i < textElements.size(); ++i) {
            this.add(textElements.get(i));
        }
    }

    public TextChunk groupByDirectionality(Boolean isLtrDominant) {
        if (this.getTextElements().size() <= 0) {
            throw new IllegalArgumentException();
        }
        ArrayList chunks = new ArrayList();
        ArrayList<TextElement> buff = new ArrayList<TextElement>();
        DirectionalityOptions buffDirectionality = DirectionalityOptions.NONE;
        for (TextElement te : this.getTextElements()) {
            DirectionalityOptions directionalityOptions;
            if (buff.size() == 0) {
                buff.add(te);
                buffDirectionality = directionalities.get(Character.getDirectionality(te.getText().charAt(0)));
                continue;
            }
            if (buffDirectionality == DirectionalityOptions.NONE) {
                buffDirectionality = directionalities.get(Character.getDirectionality(te.getText().charAt(0)));
            }
            if ((directionalityOptions = directionalities.get(Character.getDirectionality(te.getText().charAt(0)))) == buffDirectionality || directionalityOptions == DirectionalityOptions.NONE) {
                if (Character.getDirectionality(te.getText().charAt(0)) == 12 && buffDirectionality == (isLtrDominant != false ? DirectionalityOptions.RTL : DirectionalityOptions.LTR)) {
                    buff.add(0, te);
                    continue;
                }
                buff.add(te);
                continue;
            }
            if (buffDirectionality == DirectionalityOptions.RTL) {
                Collections.reverse(buff);
            }
            chunks.add(buff);
            buffDirectionality = directionalities.get(Character.getDirectionality(te.getText().charAt(0)));
            buff = new ArrayList();
            buff.add(te);
        }
        if (buffDirectionality == DirectionalityOptions.RTL) {
            Collections.reverse(buff);
        }
        chunks.add(buff);
        ArrayList<TextElement> everything = new ArrayList<TextElement>();
        if (!isLtrDominant.booleanValue()) {
            Collections.reverse(chunks);
        }
        for (ArrayList arrayList : chunks) {
            everything.addAll(arrayList);
        }
        return new TextChunk(everything);
    }

    @Override
    public int isLtrDominant() {
        int ltrCnt = 0;
        int rtlCnt = 0;
        for (int i = 0; i < this.getTextElements().size(); ++i) {
            String elementText = ((TextElement)this.getTextElements().get(i)).getText();
            for (int j = 0; j < elementText.length(); ++j) {
                byte dir = Character.getDirectionality(elementText.charAt(j));
                if (dir == 0 || dir == 14 || dir == 15) {
                    ++ltrCnt;
                    continue;
                }
                if (dir != 1 && dir != 2 && dir != 16 && dir != 17) continue;
                ++rtlCnt;
            }
        }
        return Integer.compare(ltrCnt, rtlCnt);
    }

    public TextChunk merge(TextChunk other) {
        super.merge(other);
        return this;
    }

    public void add(TextElement textElement) {
        this.textElements.add(textElement);
        this.merge(textElement);
    }

    public void add(List<TextElement> elements) {
        for (TextElement te : elements) {
            this.add(te);
        }
    }

    @Override
    public String getText() {
        if (this.textElements.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (TextElement te : this.textElements) {
            sb.append(te.getText());
        }
        return Normalizer.normalize(sb.toString(), Normalizer.Form.NFKC).trim();
    }

    @Override
    public String getText(boolean useLineReturns) {
        return this.getText();
    }

    public boolean isSameChar(Character c) {
        return this.isSameChar(new Character[]{c});
    }

    public boolean isSameChar(Character[] c) {
        String s = this.getText();
        List<Character> chars = Arrays.asList(c);
        for (int i = 0; i < s.length(); ++i) {
            if (chars.contains(Character.valueOf(s.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public TextChunk[] splitAt(int i) {
        if (i < 1 || i >= this.getTextElements().size()) {
            throw new IllegalArgumentException();
        }
        return new TextChunk[]{new TextChunk(this.getTextElements().subList(0, i)), new TextChunk(this.getTextElements().subList(i, this.getTextElements().size()))};
    }

    public List<TextChunk> squeeze(Character c, int minRunLength) {
        Character lastChar = null;
        int subSequenceLength = 0;
        int subSequenceStart = 0;
        ArrayList<TextChunk> rv = new ArrayList<TextChunk>();
        for (int i = 0; i < this.getTextElements().size(); ++i) {
            TextElement textElement = (TextElement)this.getTextElements().get(i);
            String text = textElement.getText();
            Character currentChar = text.length() > 1 ? Character.valueOf(text.trim().charAt(0)) : Character.valueOf(text.charAt(0));
            if (lastChar != null && currentChar.equals(c) && lastChar.equals(currentChar)) {
                ++subSequenceLength;
            } else {
                if ((lastChar != null && !lastChar.equals(currentChar) || i + 1 == this.getTextElements().size()) && subSequenceLength >= minRunLength) {
                    TextChunk[] t;
                    if (subSequenceStart == 0 && subSequenceLength <= this.getTextElements().size() - 1) {
                        t = this.splitAt(subSequenceLength);
                    } else {
                        t = this.splitAt(subSequenceStart);
                        rv.add(t[0]);
                    }
                    rv.addAll(t[1].squeeze(c, minRunLength));
                    break;
                }
                subSequenceLength = 1;
                subSequenceStart = i;
            }
            lastChar = currentChar;
        }
        if (rv.isEmpty()) {
            if (subSequenceLength >= minRunLength && subSequenceLength < this.textElements.size()) {
                TextChunk[] chunks = this.splitAt(subSequenceStart);
                rv.add(chunks[0]);
            } else {
                rv.add(this);
            }
        }
        return rv;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.textElements == null ? 0 : this.textElements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextChunk other = (TextChunk)obj;
        if (this.textElements == null) {
            return other.textElements == null;
        }
        return this.textElements.equals(other.textElements);
    }

    public static boolean allSameChar(List<TextChunk> textChunks) {
        if (textChunks.size() == 1) {
            return false;
        }
        boolean hasHadAtLeastOneNonEmptyTextChunk = false;
        char first = '\u0000';
        for (TextChunk tc : textChunks) {
            if (tc.getText().length() == 0) continue;
            if (first == '\u0000') {
                first = tc.getText().charAt(0);
                continue;
            }
            hasHadAtLeastOneNonEmptyTextChunk = true;
            if (tc.isSameChar(Character.valueOf(first))) continue;
            return false;
        }
        return hasHadAtLeastOneNonEmptyTextChunk;
    }

    public static List<Line> groupByLines(List<TextChunk> textChunks) {
        ArrayList<Line> lines = new ArrayList<Line>();
        if (textChunks.size() == 0) {
            return lines;
        }
        float bbwidth = Rectangle.boundingBoxOf(textChunks).width;
        Line l = new Line();
        l.addTextChunk(textChunks.get(0));
        textChunks.remove(0);
        lines.add(l);
        Line last = (Line)lines.get(lines.size() - 1);
        for (TextChunk te : textChunks) {
            if ((double)last.verticalOverlapRatio(te) < 0.1) {
                if ((double)(last.width / bbwidth) > 0.9 && TextChunk.allSameChar(last.getTextElements())) {
                    lines.remove(lines.size() - 1);
                }
                lines.add(new Line());
                last = (Line)lines.get(lines.size() - 1);
            }
            last.addTextChunk(te);
        }
        if ((double)(last.width / bbwidth) > 0.9 && TextChunk.allSameChar(last.getTextElements())) {
            lines.remove(lines.size() - 1);
        }
        ArrayList<Line> rv = new ArrayList<Line>(lines.size());
        for (Line line : lines) {
            rv.add(Line.removeRepeatedCharacters(line, Character.valueOf(' '), 3));
        }
        return rv;
    }

    static {
        directionalities.put((byte)6, DirectionalityOptions.LTR);
        directionalities.put((byte)9, DirectionalityOptions.NONE);
        directionalities.put((byte)7, DirectionalityOptions.LTR);
        directionalities.put((byte)3, DirectionalityOptions.LTR);
        directionalities.put((byte)4, DirectionalityOptions.LTR);
        directionalities.put((byte)5, DirectionalityOptions.LTR);
        directionalities.put((byte)0, DirectionalityOptions.LTR);
        directionalities.put((byte)14, DirectionalityOptions.LTR);
        directionalities.put((byte)15, DirectionalityOptions.LTR);
        directionalities.put((byte)8, DirectionalityOptions.NONE);
        directionalities.put((byte)13, DirectionalityOptions.NONE);
        directionalities.put((byte)10, DirectionalityOptions.NONE);
        directionalities.put((byte)18, DirectionalityOptions.NONE);
        directionalities.put((byte)1, DirectionalityOptions.RTL);
        directionalities.put((byte)2, DirectionalityOptions.RTL);
        directionalities.put((byte)16, DirectionalityOptions.RTL);
        directionalities.put((byte)17, DirectionalityOptions.RTL);
        directionalities.put((byte)11, DirectionalityOptions.RTL);
        directionalities.put((byte)-1, DirectionalityOptions.NONE);
        directionalities.put((byte)12, DirectionalityOptions.NONE);
    }

    private static enum DirectionalityOptions {
        LTR,
        NONE,
        RTL;

    }
}

