This application illustrates visually and mathematically the way PCA finds the first principal component (PC).  Overall, locating the first PC is similar to using a ruler to draw the best line through a cloud of points, like the old-timers used to do before computers were readily available, but there are important differences.^1

**Optional Preliminaries**  Generate some data.  When the app loads, the default data is a scatter of points in roughly the shape of an elongated ellipse.  You have full control over the generation of this data, and we recommend you play around with the parameters eventually.  However, for learning about PCA, we suggest you stick with the default data and start with The Main Event.

**The Main Event**  *Use the top control to rotate the test axes.*  Think of the test axes as proposed PCs.  The light blue axis is the proposed first PC, and the pink axis is the proposed second PC (and is by theory perpendicular to the first PC). The goal is to position the first PC so that the maximum amount of variance is explained. As you rotate the axes, watch the output in the upper left corner to see how the variance changes.  Adjust the angle to find the maximum.  You can reset all parameters by refreshing the browser.

**Details** If *Show all projections on PC1* is unchecked, one of the data points has dark orange lines showing how that data point can be projected onto each of the proposed PCs.  The variance is the sum of the lengths of the projections for every data point onto a given proposed PC.  This is the value reported in the upper left corner.  This is the value one is trying to maximize.  Check the box to see projections from all data points onto the proposed PC1.

1: A key point is the value being optimized as one "draws" the line:  If the intent is a linear regression of the data, it is the residuals along the y direction that are *minimized*.  If the intent is PCA, it is the length of the projections of the data onto the line that are *maximized* (which is the variance, displayed in the upper left-hand corner of the plot).
