/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class N3EventPrinter
implements N3ParserEventHandler {
    public boolean printStartFinish = false;
    PrintWriter out = null;

    public N3EventPrinter(OutputStream _out) {
        this.out = FileUtils.asPrintWriterUTF8(_out);
    }

    public N3EventPrinter(PrintWriter _out) {
        this.out = _out;
    }

    public void error(Exception ex, String message) {
        N3EventPrinter.println(this.out, "Error: " + message);
        N3EventPrinter.flush(this.out);
    }

    public void startDocument() {
        if (this.printStartFinish) {
            N3EventPrinter.println(this.out, "Document start");
            N3EventPrinter.flush(this.out);
        }
    }

    public void endDocument() {
        if (this.printStartFinish) {
            N3EventPrinter.println(this.out, "Document end");
            N3EventPrinter.flush(this.out);
        }
    }

    public void startFormula(int line, String context) {
        if (this.printStartFinish) {
            N3EventPrinter.print(this.out, "Formula start: " + context);
            N3EventPrinter.flush(this.out);
        }
    }

    public void endFormula(int line, String context) {
        if (this.printStartFinish) {
            N3EventPrinter.print(this.out, "Formula finish: " + context);
            N3EventPrinter.flush(this.out);
        }
    }

    public void directive(int line, AST directive, AST[] args, String context) {
        if (context != null) {
            N3EventPrinter.print(this.out, context + " ");
        }
        N3EventPrinter.print(this.out, directive.getText());
        for (int i = 0; i < args.length; ++i) {
            N3EventPrinter.print(this.out, " ");
            N3EventPrinter.printSlot(this.out, args[i]);
        }
        N3EventPrinter.println(this.out);
        N3EventPrinter.flush(this.out);
    }

    public void quad(int line, AST subj, AST prop, AST obj, String context) {
        if (context != null) {
            N3EventPrinter.print(this.out, context + " ");
        }
        N3EventPrinter.print(this.out, "[ ");
        N3EventPrinter.printSlot(this.out, subj);
        N3EventPrinter.print(this.out, " , ");
        N3EventPrinter.printSlot(this.out, prop);
        N3EventPrinter.print(this.out, " , ");
        N3EventPrinter.printSlot(this.out, obj);
        N3EventPrinter.println(this.out, " ]");
        N3EventPrinter.flush(this.out);
    }

    public static String formatSlot(AST slot) {
        try {
            StringWriter sw = new StringWriter();
            N3EventPrinter.printSlot(sw, slot);
            sw.close();
            return sw.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void printSlot(Writer out, AST ast) {
        N3EventPrinter.printSlot(out, ast, true);
    }

    private static void printSlot(Writer out, AST ast, boolean printType) {
        try {
            if (ast == null) {
                out.write("<null>");
                return;
            }
            int tokenType = ast.getType();
            String tmp = ast.toString();
            if (tmp.equals("")) {
                tmp = "<empty string>";
            }
            switch (tokenType) {
                case 22: {
                    out.write(34);
                    N3EventPrinter.printString(out, tmp);
                    out.write(34);
                    AST a1 = ast.getNextSibling();
                    AST a2 = a1 == null ? null : a1.getNextSibling();
                    N3EventPrinter.printLiteralModifier(out, a1);
                    N3EventPrinter.printLiteralModifier(out, a2);
                    break;
                }
                case 41: {
                    AST ast2 = ast.getFirstChild();
                    out.write(tmp);
                    if (ast2 == null) break;
                    out.write("^^");
                    N3EventPrinter.printSlot(out, ast2, false);
                    break;
                }
                default: {
                    out.write(tmp);
                }
            }
            if (printType) {
                out.write(40);
                out.write(N3Parser.getTokenNames()[tokenType]);
                out.write(41);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printString(Writer out, String s) {
        try {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\' || c == '\"') {
                    out.write(92);
                    out.write(c);
                    continue;
                }
                if (c == '\n') {
                    out.write("\\n");
                    continue;
                }
                if (c == '\r') {
                    out.write("\\r");
                    continue;
                }
                if (c == '\t') {
                    out.write("\\t");
                    continue;
                }
                if (c >= ' ' && c < '\u007f') {
                    out.write(c);
                    continue;
                }
                String hexstr = Integer.toHexString(c).toUpperCase();
                out.write("\\u");
                for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                    out.write("0");
                }
                out.write(hexstr);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printLiteralModifier(Writer out, AST a) throws IOException {
        if (a == null) {
            return;
        }
        int i = a.getType();
        switch (a.getType()) {
            case 39: {
                out.write("^^");
                AST dt = a.getFirstChild();
                N3EventPrinter.printSlot(out, dt, false);
                break;
            }
            case 20: {
                out.write(a.getText());
                break;
            }
            default: {
                System.err.println("Error in grammar - not a datatype or lang tag: " + a.getText() + "/" + N3Parser.getTokenNames()[a.getType()]);
            }
        }
    }

    private static void print(PrintWriter out, String s) {
        out.print(s);
    }

    private static void println(PrintWriter out, String s) {
        out.println(s);
    }

    private static void println(PrintWriter out) {
        out.println();
    }

    private static void flush(PrintWriter out) {
        out.flush();
    }
}

