/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.tree.DefaultMutableTreeNode;
import weka.gui.ensembleLibraryEditor.tree.NumberClassNotFoundException;

public class NumberNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -2505599954089243851L;
    public static final int NOT_ITERATOR = 0;
    public static final int TIMES_EQUAL = 1;
    public static final int PLUS_EQUAL = 2;
    private String m_Name;
    private int m_IteratorType;
    private boolean m_Checkable;
    private boolean m_Selected;
    private String m_ToolTipText;
    public static final int scale = 7;
    public static final double epsilon = 1.0E-6;

    public static double roundDouble(double d) {
        return new BigDecimal("" + d).setScale(7, 4).doubleValue();
    }

    public static float roundFloat(float f) {
        return new BigDecimal("" + f).setScale(7, 4).floatValue();
    }

    public NumberNode(String string, Number number, int n, boolean bl, String string2) {
        this.m_Name = string;
        this.setValue(number);
        this.m_IteratorType = n;
        this.m_Checkable = bl;
        this.m_Selected = false;
        this.m_ToolTipText = string2;
    }

    public boolean getSelected() {
        return this.m_Selected;
    }

    public void setSelected(boolean bl) {
        this.m_Selected = bl;
    }

    public Number getValue() {
        return (Number)this.getUserObject();
    }

    public void setValue(Number number) {
        this.userObject = number;
    }

    public int getIteratorType() {
        return this.m_IteratorType;
    }

    public void setIteratorType(int n) {
        this.m_IteratorType = n;
    }

    public boolean getCheckable() {
        return this.m_Checkable;
    }

    public String getText() {
        return this.m_Name;
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    public void setUserObject(Object object) {
        if (object != null) {
            super.setUserObject(object);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.m_Name + ": " + this.getUserObject().toString() + "]";
    }

    public Number getZeroValue() throws NumberClassNotFoundException {
        Number number = this.getValue();
        Number number2 = null;
        if (number instanceof Double) {
            number2 = new Double(0.0);
        } else if (number instanceof Integer) {
            number2 = new Integer(0);
        } else if (number instanceof Float) {
            number2 = new Float(0.0);
        } else if (number instanceof Long) {
            number2 = new Long(0L);
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " not currently supported.");
        }
        return number2;
    }

    public Number getOneValue() throws NumberClassNotFoundException {
        Number number = this.getValue();
        Number number2 = null;
        if (number instanceof Double) {
            number2 = new Double(1.0);
        } else if (number instanceof Integer) {
            number2 = new Integer(1);
        } else if (number instanceof Float) {
            number2 = new Float(1.0);
        } else if (number instanceof Long) {
            number2 = new Long(1L);
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " not currently supported.");
        }
        return number2;
    }

    public Number getTwoValue() throws NumberClassNotFoundException {
        Number number = this.getValue();
        Number number2 = null;
        if (number instanceof Double) {
            number2 = new Double(2.0);
        } else if (number instanceof Integer) {
            number2 = new Integer(2);
        } else if (number instanceof Float) {
            number2 = new Float(2.0);
        } else if (number instanceof Long) {
            number2 = new Long(2L);
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " not currently supported.");
        }
        return number2;
    }

    public Number addNumbers(Number number, Number number2) throws NumberClassNotFoundException {
        Number number3 = null;
        if (number instanceof Double && number2 instanceof Double) {
            number3 = new Double(NumberNode.roundDouble(number.doubleValue() + number2.doubleValue()));
        } else if (number instanceof Integer && number2 instanceof Integer) {
            number3 = new Integer(number.intValue() + number2.intValue());
        } else if (number instanceof Float && number2 instanceof Float) {
            number3 = new Float(NumberNode.roundFloat(number.floatValue() + number2.floatValue()));
        } else if (number instanceof Long && number2 instanceof Long) {
            number3 = new Long(number.longValue() + number2.longValue());
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " and " + number2.getClass() + " not currently supported.");
        }
        return number3;
    }

    public Number multiplyNumbers(Number number, Number number2) throws NumberClassNotFoundException {
        Number number3 = null;
        if (number instanceof Double && number2 instanceof Double) {
            number3 = new Double(NumberNode.roundDouble(number.doubleValue() * number2.doubleValue()));
        } else if (number instanceof Integer && number2 instanceof Integer) {
            number3 = new Integer(number.intValue() * number2.intValue());
        } else if (number instanceof Float && number2 instanceof Float) {
            number3 = new Float(NumberNode.roundFloat(number.floatValue() * number2.floatValue()));
        } else if (number instanceof Long && number2 instanceof Long) {
            number3 = new Long(number.longValue() * number2.longValue());
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " and " + number2.getClass() + " not currently supported.");
        }
        return number3;
    }

    public boolean lessThan(Number number, Number number2) throws NumberClassNotFoundException {
        boolean bl = false;
        if (number instanceof Double && number2 instanceof Double) {
            if (number.doubleValue() < number2.doubleValue()) {
                bl = true;
            }
        } else if (number instanceof Integer && number2 instanceof Integer) {
            if (number.intValue() < number2.intValue()) {
                bl = true;
            }
        } else if (number instanceof Float && number2 instanceof Float) {
            if (number.floatValue() < number2.floatValue()) {
                bl = true;
            }
        } else if (number instanceof Long && number2 instanceof Long) {
            if (number.longValue() < number2.longValue()) {
                bl = true;
            }
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " and " + number2.getClass() + " not currently supported.");
        }
        return bl;
    }

    public boolean equals(Number number, Number number2) throws NumberClassNotFoundException {
        boolean bl = false;
        if (number instanceof Double && number2 instanceof Double) {
            if (Math.abs(number.doubleValue() - number2.doubleValue()) < 1.0E-6) {
                bl = true;
            }
        } else if (number instanceof Integer && number2 instanceof Integer) {
            if (number.intValue() == number2.intValue()) {
                bl = true;
            }
        } else if (number instanceof Float && number2 instanceof Float) {
            if ((double)Math.abs(number.floatValue() - number2.floatValue()) < 1.0E-6) {
                bl = true;
            }
        } else if (number instanceof Long && number2 instanceof Long) {
            if (number.longValue() == number2.longValue()) {
                bl = true;
            }
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " and " + number2.getClass() + " not currently supported.");
        }
        return bl;
    }

    public NumberFormat getNumberFormat() throws NumberClassNotFoundException {
        NumberFormat numberFormat = null;
        Number number = this.getValue();
        if (number instanceof Double) {
            numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(7);
        } else if (number instanceof Integer) {
            numberFormat = NumberFormat.getIntegerInstance();
        } else if (number instanceof Float) {
            numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(7);
        } else if (number instanceof Long) {
            numberFormat = NumberFormat.getIntegerInstance();
        } else {
            throw new NumberClassNotFoundException(number.getClass() + " not currently supported.");
        }
        return numberFormat;
    }
}

