/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.internalConstraints;

import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;

public final class Outbox
extends InternalConstraint {
    private int[] t;
    private int[] l;

    public Outbox(int[] t, int[] l) {
        super(2);
        this.t = t;
        this.l = l;
    }

    public int[] getL() {
        return this.l;
    }

    public int getL(int index) {
        return this.l[index];
    }

    public void setL(int[] l) {
        this.l = l;
    }

    public int[] getT() {
        return this.t;
    }

    public int getT(int index) {
        return this.t[index];
    }

    public void setT(int[] t) {
        this.t = t;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int aT : this.t) {
            res.append("[").append(aT).append("],");
        }
        for (int i = 0; i < this.t.length; ++i) {
            res.append("[").append(this.l[i]).append("],");
        }
        return res.toString();
    }

    public int adjacent(Outbox ob) {
        int already_found = -1;
        for (int i = 0; i < this.t.length; ++i) {
            if (this.t[i] + this.l[i] == ob.getT(i) || ob.getT(i) + ob.getL(i) == this.t[i]) {
                if (already_found != -1) {
                    return -1;
                }
                already_found = i;
            }
            if (i == already_found || this.t[i] == ob.getT(i)) continue;
            return -1;
        }
        return already_found;
    }

    public void merge(Outbox ob, int dim) {
        if (ob.getT(dim) < this.t[dim]) {
            this.t[dim] = ob.getT(dim);
            int n = dim;
            this.l[n] = this.l[n] + ob.getL(dim);
        } else {
            int n = dim;
            this.l[n] = this.l[n] + ob.getL(dim);
        }
    }

    public boolean sameSize(Outbox ob, int dim) {
        for (int i = 0; i < this.t.length; ++i) {
            if (i == dim || this.l[i] == ob.getL(i)) continue;
            return false;
        }
        return true;
    }
}

