/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.real.objective;

import choco.cp.solver.search.real.objective.RealObjectiveManager;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;

public final class MinRealObjManager
extends RealObjectiveManager {
    public MinRealObjManager(RealVar objective) {
        super(objective);
    }

    @Override
    public double getInitialBoundValue() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getFloorValue() {
        return this.objective.getInf();
    }

    @Override
    public double getCeilValue() {
        return this.objective.getSup();
    }

    @Override
    protected void setBoundInterval() {
        this.boundInterval = new RealIntervalConstant(Double.NEGATIVE_INFINITY, this.targetBound);
    }

    @Override
    public void setBound() {
        double v = this.getFloorValue();
        if (v < this.bound) {
            this.bound = v;
        }
    }

    @Override
    public void setTargetBound() {
        this.targetBound = RealMath.prevFloat(this.getFloorValue());
        this.setBoundInterval();
    }

    @Override
    public boolean isTargetInfeasible() {
        return this.targetBound < this.floorBound;
    }
}

