## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(digits = 3)

## ----setup--------------------------------------------------------------------
library(ratesci)

## -----------------------------------------------------------------------------
scaspci(x = 1, n = 29)

## -----------------------------------------------------------------------------
scoreci(x1 = 1, n1 = 29, contrast = "p")$estimates

## -----------------------------------------------------------------------------
rateci(x = 1, n = 29)

## -----------------------------------------------------------------------------
jeffreysci(x = 1, n = 29, ai = 1.5, bi = 9.5)

## -----------------------------------------------------------------------------
rateci(x = 1, n = 29, cc = TRUE)

## -----------------------------------------------------------------------------
rateci(x = 1, n = 29, cc = 0.25)

## -----------------------------------------------------------------------------
data(compress, package = "ratesci")
strat_p <- scoreci(x1 = compress$event.control, 
                   n1 = compress$n.control, 
                   contrast = "p", 
                   stratified = TRUE)
strat_p$estimates

## -----------------------------------------------------------------------------
strat_p$pval

## -----------------------------------------------------------------------------
strat_p$Qtest

## -----------------------------------------------------------------------------
strat_p$stratdata

## -----------------------------------------------------------------------------
strat_p_rand <- scoreci(x1 = compress$event.control, 
                        n1 = compress$n.control, 
                        contrast = "p", 
                        stratified = TRUE, 
                        random = TRUE,
                        prediction = TRUE)
strat_p_rand$estimates
strat_p_rand$pval

## -----------------------------------------------------------------------------
strat_p_rand$prediction

## ----include = FALSE----------------------------------------------------------
options(digits = 4)

## -----------------------------------------------------------------------------
  # Data from Liang 1992
  x <- c(rep(c(0, 1), c(36, 12)),
          rep(c(0, 1, 2), c(15, 7, 1)),
          rep(c(0, 1, 2, 3), c(5, 7, 3, 2)),
          rep(c(0, 1, 2), c(3, 3, 1)),
          c(0, 2, 3, 4, 6))
  n <- c(rep(1, 48),
          rep(2, 23),
          rep(3, 17),
          rep(4, 7),
          rep(6, 5))
  # Wilson-based interval as per Saha et al.
  clusterpci(x, n, skew = FALSE)
  # Skewness-corrected version
  clusterpci(x, n, skew = TRUE)

