/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.IBipartiteList;
import org.chocosolver.util.tools.ArrayUtils;

final class BipartiteList
implements IBipartiteList {
    private int capacity;
    int first;
    int last;
    final IStateInt splitter;
    Propagator<?>[] propagators;
    int[] pindices;

    BipartiteList(IEnvironment environment) {
        this.splitter = environment.makeInt(0);
        this.last = 0;
        this.first = 0;
        this.capacity = 1;
        this.propagators = new Propagator[this.capacity];
        this.pindices = new int[this.capacity];
    }

    @Override
    public int getFirst() {
        return this.first;
    }

    @Override
    public int getLast() {
        return this.last;
    }

    @Override
    public int getSplitter() {
        return this.splitter.get();
    }

    @Override
    public Propagator<?> get(int i) {
        return this.propagators[i];
    }

    @Override
    public int add(Propagator<?> propagator, int idxInVar) {
        if (this.first > 0 && this.splitter.get() == 0) {
            this.shiftTail();
        }
        if (this.last == this.capacity - 1) {
            this.capacity = ArrayUtils.newBoundedSize(this.capacity, this.capacity * 2);
            this.propagators = Arrays.copyOf(this.propagators, this.capacity);
            this.pindices = Arrays.copyOf(this.pindices, this.capacity);
        }
        this.propagators[this.last] = propagator;
        this.pindices[this.last++] = idxInVar;
        return this.last - 1;
    }

    @Override
    public void remove(Propagator<?> propagator, int idxInProp, AbstractVariable var) {
        int p = propagator.getVIndice(idxInProp);
        assert (p > -1);
        assert (this.propagators[p] == propagator) : "Try to unlink from " + var.getName() + ":\n" + propagator + "but found:\n" + this.propagators[p];
        assert (this.propagators[p].getVar(idxInProp) == var);
        if (p < this.splitter.get()) {
            propagator.setVIndices(idxInProp, -1);
            this.propagators[p] = this.propagators[this.first];
            this.pindices[p] = this.pindices[this.first];
            this.propagators[p].setVIndices(this.pindices[p], p);
            this.propagators[this.first] = null;
            this.pindices[this.first] = 0;
            ++this.first;
        } else {
            --this.last;
            if (p < this.last) {
                this.propagators[p] = this.propagators[this.last];
                this.pindices[p] = this.pindices[this.last];
                this.propagators[p].setVIndices(this.pindices[p], p);
            }
            this.propagators[this.last] = null;
            this.pindices[this.last] = 0;
            propagator.setVIndices(idxInProp, -1);
        }
    }

    @Override
    public void swap(Propagator<?> propagator, int idxInProp, AbstractVariable var) {
        int p = propagator.getVIndice(idxInProp);
        assert (p != -1);
        assert (this.propagators[p] == propagator) : "Try to swap from " + var.getName() + ":\n" + propagator + "but found: " + this.propagators[p];
        assert (this.propagators[p].getVar(idxInProp) == var);
        int pos = this.splitter.add(1) - 1;
        if (this.first > 0) {
            if (pos == 0) {
                this.shiftTail();
                p = propagator.getVIndice(idxInProp);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (pos < p) {
            this.propagators[p] = this.propagators[pos];
            this.propagators[pos] = propagator;
            int pi = this.pindices[p];
            this.pindices[p] = this.pindices[pos];
            this.pindices[pos] = pi;
            this.propagators[p].setVIndices(this.pindices[p], p);
            this.propagators[pos].setVIndices(this.pindices[pos], pos);
            assert (this.propagators[pos] == propagator);
        }
    }

    @Override
    public void schedule(ICause cause, PropagationEngine engine, int mask) {
        int s = this.splitter.get();
        if (this.first > 0) {
            if (s == 0) {
                this.shiftTail();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        for (int p = s; p < this.last; ++p) {
            Propagator<?> prop = this.propagators[p];
            if (!prop.isActive() || cause == prop) continue;
            engine.schedule(prop, this.pindices[p], mask);
        }
    }

    private void shiftTail() {
        int i;
        for (i = 0; i < this.last - this.first; ++i) {
            this.propagators[i] = this.propagators[i + this.first];
            this.pindices[i] = this.pindices[i + this.first];
            this.propagators[i].setVIndices(this.pindices[i], i);
        }
        for (i = this.last - this.first; i < this.last; ++i) {
            this.propagators[i] = null;
            this.pindices[i] = 0;
        }
        this.last -= this.first;
        this.first = 0;
    }

    @Override
    public Stream<Propagator<?>> stream() {
        final int s = this.splitter.get();
        if (this.first > 0 && s == 0) {
            this.shiftTail();
        }
        Spliterator it = new Spliterator<Propagator<?>>(){
            int i;
            final /* synthetic */ BipartiteList this$0;
            {
                this.this$0 = this$0;
                this.i = s;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Propagator<?>> action) {
                if (this.i < this.this$0.last) {
                    action.accept(this.this$0.propagators[this.i++]);
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<Propagator<?>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return this.this$0.last - this.this$0.first;
            }

            @Override
            public int characteristics() {
                return 4369;
            }
        };
        return StreamSupport.stream(it, false);
    }
}

