# RcppThread 2.3.0

* fixed issues with hanging interrupts on Rgui.exe and similar (#82).

* fixed non-virtual destructor warning in ProgressPrinter base class (#80, thanks @SpatLyu).

# RcppThread 2.2.0

NEW FEATURE

* Added `RMatrix` class (from the RcppParallel package) to allow 
  for thread safe access to R matrices (#74, thanks @rorynolan).

BUG FIX

* Fixed compilation warning about R_NO_REMAP being defined multiple times 
  (#77, thanks @tylermorganwall)

# RcppThread 2.1.7

BUG FIX

* enable check for standalone libatomic on Windows (#72, thanks @kalibera)


# RcppThread 2.1.6

NEW FEATURES

* allow custom message in `ProgessCounter` (thanks @tylermorganwall)


# RcppThread 2.1.5

BUG FIX

* Fixes static lifetime issue on MacM1.

# RcppThread 2.1.4

BUG FIX

* Fixes order of headers in `detectCores.cpp`.

REQUIREMENTS

* Remove `Systemrequirements: C++11`


# RcppThread 2.1.3

BUG FIX

* Fixes clang-14 warning about bitwise & with Boolean operands.


# RcppThread 2.1.2

NEW FEATURE

* R function `LdFlags()` to portably generate linker flags for `libatomic`/`pthread`. See README for details.

  
# RcppThread 2.1.0

NEW FEATURE

* safe printing to the R error stream with `RcppThread::Rcerr` (#60, thanks to
  @appelmar).

BUG FIX

* adapt thread affinity to possibly restricted CPU set (#61).


# RcppThread 2.0.1

BUG FIX

* safeguard construction of memory aligned objects.


# RcppThread 2.0.0

NEW FEATURES

* Add R function `detectCores()` (#48).

* Add classes `ProgressCounter` and `ProgressBar` for tracking progress in long-
  running loops (#49).

* Increased speed due to work-stealing and lock-free pops (#51, #52, #53).

* Free-standing `parallelFor()` and `parallelForEach()` functions now dispatch 
  to a global thread pool that persists for the entire session. This 
  significantly speeds up programs that repeatedly call these functions. (#54)
  
* New free-standing `push()`, `pushReturn()`/`async()`, and `wait()`, mirroring
  functionality from `ThreadPool`. (#56)

* Option to resize a thread pool (#56).


# RcppThread 1.0.0

* Release for JSS publication https://doi.org/10.18637/jss.v097.c01.


# RcppThread 0.5.4

* Fixed warning for move constructor in ThreadPool (#35, #36, thanks @asardaes 
  for noticing).


# RcppThread 0.5.3

* Improved handling of exceptions thrown from threads.


# RcppThread 0.5.2

* Limit number of threads in unit tests.

* Fixed typos in package vignette.


# RcppThread 0.5.1

BUG FIXES

* Fix portability issues related to `native_handle_type`.

* Fix signed/unsigned comparison in `parallelFor()`.

* Fix signed/unsigned warnings in unit tests.


# RcppThread 0.5.0

DEPENDENCIES

* Rcpp is no longer a hard dependency, but only used for unit tests. This avoids unnecessary compilation time during package installation. 

NEW FEATURES

* New vignette available, see `browseVignettes("RcppThread")`.

* New functions `parallelFor()` and `ForEach()` allowing parallel `for` loops 
  with load balancing. Can also be called as method of a `ThreadPool`.

* Options to override `std::thread` and `std::cout` with RcppThread equivalents 
  using preprocessor variables `RCPPTHREAD_OVERRIDE_THREAD` and 
  `RCPPTHREAD_OVERRIDE_COUT`.
  
* Several minor performance optimizations.


# RcppThread 0.4.0

NEW FEATURE

* New function `ThreadPool::map()` that allows to map a function a list of items.


# RcppThread 0.3.0

NEW FEATURE

* A `ThreadPool` can now be instantiated with zero threads in the pool. It
  will then do all work pushed to it in the main thread.


# RcppThread 0.2.0

NEW FEATURE

* `ThreadPool` has a new method `wait()` that waits for all jobs to be done 
  without joining the threads. This way the thread pool can be re-used for 
  different types of tasks that need to be run sequentially.


# RcppThread 0.1.3

BUG FIX

* Don't check print output of multi-threaded code b/c of random results.


# RcppThread 0.1.2

DEPENDS

* Now available for `R (>= 3.3.0)`.

BUG FIX

* Fixed a randomly failing unit test.


# RcppThread 0.1.1

BUG FIX

* Default initialize static `Rcout` instance in header file (#9; couldn't link
  shared library on r-hub, see discussion in #8) 


# RcppThread 0.1.0

* Initial release.
