/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TriangularDist
extends ContinuousDistribution {
    private double a;
    private double b;
    private double m;

    public TriangularDist() {
        this.setParams(0.0, 1.0, 0.5);
    }

    public TriangularDist(double d) {
        this.setParams(0.0, 1.0, d);
    }

    public TriangularDist(double d, double d2, double d3) {
        this.setParams(d, d2, d3);
    }

    public double density(double d) {
        return TriangularDist.density(this.a, this.b, this.m, d);
    }

    public double cdf(double d) {
        return TriangularDist.cdf(this.a, this.b, this.m, d);
    }

    public double barF(double d) {
        return TriangularDist.barF(this.a, this.b, this.m, d);
    }

    public double inverseF(double d) {
        return TriangularDist.inverseF(this.a, this.b, this.m, d);
    }

    public double getMean() {
        return TriangularDist.getMean(this.a, this.b, this.m);
    }

    public double getVariance() {
        return TriangularDist.getVariance(this.a, this.b, this.m);
    }

    public double getStandardDeviation() {
        return TriangularDist.getStandardDeviation(this.a, this.b, this.m);
    }

    public static double density(double d, double d2, double d3, double d4) {
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (d4 < d || d4 > d2) {
            return 0.0;
        }
        if (d4 <= d3 && d3 != d) {
            return 2.0 * (d4 - d) / ((d2 - d) * (d3 - d));
        }
        return 2.0 * (d2 - d4) / ((d2 - d) * (d2 - d3));
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (d4 < d) {
            return 0.0;
        }
        if (d4 <= d3 && d3 != d) {
            return (d4 - d) * (d4 - d) / ((d2 - d) * (d3 - d));
        }
        if (d4 <= d2) {
            return 1.0 - (d2 - d4) * (d2 - d4) / ((d2 - d) * (d2 - d3));
        }
        return 1.0;
    }

    public static double barF(double d, double d2, double d3, double d4) {
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (d4 <= d) {
            return 1.0;
        }
        if (d4 <= d3 && d3 != d) {
            return 1.0 - (d4 - d) * (d4 - d) / ((d2 - d) * (d3 - d));
        }
        if (d4 <= d2) {
            return (d2 - d4) * (d2 - d4) / ((d2 - d) * (d2 - d3));
        }
        return 0.0;
    }

    public static double inverseF(double d, double d2, double d3, double d4) {
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d4 <= 0.0) {
            return d;
        }
        if (d4 >= 1.0) {
            return d2;
        }
        double d5 = (d3 - d) / (d2 - d);
        return d4 <= d5 && d3 != d ? d + Math.sqrt((d2 - d) * (d3 - d) * d4) : d2 - Math.sqrt((d2 - d) * (d2 - d3) * (1.0 - d4));
    }

    public static double getMean(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 1.0 && (d3 < 0.0 || d3 > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (d + d2 + d3) / 3.0;
    }

    public static double getVariance(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 1.0 && (d3 < 0.0 || d3 > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (d * d + d2 * d2 + d3 * d3 - d * d2 - d * d3 - d2 * d3) / 18.0;
    }

    public static double getStandardDeviation(double d, double d2, double d3) {
        return Math.sqrt(TriangularDist.getVariance(d, d2, d3));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getM() {
        return this.m;
    }

    public void setParams(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 1.0 && (d3 < 0.0 || d3 > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (d >= d2) {
            throw new IllegalArgumentException("a >= b");
        }
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        this.a = d;
        this.b = d2;
        this.m = d3;
        this.supportA = d;
        this.supportB = d2;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.a, this.b, this.m};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : a = " + this.a + ", b = " + this.b + ", m = " + this.m;
    }
}

