/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RMainLoopCallbacks;

public class Rengine
extends Thread {
    public static boolean jriLoaded;
    boolean loopHasLock = false;
    static Thread mainRThread;
    public static final int SO_NilValue = 0;
    public static final int SO_GlobalEnv = 1;
    public static final int SO_EmptyEnv = 2;
    public static final int SO_BaseEnv = 3;
    public static final int SO_UnboundValue = 4;
    public static final int SO_MissingArg = 5;
    public static final int SO_NaString = 6;
    public static final int SO_BlankString = 7;
    public static int DEBUG;
    public int idleDelay = 200;
    static Rengine mainEngine;
    boolean standAlone = true;
    boolean died = false;
    boolean alive;
    boolean runLoop;
    boolean loopRunning;
    String[] args;
    Mutex Rsync = new Mutex();
    RMainLoopCallbacks callback;

    public static long getVersion() {
        return 266L;
    }

    public static boolean versionCheck() {
        return Rengine.getVersion() == Rengine.rniGetVersion();
    }

    public static Rengine getMainEngine() {
        return mainEngine;
    }

    public static boolean inMainRThread() {
        return mainRThread != null && mainRThread.equals(Thread.currentThread());
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public Rengine(String[] stringArray, boolean bl, RMainLoopCallbacks rMainLoopCallbacks) {
        this.alive = false;
        this.runLoop = bl;
        this.loopRunning = false;
        this.args = stringArray;
        this.callback = rMainLoopCallbacks;
        mainEngine = this;
        mainRThread = this;
        this.start();
        while (!this.alive && !this.died) {
            Thread.yield();
        }
    }

    public Rengine() {
        this.alive = true;
        this.runLoop = false;
        this.loopRunning = true;
        this.standAlone = false;
        this.args = new String[]{"--zero-init"};
        this.callback = null;
        mainEngine = this;
        mainRThread = Thread.currentThread();
        this.rniSetupR(this.args);
    }

    native int rniSetupR(String[] var1);

    public native int rniSetupRJava(int var1, int var2);

    public native int rniRJavaLock();

    public native int rniRJavaUnlock();

    synchronized int setupR() {
        return this.setupR(null);
    }

    synchronized int setupR(String[] stringArray) {
        int n = this.rniSetupR(stringArray);
        if (n == 0) {
            this.alive = true;
            this.died = false;
        } else {
            this.alive = false;
            this.died = true;
        }
        return n;
    }

    public synchronized native long rniParse(String var1, int var2);

    public synchronized native long rniEval(long var1, long var3);

    public synchronized native void rniProtect(long var1);

    public synchronized native void rniUnprotect(int var1);

    public synchronized native String rniGetString(long var1);

    public synchronized native String[] rniGetStringArray(long var1);

    public synchronized native int[] rniGetIntArray(long var1);

    public synchronized native int[] rniGetBoolArrayI(long var1);

    public synchronized native double[] rniGetDoubleArray(long var1);

    public synchronized native byte[] rniGetRawArray(long var1);

    public synchronized native long[] rniGetVector(long var1);

    public synchronized native long rniPutString(String var1);

    public synchronized native long rniPutStringArray(String[] var1);

    public synchronized native long rniPutIntArray(int[] var1);

    public synchronized native long rniPutBoolArrayI(int[] var1);

    public synchronized native long rniPutBoolArray(boolean[] var1);

    public synchronized native long rniPutDoubleArray(double[] var1);

    public synchronized native long rniPutRawArray(byte[] var1);

    public synchronized native long rniPutVector(long[] var1);

    public synchronized native long rniGetAttr(long var1, String var3);

    public synchronized native String[] rniGetAttrNames(long var1);

    public synchronized native void rniSetAttr(long var1, String var3, long var4);

    public synchronized native boolean rniInherits(long var1, String var3);

    public synchronized native long rniCons(long var1, long var3, long var5, boolean var7);

    public long rniCons(long l, long l2) {
        return this.rniCons(l, l2, 0L, false);
    }

    public long rniLCons(long l, long l2) {
        return this.rniCons(l, l2, 0L, true);
    }

    public synchronized native long rniCAR(long var1);

    public synchronized native long rniCDR(long var1);

    public synchronized native long rniTAG(long var1);

    public synchronized native long rniPutList(long[] var1);

    public synchronized native long[] rniGetList(long var1);

    public synchronized native String rniGetSymbolName(long var1);

    public synchronized native long rniInstallSymbol(String var1);

    public synchronized native void rniPrint(String var1, int var2);

    public synchronized native void rniPrintValue(long var1);

    public synchronized native void rniPreserve(long var1);

    public synchronized native void rniRelease(long var1);

    public synchronized native long rniParentEnv(long var1);

    public synchronized native long rniFindVar(String var1, long var2);

    public synchronized native long rniListEnv(long var1, boolean var3);

    public synchronized native long rniSpecialObject(int var1);

    public synchronized native long rniJavaToXref(Object var1);

    public synchronized native Object rniXrefToJava(long var1);

    public static native long rniGetVersion();

    public native int rniStop(int var1);

    public synchronized native boolean rniAssign(String var1, long var2, long var4);

    public synchronized native int rniExpType(long var1);

    public native void rniRunMainLoop();

    public synchronized native void rniIdle();

    public void addMainLoopCallbacks(RMainLoopCallbacks rMainLoopCallbacks) {
        this.callback = rMainLoopCallbacks;
    }

    public void startMainLoop() {
        this.runLoop = true;
    }

    public void jriWriteConsole(String string, int n) {
        if (this.callback != null) {
            this.callback.rWriteConsole(this, string, n);
        }
    }

    public void jriBusy(int n) {
        if (this.callback != null) {
            this.callback.rBusy(this, n);
        }
    }

    public String jriReadConsole(String string, int n) {
        if (DEBUG > 1) {
            System.out.println("Rengine.jreReadConsole BEGIN " + Thread.currentThread());
        }
        if (this.loopHasLock) {
            this.Rsync.unlock();
            this.loopHasLock = false;
        }
        String string2 = this.callback == null ? null : this.callback.rReadConsole(this, string, n);
        this.loopHasLock = this.Rsync.safeLock();
        if (!this.loopHasLock) {
            String string3 = "\n>>JRI Warning: jriReadConsole detected a possible deadlock [" + this.Rsync + "][" + Thread.currentThread() + "]. Proceeding without lock, but this is inherently unsafe.\n";
            this.jriWriteConsole(string3, 1);
            System.err.print(string3);
        }
        if (DEBUG > 1) {
            System.out.println("Rengine.jreReadConsole END " + Thread.currentThread());
        }
        return string2;
    }

    public void jriShowMessage(String string) {
        if (this.callback != null) {
            this.callback.rShowMessage(this, string);
        }
    }

    public void jriLoadHistory(String string) {
        if (this.callback != null) {
            this.callback.rLoadHistory(this, string);
        }
    }

    public void jriSaveHistory(String string) {
        if (this.callback != null) {
            this.callback.rSaveHistory(this, string);
        }
    }

    public String jriChooseFile(int n) {
        if (this.callback != null) {
            return this.callback.rChooseFile(this, n);
        }
        return null;
    }

    public void jriFlushConsole() {
        if (this.callback != null) {
            this.callback.rFlushConsole(this);
        }
    }

    public synchronized REXP eval(String string) {
        return this.eval(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized REXP eval(String string, boolean bl) {
        if (DEBUG > 0) {
            System.out.println("Rengine.eval(" + string + "): BEGIN " + Thread.currentThread());
        }
        boolean bl2 = this.Rsync.safeLock();
        try {
            long l;
            long l2 = this.rniParse(string, 1);
            if (l2 != 0L && (l = this.rniEval(l2, 0L)) != 0L) {
                REXP rEXP = new REXP(this, l, bl);
                if (DEBUG > 0) {
                    System.out.println("Rengine.eval(" + string + "): END (OK)" + Thread.currentThread());
                }
                REXP rEXP2 = rEXP;
                return rEXP2;
            }
        }
        finally {
            if (bl2) {
                this.Rsync.unlock();
            }
        }
        if (DEBUG > 0) {
            System.out.println("Rengine.eval(" + string + "): END (ERR)" + Thread.currentThread());
        }
        return null;
    }

    public synchronized REXP idleEval(String string) {
        return this.idleEval(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized REXP idleEval(String string, boolean bl) {
        int n = this.Rsync.tryLock();
        if (n == 1) {
            return null;
        }
        boolean bl2 = n == 0;
        try {
            long l;
            long l2 = this.rniParse(string, 1);
            if (l2 != 0L && (l = this.rniEval(l2, 0L)) != 0L) {
                REXP rEXP;
                REXP rEXP2 = rEXP = new REXP(this, l, bl);
                return rEXP2;
            }
        }
        finally {
            if (bl2) {
                this.Rsync.unlock();
            }
        }
        return null;
    }

    public Mutex getRsync() {
        return this.Rsync;
    }

    public synchronized boolean waitForR() {
        return this.alive;
    }

    public void end() {
        this.alive = false;
        this.interrupt();
    }

    @Override
    public void run() {
        block16: {
            if (DEBUG > 0) {
                System.out.println("Starting R...");
            }
            this.loopHasLock = this.Rsync.safeLock();
            try {
                if (this.setupR(this.args) == 0) {
                    if (!this.runLoop && this.loopHasLock) {
                        this.Rsync.unlock();
                        this.loopHasLock = false;
                    }
                    while (this.alive) {
                        block15: {
                            if (!this.runLoop) break block15;
                            if (DEBUG > 0) {
                                System.out.println("***> launching main loop:");
                            }
                            this.loopRunning = true;
                            this.rniRunMainLoop();
                            this.loopRunning = false;
                            if (DEBUG > 0) {
                                System.out.println("***> main loop finished:");
                            }
                            this.runLoop = false;
                            this.died = true;
                            return;
                        }
                        try {
                            Rengine.sleep(this.idleDelay);
                            if (!this.runLoop) continue;
                            this.rniIdle();
                        }
                        catch (InterruptedException interruptedException) {
                            Rengine.interrupted();
                        }
                    }
                    this.died = true;
                    if (DEBUG > 0) {
                        System.out.println("Terminating R thread.");
                    }
                    break block16;
                }
                System.err.println("Unable to start R");
            }
            finally {
                if (this.loopHasLock) {
                    this.Rsync.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assign(String string, String string2) {
        boolean bl = this.Rsync.safeLock();
        try {
            long l = this.rniPutString(string2);
            boolean bl2 = this.rniAssign(string, l, 0L);
            return bl2;
        }
        finally {
            if (bl) {
                this.Rsync.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assign(String string, REXP rEXP) {
        boolean bl = this.Rsync.safeLock();
        try {
            if (rEXP.Xt == -1) {
                boolean bl2 = this.rniAssign(string, rEXP.xp, 0L);
                return bl2;
            }
            if (rEXP.Xt == 1 || rEXP.Xt == 32) {
                int[] nArray;
                if (rEXP.rtype == 1) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = (Integer)rEXP.cont;
                } else {
                    nArray = (int[])rEXP.cont;
                }
                int[] nArray3 = nArray;
                long l = this.rniPutIntArray(nArray3);
                boolean bl3 = this.rniAssign(string, l, 0L);
                return bl3;
            }
            if (rEXP.Xt == 2 || rEXP.Xt == 33) {
                double[] dArray;
                if (rEXP.rtype == 2) {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = ((Double)rEXP.cont).intValue();
                } else {
                    dArray = (double[])rEXP.cont;
                }
                double[] dArray3 = dArray;
                long l = this.rniPutDoubleArray(dArray3);
                boolean bl4 = this.rniAssign(string, l, 0L);
                return bl4;
            }
            if (rEXP.Xt == 37) {
                long l = this.rniPutBoolArrayI((int[])rEXP.cont);
                boolean bl5 = this.rniAssign(string, l, 0L);
                return bl5;
            }
            if (rEXP.Xt == 3 || rEXP.Xt == 34) {
                String[] stringArray;
                if (rEXP.rtype == 3) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)rEXP.cont;
                } else {
                    stringArray = (String[])rEXP.cont;
                }
                String[] stringArray3 = stringArray;
                long l = this.rniPutStringArray(stringArray3);
                boolean bl6 = this.rniAssign(string, l, 0L);
                return bl6;
            }
        }
        finally {
            if (bl) {
                this.Rsync.unlock();
            }
        }
        return false;
    }

    public boolean assign(String string, double[] dArray) {
        return this.assign(string, new REXP(dArray));
    }

    public boolean assign(String string, int[] nArray) {
        return this.assign(string, new REXP(nArray));
    }

    public boolean assign(String string, boolean[] blArray) {
        return this.assign(string, new REXP(blArray));
    }

    public boolean assign(String string, String[] stringArray) {
        return this.assign(string, new REXP(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP createRJavaRef(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.getClass().getName();
        boolean bl = this.Rsync.safeLock();
        try {
            long l = this.rniEval(this.rniLCons(this.rniInstallSymbol(".jmkref"), this.rniLCons(this.rniJavaToXref(object), this.rniLCons(this.rniPutString(string), 0L))), 0L);
            if (l <= 0L && l > -4L) {
                REXP rEXP = null;
                return rEXP;
            }
            REXP rEXP = new REXP(this, l, false);
            return rEXP;
        }
        finally {
            if (bl) {
                this.Rsync.unlock();
            }
        }
    }

    static {
        block2: {
            try {
                System.loadLibrary("jri");
                jriLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                jriLoaded = false;
                String string = System.getProperty("jri.ignore.ule");
                if (string != null && string.equals("yes")) break block2;
                System.err.println("Cannot find JRI native library!\nPlease make sure that the JRI native library is in a directory listed in java.library.path.\n");
                unsatisfiedLinkError.printStackTrace();
                System.exit(1);
            }
        }
        mainRThread = null;
        DEBUG = 0;
        mainEngine = null;
    }
}

