/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class SpringLayout
implements LayoutManager {
    private Type type;
    private int inset;

    public SpringLayout(Type type, int n) {
        this.type = type;
        this.inset = n;
    }

    public SpringLayout(Type type) {
        this(type, 0);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        JComponent jComponent;
        Border border;
        Dimension dimension = container.getSize();
        Dimension dimension2 = container.getPreferredSize();
        Insets insets = new Insets(0, 0, 0, 0);
        if (container instanceof JComponent && (border = (jComponent = (JComponent)container).getBorder()) != null) {
            insets = border.getBorderInsets(container);
        }
        int n = insets.left;
        int n2 = insets.top;
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.bottom + insets.top;
        dimension2.width -= insets.left + insets.right;
        dimension2.height -= insets.bottom + insets.top;
        int n3 = 0;
        int n4 = container.getComponentCount();
        if (this.type == Type.HORIZONTAL) {
            int n5 = (dimension.width - dimension2.width) / container.getComponentCount();
            for (Component component : container.getComponents()) {
                component.setLocation(n, n2);
                int n6 = component.getPreferredSize().width + n5;
                if (n3 == n4 - 1) {
                    n6 = dimension.width - n + insets.left;
                }
                n += n6;
                n += this.inset;
                component.setSize(new Dimension(n6, dimension.height));
                ++n3;
            }
        } else {
            int n7 = (dimension.height - dimension2.height) / container.getComponentCount();
            for (Component component : container.getComponents()) {
                component.setLocation(n, n2);
                int n8 = component.getPreferredSize().height + n7;
                if (n3 == n4 - 1) {
                    n8 = dimension.height - n2 + insets.top;
                }
                n2 += n8;
                n2 += this.inset;
                component.setSize(new Dimension(dimension.width, n8));
                ++n3;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Component[] componentArray;
        Insets insets = new Insets(0, 0, 0, 0);
        if (container instanceof JComponent && (componentArray = (serializable = (JComponent)container).getBorder()) != null) {
            insets = componentArray.getBorderInsets(container);
        }
        serializable = new Dimension();
        for (Component component : container.getComponents()) {
            Dimension dimension = component.getPreferredSize();
            if (this.type == Type.HORIZONTAL) {
                ((Dimension)serializable).width += dimension.width;
                ((Dimension)serializable).height = Math.max(((Dimension)serializable).height, dimension.height);
                continue;
            }
            ((Dimension)serializable).width = Math.max(((Dimension)serializable).width, dimension.width);
            ((Dimension)serializable).height += dimension.height;
        }
        if (container.getComponentCount() > 1 && this.inset > 0) {
            if (this.type == Type.HORIZONTAL) {
                ((Dimension)serializable).width += (container.getComponentCount() - 1) * this.inset;
            } else {
                ((Dimension)serializable).height += (container.getComponentCount() - 1) * this.inset;
            }
        }
        ((Dimension)serializable).width += insets.left + insets.right;
        ((Dimension)serializable).height += insets.top + insets.bottom;
        return serializable;
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    public static enum Type {
        VERTICAL,
        HORIZONTAL;

    }
}

