## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ProxReg)

## ----echo=FALSE , out.width="50%"---------------------------------------------

knitr::include_graphics(system.file("extdata", "ols.jpg", package = "ProxReg"))



## -----------------------------------------------------------------------------
df = data.frame("hours"=c(1, 2, 4, 5, 5, 6, 6, 7, 8, 10, 11, 11, 12, 12, 14),
"score"=c(64, 66, 76, 73, 74, 81, 83, 82, 80, 88, 84, 82, 91, 93, 89),
"entertain_hours"=c(6,5,3,2,2,2,1,1,0.5,1,0.3,0.3,0.2,0.2,0.1))
ols(df,"score",c("hours","entertain_hours"),alpha = 0.025,verbose = FALSE)

## ----echo=FALSE , out.width="70%"---------------------------------------------

knitr::include_graphics(system.file("extdata", "k_fold.png", package = "ProxReg"))


## -----------------------------------------------------------------------------
df = data.frame("hours"=c(1, 2, 4, 5, 5, 6, 6, 7, 8, 10, 11, 11, 12, 12, 14),
"score"=c(64, 66, 76, 73, 74, 81, 83, 82, 80, 88, 84, 82, 91, 93, 89),
"entertain_hours"=c(6,5,3,2,2,2,1,1,0.5,1,0.3,0.3,0.2,0.2,0.1))

k_fold_cross(df,k=3)


## -----------------------------------------------------------------------------
ols_KCV(df,k=5,"hours",c("score","entertain_hours"))

## ----echo=FALSE , out.width="70%"---------------------------------------------

knitr::include_graphics(system.file("extdata", "ridge.png", package = "ProxReg"))


## ----echo=FALSE , out.width="70%"---------------------------------------------

knitr::include_graphics(system.file("extdata", "lasso.png", package = "ProxReg"))

## ----echo=FALSE , out.width="70%"---------------------------------------------
knitr::include_graphics(system.file("extdata", "ridge_lasso.png", package = "ProxReg"))


## -----------------------------------------------------------------------------
library("glmnet")
data("QuickStartExample")
test<-as.data.frame(cbind(QuickStartExample$y,QuickStartExample$x))
ridge(data=test,y="V1",x=colnames(test)[2:21],lambda=c(0.01,0.1))

