/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.FortranMatrixUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.lightgbm.Classification;
import org.jpmml.lightgbm.Section;
import org.jpmml.lightgbm.Tree;

public class MultinomialLogisticRegression
extends Classification {
    public MultinomialLogisticRegression(Section config) {
        super(config);
        int num_class = config.getInt("num_class");
        if (num_class < 3) {
            throw new IllegalArgumentException("Multi-class classification requires three or more target categories");
        }
    }

    @Override
    public MiningModel encodeModel(List<Tree> trees, Integer numIteration, Schema schema) {
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        ArrayList<MiningModel> miningModels = new ArrayList<MiningModel>();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        int rows = categoricalLabel.size();
        int columns = trees.size() / rows;
        for (int i = 0; i < rows; ++i) {
            MiningModel miningModel = this.createMiningModel(FortranMatrixUtil.getRow(trees, (int)rows, (int)columns, (int)i), numIteration, segmentSchema).setOutput(ModelUtil.createPredictedOutput((String)FieldNameUtil.create((String)"lgbmValue", (Object[])new Object[]{categoricalLabel.getValue(i)}), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[0]));
            miningModels.add(miningModel);
        }
        return MiningModelUtil.createClassification(miningModels, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.SOFTMAX, (boolean)true, (Schema)schema);
    }
}

