/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.propagation.PropagationObserver;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;

public class PropagationEngineObserver
extends PropagationEngine {
    private final PropagationObserver observer;

    public PropagationEngineObserver(Model model, PropagationObserver observer) {
        super(model);
        this.observer = observer;
    }

    @Override
    public void execute(Propagator<?> propagator) throws ContradictionException {
        if (propagator.isStateLess() || propagator.isActive()) {
            this.observer.onCoarseEvent(propagator);
        }
        super.execute(propagator);
    }

    @Override
    protected void propagateEvents() throws ContradictionException {
        try {
            if (this.lastProp.reactToFineEvent()) {
                this.observer.onFineEvent(this.lastProp);
                this.lastProp.doFinePropagation();
                int dp = this.getDelayedPropagation();
                if (dp > 0) {
                    this.observer.onCoarseEvent(this.lastProp);
                    this.lastProp.propagate(dp);
                }
            } else if (this.lastProp.isActive()) {
                this.observer.onCoarseEvent(this.lastProp);
                this.lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
            }
        }
        catch (ContradictionException cex) {
            this.observer.onFailure(cex.c, this.lastProp);
            throw cex;
        }
    }

    @Override
    public void onVariableUpdate(Variable variable, IEventType type, ICause cause) {
        if (cause instanceof Propagator) {
            this.observer.onFiltering(cause, this.lastProp);
        }
        this.observer.onVariableModification(variable, type, cause);
        super.onVariableUpdate(variable, type, cause);
    }
}

