/*
 * Decompiled with CFR 0.152.
 */
package javalain.ea.quality;

import java.util.Arrays;
import javalain.ea.operator.comparator.LexicographicalComparator;
import javalain.math.Calcul;

public final class DistanceFront {
    public static double generationalDistance(double[][] front, double[][] trueParetoFront) {
        double[] maxValues = DistanceFront.getMaxValues(trueParetoFront);
        double[] minValues = DistanceFront.getMinValues(trueParetoFront);
        double[][] normalizedFront = DistanceFront.getNormalizedFront(front, minValues, maxValues);
        double[][] normalizedParetoFront = DistanceFront.getNormalizedFront(trueParetoFront, minValues, maxValues);
        double sommme = 0.0;
        for (int i = 0; i < normalizedFront.length; ++i) {
            sommme += Calcul.pow2(DistanceFront.distanceToClosedPoint(normalizedFront[i], normalizedParetoFront));
        }
        return Math.sqrt(sommme) / (double)normalizedFront.length;
    }

    public static double invertedGenerationalDistance(double[][] front, double[][] trueParetoFront) {
        double[] maxValues = DistanceFront.getMaxValues(trueParetoFront);
        double[] minValues = DistanceFront.getMinValues(trueParetoFront);
        double[][] normalizedFront = DistanceFront.getNormalizedFront(front, minValues, maxValues);
        double[][] normalizedParetoFront = DistanceFront.getNormalizedFront(trueParetoFront, minValues, maxValues);
        double sommme = 0.0;
        for (int i = 0; i < normalizedParetoFront.length; ++i) {
            sommme += Calcul.pow2(DistanceFront.distanceToClosedPoint(normalizedParetoFront[i], normalizedFront));
        }
        return Math.sqrt(sommme) / (double)normalizedParetoFront.length;
    }

    public static double spread(double[][] front, double[][] trueParetoFront) {
        int i;
        double[] maxValues = DistanceFront.getMaxValues(trueParetoFront);
        double[] minValues = DistanceFront.getMinValues(trueParetoFront);
        double[][] normalizedFront = DistanceFront.getNormalizedFront(front, minValues, maxValues);
        double[][] normalizedParetoFront = DistanceFront.getNormalizedFront(trueParetoFront, minValues, maxValues);
        LexicographicalComparator lex_comparateur = new LexicographicalComparator();
        Arrays.sort(normalizedFront, lex_comparateur);
        Arrays.sort(normalizedParetoFront, lex_comparateur);
        double df = Calcul.distanceEuclidienne(normalizedFront[0], normalizedParetoFront[0]);
        double dl = Calcul.distanceEuclidienne(normalizedFront[normalizedFront.length - 1], normalizedParetoFront[normalizedParetoFront.length - 1]);
        double moyenne = 0.0;
        double somme = df + dl;
        for (i = 0; i < normalizedFront.length - 1; ++i) {
            moyenne += Calcul.distanceEuclidienne(normalizedFront[i], normalizedFront[i + 1]);
        }
        moyenne /= (double)(normalizedFront.length - 1);
        if (normalizedFront.length > 1) {
            for (i = 0; i < normalizedFront.length - 1; ++i) {
                somme += Math.abs(Calcul.distanceEuclidienne(normalizedFront[i], normalizedFront[i + 1]) - moyenne);
            }
            return somme / (df + dl + (double)(normalizedFront.length - 1) * moyenne);
        }
        return 1.0;
    }

    public static double hypervolume(double[][] front, double[][] trueParetoFront) {
        double[] maxValues = DistanceFront.getMaxValues(trueParetoFront);
        double[] minValues = DistanceFront.getMinValues(trueParetoFront);
        double[][] normalizedFront = DistanceFront.getNormalizedFront(front, minValues, maxValues);
        double[][] invertedFront = DistanceFront.inverseFront(normalizedFront);
        return DistanceFront.calculHypervolume(invertedFront, invertedFront.length, invertedFront[0].length);
    }

    private static double[] getMaxValues(double[][] front) {
        int nbObj = front[0].length;
        double[] maxValues = new double[nbObj];
        Arrays.fill(maxValues, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < front.length; ++i) {
            for (int j = 0; j < nbObj; ++j) {
                if (!(front[i][j] > maxValues[j])) continue;
                maxValues[j] = front[i][j];
            }
        }
        return maxValues;
    }

    private static double[] getMinValues(double[][] front) {
        int nbObj = front[0].length;
        double[] minValues = new double[nbObj];
        Arrays.fill(minValues, Double.POSITIVE_INFINITY);
        for (int i = 0; i < front.length; ++i) {
            for (int j = 0; j < nbObj; ++j) {
                if (!(front[i][j] < minValues[j])) continue;
                minValues[j] = front[i][j];
            }
        }
        return minValues;
    }

    private static double[][] getNormalizedFront(double[][] front, double[] minimumValue, double[] maximumValue) {
        int nbSol = front.length;
        int nbObj = front[0].length;
        double[][] normalizedFront = new double[nbSol][nbObj];
        for (int i = 0; i < nbSol; ++i) {
            for (int j = 0; j < nbObj; ++j) {
                normalizedFront[i][j] = (front[i][j] - minimumValue[j]) / (maximumValue[j] - minimumValue[j]);
            }
        }
        return normalizedFront;
    }

    private static double distanceToClosedPoint(double[] point, double[][] front) {
        double min = Calcul.distanceEuclidienne(point, front[0]);
        for (int i = 1; i < front.length; ++i) {
            double d = Calcul.distanceEuclidienne(point, front[i]);
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    private static double[][] inverseFront(double[][] front) {
        double[][] inverseFront = new double[front.length][];
        for (int i = 0; i < front.length; ++i) {
            inverseFront[i] = new double[front[i].length];
            for (int j = 0; j < front[i].length; ++j) {
                if (front[i][j] <= 1.0 && front[i][j] >= 0.0) {
                    inverseFront[i][j] = 1.0 - front[i][j];
                    continue;
                }
                if (front[i][j] > 1.0) {
                    inverseFront[i][j] = 0.0;
                    continue;
                }
                if (!(front[i][j] < 0.0)) continue;
                inverseFront[i][j] = 1.0;
            }
        }
        return inverseFront;
    }

    private static double calculHypervolume(double[][] front, int noPoints, int noObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        int n = noPoints;
        while (n > 0) {
            int noNondominatedPoints = DistanceFront.filterNondominatedSet(front, n, noObjectives - 1);
            double tempVolume = 0.0;
            if (noObjectives < 3) {
                if (noNondominatedPoints < 1) {
                    System.err.println("run-time error");
                }
                tempVolume = front[0][0];
            } else {
                tempVolume = DistanceFront.calculHypervolume(front, noNondominatedPoints, noObjectives - 1);
            }
            double tempDistance = DistanceFront.surfaceUnchangedTo(front, n, noObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            n = DistanceFront.reduceNondominatedSet(front, n, noObjectives - 1, distance);
        }
        return volume;
    }

    static int filterNondominatedSet(double[][] front, int noPoints, int noObjectives) {
        int n = noPoints;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (DistanceFront.dominates(front[i], front[j], noObjectives)) {
                    DistanceFront.swap(front, j, --n);
                    continue;
                }
                if (DistanceFront.dominates(front[j], front[i], noObjectives)) {
                    DistanceFront.swap(front, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    static double surfaceUnchangedTo(double[][] front, int noPoints, int objective) {
        if (noPoints < 1) {
            System.err.println("run-time error");
        }
        double minValue = front[0][objective];
        for (int i = 1; i < noPoints; ++i) {
            double value = front[i][objective];
            if (!(value < minValue)) continue;
            minValue = value;
        }
        return minValue;
    }

    static int reduceNondominatedSet(double[][] front, int noPoints, int objective, double threshold) {
        int n = noPoints;
        for (int i = 0; i < n; ++i) {
            if (!(front[i][objective] <= threshold)) continue;
            DistanceFront.swap(front, i, --n);
        }
        return n;
    }

    static boolean dominates(double[] point1, double[] point2, int noObjectives) {
        int i;
        int betterInAnyObjective = 0;
        for (i = 0; i < noObjectives && point1[i] >= point2[i]; ++i) {
            if (!(point1[i] > point2[i])) continue;
            betterInAnyObjective = 1;
        }
        return i >= noObjectives && betterInAnyObjective > 0;
    }

    static void swap(double[][] front, int i, int j) {
        double[] temp = front[i];
        front[i] = front[j];
        front[j] = temp;
    }
}

