/*
 * Decompiled with CFR 0.152.
 */
package mrmc.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.StatTest;
import mrmc.gui.GUInterface;

public class InputSummaryCard {
    private GUInterface GUI;
    private InputFile InputFile1;
    private DBRecord DBRecordStat;
    private DBRecord DBRecordSize;
    JTextField JTextFilename;
    public static final int USE_MLE = 1;
    public static final int NO_MLE = 0;
    public int FlagMLE = 0;
    private JCheckBox mleCheckBoxSummary;
    private JComboBox<String> chooseA;
    public String loadmodalityA;
    public String loadmodalityB;

    public void resetInputSummaryCard() {
        this.JTextFilename.setText("");
        this.FlagMLE = 0;
        this.mleCheckBoxSummary.setSelected(false);
        this.chooseA.removeAllItems();
        this.chooseA.addItem("Choose Modality");
    }

    public InputSummaryCard(JPanel CardInputModeImrmc, GUInterface GUInterface_temp) {
        this.GUI = GUInterface_temp;
        this.InputFile1 = this.GUI.InputFile1;
        this.DBRecordStat = this.GUI.DBRecordStat;
        this.DBRecordSize = this.GUI.DBRecordSize;
        JLabel studyLabel = new JLabel(".imrmc, .omrmc or. csv file  ");
        this.JTextFilename = new JTextField(20);
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new brwsButtonListener());
        JPanel RawStudyCardRow1 = new JPanel();
        RawStudyCardRow1.add(studyLabel);
        RawStudyCardRow1.add(this.JTextFilename);
        RawStudyCardRow1.add(browseButton);
        this.mleCheckBoxSummary = new JCheckBox("MLE (avoid negatives)");
        this.mleCheckBoxSummary.setSelected(false);
        this.mleCheckBoxSummary.addItemListener(new UseMLEListener());
        this.chooseA = new JComboBox();
        this.chooseA.addItemListener(new ModalitySelectListener());
        JPanel RawStudyCardRow2 = new JPanel();
        RawStudyCardRow2.add(this.mleCheckBoxSummary);
        RawStudyCardRow2.add(this.chooseA);
        this.resetInputSummaryCard();
        GroupLayout layout = new GroupLayout(CardInputModeImrmc);
        CardInputModeImrmc.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(RawStudyCardRow1)).addGroup(layout.createSequentialGroup().addComponent(RawStudyCardRow2))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(RawStudyCardRow1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(RawStudyCardRow2)));
    }

    public void varianceAnalysis() {
        System.out.println("MRMC Variance analysis button clicked. RawStudyCard.varAnalysisListener");
        String name = this.JTextFilename.getText();
        System.out.println("name=" + name);
        if (name.equals(null) || name.equals("")) {
            JFrame frame = this.GUI.MRMCobject.getFrame();
            JOptionPane.showMessageDialog(frame, "Please browse for .imrmc .omrmc or .csv input file", " Error", 0);
            return;
        }
        if (this.DBRecordStat.modalityA == "NO_MOD" && this.DBRecordStat.modalityB == "NO_MOD") {
            JFrame frame = this.GUI.MRMCobject.getFrame();
            JOptionPane.showMessageDialog(frame, "You must select at least one modality", "Error", 0);
            return;
        }
        this.DBRecordStat.DBRecordStatFillSummary(this.DBRecordStat);
        this.GUI.hasNegative = !(this.DBRecordStat.totalVar > 0.0);
        if (this.GUI.hasNegative && this.FlagMLE == 0) {
            JFrame frame = this.GUI.MRMCobject.getFrame();
            int result = JOptionPane.showConfirmDialog(frame, "The total variance estimate is negative.\nPlease report to the program developers. This is not expected.\nDo you want to proceed with MLE estimates to avoid negatives?");
            if (2 == result) {
                System.out.println("cancel");
            } else if (result == 0) {
                this.DBRecordStat.flagMLE = this.FlagMLE = 1;
                this.mleCheckBoxSummary.setSelected(true);
                this.DBRecordStat.totalVar = this.DBRecordStat.totalVarMLE;
                this.DBRecordStat.varA = this.DBRecordStat.varAMLE;
                this.DBRecordStat.varB = this.DBRecordStat.varBMLE;
                this.DBRecordStat.readerTotalVar = this.DBRecordStat.readerTotalVarMLE;
                this.DBRecordStat.readerVarA = this.DBRecordStat.readerVarAMLE;
                this.DBRecordStat.readerVarB = this.DBRecordStat.readerVarBMLE;
                this.DBRecordStat.SE = Math.sqrt(this.DBRecordStat.totalVar);
                this.DBRecordStat.testStat = new StatTest(this.DBRecordStat);
            } else if (1 == result) {
                this.FlagMLE = 0;
            }
        }
        this.DBRecordStat.flagMLE = this.FlagMLE;
        this.GUI.StatPanel1.setStatPanel();
        this.GUI.StatPanel1.setTable1();
        this.DBRecordSize.Nreader = this.DBRecordStat.Nreader;
        this.DBRecordSize.Nnormal = this.DBRecordStat.Nnormal;
        this.DBRecordSize.Ndisease = this.DBRecordStat.Ndisease;
        this.GUI.SizePanel1.NreaderJTextField.setText(Long.toString(this.DBRecordStat.Nreader));
        this.GUI.SizePanel1.NnormalJTextField.setText(Long.toString(this.DBRecordStat.Nnormal));
        this.GUI.SizePanel1.NdiseaseJTextField.setText(Long.toString(this.DBRecordStat.Ndisease));
    }

    class ModalitySelectListener
    implements ItemListener {
        ModalitySelectListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 2) {
                return;
            }
            if (InputSummaryCard.this.chooseA.getSelectedItem() == null) {
                return;
            }
            ((InputSummaryCard)InputSummaryCard.this).GUI.StatPanel1.resetStatPanel();
            ((InputSummaryCard)InputSummaryCard.this).GUI.StatPanel1.resetTable1();
            ((InputSummaryCard)InputSummaryCard.this).GUI.SizePanel1.resetSizePanel();
            boolean modA = !InputSummaryCard.this.chooseA.getSelectedItem().equals("Choose Modality");
            ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA = modA ? (String)InputSummaryCard.this.chooseA.getSelectedItem() : "NO_MOD";
            if (((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA.equals("A vs B:" + InputSummaryCard.this.loadmodalityA + " vs " + InputSummaryCard.this.loadmodalityB)) {
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA = InputSummaryCard.this.loadmodalityA;
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB = InputSummaryCard.this.loadmodalityB;
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.selectedMod = 3;
                InputSummaryCard.this.varianceAnalysis();
            } else if (((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA.equals("A:" + InputSummaryCard.this.loadmodalityA)) {
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA = InputSummaryCard.this.loadmodalityA;
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB = "NO_MOD";
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.selectedMod = 0;
                InputSummaryCard.this.varianceAnalysis();
            } else if (((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA.equals("B:" + InputSummaryCard.this.loadmodalityB)) {
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA = "NO_MOD";
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB = InputSummaryCard.this.loadmodalityB;
                ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.selectedMod = 1;
                InputSummaryCard.this.varianceAnalysis();
            }
            ((InputSummaryCard)InputSummaryCard.this).DBRecordSize.selectedMod = ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.selectedMod;
            ((InputSummaryCard)InputSummaryCard.this).DBRecordSize.modalityA = ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA;
        }
    }

    class UseMLEListener
    implements ItemListener {
        UseMLEListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            InputSummaryCard.this.FlagMLE = InputSummaryCard.this.mleCheckBoxSummary.isSelected() ? 1 : 0;
            ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.flagMLE = InputSummaryCard.this.FlagMLE;
            ((InputSummaryCard)InputSummaryCard.this).GUI.StatPanel1.resetStatPanel();
            ((InputSummaryCard)InputSummaryCard.this).GUI.StatPanel1.resetTable1();
            ((InputSummaryCard)InputSummaryCard.this).GUI.SizePanel1.resetSizePanel();
            if (((InputSummaryCard)InputSummaryCard.this).GUI.resetcall == 0) {
                InputSummaryCard.this.varianceAnalysis();
            }
        }
    }

    class brwsButtonListener
    implements ActionListener {
        brwsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputSummaryCard.this.GUI.resetGUI();
            if (GUInterface.selectedInput == "Please choose input file mode") {
                JOptionPane.showMessageDialog(((InputSummaryCard)InputSummaryCard.this).GUI.MRMCobject.getFrame(), "Please choose one kind of input file.", "Error", 0);
                return;
            }
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("iMRMC Input Files (.imrmc, omrmc or csv)", "imrmc", "omrmc", "csv");
            if (((InputSummaryCard)InputSummaryCard.this).GUI.inputfileDirectory != null) {
                fc.setCurrentDirectory(((InputSummaryCard)InputSummaryCard.this).GUI.inputfileDirectory);
            }
            fc.setFileFilter(filter);
            int returnVal = fc.showOpenDialog((Component)e.getSource());
            if (returnVal == 1 || returnVal == -1) {
                return;
            }
            ((InputSummaryCard)InputSummaryCard.this).GUI.inputfileDirectory = fc.getCurrentDirectory();
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            ((InputSummaryCard)InputSummaryCard.this).InputFile1.fileName = f.getName();
            ((InputSummaryCard)InputSummaryCard.this).InputFile1.filePath = f.getParent();
            ((InputSummaryCard)InputSummaryCard.this).InputFile1.filePathAndName = f.getPath();
            InputSummaryCard.this.JTextFilename.setText(f.getPath());
            try {
                InputSummaryCard.this.InputFile1.ReadInputFile(InputSummaryCard.this.GUI);
            }
            catch (IOException except) {
                except.printStackTrace();
                JOptionPane.showMessageDialog(((InputSummaryCard)InputSummaryCard.this).GUI.MRMCobject.getFrame(), except.getMessage(), "Error", 0);
                InputSummaryCard.this.GUI.resetGUI();
                InputSummaryCard.this.JTextFilename.setText("");
                return;
            }
            if (!((InputSummaryCard)InputSummaryCard.this).InputFile1.dataCheckResults.isEmpty()) {
                JOptionPane.showMessageDialog(((InputSummaryCard)InputSummaryCard.this).GUI.MRMCobject.getFrame(), ((InputSummaryCard)InputSummaryCard.this).InputFile1.dataCheckResults, "Warning: Input Header Values Do Not Match Actual Values", 2);
            } else {
                JOptionPane.showMessageDialog(((InputSummaryCard)InputSummaryCard.this).GUI.MRMCobject.getFrame(), "NR = " + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.NreaderDB + " N0 = " + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.NnormalDB + " N1 = " + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.NdiseaseDB, "Summary Info", 1);
            }
            if (((InputSummaryCard)InputSummaryCard.this).DBRecordStat.inputMod == 0) {
                InputSummaryCard.this.chooseA.addItem("A:" + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA);
                InputSummaryCard.this.loadmodalityA = ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA;
            } else if (((InputSummaryCard)InputSummaryCard.this).DBRecordStat.inputMod == 1) {
                InputSummaryCard.this.chooseA.addItem("B:" + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB);
                InputSummaryCard.this.loadmodalityB = ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB;
            } else {
                InputSummaryCard.this.loadmodalityA = ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA;
                InputSummaryCard.this.loadmodalityB = ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB;
                InputSummaryCard.this.chooseA.addItem("A:" + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA);
                InputSummaryCard.this.chooseA.addItem("B:" + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB);
                InputSummaryCard.this.chooseA.addItem("A vs B:" + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA + " vs " + ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB);
            }
            ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityA = "NO_MOD";
            ((InputSummaryCard)InputSummaryCard.this).DBRecordStat.modalityB = "NO_MOD";
        }
    }
}

