#' Printing method for class `"testL"`
#'
#' Internal printing method for `"testL"` object generated by `testL()`.
#'
#' @param x Object of class `"testL"`.
#'
#' @return Does not return a value. It is used to print out the test results.
#'
#' @export
#' @keywords internal

print.testL <- function(x, ...) {
  cat(x$test, "test\n")
  cat("\nEstimated difference L(algorithm1) - L(algorithm2):\n", x$estimate)
  cat("\nAlternative hypothesis:\n L(algorithm1) - L(algorithm2) ", x$Ha)
  cat("\nt-stat:\n", x$tval)
  cat("\np-val:\n", x$pval)
  return()
}
