% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{data_gen}
\alias{data_gen}
\title{Generation of Artificial Data}
\usage{
data_gen(n, p, pi_01, pi_10, gamma0, gamma1, e_var)
}
\arguments{
\item{n}{Sample size.}

\item{p}{The number of covariates.}

\item{pi_01}{Misclassifcation probability is P(Observed Censoring Status = 0 | Actual Censoring Status = 1).}

\item{pi_10}{Misclassifcation probability is P(Observed Censoring Status = 1 | Actual
Censoring Status = 0).}

\item{gamma0}{A scalar that links the observed survival time and true survival time in
the classical additive measurement error model \code{y*=y+gamma0+gamma1*X+v}, where y* is observed survival time and \code{y} is true survival time, and \code{x} is covariates and v is noise term.}

\item{gamma1}{A \code{p}-dimensional vector of parameters in the
additive measurement error model \code{y*=y+gamma0+gamma1*X+v}, where \code{y*}
is observed survival time and \code{y} is true survival time, \code{x} is covariates and \code{v} is
noise term.}

\item{e_var}{The variance of noise term \code{v} in the additive measurement
error model \code{y*=y+gamma0+gamma1*X+v}, where \code{v} is assumed to follow a normal
distribution.}
}
\value{
generated_data \code{c(n,p+2)} dimensional data frame. The first column is observed survival time and
second column is observed censoring status, and the other columns are covariates.
}
\description{
The function generates a set of artificial data, including covariates generated by uniform
distribution with an interval \code{[0.5, 0.5]}, survival time and censoring status with measurement error and misclassifications.
In this function, users can specify different degrees of measurement
error that links observed survival time with true survival time, and links observed
censoring status with true censoring status. Moreover, the accelerated functional failure time model considered in
function is given by \code{T=f(X1)+f(X2)+f(X3)+f(X4)+error}, where \code{T} is log failure time and \code{f(X1)=4*x1^2+x1},
\code{f(X2)=sin(6*x2)},\code{f(X3)=cos(6*x3)-1} and \code{f(X4)=4*x4^3+x4^2}.
}
\examples{
## Set the relationship between observed survival time
## and true survival time equals y*= y+1+X1+v, where the variance is
## 0.75 with n=500 and p=50 and misclassification probability=0.9.

a <- matrix(0,ncol=50, nrow = 1); a[1,1] <- 1
data <- data_gen(n=500, p=50, pi_01=0.9, pi_10 = 0.9, gamma0=1,
gamma1=a, e_var=0.75)
}
