% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fit_logit}
\alias{fit_logit}
\title{fit_logit: Logistic Regression Wrapper for the ARTtransfer package}
\usage{
fit_logit(
  X,
  y,
  X_val,
  y_val,
  X_test,
  min_prod = 1e-05,
  max_prod = 1 - 1e-05,
  ...
)
}
\arguments{
\item{X}{A matrix of predictors for the training set.}

\item{y}{A vector of binary responses for the training set.}

\item{X_val}{A matrix of predictors for the validation set. If `NULL`, deviance is not calculated.}

\item{y_val}{A vector of binary responses for the validation set. If `NULL`, deviance is not calculated.}

\item{X_test}{A matrix of predictors for the test set. If `NULL`, predictions are not generated.}

\item{min_prod}{A numeric value indicating the minimum probability bound for predictions. Default is `1e-5`.}

\item{max_prod}{A numeric value indicating the maximum probability bound for predictions. Default is `1-1e-5`.}

\item{...}{Additional arguments passed to the function (currently unused).}
}
\value{
A list containing:
\item{dev}{The deviance (negative log-likelihood) on the validation set if provided, otherwise `NULL`.}
\item{pred}{The predicted probabilities on the test set if `X_test` is provided, otherwise `NULL`.}
\item{coef}{The fitted coefficients of the logistic model.}
}
\description{
This function fits a logistic regression model using `glm()` and returns the 
coefficients, deviance on a validation set, and predictions on a test set. 
It is specifically designed for use in the `ART` adaptive and robust transfer learning framework.
}
\examples{
# Fit a logistic regression model with validation and test data
X_train <- matrix(rnorm(100 * 5), 100, 5)
y_train <- rbinom(100, 1, 0.5)
X_val <- matrix(rnorm(50 * 5), 50, 5)
y_val <- rbinom(50, 1, 0.5)
X_test <- matrix(rnorm(20 * 5), 20, 5)

fit <- fit_logit(X_train, y_train, X_val, y_val, X_test)

}
