% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat8}
\alias{simDat8}
\title{Simulate data for Chapter 8: Two-way ANOVA}
\usage{
simDat8(
  nPops = 5,
  nHab = 3,
  nSample = 12,
  baseline = 40,
  pop.eff = c(-10, -5, 5, 10),
  hab.eff = c(5, 10),
  interaction.eff = c(-2, 3, 0, 4, 4, 0, 3, -2),
  sigma = 3
)
}
\arguments{
\item{nPops}{Number of populations}

\item{nHab}{Number of habitats}

\item{nSample}{Samples from each population-habitat combination}

\item{baseline}{Grand mean length}

\item{pop.eff}{Population effects, should be nPops - 1 values}

\item{hab.eff}{Habitat effects, should be nHab - 1 values}

\item{interaction.eff}{Interaction effects, should be (nPops-1)*(nHab-1) values}

\item{sigma}{Value for the residual standard deviation}
}
\value{
A list of simulated data and parameters.
  \item{nPops}{Number of populations}
  \item{nSample}{Number of samples per population}
  \item{baseline}{Grand mean length}
  \item{pop.eff}{Population effects}
  \item{hab.eff}{Habitat effects}
  \item{interaction.eff}{Interaction effects}
  \item{sigma}{Residual SD}
  \item{all.eff}{All effects}
  \item{pop}{Indicator for population number}
  \item{hab}{Indicator for habitat number}
  \item{eps}{Simulated residuals}
  \item{wing}{Simulated wing lengths}
}
\description{
Simulate wing length measurements of mourning cloak butterflies with two factors (habitat and population)
including their interaction if so wished (simulation under a fixed-effects model)
}
\examples{
str(dat <- simDat8())      # Implicit default arguments (for the model with interactions)
# Model with main effects only (and very large sample size; to minimize sampling error 
# and clarify structure of main effects in plot)
str(dat <- simDat8(nSample = 1000, interaction.eff = c(0,0,0,0, 0,0,0,0)))
str(dat <- simDat8(nSample = 10000, interaction.eff = rep(0, 8))) # same, even larger sample size

# Revert to one-way ANOVA model with only effects of pop (with much larger sample size)
str(dat <- simDat8(nSample = 10000, pop.eff = c(-10, -5, 5, 10),
    hab.eff = c(0, 0), interaction.eff = rep(0, 8)))  # note no effect of habitat

# Revert to one-way ANOVA model with only effects of hab
str(dat <- simDat8(nSample = 10000, pop.eff = c(0, 0, 0, 0),
    hab.eff = c(5, 10), interaction.eff = rep(0, 8)))  # note no effect of pop

# Revert to "model-of-the-mean"
str(dat <- simDat8(nSample = 10000, pop.eff = c(0, 0, 0, 0), 
    hab.eff = c(0, 0), interaction.eff = rep(0, 8)))  # note no effect of pop nor of h

}
\author{
Marc Kéry
}
